#include <windows.h>

static const int MAX_BUTTON = 4;
static HHOOK hHook;
static UINT uMsgType;
static int deltaDidth[MAX_BUTTON];
static LPCWSTR str[MAX_BUTTON];

static LRESULT CALLBACK CBTProc(int nCode, WPARAM wParam, LPARAM lParam)
{
	if (nCode == HCBT_ACTIVATE)
	{
		UnhookWindowsHookEx(hHook);

		const HWND hDlg = (HWND)wParam;
		UINT idd[MAX_BUTTON] = { };
		switch (uMsgType & 0x000F) {
		default:
		case MB_OK:	// The message box contains one push button: OK. This is the default.
			idd[0] = IDOK;
			break;
		case MB_OKCANCEL:	// The message box contains two push buttons: OK and Cancel.
			idd[0] = IDOK; idd[1] = IDCANCEL;
			break;
		case MB_ABORTRETRYIGNORE:	// The message box contains three push buttons: Abort, Retry, and Ignore.
			idd[0] = IDABORT; idd[1] = IDRETRY; idd[2] = IDIGNORE;
			break;
		case MB_YESNOCANCEL:	// The message box contains three push buttons: Yes, No, and Cancel.
			idd[0] = IDYES; idd[1] = IDNO; idd[2] = IDCANCEL;
			break;
		case MB_YESNO:	// The message box contains two push buttons: Yes and No.
			idd[0] = IDYES; idd[1] = IDNO;
			break;
		case MB_RETRYCANCEL:	// The message box contains two push buttons: Retry and Cancel.
			idd[0] = IDRETRY; idd[1] = IDCANCEL;
			break;
		case MB_CANCELTRYCONTINUE:	// The message box contains three push buttons: Cancel, Try Again, Continue. Use this message box type instead of MB_ABORTRETRYIGNORE.
			idd[0] = IDCANCEL; idd[1] = IDTRYAGAIN; idd[2] = IDCONTINUE;
			break;
		}
		if (GetDlgItem(hDlg, IDHELP) != NULL)
			idd[3] = IDHELP;

		RECT rcDlg; GetClientRect(hDlg, &rcDlg);
		int left = rcDlg.right - 9;
		for (int i = MAX_BUTTON; i--; )
			if (idd[i]) {
				if (str[i])
					SetDlgItemTextW(hDlg, idd[i], str[i]);

				HWND hBtn = GetDlgItem(hDlg, idd[i]);
				RECT rc;
				GetWindowRect(hBtn, &rc);
				POINT p = { rc.left, rc.top };
				ScreenToClient(hDlg, &p);
				const int height = rc.bottom - rc.top;
				const int width = rc.right - rc.left + deltaDidth[i];
				const int top = p.y;
				left -= width + 9;
				MoveWindow(hBtn, left, top, width, height, TRUE);
			}
	}
	return CallNextHookEx(hHook, nCode, wParam, lParam);
}

__declspec(dllexport) int WINAPI MessageBoxN(HWND hWnd, LPCWSTR lpText, LPCWSTR lpCaption, UINT uType, int dw1, LPCWSTR lpstr1, int dw2, LPCWSTR lpstr2, int dw3, LPCWSTR lpstr3)
{
	uMsgType = uType;

	deltaDidth[0] = dw1; str[0] = lpstr1;
	deltaDidth[1] = dw2; str[1] = lpstr2;
	deltaDidth[2] = dw3; str[2] = lpstr3;
	deltaDidth[3] = 0;   str[3] = nullptr;

	hHook = SetWindowsHookEx(WH_CBT, CBTProc, NULL, GetCurrentThreadId());
	return  MessageBox(hWnd, lpText, lpCaption, uType);
}
