package jp.sourceforge.larch.core.command
{
    /**
     * 同期処理コマンド基底クラス
     * @author tdott&lt;tdott@users.sourceforge.jp&gt;
     */
    public class SyncCommand extends Command
    {
        /**
         * コンストラクタ
         * @param aTarget 結果の設定先
         * @param aTargetProperty 結果の設定先のプロパティ名
         */
        public function SyncCommand(aTarget:Object = null, aTargetProperty:String = null)
        {
            super(aTarget, aTargetProperty);
        }

        /**
         * サブクラスのコマンド処理を実行します。
         * 実行が正常終了したらnextCommandを実行します。
         */
        override public function execute():void
        {
            var result:Boolean = doExecute();
            if(result && nextCommand)
                nextCommand.execute();
        }

        /**
         * コマンド処理を実行します。
         * サブクラスにて実装してください。
         * @return 実行結果
         */
        protected function doExecute():Boolean
        {
            throw new Error("doExecuteメソッドを実装してください。");
        }
    }
}