package jp.sourceforge.larch.core.util
{
    import flash.utils.getQualifiedClassName;

    import mx.collections.ArrayCollection;
    import mx.collections.ICollectionView;
    import mx.collections.IViewCursor;

    /**
     * コレクションユーティリティ
     * @author tdott&lt;tdott@users.sourceforge.jp&gt;
     */
    public class LarchCollectionUtil
    {
        /**
         * 2つのコレクションの各要素を比較して全て等しいか調べます。
         * @param value1 比較するコレクション
         * @param value2 比較するコレクション
         * @return 等しければtrue
         */
        public static function equals(value1:ICollectionView, value2:ICollectionView):Boolean
        {
            if(value1.length != value2.length)
                return false;
            if(value1.length == 0)
                return true;
            var equals:Boolean;
            var cursor1:IViewCursor = value1.createCursor();
            var cursor2:IViewCursor = value2.createCursor();
            do
            {
                if(getQualifiedClassName(cursor1.current) != getQualifiedClassName(cursor2.current))
                    return false;
                if(cursor1.current is ICollectionView)
                {
                    if(!LarchCollectionUtil.equals(cursor1.current as ICollectionView, cursor2.current as ICollectionView))
                        return false;
                }
                else
                {
                    if(cursor1.current != cursor2.current)
                        return false;
                }
            }while(cursor1.moveNext() && cursor2.moveNext());
            return true;
        }

        /**
         * targetにsourceの全ての要素を追加します。
         * @param target 追加先のコレクション
         * @param source 追加元のコレクション
         */
        public static function addAll(target:ICollectionView, source:ICollectionView):void
        {
            var sourceCursor:IViewCursor = source.createCursor();
            var targetCursor:IViewCursor = target.createCursor();
            LarchCollectionUtil.moveToAfterLast(targetCursor);
            for( ; !sourceCursor.afterLast; sourceCursor.moveNext())
            {
                targetCursor.insert(sourceCursor.current);
                targetCursor.moveNext();
            }
        }

        /**
         * カーソルを最後尾まで移動します。
         * @param cursor カーソル
         */
        public static function moveToAfterLast(cursor:IViewCursor):void
        {
            while(!cursor.afterLast)
            {
                cursor.moveNext();
            }
        }

        /**
         * collectionからitemを削除します。
         * itemと同一の要素が複数存在する場合は、最初のインデックスの要素のみを削除します。
         * @param collection コレクション
         * @param item 削除するオブジェクト
         * @return 削除したオブジェクト(対象のオブジェクトがコレクション内に存在しない場合はnull)
         */
        public static function removeItem(collection:ArrayCollection, item:Object):Object
        {
            var index:int = collection.getItemIndex(item);
            if(index != -1)
                return collection.removeItemAt(index);
            else
                return null;
        }
    }
}