#!/usr/bin/env perl
# -*- mode: cperl; coding: utf-8 -*-
# $Id: convert.pl,v 1.2 2007/02/08 04:06:56 yaizawa Exp $

use strict ;
use utf8 ;
use warnings ;
use Archive::Zip ;
use IO::File ;
use LWP ;

use Data::Dump;

binmode STDOUT, ':encoding(iso-2022-jp)' ;

my $DISTNAME    = 'jsclasses-061106.zip' ;
my $MASTER_SITE = 'http://oku.edu.mie-u.ac.jp/~okumura/jsclasses/' ;

my $version = 0.1 ;
#my $DEBUG = 0 ;
my $DEBUG = 1 ;

my $TAGDATE = '$Date: 2007/02/08 04:06:56 $' ;

&main () ;

sub fetch
  {
    my $fh = $_[ 0 ] ;

    my $ua = LWP::UserAgent->new ;
    $ua-> agent( sprintf( "DBSJClassGenerater/%f", $version ) ) ;

    my $req = HTTP::Request->new( GET => $MASTER_SITE . $DISTNAME ) ;

    my $res = $ua->request( $req ) ;
    if( ! $res->is_success )
      {
	printf( STDERR "Can't fetch %s.\n", $DISTNAME ) ;
	exit( 1 ) ;
      }
    else
      {
	print( $fh $res->content ) ;
	$fh->seek( 0, SEEK_SET ) ;
      }
  }

sub extract
  {
    my $fh = $_[ 0 ] ;
    my %result = {} ;

    my $zip = Archive::Zip->new () ;
    if( $zip->readFromFileHandle( $fh ) != Archive::Zip->AZ_OK )
      {
	printf( STDERR "Downloaded File is broken!\n" ) ;
	exit( 1 ) ;
      }

    if( $DEBUG )
      {
	$zip->extractMemberWithoutPaths( 'jsarticle.cls' ) ;
	$zip->extractMemberWithoutPaths( 'jspf.cls' ) ;
      }

    $result{ 'jsarticle' } = $zip->memberNamed( 'jsarticle.cls' )->contents ;
    $result{ 'jspf' }      = $zip->memberNamed( 'jspf.cls' )->contents ;

    return ( %result ) ;
  }

sub edit
  {
    my $jsarticle = $_[ 0 ]->{ 'jsarticle' } ;
    my $jspf      = $_[ 0 ]->{ 'jspf' } ;
    my $dbsj      = '' ;
    my $tmp ;
    my $fh ;

    # ヘッダ部分を差し替え
    $dbsj = <<'_EOF_';
%%
%% This is file `dbsj.cls',
%% generated with jsarticle.cls to dbsj.cls converter.
%%
%% The original source files were:
%%
%% jsarticle.cls (generated from jsclasses.dtx with options: `article')
%% convert.pl
%%
%% IMPORTANT NOTICE:
%%
%% For the copyright see the source file.
%%
%% Any modified versions of this file must be renamed
%% with new filenames distinct from dbsj.cls.
%%
%% Copyright (c) 2007 Yuichiro AIZAWA a.k.a. yaizawa
%% All rights reserved.
%%
%% Redistribution and use in source and binary forms, with or without
%% modification, are permitted provided that the following conditions
%% are met:
%% 1. Redistributions of source code must retain the above copyright
%%    notice, this list of conditions and the following disclaimer.
%% 2. Redistributions in binary form must reproduce the above copyright
%%    notice, this list of conditions and the following disclaimer in the
%%    documentation and/or other materials provided with the distribution.
%%
%% THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
%% ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
%% IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
%% ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
%% FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
%% DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
%% OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
%% HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
%% LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
%% OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
%% SUCH DAMAGE.
%%
%% $Id: convert.pl,v 1.2 2007/02/08 04:06:56 yaizawa Exp $
%%
%% This generated file may be distributed as long as the
%% original source files, as listed above, are part of the
%% same distribution. (The sources need not necessarily be
%% in the same archive or directory.)
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{pLaTeX2e}
_EOF_

    # クラス名を出力
    $TAGDATE =~ /^\$Date: 2007/02/08 04:06:56 $$/ ;
    $dbsj .= sprintf ( "\\ProvidesClass{dbsj}[%s yaizawa]\n", $1 ) ;

    # 所属表示に使う記号を有効にするためにpifontをロード
    $dbsj .= "\\RequirePackage{pifont}\n" ;

    # メモ: 段組なので\if@restonecolはtrue
    #       タイトルページはつけないので\if@titlepageはfalse

    # enablejfamは輸入する
    $jsarticle =~ /^(\\newif\\if\@enablejfam.+?)$/ms ;
    $dbsj .= $1 . "\n" ;

    # 用紙サイズはa4paperのみ使用する
    $jsarticle =~ /^(\\DeclareOption{a4paper}{(.*?{.+?}){2}}\s*)$/ms ;
    $tmp = $1 ;
    while ( $tmp =~ s/(\\setlength\\.+?{.+?})//s )
      {
	$dbsj .= $1 . "\n" ;
      }

    # フォントサイズは投稿規定により9pt固定のためオプションとして定義しない

    # 論文なのでonesideにする
    $jsarticle =~ /^\\DeclareOption{oneside}{(.+?)}$/ms ;
    $dbsj .= $1 . "\n" ;

    # 投稿規定によりtwocolumnにする
    $jsarticle =~ /^\\DeclareOption{twocolumn}{(.+?)}$/ms ;
    $dbsj .= $1 . "\n" ;

    # eqnarray環境関連の定義を輸入
    # 現在のjsarticleでは\DeclareOption{openbib}がコメントアウトされているが，
    # 年のためopenbib OR disablejfamで判定
    $jsarticle =~ /^(\\def\\eqnarray{%.+?)\\DeclareOption{(openbib|disablejfam)}/ms ;
    $dbsj .= $1 ;

    # disablejfamオプションを輸入 (理工系では数式が多いため必要性が見込める)
    $jsarticle =~ /^(\\DeclareOption{disablejfam}.+?)$/ms ;
    $dbsj .= $1 . "\n" ;

    # draft/finalオプションを輸入
    $jsarticle =~ /^(\\newif\\ifdraft.+?\\DeclareOption{final}.+?)$/ms ;
    $dbsj .= $1 . "\n" ;

    # フォントメトリックの選択
    # 互換性を重視し，標準ではmin/gothを使いオプションjisでjis/jisgを使う
    # 変更点が細かいため，ヒアドキュメントで記述する
    $dbsj .= <<'_EOF_';
\newif\ifjisfont
\jisfontfalse
\DeclareOption{jis}{\jisfonttrue}
\newif\ifwinjis
\winjisfalse
\DeclareOption{winjis}{\winjistrue}
_EOF_

    # papersizeオプションを輸入
    $jsarticle =~ /^(\\newif\\ifpapersize.+?\\DeclareOption{papersize}.+?)$/ms ;
    $dbsj .= $1 . "\n" ;

    # jsarticleでは英語化オプションがあるが，DBSJ Lettersでは英文論文
    # 誌の規定が無いため省略...が，一応輸入
    $jsarticle =~ /^(\\newif\\if\@english.+?\\DeclareOption{english}.+?)$/ms ;
    $dbsj .= $1 . "\n" ;

    # デフォルトのオプションを実行
    # 変更部分が多いのでここは文字連結で発行
    $dbsj .= "\\ExecuteOptions{final}\n\\ProcessOptions\n" ;

    # papersizeスペシャルの出力
    $jsarticle =~ /^(\\ifpapersize.+?\\iftombow.+?\\fi.+?\\fi)$/ms ;
    $tmp = $1 ;
    $tmp =~ s/^\s*\\iftombow.+?\\fi\n//ms ;
    $dbsj .= $tmp . "\n" ;

    # 行送りと拡大率の設定を輸入
    # 拡大を使わないで9ptにしたい
    # プラズマ・核融合学会誌用スタイルの設定 (14.554375pt) を拝借する
    $jspf =~ /^(\\def\\n\@baseline.+?)$/ms ;
    $dbsj .= $1 . "\n" ;

    # 和文フォントサイズの変更について輸入
    # これにより和文フォントは
    #    9.62216pt (pTeX) * 0.961 = 約9.21pt
    # になります (欧文は10pt)
    # 実際にはさらに9ptの設定に落すので1割引になる・・・はず
    $jsarticle =~ /^(\\ifwinjis.+?^\\fi)$/ms ;
    $dbsj .= $1 . "\n" ;

    # 和文のit, sl, sf, ttの代替をgtに変更
    # \textgt, \textmcの再定義
    # その後の数式関係のもろもろ (ドキュメントにない) も輸入
    $jsarticle =~ /^(\\DeclareFontShape{.+?)\\if\@enablejfam/ms ;
    $dbsj .= $1 ;

    # 数式モードで和文フォントを有効化する
    $jsarticle =~ /^(\\if\@enablejfam.+?^\\fi)$/ms ;
    $dbsj .= $1 . "\n" ;

    # 禁則処理のパラメータ変更を輸入
    $jsarticle =~ /^(\\prebreakpenalty\\jis.+?)^\\def\\\@{\\spacefactor/ms ;
    $dbsj .= $1 ;

    # \@のパラメータ変更を輸入
    $jsarticle =~ /^(\\def\\\@{\\spacefactor.+?)$/ms ;
    $dbsj .= $1 . "\n" ;

    # \@setfontsize周りを輸入
    $jsarticle =~ /^(\\def\\\@setfontsize.+?)^\\renewcommand{\\normalsize}/ms ;
    $tmp = $1 ;
    $tmp =~ s/\\if\@slide.+?\\else\n  (.+?)\\fi\n/$1/ms ;
    $dbsj .= $tmp ;

    # 本文のフォントサイズを変更
    # 本文は投稿規定に従い9pt，narrowでの行送りは12ptとします
    # 数式上下の空きについても10ptのところを9ptに変更します．微調整は
    # jsarticleの10ptの設定を流用します．
    $dbsj .= <<'_EOF_';
\renewcommand{\normalsize}{%
  \ifnarrowbaselines
    \@setfontsize\normalsize\@ixpt\@xiipt
  \else
    \@setfontsize\normalsize\@xpt{\n@baseline}%
  \fi
  \abovedisplayskip 9\p@ \@plus3\p@ \@minus4\p@
  \abovedisplayshortskip \z@ \@plus3\p@
  \belowdisplayskip \abovedisplayskip
  \belowdisplayshortskip \belowdisplayskip
  \let\@listi\@listI}
\normalsize
_EOF_

    # 長さ基準の設定を輸入
    $jsarticle =~ /^(\\setbox0.*?)\\newcommand/ms ;
    $dbsj .= $1 ;

    # smallのフォントサイズを変更
    # 本文の9ptより1pt小さくして8ptとし，行送りは13pt (narrowで10pt) 
    # とします
    $dbsj .= <<'_EOF_';
\newcommand{\small}{%
  \ifnarrowbaselines
    \@setfontsize\small\@viiipt{\@xpt}%
  \else
    \@setfontsize\small\@viiipt{13}%
  \fi
  \abovedisplayskip 8\p@ \@plus3\p@ \@minus4\p@
  \abovedisplayshortskip  \z@ \@plus3\p@
  \belowdisplayskip \abovedisplayskip
  \belowdisplayshortskip \belowdisplayskip
  \def\@listi{\leftmargin\leftmargini
              \topsep \z@
              \parsep \z@
              \itemsep \parsep}}
_EOF_

    # footnotesizeのフォントサイズを変更
    # smallよりも大きいですが，9ptとします (投稿様式サンプルより)
    # ここでは行送りなども\normalsizeを活かします
    # ただし，行間は詰めます
    $dbsj .= <<'_EOF_';
\newcommand{\footnotesize}{%
  \@setfontsize\normalsize\@ixpt\@xipt
  \abovedisplayskip 9\p@ \@plus3\p@ \@minus4\p@
  \abovedisplayshortskip \z@ \@plus3\p@
  \belowdisplayskip \abovedisplayskip
  \belowdisplayshortskip \belowdisplayskip
  \let\@listi\@listI}
_EOF_

    # その他のフォントサイズも変更します
    # 投稿規定の次の物に対応させます:
    #    タイトル       (16pt)   → \huge
    #    邦文著者名     (14pt)   → \LARGE
    #    邦文タイトル   (12pt)   → \Large
    #    英文著者名     (10.5pt) → \large
    #    節タイトル
    #    文献見出し
    #    著者紹介の名前
    # scriptsizeとtinyはおそらく使わないでしょう :)
    $dbsj .= <<'_EOF_';
\newcommand{\scriptsize}{\@setfontsize\scriptsize\@vipt\@viipt}
\newcommand{\tiny}{\@setfontsize\tiny\@ivpt\@vpt}
\newcommand{\large}{\@setfontsize\large{10.5}{13}}
\newcommand{\Large}{\@setfontsize\Large\@xiipt{15}}
\newcommand{\LARGE}{\@setfontsize\LARGE\@xivpt{18}}
\newcommand{\huge}{\@setfontsize\huge{16}{20}}
\let\Huge=\huge
_EOF_

    # 別立て数式の行間をつめる設定を輸入します
    $jsarticle =~ /^(\\everydisplay.+?)$/ms ;
    $dbsj .= $1 . "\n" ;

    # 見出しのフォントはゴシック指定なので，それに従います
    # jsarticleではゴシックを使っているので設定を流用します
    $jsarticle =~ /^(\\newcommand{\\headfont.+?)$/ms ;
    $dbsj .= $1 . "\n" ;

    # 段組・段落についてはjsarticleをそのまま使います
    $jsarticle =~ /^(\\setlength\\columnsep.+?\\parskip.+?)$/ms ;
    $dbsj .= $1 . "\n" ;
    $jsarticle =~ /^\\setlength\\parskip{.+?}\n\\if\@slide.+?\\else\s+(.+?)\\fi$/ms ;
    $dbsj .= $1 ;
    $jsarticle =~ /^(\\\@lowpenalty.+?\\\@highpenalty.+?)$/ms ;
    $dbsj .= $1 . "\n" ;

    # 縦方向のスペースについてもjsarticleをそのまま使います
    $jsarticle =~ /^(\\setlength\\topskip.+?)$/ms ;
    $dbsj .= $1 . "\n" ;
    $jsarticle =~ /^\\if\@slide.+?\\else\s+(\\setlength\\headheight.+?)^\\fi$/ms ;
    $dbsj .= $1 ;
    $jsarticle =~ /^\\if\@slide.+?\\else\s+(\\setlength\\footskip.+?)^\\fi$/ms ;
    $tmp = $1 ;
    $tmp =~ s/^\s{2}//gm ;
    $dbsj .= $tmp ;
    $jsarticle =~ /^\\if\@slide.+?\\else\s+(\\setlength\\headsep.+?)^\\fi$/ms ;
    $tmp = $1 ;
    $tmp =~ s/^\s{2}//gm ;
    $dbsj .= $tmp ;
    $jsarticle =~ /^(\\setlength\\maxdepth.+?)$/ms ;
    $dbsj .= $1 ;

    # 紙の横幅については執筆規定によると両側15mmをスペースとしています
    # 定義や使い方はjsarticleに準ずるようにして独自定義します
    $dbsj .= <<'_EOF_';
\newdimen\fullwidth
\setlength\fullwidth{\paperwidth}
\addtolength\fullwidth{-30mm}
\@tempdima=2zw
\divide\fullwidth\@tempdima \multiply\fullwidth\@tempdima
\setlength\textwidth{\fullwidth}
_EOF_

    # 縦幅についても執筆規定に従って再定義します
    # 上下マージンとして上20mm，下30mmを空けます
    # さらにヘッダ・フッタに必要なスペースを引き，本文領域を確定します
    $dbsj .= <<'_EOF_';
\setlength\textheight{\paperheight}
\addtolength\textheight{-50mm}
_EOF_
    $jsarticle =~ /^(\\addtolength{\\textheight}{-\\topskip}.+?\\addtolength{\\textheight}{0.1\\p\@})$/ms ;
    $dbsj .= $1 . "\n" ;

    # 欄外は使わないので欄外とのスペースを0ptにします
    $dbsj .= <<'_EOF_';
\setlength\marginparsep{0pt}
_EOF_

    # LaTeX標準のマージンを含めた調整を行ないます
    # \@mparswitchは使わないので完全に排除します
    $jsarticle =~ /^(\\setlength{\\oddsidemargin}.+?)^\\if\@mparswitch/ms ;
    $tmp = $1 ;
    $tmp =~ s/^\\iftombow.+?\\else//ms ;
    $tmp =~ s/^\\fi//ms ;
    $tmp =~ s/^\s+//gms ;
    $dbsj .= $tmp ;

    # 欄外は使わないので欄外の幅をを0ptにします
    $dbsj .= <<'_EOF_';
\setlength\marginparwidth{0pt}
_EOF_

    # 上部マージンを20mmにします (LaTeX標準の1inに注意)
    $dbsj .= <<'_EOF_';
\setlength\topmargin{20mm}
\addtolength\topmargin{-1in}
_EOF_

    # 脚注をjsarticleから輸入します
    $jsarticle =~ /^({\\footnotesize.+?^\\setlength\\footnotesep{.+?})$/ms ;
    $dbsj .= $1 . "\n" ;

    # フロート関係もjsarticleから輸入します
    $jsarticle =~ /^(\\setcounter{topnumber}.+?^\\setlength\\\@dblfpbot.+?)$/ms ;
    $dbsj .= $1 . "\n" ;

    # ページスタイルは投稿様式に従った物を独自に定義します
    # ヘッダには第○巻第○号と出るため，これらのためのカウンタを定義しています
    # また，ページ数を調節するためのオフセットカウンタも定義します
    $dbsj .= <<'_EOF_';
\newcounter{volume}
\newcounter{number}
\newcounter{volpageoffset}
\setcounter{volume}{1}
\setcounter{number}{1}
\setcounter{volpageoffset}{1}
\let\latex@document\document
\def\document{\latex@document
        \global\c@page\c@volpageoffset}
\let\c@volpage\c@page
\def\thevolpage{\thepage}
\def\ps@empty{\let\@mkboth\@gobbletwo
   \let\ps@jpl@in\ps@plain
   \def\@oddhead{\underline{\hbox to \textwidth{\LARGE\sffamily 論文\hfill\normalsize DBSJ Letters Vol.\arabic{volume}, No.\arabic{number}}}}
   \def\@oddfoot{\large\sffamily\thepage\hfil 日本データベース学会Letters Vol.\arabic{volume}, No.\arabic{number}}%
   \let\@evenhead\@empty
   \let\@evenfoot\@oddfoot}
\pagenumbering{arabic} % debug用仮置き
_EOF_

    # maketitleはごっそり作り直します
    # 和文タイトルを\jtitleに変更します
    $dbsj .= <<'_EOF_';
\def\jtitle#1{\gdef\@jtitle{#1}}
\def\@jtitle{\@latex@error{No \noexpand\jtitle given}\@ehc}
\global\let\@title\@empty
\global\let\author\relax
_EOF_
    # 英文タイトル \etitle を定義します
    $dbsj .= <<'_EOF_';
\def\etitle#1{\gdef\@etitle{#1}}
\def\@etitle{\@latex@error{No \noexpand\etitle given}\@ehc}
_EOF_
    # authorは作り直すので定義を消します
    # dateも使わないので消します
    $dbsj .= <<'_EOF_';
\global\let\@author\@empty
\global\let\@date\@empty
\global\let\author\relax
\global\let\date\relax
_EOF_

    # authorlistを定義します
    # 電子情報通信学会スタイルを参考にしています
    $dbsj .= <<'_EOF_';
\newcounter{@authors}
\setcounter{@authors}{0}
\let\@author@membership\@empty
\let\@author@jname\@empty
\let\@author@ename\@empty
\let\@author@mailaddress\@empty
\let\@author@affiliate\@empty
\let\@author@introduction\@empty
\newcommand{\authorentry}[6]{
 \stepcounter{@authors}
 \expandafter\gdef\expandafter\@author@membership\expandafter{\@author@membership\@elt{#1}}
 \expandafter\gdef\expandafter\@author@jname\expandafter{\@author@jname\@elt{#2}}
 \expandafter\gdef\expandafter\@author@ename\expandafter{\@author@ename\@elt{#3}}
 \expandafter\gdef\expandafter\@author@mailaddress\expandafter{\@author@mailaddress\@elt{#4}}
 \expandafter\gdef\expandafter\@author@affiliate\expandafter{\@author@affiliate\@elt{#5}}
 \expandafter\gdef\expandafter\@author@introduction\expandafter{\@author@introduction\@elt{#6}}}
_EOF_

    # リストからのpopを実行するマクロを定義します
    # LaTeX2e マクロ&クラス プログラミング基礎解説p.76よりの引用です
    $dbsj .= <<'_EOF_';
\def\@pop@list#1#2{%
 \ifx#2\@empty \gdef#1{}%
 \else \expandafter\@pop@list@#2\@nil#1#2%
 \fi}
\def\@pop@list@\@elt#1#2\@nil#3#4{\gdef#3{#1}\gdef#4{#2}}
_EOF_

    # リストを処理して著者欄を作成するマクロです
    # 著者紹介もここで作成し，\makeauthorで実行します
    $dbsj .= <<'_EOF_';
\let\@maketitle@jname\@empty
\let\@maketitle@ename\@empty
\let\@maketitle@introduction\@empty
\newcommand\@maketitle@author{
 \newcounter{counteri}
 \setcounter{counteri}{0}
 \let\@@jname\@author@jname
 \let\@@ename\@author@ename
 \newtoks\toks@jname
 \newtoks\toks@ename
 \newtoks\toks@mailfont
 \newtoks\toks@introduction
 \newtoks\toks@authorfont
 \toks@mailfont{\texttt}
 \toks@authorfont{\Large\sffamily}
 \@whilenum\value{counteri}<\value{@authors}\do{
  \stepcounter{counteri} 
  \@pop@list{\car@membership}{\@author@membership}
  \@pop@list{\car@jname}{\@@jname}
  \@pop@list{\car@ename}{\@@ename}
  \@pop@list{\car@mailaddress}{\@author@mailaddress}
  \@pop@list{\car@affiliate}{\@author@affiliate}
  \@pop@list{\car@introduction}{\@author@introduction}

  \toks@jname\expandafter{\@maketitle@jname}
  \edef\@maketitle@jname{\the\toks@jname \car@jname}
  \toks@jname\expandafter{\@maketitle@jname\thanks}
  \edef\@maketitle@jname{\the\toks@jname{\car@membership 　 \car@affiliate 　 {\the\toks@mailfont{\car@mailaddress}}}}
  \toks@ename\expandafter{\@maketitle@ename}
  \edef\@maketitle@ename{\the\toks@ename \car@ename}
  \toks@introduction\expandafter{\@maketitle@introduction\noindent\begingroup\Large\sffamily}
  \xdef\@maketitle@introduction{\the\toks@introduction\car@jname ~ \car@ename}
  \toks@introduction\expandafter{\@maketitle@introduction\endgroup}
  \xdef\@maketitle@introduction{\the\toks@introduction\par\noindent\car@introduction\par}
  \count@=\c@counteri
  \divide\count@ by 2
  \multiply\count@ by 2
  \ifnum\c@counteri=\count@
   \toks@jname\expandafter{\@maketitle@jname \\}
   \toks@ename\expandafter{\@maketitle@ename \\}
  \else
   \toks@jname\expandafter{\@maketitle@jname &}
   \toks@ename\expandafter{\@maketitle@ename &}
  \fi
  \edef\@maketitle@jname{\the\toks@jname}
  \edef\@maketitle@ename{\the\toks@ename}
 }
}
\def\makeauthor{
  \hrule
  \par\vskip .5\baselineskip
  \@maketitle@introduction
}
_EOF_

    # maketitleを定義します
    # affiliateの記号はZapf Dingbatsでは多少くどいのでSymbolを使用します
    $jsarticle =~ /^\\if\@titlepage\s+\\newcommand{\\maketitle}.+?\\else\n(^\s+\\newcommand{\\maketitle}{.+?\s+})/ms ;
    $tmp = $1 ;
    $tmp =~ s/{\\par/{/ ;
    # 脚注の左スペースをこちらにも反映します
    $tmp =~ s/3zw/\\footnote\@leftskip/ms ;
    $tmp =~ s/^\s+\\plainifnotempty\n//ms ;
    $tmp =~ s/^\s{6}\\if\@twocolumn\n.+?^\s{6}\\else\n(.+?)\\fi\n/$1/ms ;
    $tmp =~ s/^\s{2}//gms ;
    $dbsj .= $tmp . "\n" ;
    $dbsj .= <<'_EOF_';
\newdimen\titlewidth
\titlewidth=\textwidth
\advance\titlewidth by -\columnsep
\divide\titlewidth by 2

\def\@maketitle{%
\@maketitle@author
\def\@fnsymbol##1{\ifcase##1 \or
 \expandafter\Pisymbol{psy}{"A9}\or
 \expandafter\Pisymbol{psy}{"A8}\or
 \expandafter\Pisymbol{psy}{"AA}\or
 \expandafter\Pisymbol{psy}{"A7}\or
 \dag\or
 \dag\dag\or
 \dag\dag\dag\or
 \dag\dag\dag\dag\or
 \dag\dag\dag\dag\dag\or
 \dag\dag\dag\dag\dag\dag\or
 \dag\dag\dag\dag\dag\dag\dag\or
 \dag\dag\dag\dag\dag\dag\dag\dag\or
 \dag\dag\dag\dag\dag\dag\dag\dag\dag\or
 *\or **\or ***\or ****\or *****\or ******\else\@ctrerr\fi\relax}%
\let\footnote\thanks
  {\huge \sffamily \noindent\@jtitle \par}%
  {\Large \rmfamily \noindent\@etitle \par}
  \vskip 2\baselineskip%
  {\LARGE \sffamily \noindent
   \begin{tabular}{p{.5\linewidth}p{.5\linewidth}}
    \@maketitle@jname
   \end{tabular}
   \par}
  \kern 2\p@
  \hrule width \linewidth
  \kern 2\p@
  {\large \noindent
   \begin{tabular}{p{.5\titlewidth}p{.5\titlewidth}}
    \@maketitle@ename
   \end{tabular}
   \par}
  \par\vskip 2\baselineskip
  \box\@jabstractbox
  \par\vskip \baselineskip
  \box\@eabstractbox}
  \par\vskip \baselineskip
_EOF_

    # 章・節の定義はjsarticleから輸入します
    $jsarticle =~ /^(\\def\\\@startsection.+?\\setcounter{secnumdepth}.+?)$/ms ;
    $tmp = $1 ;
    $tmp =~ s/^\s+\\if\@slide.+?\\fi\n//gms ;
    $dbsj .= $tmp . "\n" ;

    # sectionのカウンタを定義します
    # partは使わないので割愛します
    $jsarticle =~ /^(\\newcounter{section}.+?\\newcounter{subparagraph}.+?\n)/ms ;
    $dbsj .= $1 ;

    # カウンタ値の出力を定義します
    $jsarticle =~ /^(\\renewcommand{\\thesection}.+?\\renewcommand{\\thesubparagraph}{.+?}\n)/ms ;
    $dbsj .= $1 ;

    # sectionなどを定義します
    $jsarticle =~ /^\\if\@twocolumn\n(\s+\\newcommand{\\section}.+?)\\else/ms ;
    $tmp = $1 ;
    $tmp =~ s/^\s{2}//gm ;
    $tmp =~ s/\\large/\\Large/ ;
    $dbsj .= $tmp ;

    $jsarticle =~ /^\\if\@twocolumn\n(\s+\\newcommand{\\subsection}.+?)\\else/ms ;
    $tmp = $1 ;
    $tmp =~ s/^\s{2}//gm ;
    $tmp =~ s/\\normalsize/\\large/ ;
    $dbsj .= $tmp ;

    $jsarticle =~ /^\\if\@twocolumn\n(\s+\\newcommand{\\subsubsection}.+?)\\else/ms ;
    $tmp = $1 ;
    $tmp =~ s/^\s{2}//gm ;
    $dbsj .= $tmp ;

    $jsarticle =~ /^\\if\@twocolumn\n(\s+\\newcommand{\\paragraph}.+?)\\else/ms ;
    $tmp = $1 ;
    $tmp =~ s/^\s{2}//gm ;
    $dbsj .= $tmp ;

    $jsarticle =~ /^(\\newcommand{\\subparagraph}.+?)^\\/ms ;
    $tmp = $1 ;
    $tmp =~ s/^\s{2}//gm ;
    $dbsj .= $tmp ;

    # リスト・enumerate環境に関しては今のところ変更の必然性が見当たら
    # ないのでjsarticleから輸入します
    $jsarticle =~ /\\if\@twocolumn\n\s+(\\setlength\\leftmargini{.+?}\n)/ms ;
    $dbsj .= $1 ;
    $jsarticle =~ /\\if\@slide.+?\\else\n(\s+\\setlength\\leftmarginii.+?)\\fi/ms ;
    $tmp = $1 ;
    $tmp =~ s/^\s+//gms ;
    $dbsj .= $tmp ;
    $jsarticle =~ /^(\\setlength\s+\\labelsep.+?\\newcommand\\labelitemiv.+?\n)/ms ;
    $dbsj .= $1 ;

    # description環境もjsarticleから輸入します
    $jsarticle =~ /(\\newenvironment{description}.+?\\newcommand\*\\descriptionlabel.+?\n)/ms ;
    $dbsj .= $1 ;

    # abstract環境はプラズマ・核融合学会を参考にします
    foreach my $lang ( 'j', 'e' )
      {
	$jspf =~ /^(\\newbox\\\@abstractbox.+?)\\newenvironment{verse}/ms ;
	$tmp = $1 ;
	$tmp =~ s/(abstract)/$lang$1/g ;
	$tmp =~ s/157mm/\\titlewidth/ ;
	$tmp =~ s/{\\sffamily.+$//m ;
	$tmp =~ s/\\small/\\normalsize/ ;
	if ( $lang eq 'e' )
	  {
	    $tmp =~ s/\\if\@english (.+?) \\else .+? \\fi/$1/ ;
	  }
	else
	  {
	    $tmp =~ s/\\if\@english .+? \\else (.+?) \\fi/$1/ ;
	    $tmp =~ s/\\normalsize/\\normalsize\\sffamily/ ;
	  }
	$dbsj .= $tmp ;
      }

    # verse環境を輸入します
    $jsarticle =~ /^(\\newenvironment{verse}.+?{\\endlist}\n)/ms ;
    $dbsj .= $1 ;

    # quotation, quoteを輸入します
    $jsarticle =~ /^(\\newenvironment{quotation}.+?{\\endlist}\n)/ms ;
    $dbsj .= $1 ;
    $jsarticle =~ /^(\\newenvironment{quote}.+?{\\endlist}\n)/ms ;
    $dbsj .= $1 ;

    # theorem関係を輸入します
    $jsarticle =~ /^(\\def\\\@begintheorem.+?)^\\newenvironment{titlepage}/ms ;
    $dbsj .= $1 ;

    # titlepageは使わないので輸入しません

    # Appendixを輸入します (あまり使わないが例はある)
    $jsarticle =~ /^(\\newcommand{\\appendix}.+?)^\\setlength/ms ;
    $dbsj .= $1 ;

    # パラメータも変更の必然性が今のところないのでそのまま輸入します
    $jsarticle =~ /^(\\setlength\\arraycolsep.+?)^\\newcounter{figure}/ms ;
    $dbsj .= $1 ;

    # フロートも同様です
    $jsarticle =~ /^(\\newcounter{figure}.+?)^\\newlength\\abovecaptionskip/ms ;
    $dbsj .= $1 ;

    # caption周りを輸入します
#    $jsarticle =~ /^(\\newlength\\abovecaptionskip.+?)^\\DeclareOldFontCommand/ms ;
    $jsarticle =~ /^(\\newlength\\abovecaptionskip.+?)^\\long\\def\\\@makecaption/ms ;
    $dbsj .= $1 ;

    # 英語のcaptionを定義します
    # latex.ltxのcaptionから作ります
    # ipsjcommon.styも参考にします
    $jsarticle =~ /^(\\def\\fnum\@figure.+?\n)/ms ;
    $tmp = $1 ;
    $tmp =~ s/\@figure/\@efigure/ ;
    $tmp =~ s/(figurename)/e$1/ ;
    $dbsj .= $tmp ;

    $jsarticle =~ /^(\\def\\fnum\@table.+?\n)/ms ;
    $tmp = $1 ;
    $tmp =~ s/\@table/\@etable/ ;
    $tmp =~ s/(tablename)/e$1/ ;
    $dbsj .= $tmp ;

    $dbsj .= <<'_EOF_';
\def\ecaption{%
   \ifx\@captype\@undefined
     \@latex@error{\noexpand\ecaption outside float}\@ehd
     \expandafter\@gobble
   \else
     \expandafter\@firstofone
   \fi
   {\@dblarg{\@ecaption\@captype}}%
}
\long\def\@ecaption#1[#2]#3{%
  \par
  \begingroup
    \@parboxrestore
    \if@minipage
      \@setminipage
    \fi
    \normalsize
    \@makecaption[e]{\csname fnum@e#1\endcsname}{\ignorespaces #3}\par
  \endgroup}
_EOF_

    # makecaptionを再定義します
    $dbsj .= <<'_EOF_';
\long\def\@makecaption{
  \@ifnextchar[\@@makecaption{\@@makecaption[j]}}
\long\def\@@makecaption[#1]#2#3{%
 {\small
  \advance\leftskip .0628\linewidth
  \advance\rightskip .0628\linewidth
  \ifx#1j
   \vskip\abovecaptionskip
  \fi
  \sbox\@tempboxa{#2\hskip1zw\relax #3}%
  \ifdim \wd\@tempboxa <\hsize \centering \fi
  #2\hskip1zw\relax #3\par
  \ifx#1e
   \vskip\belowcaptionskip
  \fi
  }}
_EOF_

    # 互換用フォントコマンドを輸入します
    # 本当は互換用のマクロは時代遅れなので捨てたかったりはします
    $jsarticle =~ /^(\\DeclareOldFontCommand.+?)\\newcommand/ms ;
    $dbsj .= $1 ;

    # 目次は論文では使わないので輸入しません

    # 参考文献を輸入します
    # 一部論文様式に合わせて変更します
    $jsarticle =~ /^(\\newdimen\\bibindent.+?)\\newenvironment{theindex}/ms ;
    $tmp = $1 ;
    $tmp =~ s/(\\section\*{)(\\refname)(})/$1\\textrm{[}$2\\textrm{]}$3/ ;
    $dbsj .= $tmp ;

    # 索引も輸入しません

    # 脚注がjsarticleで変更されているので輸入します
    $jsarticle =~ /^(\\let\\footnotes\@ve.+?)\\def\\thefootnote/ms ;
    $dbsj .= $1 ;
    # ただし，脚注の表示が多くの論文で「注1」のようにならずただ「1」と
    # なっているので，それに合わせた変更を実施します
    $jsarticle =~ /^(\\def\\thefootnote.+?\n)/ms ;
    $tmp = $1 ;
    $tmp =~ s/\\leavevmode\\lower.5ex\\hbox{\*}// ;
    $dbsj .= $tmp ;
    # 脚注についてはそれ以外はほぼそのまま輸入します
    $jsarticle =~ /^(\\renewcommand{\\footnoterule}.+?)\\newcommand\\\@makefntext/ms ;
    $dbsj .= $1 ;
    # ただし脚注の左側が空き過ぎるので調整します
    $dbsj .= "\\newdimen\\footnote\@leftskip\n" ;
    $dbsj .= "\\setlength\\footnote\@leftskip{1zw}\n" ;
    $jsarticle =~ /^(\\newcommand\\\@makefntext.+?)\\def\\\@inhibitglue/ms ;
    $tmp = $1 ;
    $tmp =~ s/3zw/\\footnote\@leftskip/ ;
    $dbsj .= $tmp ;

    # 段落の頭のグルーについて輸入します
    $jsarticle =~ /^(\\def\\\@inhibitglue.+?\\def\\\@gnewline.+?}\n)/ms ;
    $dbsj .= $1 ;

    # 修正されたロゴの輸入します
    $jsarticle =~ /^\\def\\\@gnewline.+?}\n(.+?\\DeclareRobustCommand{\\SliTeX}.+?}\n)/ms ;
    $dbsj .= $1 ;

    # jsarticleをベースにしているためamsmathとの衝突回避も必須なので輸
    # 入します
    $jsarticle =~ /^(\\let\\ltx\@ifnextchar.+?)\\newcommand/ms ;
    $dbsj .= $1 ;

    # sectionなどにつける名前などを輸入します
    # 論文様式に合わせるところは合わせます
    $jsarticle =~ /^(\\newcommand{\\presectionname}.+?\n)/ms ;
    $dbsj .= $1 ;
    $jsarticle =~ /^(\\newcommand{\\postsectionname}.+?\n)/ms ;
    $dbsj .= $1 ;
    $dbsj .= "\\newcommand{\\refname}{\\if\@english References\\else 文献\\fi}\n" ;
    $dbsj .= "\\newcommand{\\bibname}{\\if\@english Bibliography\\else 文献\\fi}\n" ;
    $jsarticle =~ /^(\\newcommand{\\figurename}.+?\n)/ms ;
    $dbsj .= $1 ;
    $dbsj .= "\\newcommand{\\efigurename}{Fig.~}\n" ;
    $jsarticle =~ /^(\\newcommand{\\tablename}.+?\n)/ms ;
    $dbsj .= $1 ;
    $dbsj .= "\\newcommand{\\etablename}{Fig.~}\n" ;
    $jsarticle =~ /^(\\newcommand{\\appendixname}.+?\n)/ms ;
    $dbsj .= $1 ;
    $dbsj .= "\\newcommand{\\ackname}{\\if\@english Acknowledgement\\else 謝辞\\fi}\n" ;

    # 日付もjsarticleから輸入します
    $jsarticle =~ /^\\newcommand{\\abstractname}.+?\n(\\newif.+?\\fi}\n)/ms ;
    $dbsj .= $1 ;

    # ハイフネーションの追加を輸入します
    $jsarticle =~ /^(\\hyphenation.+?\n)/ms ;
    $dbsj .= $1 ;

    # 初期設定を記述します
    $dbsj .= <<'_EOF_';
\pagestyle{empty}
\twocolumn
\sloppy
\flushbottom
_EOF_

    # jsarticleには無い，謝辞を作ります
    # マクロ名はieice.clsに従い\ackとします (ipsjpapers.cls関係の方々ごめんなさい)
    # 実態は「[謝辞]」と出すだけだったりはしますが・・・．
    $dbsj .= <<'_EOF_';
\def\ack{
  \section*{\textrm{[}\ackname\textrm{]}}
}
_EOF_


#    # btt
#    open( $fh, 'btt-import.txt' ) ;
#    foreach $tmp( <$fh> )
#      {
#	$dbsj .= $tmp ;
#      }
#    close( $fh ) ;

    $dbsj .= "\\endinput\n" ;
    print $dbsj ;
  }

sub main
  {
    my $fh ;
    my %jsclasses ;

    $fh = IO::File->new_tmpfile() ;
    &fetch( $fh ) ;
    %jsclasses = &extract( $fh ) ;
    close( $fh ) ;

#    open ( $fh, 'jsarticle.cls' ) ;
#    foreach my $tmp ( <$fh> )
#      {
#	$jsclasses{ 'jsarticle' } .= $tmp ;
#      }
#    close( $fh ) ;
#    open ( $fh, 'jspf.cls' ) ;
#    foreach my $tmp ( <$fh> )
#      {
#	$jsclasses{ 'jspf' } .= $tmp ;
#      }
#    close( $fh ) ;

    &edit( \%jsclasses ) ;
  }

0 ;
