/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;
import sun.misc.HexDumpEncoder;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public final class PBEParameters
extends AlgorithmParametersSpi {
    private byte[] a = null;
    private int b = 0;
    static /* synthetic */ Class c;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.a = (byte[])((PBEParameterSpec)algorithmParameterSpec).getSalt().clone();
        this.b = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            DerValue derValue = new DerValue(byArray);
            if (derValue.tag != 48) {
                throw new IOException("PBE parameter parsing error: not a sequence");
            }
            derValue.data.reset();
            this.a = derValue.data.getOctetString();
            this.b = derValue.data.getInteger();
            if (derValue.data.available() != 0) {
                throw new IOException("PBE parameter parsing error: extra data");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("iteration count too big");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if ((c == null ? (c = PBEParameters.class$("javax.crypto.spec.PBEParameterSpec")) : c).isAssignableFrom(clazz)) {
            return new PBEParameterSpec(this.a, this.b);
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.a);
        derOutputStream2.putInteger(this.b);
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        String string = System.getProperty("line.separator");
        String string2 = string + "    salt:" + string + "[";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string2 = string2 + hexDumpEncoder.encodeBuffer(this.a);
        string2 = string2 + "]";
        return string2 + string + "    iterationCount:" + string + Debug.toHexString(BigInteger.valueOf(this.b)) + string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

