/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.JavawsFactory;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.net.HttpRequest;
import com.sun.javaws.net.HttpResponse;
import com.sun.javaws.ui.player.BookmarkEntry;
import com.sun.javaws.util.URLUtil;
import com.sun.javaws.util.VersionString;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigProperties {
    private static ConfigProperties _instance;
    private static Properties _props;
    private static Properties _defaultProps;
    private ArrayList _jreInfoList = null;
    private long _lastChanged;
    private boolean _dirty;
    private static final String PROPERTIES_FILE = "deployment.properties";
    private static final String CONFIG_FILE = "deployment.config";
    private static final String JAVAWS = "javaws";
    private static final String CACHE = "cache";
    private static final String MUFFINS = "muffins";
    private static final String SPLASHES = "splashes";
    private static final String SPLASH_INDEX = "splash.xml";
    private static final String DEFAULT_CONSOLE_SIZE = "10000";
    private static final String DEFAULT_BROWSER_PATH = "netscape";
    public static final String PROXY_AUTO = "AUTOMATIC";
    public static final String PROXY_MANUAL = "MANUAL";
    public static final String PROXY_NONE = "NONE";
    private static final String DEFAULT_JRE_INSTALL_URL = "http://java.sun.com/products/autodl/j2se";
    private static final String DEFAULT_JRE_LOCATION = "http://java.sun.com/products/autodl/j2se";
    private static final String DEFAULT_AUTO_UPDATER_URL = "http://java.sun.com/products/javawebstart/auto-update/javaws-1_0.conf";
    private static final String REMOTE_APPS_URL = "http://java.sun.com/products/javawebstart/apps/remoteApps.html";
    public static final String JAUTHENTICATOR_SYSTEM_KEY = "javaws.cfg.jauthenticator";
    private static final String DEPLOYMENT = "deployment.";
    private static final String BASE = "deployment.javaws.";
    private static final String JRE_PLATFORM_ID = ".platform";
    private static final String JRE_PRODUCT_ID = ".product";
    private static final String JRE_PRODUCT_LOCATION = ".location";
    private static final String JRE_PATH = ".path";
    private static final String JRE_OS_NAME = ".osname";
    private static final String JRE_OS_ARCH = ".osarch";
    private static final String JRE_ISENABLED = ".enabled";
    private static final String JRE_ISREGISTERED = ".registered";
    private static final String SERVICES = "deployment.javaws.services.";
    private static final String PLAYER = "deployment.javaws.player.";
    public static final String JRE_KEY = "deployment.javaws.jre.";
    public static final String SPLASH_CACHE_KEY = "deployment.javaws.splash.cache";
    public static final String MUFFIN_KEY = "deployment.javaws.services.persistence";
    public static final String MUFFIN_LIMIT_KEY = "deployment.javaws.services.persistence.limit";
    public static final String CACHE_KEY = "deployment.javaws.cache";
    public static final String CACHE_DIR_KEY = "deployment.javaws.cache.dir";
    public static final String CACHE_SIZE_KEY = "deployment.javaws.cache.size";
    public static final String PROXY_KEY = "deployment.javaws.proxy.";
    public static final String AUTO_UPDATER_URL_KEY = "deployment.javaws.autoUpdateURL";
    public static final String JAUTHENTICATOR_KEY = "deployment.javaws.jauthenticator";
    public static final String PROXY_TYPE_KEY = "deployment.javaws.proxy.setting";
    public static final String HTTP_PROXY_KEY = "deployment.javaws.proxy.http";
    public static final String HTTP_PROXY_PORT_KEY = "deployment.javaws.proxy.httpport";
    public static final String OVERRIDE_KEY = "deployment.javaws.proxy.httpproxyoverride";
    public static final String SHOW_CONSOLE_KEY = "deployment.javaws.showConsole";
    public static final String CONSOLE_SIZE_KEY = "deployment.javaws.consoleBufferSize";
    public static final String LOG_TO_FILE_KEY = "deployment.javaws.logToFile";
    public static final String LOG_DIR_KEY = "deployment.javaws.logdir";
    public static final String LOG_FILENAME_KEY = "deployment.javaws.logFileName";
    public static final String BROWSER_PATH_KEY = "deployment.javaws.browserPath";
    public static final String NETSCAPE_BROWSER_KEY = "deployment.javaws.netscapeBrowser";
    public static final String JRE_INSTALL_URL_KEY = "deployment.javaws.installURL";
    public static final String FAVORITE_SIZE_KEY = "deployment.javaws.favorites.size";
    public static final String FAVORITES_KEY = "deployment.javaws.favorites";
    public static final String REMOTE_APPS_KEY = "deployment.javaws.player.remoteURL";
    public static final String PLAYER_BOUNDS_KEY = "deployment.javaws.player.bounds";
    public static final String PLAYER_MANAGER_KEY = "deployment.javaws.player.manager";
    public static final String PLAYER_MODE_KEY = "deployment.javaws.player.mode";
    public static final String BOOKMARK_NAME_KEY = "deployment.javaws.player.bookmark.name";
    public static final String BOOKMARK_URL_KEY = "deployment.javaws.player.bookmark.url";
    public static final String FORCE_UPDATE_CHECK = "deployment.javaws.forceUpdate";
    public static final String UPDATE_TIMEOUT_KEY = "deployment.javaws.updateTimeout";
    public static final String TRUSTED_PLAYER_URL = "deployment.javaws.trustedPlayerURL";
    public static final String VERSION_UPDATED_KEY = "deployment.javaws.version";
    public static final String SECURE_PROPS_KEY = "deployment.javaws.secure.properties";
    public static final String WHEN_INSTALL_KEY = "deployment.javaws.whenInstall";
    public static final String WHAT_INSTALL_KEY = "deployment.javaws.whatInstall";
    private static final String SYSTEM_POLICY_KEY = "deployment.system.security.policy";
    private static final String USER_POLICY_KEY = "deployment.user.security.policy";
    public static final int INSTALL_NEVER = 0;
    public static final int INSTALL_ALWAYS = 1;
    public static final int INSTALL_ASK = 2;
    public static final int INSTALL_ASK_OLD = 3;
    public static final int JA_ALL = 0;
    public static final int JA_PROXY = 1;
    public static final int JA_DOWNLOAD = 2;
    public static final int JA_BOTH = 3;
    public static final int JA_NONE = 4;
    private static final String DEFAULT_UPDATE_TIMEOUT = "1500";
    private static final long DEFAULT_MUFFIN_LIMIT = 262144L;
    private static final int MAX_URLS_LEN = 16;
    private static int _nextAvailableJREIndex;
    private static final String[] DefaultSecureProperties;

    public int getCacheSize() {
        return this.getIntegerProperty(CACHE_SIZE_KEY);
    }

    public int getConsoleSize() {
        return this.getIntegerProperty(CONSOLE_SIZE_KEY);
    }

    int getJAuthenticator() {
        int n = 0;
        String string = ConfigProperties.getSystemProperty(JAUTHENTICATOR_SYSTEM_KEY);
        if (string == null) {
            string = this.getProperty(JAUTHENTICATOR_KEY);
        }
        if (string != null) {
            if ((string = string.toLowerCase()).equals("none")) {
                n = 4;
            } else if (string.equals("all")) {
                n = 0;
            } else if (string.equals("both")) {
                n = 3;
            } else {
                if (string.indexOf("proxy") >= 0) {
                    n |= 1;
                }
                if (string.indexOf("download") >= 0) {
                    n |= 2;
                }
            }
        }
        return n;
    }

    public static int getMaxUrlsLength() {
        return 16;
    }

    public static synchronized int getNextAvailableUserJREIndex() {
        return _nextAvailableJREIndex++;
    }

    public static int getPlayerManager() {
        String string = ConfigProperties.getInstance().getProperty(PLAYER_MANAGER_KEY);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getPlayerMode() {
        String string = ConfigProperties.getInstance().getProperty(PLAYER_MODE_KEY);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getProxyType() {
        String string = this.getProperty(PROXY_TYPE_KEY);
        if (string.compareToIgnoreCase(PROXY_NONE) == 0) {
            return 0;
        }
        if (string.compareToIgnoreCase(PROXY_MANUAL) == 0) {
            return 1;
        }
        return 2;
    }

    int getRapidUpdateTimeout() {
        return this.getIntegerProperty(UPDATE_TIMEOUT_KEY);
    }

    public int getWhatInstall() {
        return this.getIntegerProperty(WHAT_INSTALL_KEY);
    }

    public int getWhenInstall() {
        return this.getIntegerProperty(WHEN_INSTALL_KEY);
    }

    private long getDefaultMuffinSizeLimit() {
        return 262144L;
    }

    public long getMuffinSizeLimit() {
        return this.getLongProperty(MUFFIN_LIMIT_KEY, this.getDefaultMuffinSizeLimit());
    }

    static {
        _props = null;
        _nextAvailableJREIndex = 0;
        DefaultSecureProperties = new String[]{"sun.java2d.noddraw", "javax.swing.defaultlf", JAUTHENTICATOR_SYSTEM_KEY};
    }

    private ConfigProperties() {
        this.setupApplicationDefaultProperties();
        this.refresh();
        new File(JnlpxArgs.getDeploymentUserHome()).mkdirs();
        new File(this.getCacheDir()).mkdirs();
        this.setupDeploymentConfig();
    }

    public synchronized void refresh() {
        Object object;
        String string = ConfigProperties.getDeploymentUserPropertiesFilePath();
        Properties properties = new Properties();
        this._dirty = false;
        this.loadProperties(properties, string);
        _props = new Properties();
        this.mergeProperties(_props, _defaultProps);
        this.mergeProperties(_props, properties);
        this._jreInfoList = new ArrayList();
        this.readJREInfoProperties(JRE_KEY, _defaultProps, 1);
        this.readJREInfoProperties(JRE_KEY, properties, 0);
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = _props.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string2 = _props.getProperty((String)object);
            if (((String)object).startsWith(JRE_KEY) || string2 == null) continue;
            properties2.setProperty((String)object, string2);
        }
        _props = properties2;
        object = new File(string);
        this._lastChanged = ((File)object).exists() ? ((File)object).lastModified() : System.currentTimeMillis();
    }

    public synchronized void refreshIfNecessary() {
        if (!this.isDirty() && this.doesNewVersionExist()) {
            this.refresh();
        }
    }

    public void setVersionUpdated() {
        this.setProperty(VERSION_UPDATED_KEY, Globals.getComponentName());
    }

    private void setupApplicationDefaultProperties() {
        Properties properties = new Properties();
        this.loadProperties(properties, ConfigProperties.getDeploymentSystemPropertiesFilePath());
        _defaultProps = this.getPreSetProperties();
        this.mergeProperties(_defaultProps, properties);
    }

    private void setupDeploymentConfig() {
        Properties properties = new Properties();
        this.loadProperties(properties, JnlpxArgs.getDeploymentUserHome() + File.separator + CONFIG_FILE);
        String string = properties.getProperty(SYSTEM_POLICY_KEY);
        String string2 = properties.getProperty(USER_POLICY_KEY);
        if (string != null || string2 != null) {
            Object var5_4 = null;
            int n = 1;
            while (Security.getProperty("policy.url." + n) != null) {
                ++n;
            }
            if (string != null) {
                Security.setProperty("policy.url." + n++, string);
            }
            if (string2 != null) {
                Security.setProperty("policy.url." + n++, string2);
            }
        }
    }

    public synchronized void store() {
        this.storeHelper(ConfigProperties.getDeploymentUserPropertiesFilePath());
    }

    public void updateConfiguration() {
        String string = this.getProperty(VERSION_UPDATED_KEY);
        String string2 = Globals.getComponentName();
        if (Globals.TraceConfig) {
            Debug.println("in updateConfiguration, oldVersion = " + string + ", newVersion = " + string2);
        }
        if (string == null || string.length() == 0) {
            String string3 = ConfigProperties.getSystemProperty("user.home") + File.separator + ".javaws";
            String string4 = string3 + File.separator + "javaws.cfg";
            String string5 = string3 + File.separator + CACHE;
            String string6 = "javaws.cfg.jre.";
            Properties properties = new Properties();
            this.loadProperties(properties, string4);
            Enumeration<Object> enumeration = properties.keys();
            boolean bl = new File(string4).exists();
            boolean bl2 = false;
            while (enumeration.hasMoreElements()) {
                String string7 = null;
                String string8 = (String)enumeration.nextElement();
                if (string8.startsWith(string6)) {
                    bl2 = true;
                } else if (string8.equals("javaws.cfg.cache.dir")) {
                    bl = false;
                    string7 = CACHE_DIR_KEY;
                } else {
                    string7 = string8.startsWith("javaws.cfg.") ? string8.replaceFirst("javaws.cfg.", BASE) : (string8.startsWith("javaws.") ? string8.replaceFirst("javaws.", BASE) : string6);
                }
                if (string7 == null) continue;
                String string9 = properties.getProperty(string8);
                this.setProperty(string7, string9);
                if (!Globals.TraceConfig) continue;
                Debug.println("translated key:" + string8 + "\n" + "    to new key:" + string7);
            }
            if (bl2) {
                this.readJREInfoProperties(string6, properties, 0);
            }
            if (bl) {
                this.setProperty(CACHE_DIR_KEY, string5);
                if (Globals.TraceConfig) {
                    Debug.println("adding cache key:deployment.javaws.cache.dir, value:" + string5);
                }
            }
        } else if (string.startsWith("javaws-1.4.2")) {
            // empty if block
        }
        this.setVersionUpdated();
        this.store();
    }

    public synchronized boolean doesNewVersionExist() {
        File file = new File(ConfigProperties.getDeploymentUserPropertiesFilePath());
        return file.exists() && file.lastModified() > this._lastChanged;
    }

    boolean getForceUpdateCheck() {
        return this.getBooleanProperty(FORCE_UPDATE_CHECK);
    }

    public boolean getshowConsole() {
        return this.getBooleanProperty(SHOW_CONSOLE_KEY);
    }

    boolean isBrowserNetscape() {
        return this.getBooleanProperty(NETSCAPE_BROWSER_KEY);
    }

    private boolean isDirty() {
        return this._dirty;
    }

    public boolean isLogToFileEnabled() {
        return this.getBooleanProperty(LOG_TO_FILE_KEY);
    }

    public boolean isVersionCurrent() {
        String string = this.getProperty(VERSION_UPDATED_KEY);
        if (string == null) {
            return false;
        }
        return string.equals(Globals.getComponentName());
    }

    public static void setPlayerManager(int n) {
        ConfigProperties.getInstance().setProperty(PLAYER_MANAGER_KEY, "" + n);
    }

    public static void setPlayerMode(int n) {
        ConfigProperties.getInstance().setProperty(PLAYER_MODE_KEY, "" + n);
    }

    public void setWhatInstall(int n) {
        this.setProperty(WHAT_INSTALL_KEY, Integer.toString(n));
    }

    public void setWhenInstall(int n) {
        this.setProperty(WHEN_INSTALL_KEY, Integer.toString(n));
    }

    public static synchronized ConfigProperties getInstance() {
        if (_instance == null) {
            _instance = new ConfigProperties();
        }
        return _instance;
    }

    public static Rectangle getPlayerBounds() {
        String string = ConfigProperties.getInstance().getProperty(PLAYER_BOUNDS_KEY);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                if (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    try {
                        nArray[i] = Integer.parseInt(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return null;
            }
            return new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        return null;
    }

    public static void setPlayerBounds(Rectangle rectangle) {
        ConfigProperties.getInstance().setProperty(PLAYER_BOUNDS_KEY, "" + rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height);
    }

    public static String getApplicationHome() {
        String string = JnlpxArgs.getHome();
        if (string == null || string.length() == 0) {
            Debug.fatal("AppHome not set");
        }
        try {
            File file = new File(string);
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        return string;
    }

    public String getAutoUpdateURL() {
        return this.getProperty(AUTO_UPDATER_URL_KEY, DEFAULT_AUTO_UPDATER_URL);
    }

    String getBrowserPath() {
        return this.getProperty(BROWSER_PATH_KEY);
    }

    public String getCacheDir() {
        return this.getProperty(CACHE_DIR_KEY, this.getDefaultCacheDir());
    }

    private String getDefaultCacheDir() {
        return JnlpxArgs.getDeploymentUserHome() + File.separator + JAVAWS + File.separator + CACHE;
    }

    public String getDefaultLogDir() {
        return JnlpxArgs.getDeploymentUserHome() + File.separator + "log" + File.separator + JAVAWS;
    }

    private static String getDeploymentSystemPropertiesFilePath() {
        String string = JnlpxArgs.getDeploymentSystemHome();
        if (string == null || string.length() == 0) {
            Debug.fatal("DeploymentSystemHome not set");
        }
        return string + File.separator + PROPERTIES_FILE;
    }

    private static String getDeploymentUserPropertiesFilePath() {
        String string = JnlpxArgs.getDeploymentUserHome();
        if (string == null || string.length() == 0) {
            Debug.fatal("DeploymentUserHome not set");
        }
        return string + File.separator + PROPERTIES_FILE;
    }

    public String getHTTPProxy() {
        return this.getProperty(HTTP_PROXY_KEY);
    }

    public String getHTTPProxyPort() {
        return this.getProperty(HTTP_PROXY_PORT_KEY);
    }

    static String getJavaWSJarFilePath() {
        String string = ConfigProperties.getApplicationHome();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        String string2 = string + "javaws.jar" + File.pathSeparator + string + "javaws-l10n.jar";
        return string2;
    }

    public String getKnownPlatforms() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._jreInfoList.size(); ++i) {
            JREInformation jREInformation = (JREInformation)this._jreInfoList.get(i);
            stringBuffer.append(jREInformation.getPlatformVersionId());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public String getLogFileDir() {
        return this.getProperty(LOG_DIR_KEY, this.getDefaultLogDir());
    }

    public String getLogFilename() {
        String string = this.getLogFileDir() + File.separator + "TEMP";
        return this.getProperty(LOG_FILENAME_KEY, string);
    }

    public String getMuffinDir() {
        return this.getCacheDir() + File.separator + MUFFINS;
    }

    public String getProxyOverrideString() {
        return this.getProperty(OVERRIDE_KEY);
    }

    public String getRemoteURL() {
        return this.getProperty(REMOTE_APPS_KEY);
    }

    String getSplashCache() {
        return this.getSplashDir() + File.separator + SPLASH_INDEX;
    }

    String getSplashDir() {
        return this.getCacheDir() + File.separator + SPLASHES;
    }

    public static String getStartCommand() {
        String string = ConfigProperties.getApplicationHome();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = Globals.isWindowsPlatform() ? string + "javaws.exe" : string + JAVAWS;
        return string;
    }

    public String toString() {
        return super.toString() + "[" + " : " + this._jreInfoList + " : " + _props + "]";
    }

    public String[] getRemoteURLs() {
        String[] stringArray = new String[16];
        stringArray[0] = this.getProperty(REMOTE_APPS_KEY);
        for (int i = 1; i < 16; ++i) {
            stringArray[i] = this.getProperty("deployment.javaws.player.remoteURL." + i);
        }
        return stringArray;
    }

    private int getIntegerProperty(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProperty(String string) {
        ConfigProperties configProperties = this;
        synchronized (configProperties) {
            _props.remove(string);
            this._dirty = true;
        }
    }

    public void setCacheDir(String string) {
        this.setProperty(CACHE_DIR_KEY, string);
    }

    void setSplashCache(String string) {
        this.setProperty(SPLASH_CACHE_KEY, string);
    }

    private synchronized void storeHelper(String string) {
        Serializable serializable;
        if (_props != null) {
            serializable = new Properties();
            this.mergeProperties((Properties)serializable, _props);
            serializable = this.diffProperties((Properties)serializable, _defaultProps);
            this.updateJREInfoProperties((Properties)serializable, 0);
            this.updateJREEnabledProperties((Properties)serializable);
            File file = new File(string);
            file.getParentFile().mkdirs();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    ((Properties)serializable).store(fileOutputStream, "");
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                }
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._dirty = false;
        serializable = new File(ConfigProperties.getDeploymentUserPropertiesFilePath());
        this._lastChanged = ((File)serializable).exists() ? ((File)serializable).lastModified() : System.currentTimeMillis();
    }

    private boolean getBooleanProperty(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            return false;
        }
        return Boolean.valueOf(string2);
    }

    private long getLongProperty(String string, long l) {
        String string2 = this.get(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public void setRemoteURLs(String[] stringArray) {
        this.setProperty(REMOTE_APPS_KEY, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            this.setProperty("deployment.javaws.player.remoteURL." + i, stringArray[i]);
        }
    }

    URL getJREInstallURL() {
        try {
            URL uRL = new URL(this.getProperty(JRE_INSTALL_URL_KEY));
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ArrayList getBookmarks() {
        String string = null;
        String string2 = null;
        boolean bl = true;
        int n = 0;
        ArrayList<BookmarkEntry> arrayList = new ArrayList<BookmarkEntry>();
        while (bl) {
            string = this.getProperty("deployment.javaws.player.bookmark.name." + n);
            string2 = this.getProperty("deployment.javaws.player.bookmark.url." + n);
            this.removeProperty("deployment.javaws.player.bookmark.name." + n);
            this.removeProperty("deployment.javaws.player.bookmark.url." + n);
            if (string == "" && string2 == "") {
                bl = false;
            }
            if (string != null && string2 != null && !string.equals("") && !string2.equals("")) {
                if (Globals.TracePlayer) {
                    Debug.println("loaded bookmark: " + string + " " + string2);
                }
                BookmarkEntry bookmarkEntry = new BookmarkEntry(string, string2);
                arrayList.add(bookmarkEntry);
            }
            ++n;
        }
        return arrayList;
    }

    public ArrayList getJREInformationList() {
        return this._jreInfoList;
    }

    public void setBookmarks(ArrayList arrayList) {
        BookmarkEntry bookmarkEntry = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            bookmarkEntry = (BookmarkEntry)arrayList.get(i);
            if (Globals.TracePlayer) {
                Debug.println("setBookmarks: " + bookmarkEntry.getName() + " " + bookmarkEntry.getUrl());
            }
            this.setProperty("deployment.javaws.player.bookmark.name." + i, bookmarkEntry.getName());
            this.setProperty("deployment.javaws.player.bookmark.url." + i, bookmarkEntry.getUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getFavorites() {
        ConfigProperties configProperties = this;
        synchronized (configProperties) {
            int n = this.getIntegerProperty(FAVORITE_SIZE_KEY);
            if (n <= 0) {
                return new ArrayList(0).iterator();
            }
            ArrayList<String> arrayList = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                String string = this.getProperty(FAVORITES_KEY + Integer.toString(i));
                if (string == null || string.length() <= 0) continue;
                arrayList.add(string);
            }
            return arrayList.iterator();
        }
    }

    public Iterator getSecurePropertyKeys() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        int n = 0;
        while (n < DefaultSecureProperties.length) {
            arrayList.add(DefaultSecureProperties[n++]);
        }
        String string = this.get(SECURE_PROPS_KEY);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFavorites(Iterator iterator) {
        ConfigProperties configProperties = this;
        synchronized (configProperties) {
            int n = this.getIntegerProperty(FAVORITE_SIZE_KEY);
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    this.removeProperty(FAVORITES_KEY + Integer.toString(i));
                }
            }
            n = 0;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setProperty(FAVORITES_KEY + Integer.toString(n++), string);
                }
            }
            this.setProperty(FAVORITE_SIZE_KEY, Integer.toString(n));
        }
    }

    public List getProxyOverrideList() {
        String string = " \t\n\r\f,";
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getProxyOverrideString(), string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList;
    }

    private Properties getPreSetProperties() {
        Properties properties = new Properties();
        properties.setProperty(CACHE_DIR_KEY, this.getDefaultCacheDir());
        properties.setProperty(CACHE_SIZE_KEY, "10");
        properties.setProperty(PROXY_TYPE_KEY, PROXY_AUTO);
        properties.setProperty(SHOW_CONSOLE_KEY, "false");
        properties.setProperty(CONSOLE_SIZE_KEY, DEFAULT_CONSOLE_SIZE);
        properties.setProperty(BROWSER_PATH_KEY, DEFAULT_BROWSER_PATH);
        properties.setProperty(NETSCAPE_BROWSER_KEY, "true");
        properties.setProperty(JRE_INSTALL_URL_KEY, "http://java.sun.com/products/autodl/j2se");
        properties.setProperty(REMOTE_APPS_KEY, REMOTE_APPS_URL);
        properties.setProperty(AUTO_UPDATER_URL_KEY, DEFAULT_AUTO_UPDATER_URL);
        properties.setProperty(UPDATE_TIMEOUT_KEY, DEFAULT_UPDATE_TIMEOUT);
        return properties;
    }

    private void updateJREEnabledProperties(Properties properties) {
        for (int i = 0; i < this._jreInfoList.size(); ++i) {
            JREInformation jREInformation = (JREInformation)this._jreInfoList.get(i);
            jREInformation.setEnabledProperty(properties);
        }
    }

    private void updateJREInfoProperties(Properties properties, int n) {
        ArrayList<JREInformation> arrayList = new ArrayList<JREInformation>();
        for (int i = 0; i < this._jreInfoList.size(); ++i) {
            JREInformation jREInformation = (JREInformation)this._jreInfoList.get(i);
            if (arrayList.contains(jREInformation) || n != jREInformation.getWhereSpecified()) continue;
            jREInformation.toProperty(properties);
            arrayList.add(jREInformation);
        }
    }

    public void setProxy(int n, String string, int n2, String string2) {
        if (n == 0) {
            this.setProperty(PROXY_TYPE_KEY, PROXY_NONE);
        } else if (n == 1) {
            this.setProperty(PROXY_TYPE_KEY, PROXY_MANUAL);
        } else {
            this.setProperty(PROXY_TYPE_KEY, PROXY_AUTO);
        }
        if (string != null && string.length() > 0) {
            this.setProperty(HTTP_PROXY_KEY, string);
        }
        if (n2 < -1 || n2 > 65565) {
            n2 = -1;
        }
        if (n2 != -1) {
            this.setProperty(HTTP_PROXY_PORT_KEY, String.valueOf(n2));
        }
        if (string2 != null) {
            this.setProperty(OVERRIDE_KEY, string2.trim());
        }
    }

    public String get(String string) {
        return this.getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProperty(String string) {
        String string2;
        ConfigProperties configProperties = this;
        synchronized (configProperties) {
            string2 = _props.getProperty(string, "");
        }
        return string2.trim();
    }

    private static String getSystemProperty(String string) {
        return System.getProperty(string);
    }

    public static String getUninstallCommand(String string) {
        String string2 = ConfigProperties.getStartCommand();
        return string2 + " -uninstall @\"" + string + "\"";
    }

    public void put(String string, String string2) {
        this.setProperty(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperty(String string, String string2) {
        if (string2 == null) {
            this.removeProperty(string);
        } else {
            ConfigProperties configProperties = this;
            synchronized (configProperties) {
                _props.put(string, string2);
                this._dirty = true;
            }
        }
    }

    private int getJREIndex(String string, String string2, int n) {
        int n2 = -1;
        try {
            int n3 = string2.indexOf(46, string.length());
            if (n3 != -1) {
                String string3 = string2.substring(string.length(), n3);
                n2 = Integer.parseInt(string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Debug.ignoredException(numberFormatException);
        }
        return n2;
    }

    private void loadProperties(Properties properties, String string) {
        InputStream inputStream = null;
        try {
            HttpRequest httpRequest = JavawsFactory.getHttpRequestImpl();
            HttpResponse httpResponse = httpRequest.doGetRequest(new URL(string));
            inputStream = httpResponse.getInputStream();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (inputStream != null) {
            try {
                properties.load(inputStream);
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
            }
        }
    }

    private void readJREInfoProperties(String string, Properties properties, int n) {
        Integer n2;
        Object object;
        Vector<Integer> vector = new Vector<Integer>();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).startsWith(string) || (n2 = new Integer(this.getJREIndex(string, (String)object, n))) < 0 || vector.contains(n2)) continue;
            vector.add(n2);
        }
        Collections.sort(vector);
        object = null;
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            n2 = (Integer)enumeration.nextElement();
            object = JREInformation.fromProperty(string, properties, n2, n);
            if (object == null || this._jreInfoList.contains(object)) continue;
            this._jreInfoList.add(object);
            if (!Globals.TraceConfig) continue;
            Debug.println("Adding jre " + ((JREInformation)object).getIndex() + " with path: " + ((JREInformation)object).getInstalledPath());
        }
    }

    private void mergeProperties(Properties properties, Properties properties2) {
        if (properties == null || properties2 == null) {
            return;
        }
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties2.getProperty(string);
            properties.setProperty(string, string2);
        }
    }

    public JREInformation getJRE(URL uRL, String string) {
        VersionString versionString = new VersionString(string);
        for (int i = 0; i < this._jreInfoList.size(); ++i) {
            JREInformation jREInformation = (JREInformation)this._jreInfoList.get(i);
            if (!jREInformation.isProductMatch(uRL, versionString)) continue;
            return jREInformation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProperty(String string, String string2) {
        String string3;
        ConfigProperties configProperties = this;
        synchronized (configProperties) {
            string3 = _props.getProperty(string, string2);
        }
        if (string3 != null) {
            return string3.trim();
        }
        return string3;
    }

    private Properties diffProperties(Properties properties, Properties properties2) {
        if (properties2 == null) {
            return properties;
        }
        Properties properties3 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 == null || string2.equals(properties2.getProperty(string))) continue;
            properties3.setProperty(string, string2);
        }
        return properties3;
    }

    public static class JREInformation {
        public static final int SRC_USER = 0;
        public static final int SRC_INSTALL = 1;
        private String _platformVersionId;
        private String _productVersionId;
        private URL _productLocation;
        private String _osName;
        private String _osArch;
        private String _installedPath;
        private boolean _isFCSVersion;
        private int _whereSpecified;
        private boolean _isEnabled;
        private boolean _isRegistered;
        private int _index;

        public int getIndex() {
            return this._index;
        }

        public int getWhereSpecified() {
            return this._whereSpecified;
        }

        public final int hashCode() {
            return this._platformVersionId == null ? 0 : this._platformVersionId.hashCode();
        }

        JREInformation() {
            this._osName = null;
            this._osArch = null;
            this._platformVersionId = null;
            this._productVersionId = null;
            this._productLocation = null;
            this._installedPath = null;
            this._isFCSVersion = true;
            this._whereSpecified = 0;
            this._isEnabled = true;
            this._isRegistered = false;
            this._index = _nextAvailableJREIndex;
        }

        boolean isCurrentRunningJRE() {
            File file = JnlpxArgs.getJVMCommand();
            return file.equals(new File(this._installedPath));
        }

        public boolean isEnabled() {
            return this._isEnabled;
        }

        private boolean isInstallJRE() {
            File file = new File(ConfigProperties.getApplicationHome()).getParentFile();
            File file2 = new File(this._installedPath).getParentFile();
            return file != null && file2 != null && file.equals(file2.getParentFile());
        }

        public boolean isRegistered() {
            return this._isRegistered;
        }

        public void setEnabled(boolean bl) {
            this._isEnabled = bl;
        }

        public JREInformation copy() {
            return new JREInformation(this._platformVersionId, this._productVersionId, this._productLocation, this._installedPath, this._whereSpecified, this._isEnabled, this._index, this._osName, this._osArch, this._isRegistered);
        }

        boolean isPlatformMatch(VersionString versionString) {
            return this._isFCSVersion && versionString.contains(this._platformVersionId);
        }

        public final boolean equals(Object object) {
            if (object == null || !(object instanceof JREInformation)) {
                return false;
            }
            JREInformation jREInformation = (JREInformation)object;
            return JREInformation.equalsHelper(this._platformVersionId, jREInformation._platformVersionId) && JREInformation.equalsHelper(this._productVersionId, jREInformation._productVersionId) && URLUtil.equals(this._productLocation, jREInformation._productLocation) && JREInformation.equalsHelper(this._installedPath, jREInformation._installedPath) && JREInformation.equalsHelper(this._osName, jREInformation._osName) && JREInformation.equalsHelper(this._osArch, jREInformation._osArch);
        }

        public String getInstalledPath() {
            return this._installedPath;
        }

        public String getOsArch() {
            return this._osArch;
        }

        public String getOsName() {
            return this._osName;
        }

        public String getPlatformVersionId() {
            return this._platformVersionId;
        }

        public String getProductVersionId() {
            return this._productVersionId;
        }

        public String toString() {
            return "JREInformation [prod=" + this.getProductVersionId() + ",plat=" + this.getPlatformVersionId() + "," + this.getInstalledPath() + "," + this.getProductLocation() + ",cur=" + this.isCurrentRunningJRE() + ",src=" + this.getWhereSpecified() + ",osName=" + this._osName + ",osArch=" + this._osArch + "]";
        }

        public URL getProductLocation() {
            return this._productLocation;
        }

        private void setEnabledProperty(Properties properties) {
            String string = ConfigProperties.JRE_KEY;
            if (this._platformVersionId != null) {
                properties.setProperty(string + this._index + ConfigProperties.JRE_ISENABLED, new Boolean(this._isEnabled).toString());
            }
        }

        private void toProperty(Properties properties) {
            if (this._platformVersionId != null) {
                this.setJREKey(properties, this._index, ConfigProperties.JRE_PLATFORM_ID, this._platformVersionId);
                this.setJREKey(properties, this._index, ConfigProperties.JRE_PRODUCT_ID, this._productVersionId);
                this.setJREKey(properties, this._index, ConfigProperties.JRE_PRODUCT_LOCATION, this._productLocation.toString());
                this.setJREKey(properties, this._index, ConfigProperties.JRE_PATH, this._installedPath);
                this.setJREKey(properties, this._index, ConfigProperties.JRE_OS_NAME, this._osName);
                this.setJREKey(properties, this._index, ConfigProperties.JRE_OS_ARCH, this._osArch);
                this.setJREKey(properties, this._index, ConfigProperties.JRE_ISREGISTERED, new Boolean(this._isRegistered).toString());
            }
        }

        boolean isProductMatch(URL uRL, VersionString versionString) {
            return URLUtil.equals(uRL, this._productLocation) && versionString.contains(this._productVersionId);
        }

        private static boolean equalsHelper(Object object, Object object2) {
            if (object == null || object2 == null) {
                return object == object2;
            }
            return object.equals(object2);
        }

        public void setOsInfo(String string, String string2) {
            this._osName = string;
            this._osArch = string2;
            if (this._osName != null && this._osName.startsWith("Windows")) {
                this._osName = "Windows";
            }
        }

        public void setVersions(String string, String string2) {
            this._platformVersionId = string;
            this._productVersionId = string2;
            if (this._productLocation == null) {
                try {
                    this._productLocation = new URL("http://java.sun.com/products/autodl/j2se");
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.ignoredException(malformedURLException);
                }
            }
        }

        public boolean isOsInfoMatch(String string, String string2) {
            if (this._osName == null || this._osArch == null) {
                return true;
            }
            return this._osName.equals(string) && this._osArch.equals(string2);
        }

        private static JREInformation fromProperty(String string, Properties properties, int n, int n2) {
            String string2 = properties.getProperty(string + n + ConfigProperties.JRE_PLATFORM_ID);
            String string3 = properties.getProperty(string + n + ConfigProperties.JRE_PRODUCT_ID);
            String string4 = properties.getProperty(string + n + ConfigProperties.JRE_PRODUCT_LOCATION);
            String string5 = properties.getProperty(string + n + ConfigProperties.JRE_PATH);
            String string6 = properties.getProperty(string + n + ConfigProperties.JRE_OS_NAME);
            String string7 = properties.getProperty(string + n + ConfigProperties.JRE_OS_ARCH);
            boolean bl = new Boolean(_props.getProperty(string + n + ConfigProperties.JRE_ISENABLED, "true"));
            boolean bl2 = new Boolean(_props.getProperty(string + n + ConfigProperties.JRE_ISREGISTERED, "true"));
            try {
                if (string2 != null && string5 != null) {
                    URL uRL;
                    URL uRL2 = uRL = string4 == null || string4.length() == 0 ? null : new URL(string4);
                    if (n2 == 0) {
                        n = _nextAvailableJREIndex++;
                    } else if (n2 == 1 && n >= _nextAvailableJREIndex) {
                        _nextAvailableJREIndex = n + 1;
                    }
                    JREInformation jREInformation = new JREInformation(string2, string3, uRL, string5, n2, bl, n, string6, string7, bl2);
                    return jREInformation;
                }
            }
            catch (MalformedURLException malformedURLException) {
                Debug.ignoredException(malformedURLException);
            }
            return null;
        }

        private void setJREKey(Properties properties, int n, String string, String string2) {
            if (string2 != null) {
                properties.setProperty(ConfigProperties.JRE_KEY + n + string, string2);
            }
        }

        public JREInformation(String string, String string2, URL uRL, String string3, int n, boolean bl, int n2, String string4, String string5) {
            this(string, string2, uRL, string3, n, bl, n2, string4, string5, false);
        }

        public JREInformation(String string, String string2, URL uRL, String string3, int n, boolean bl, int n2, String string4, String string5, boolean bl2) {
            this.setOsInfo(string4, string5);
            this._platformVersionId = string;
            this._productVersionId = string2;
            this._productLocation = uRL;
            this._installedPath = string3;
            this._whereSpecified = n;
            this._isEnabled = bl;
            this._isRegistered = bl2;
            this._index = n2;
            if (this._productLocation == null) {
                try {
                    this._productLocation = new URL("http://java.sun.com/products/autodl/j2se");
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.ignoredException(malformedURLException);
                }
            }
            this._isFCSVersion = this._productVersionId == null || this._productVersionId.indexOf(45) == -1 || this._productVersionId.startsWith("1.2") || this.isInstallJRE();
        }
    }
}

