/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtDownloadDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.LibraryDesc;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.jnl.XMLReader;
import com.sun.javaws.util.GeneralUtil;
import com.sun.javaws.util.URLUtil;
import com.sun.javaws.xml.XMLNode;
import com.sun.javaws.xml.XMLParser;
import com.sun.javaws.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public class XMLFormat {
    public static LaunchDesc parse(byte[] byArray) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        XMLReader xMLReader = (XMLReader)XMLReader.createReader(byteArrayInputStream);
        String string = xMLReader.getEncoding();
        xMLReader.close();
        String string2 = new String(byArray, string);
        XMLNode xMLNode = new XMLParser(string2).parse();
        InformationDesc informationDesc = null;
        ResourcesDesc resourcesDesc = null;
        ApplicationDesc applicationDesc = null;
        AppletDesc appletDesc = null;
        LibraryDesc libraryDesc = null;
        InstallerDesc installerDesc = null;
        String string3 = null;
        if (xMLNode.getName().equals("player")) {
            return LaunchDescFactory.buildPlayerLaunchDesc(string2);
        }
        if (!xMLNode.getName().equals("jnlp")) {
            throw new MissingFieldException(string2, "<jnlp>");
        }
        String string4 = XMLUtils.getAttribute(xMLNode, "", "spec", "1.0+");
        String string5 = XMLUtils.getAttribute(xMLNode, "", "version");
        URL uRL = URLUtil.asPathURL(XMLUtils.getAttributeURL(string2, xMLNode, "", "codebase"));
        URL uRL2 = XMLUtils.getAttributeURL(string2, uRL, xMLNode, "", "href");
        int n2 = 0;
        if (XMLUtils.isElementPath(xMLNode, "<security><all-permissions>")) {
            n2 = 1;
        } else if (XMLUtils.isElementPath(xMLNode, "<security><j2ee-application-client-permissions>")) {
            n2 = 2;
        }
        if (XMLUtils.isElementPath(xMLNode, "<application-desc>")) {
            n = 1;
            applicationDesc = XMLFormat.buildApplicationDesc(string2, xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<component-desc>")) {
            n = 3;
            libraryDesc = new LibraryDesc();
        } else if (XMLUtils.isElementPath(xMLNode, "<installer-desc>")) {
            n = 4;
            installerDesc = XMLFormat.buildInstallerDesc(string2, uRL, xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<applet-desc>")) {
            n = 2;
            appletDesc = XMLFormat.buildAppletDesc(string2, uRL, xMLNode);
        } else {
            throw new MissingFieldException(string2, "<jnlp>(<application-desc>|<applet-desc>|<installer-desc>|<component-desc>)");
        }
        informationDesc = XMLFormat.buildInformationDesc(string2, uRL, xMLNode);
        resourcesDesc = XMLFormat.buildResourcesDesc(string2, uRL, xMLNode, false);
        LaunchDesc launchDesc = new LaunchDesc(string4, uRL, uRL2, string5, informationDesc, n2, resourcesDesc, n, applicationDesc, appletDesc, libraryDesc, installerDesc, string3, string2);
        return launchDesc;
    }

    public static boolean matchDefaultLocale(String[] stringArray) {
        return GeneralUtil.matchLocale(stringArray, Globals.getLocale());
    }

    private static ApplicationDesc buildApplicationDesc(final String string, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getAttribute(xMLNode, "<application-desc>", "main-class");
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<application-desc><argument>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string2 = XMLUtils.getElementContents(xMLNode, "", null);
                if (string2 == null) {
                    throw new BadFieldException(string, XMLUtils.getPathString(xMLNode), "");
                }
                arrayList.add(string2);
            }
        });
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return new ApplicationDesc(string2, stringArray);
    }

    private static ExtDownloadDesc[] getExtDownloadDescs(final String string, XMLNode xMLNode) throws BadFieldException, MissingFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<ext-download>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException {
                String string4 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "ext-part");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "part");
                String string3 = XMLUtils.getAttribute(xMLNode, "", "download", "eager");
                boolean bl = "lazy".equals(string3);
                arrayList.add(new ExtDownloadDesc(string4, string2, bl));
            }
        });
        ExtDownloadDesc[] extDownloadDescArray = new ExtDownloadDesc[arrayList.size()];
        return arrayList.toArray(extDownloadDescArray);
    }

    private static InformationDesc combineInformationDesc(InformationDesc informationDesc, InformationDesc informationDesc2) {
        if (informationDesc == null) {
            return informationDesc2;
        }
        if (informationDesc2 == null) {
            return informationDesc;
        }
        String string = informationDesc.getTitle() != null ? informationDesc.getTitle() : informationDesc2.getTitle();
        String string2 = informationDesc.getVendor() != null ? informationDesc.getVendor() : informationDesc2.getVendor();
        URL uRL = informationDesc.getHome() != null ? informationDesc.getHome() : informationDesc2.getHome();
        String[] stringArray = new String[4];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = informationDesc.getDescription(i) != null ? informationDesc.getDescription(i) : informationDesc2.getDescription(i);
        }
        ArrayList<IconDesc> arrayList = new ArrayList<IconDesc>();
        if (informationDesc2.getIcons() != null) {
            arrayList.addAll(Arrays.asList(informationDesc2.getIcons()));
        }
        if (informationDesc.getIcons() != null) {
            arrayList.addAll(Arrays.asList(informationDesc.getIcons()));
        }
        IconDesc[] iconDescArray = new IconDesc[arrayList.size()];
        iconDescArray = arrayList.toArray(iconDescArray);
        boolean bl = informationDesc.supportsOfflineOperation() || informationDesc.supportsOfflineOperation();
        return new InformationDesc(string, string2, uRL, stringArray, iconDescArray, bl, null);
    }

    private static AppletDesc buildAppletDesc(final String string, URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getRequiredAttribute(string, xMLNode, "<applet-desc>", "main-class");
        String string3 = XMLUtils.getRequiredAttribute(string, xMLNode, "<applet-desc>", "name");
        URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "<applet-desc>", "documentbase");
        int n = XMLUtils.getRequiredIntAttribute(string, xMLNode, "<applet-desc>", "width");
        int n2 = XMLUtils.getRequiredIntAttribute(string, xMLNode, "<applet-desc>", "height");
        if (n <= 0) {
            throw new BadFieldException(string, XMLUtils.getPathString(xMLNode) + "<applet-desc>width", new Integer(n).toString());
        }
        if (n2 <= 0) {
            throw new BadFieldException(string, XMLUtils.getPathString(xMLNode) + "<applet-desc>height", new Integer(n2).toString());
        }
        final Properties properties = new Properties();
        XMLUtils.visitElements(xMLNode, "<applet-desc><param>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string3 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
                String string2 = XMLUtils.getRequiredAttributeEmptyOK(string, xMLNode, "", "value");
                properties.setProperty(string3, string2);
            }
        });
        return new AppletDesc(string3, string2, uRL2, n, n2, properties);
    }

    private static InformationDesc buildInformationDesc(final String string, final URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<information>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws BadFieldException, MissingFieldException {
                String[] stringArray = GeneralUtil.getStringList(XMLUtils.getAttribute(xMLNode, "", "locale"));
                String string3 = XMLUtils.getElementContents(xMLNode, "<title>");
                String string2 = XMLUtils.getElementContents(xMLNode, "<vendor>");
                URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "<homepage>", "href");
                String[] stringArray2 = new String[4];
                stringArray2[0] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "", null);
                stringArray2[2] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "one-line", null);
                stringArray2[1] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "short", null);
                stringArray2[3] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "tooltip", null);
                ArrayList arrayList2 = new ArrayList();
                XMLUtils.visitElements(xMLNode, "<icon>", new XMLUtils.ElementVisitor(this, arrayList2){
                    private final /* synthetic */ ArrayList val$iconList;
                    private final /* synthetic */ 1 this$0;

                    public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                        String string = XMLUtils.getAttribute(xMLNode, "", "kind", "");
                        URL uRL = XMLUtils.getRequiredURL(1.access$000(this.this$0), 1.access$100(this.this$0), xMLNode, "", "href");
                        String string2 = XMLUtils.getAttribute(xMLNode, "", "version", null);
                        int n = XMLUtils.getIntAttribute(1.access$000(this.this$0), xMLNode, "", "height", 0);
                        int n2 = XMLUtils.getIntAttribute(1.access$000(this.this$0), xMLNode, "", "width", 0);
                        int n3 = XMLUtils.getIntAttribute(1.access$000(this.this$0), xMLNode, "", "depth", 0);
                        int n4 = 0;
                        if (string.equals("selected")) {
                            n4 = 1;
                        } else if (string.equals("disabled")) {
                            n4 = 2;
                        } else if (string.equals("rollover")) {
                            n4 = 3;
                        } else if (string.equals("splash")) {
                            n4 = 4;
                        }
                        this.val$iconList.add(new IconDesc(uRL, string2, n, n2, n3, n4));
                    }
                    {
                        this.this$0 = var1_1;
                        this.val$iconList = arrayList;
                    }
                });
                IconDesc[] iconDescArray = new IconDesc[arrayList2.size()];
                iconDescArray = arrayList2.toArray(iconDescArray);
                InformationDesc informationDesc = new InformationDesc(string3, string2, uRL2, stringArray2, iconDescArray, XMLUtils.isElementPath(xMLNode, "<offline-allowed>"), stringArray);
                arrayList.add(informationDesc);
            }

            static /* synthetic */ String access$000(1 var0) {
                return var0.string;
            }

            static /* synthetic */ URL access$100(1 var0) {
                return var0.uRL;
            }
        });
        InformationDesc informationDesc = new InformationDesc(null, null, null, null, null, false, null);
        for (int i = 0; i < arrayList.size(); ++i) {
            InformationDesc informationDesc2 = (InformationDesc)arrayList.get(i);
            if (!XMLFormat.matchDefaultLocale(informationDesc2.getLocaleList())) continue;
            informationDesc = XMLFormat.combineInformationDesc(informationDesc2, informationDesc);
        }
        if (informationDesc.getTitle() == null) {
            throw new MissingFieldException(string, "<jnlp><information><title>");
        }
        if (informationDesc.getVendor() == null) {
            throw new MissingFieldException(string, "<jnlp><information><vendor>");
        }
        return informationDesc;
    }

    private static InstallerDesc buildInstallerDesc(String string, URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getAttribute(xMLNode, "<installer-desc>", "main-class");
        return new InstallerDesc(string2);
    }

    static /* synthetic */ void access$600(String string, URL uRL, XMLNode xMLNode, ResourcesDesc resourcesDesc, boolean bl) throws MissingFieldException, BadFieldException {
        XMLFormat.handleResourceElement(string, uRL, xMLNode, resourcesDesc, bl);
    }

    private static void handleResourceElement(String string, URL uRL, XMLNode xMLNode, ResourcesDesc resourcesDesc, boolean bl) throws MissingFieldException, BadFieldException {
        String string2 = xMLNode.getName();
        if (string2.equals("jar") || string2.equals("nativelib")) {
            URL uRL2 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
            String string3 = XMLUtils.getAttribute(xMLNode, "", "version", null);
            String string4 = XMLUtils.getAttribute(xMLNode, "", "download");
            String string5 = XMLUtils.getAttribute(xMLNode, "", "main");
            String string6 = XMLUtils.getAttribute(xMLNode, "", "part");
            int n = XMLUtils.getIntAttribute(string, xMLNode, "", "size", 0);
            boolean bl2 = string2.equals("nativelib");
            boolean bl3 = false;
            boolean bl4 = false;
            if ("lazy".equalsIgnoreCase(string4)) {
                bl3 = true;
            }
            if ("true".equalsIgnoreCase(string5)) {
                bl4 = true;
            }
            resourcesDesc.addResource(new JARDesc(uRL2, string3, bl3, bl4, bl2, string6, n, resourcesDesc));
        } else if (string2.equals("property")) {
            String string7 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
            String string8 = XMLUtils.getRequiredAttributeEmptyOK(string, xMLNode, "", "value");
            resourcesDesc.addResource(new PropertyDesc(string7, string8));
        } else if (string2.equals("package")) {
            String string9 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
            String string10 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "part");
            String string11 = XMLUtils.getAttribute(xMLNode, "", "recursive", "false");
            boolean bl5 = "true".equals(string11);
            resourcesDesc.addResource(new PackageDesc(string9, string10, bl5));
        } else if (string2.equals("extension")) {
            String string12 = XMLUtils.getAttribute(xMLNode, "", "name");
            URL uRL3 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
            String string13 = XMLUtils.getAttribute(xMLNode, "", "version", null);
            ExtDownloadDesc[] extDownloadDescArray = XMLFormat.getExtDownloadDescs(string, xMLNode);
            resourcesDesc.addResource(new ExtensionDesc(string12, uRL3, string13, extDownloadDescArray));
        } else if (string2.equals("j2se") && !bl) {
            String string14 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "version");
            URL uRL4 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "", "href");
            String string15 = XMLUtils.getAttribute(xMLNode, "", "initial-heap-size");
            String string16 = XMLUtils.getAttribute(xMLNode, "", "max-heap-size");
            long l = -1L;
            long l2 = -1L;
            l = GeneralUtil.heapValToLong(string15);
            l2 = GeneralUtil.heapValToLong(string16);
            ResourcesDesc resourcesDesc2 = XMLFormat.buildResourcesDesc(string, uRL, xMLNode, true);
            JREDesc jREDesc = new JREDesc(string14, l, l2, uRL4, resourcesDesc2);
            resourcesDesc.addResource(jREDesc);
        }
    }

    static final ResourcesDesc buildResourcesDesc(final String string, final URL uRL, XMLNode xMLNode, final boolean bl) throws MissingFieldException, BadFieldException {
        final ResourcesDesc resourcesDesc = new ResourcesDesc();
        XMLUtils.visitElements(xMLNode, "<resources>", new XMLUtils.ElementVisitor(){

            static /* synthetic */ boolean access$500(3 var0) {
                return var0.bl;
            }

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String[] stringArray = GeneralUtil.getStringList(XMLUtils.getAttribute(xMLNode, "", "os", null));
                String[] stringArray2 = GeneralUtil.getStringList(XMLUtils.getAttribute(xMLNode, "", "arch", null));
                String[] stringArray3 = GeneralUtil.getStringList(XMLUtils.getAttribute(xMLNode, "", "locale", null));
                if (GeneralUtil.prefixMatchStringList(stringArray, Globals.getOperatingSystemID()) && GeneralUtil.prefixMatchStringList(stringArray2, Globals.getArchitectureID()) && XMLFormat.matchDefaultLocale(stringArray3)) {
                    XMLUtils.visitChildrenElements(xMLNode, new XMLUtils.ElementVisitor(this){
                        private final /* synthetic */ 3 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                            XMLFormat.access$600(3.access$200(this.this$0), 3.access$300(this.this$0), xMLNode, 3.access$400(this.this$0), 3.access$500(this.this$0));
                        }
                    });
                }
            }

            static /* synthetic */ ResourcesDesc access$400(3 var0) {
                return var0.resourcesDesc;
            }

            static /* synthetic */ String access$200(3 var0) {
                return var0.string;
            }

            static /* synthetic */ URL access$300(3 var0) {
                return var0.uRL;
            }
        });
        return resourcesDesc.isEmpty() ? null : resourcesDesc;
    }
}

