/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class BorderLayout
implements LayoutManager2,
Serializable {
    int hgap;
    int vgap;
    Component north;
    Component west;
    Component east;
    Component south;
    Component center;
    Component firstLine;
    Component lastLine;
    Component firstItem;
    Component lastItem;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    public static final String BEFORE_FIRST_LINE = "First";
    public static final String AFTER_LAST_LINE = "Last";
    public static final String BEFORE_LINE_BEGINS = "Before";
    public static final String AFTER_LINE_ENDS = "After";
    public static final String PAGE_START = "First";
    public static final String PAGE_END = "Last";
    public static final String LINE_START = "Before";
    public static final String LINE_END = "After";
    private static final long serialVersionUID = -8658291919501921765L;

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public BorderLayout() {
        this(0, 0);
    }

    public void setHgap(int n2) {
        this.hgap = n2;
    }

    public void setVgap(int n2) {
        this.vgap = n2;
    }

    public BorderLayout(int n2, int n3) {
        this.hgap = n2;
        this.vgap = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component == this.center) {
                this.center = null;
            } else if (component == this.north) {
                this.north = null;
            } else if (component == this.south) {
                this.south = null;
            } else if (component == this.east) {
                this.east = null;
            } else if (component == this.west) {
                this.west = null;
            }
            if (component == this.firstLine) {
                this.firstLine = null;
            } else if (component == this.lastLine) {
                this.lastLine = null;
            } else if (component == this.firstItem) {
                this.firstItem = null;
            } else if (component == this.lastItem) {
                this.lastItem = null;
            }
        }
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension;
            Insets insets = container.getInsets();
            int n2 = insets.top;
            int n3 = container.height - insets.bottom;
            int n4 = insets.left;
            int n5 = container.width - insets.right;
            boolean bl2 = container.getComponentOrientation().isLeftToRight();
            Component component = null;
            component = this.getChild(NORTH, bl2);
            if (component != null) {
                component.setSize(n5 - n4, component.height);
                dimension = component.getPreferredSize();
                component.setBounds(n4, n2, n5 - n4, dimension.height);
                n2 += dimension.height + this.vgap;
            }
            if ((component = this.getChild(SOUTH, bl2)) != null) {
                component.setSize(n5 - n4, component.height);
                dimension = component.getPreferredSize();
                component.setBounds(n4, n3 - dimension.height, n5 - n4, dimension.height);
                n3 -= dimension.height + this.vgap;
            }
            if ((component = this.getChild(EAST, bl2)) != null) {
                component.setSize(component.width, n3 - n2);
                dimension = component.getPreferredSize();
                component.setBounds(n5 - dimension.width, n2, dimension.width, n3 - n2);
                n5 -= dimension.width + this.hgap;
            }
            if ((component = this.getChild(WEST, bl2)) != null) {
                component.setSize(component.width, n3 - n2);
                dimension = component.getPreferredSize();
                component.setBounds(n4, n2, dimension.width, n3 - n2);
                n4 += dimension.width + this.hgap;
            }
            if ((component = this.getChild(CENTER, bl2)) != null) {
                component.setBounds(n4, n2, n5 - n4, n3 - n2);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(String string, Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (string == null) {
                string = CENTER;
            }
            if (CENTER.equals(string)) {
                this.center = component;
            } else if (NORTH.equals(string)) {
                this.north = component;
            } else if (SOUTH.equals(string)) {
                this.south = component;
            } else if (EAST.equals(string)) {
                this.east = component;
            } else if (WEST.equals(string)) {
                this.west = component;
            } else if ("First".equals(string)) {
                this.firstLine = component;
            } else if ("Last".equals(string)) {
                this.lastLine = component;
            } else if ("Before".equals(string)) {
                this.firstItem = component;
            } else if ("After".equals(string)) {
                this.lastItem = component;
            } else {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
            }
        }
    }

    private Component getChild(String string, boolean bl2) {
        Component component = null;
        if (string == NORTH) {
            component = this.firstLine != null ? this.firstLine : this.north;
        } else if (string == SOUTH) {
            component = this.lastLine != null ? this.lastLine : this.south;
        } else if (string == WEST) {
            Component component2 = component = bl2 ? this.firstItem : this.lastItem;
            if (component == null) {
                component = this.west;
            }
        } else if (string == EAST) {
            Component component3 = component = bl2 ? this.lastItem : this.firstItem;
            if (component == null) {
                component = this.east;
            }
        } else if (string == CENTER) {
            component = this.center;
        }
        if (component != null && !component.visible) {
            component = null;
        }
        return component;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Cloneable cloneable;
            Dimension dimension = new Dimension(0, 0);
            boolean bl2 = container.getComponentOrientation().isLeftToRight();
            Component component = null;
            component = this.getChild(EAST, bl2);
            if (component != null) {
                cloneable = component.getMinimumSize();
                dimension.width += cloneable.width + this.hgap;
                dimension.height = Math.max(cloneable.height, dimension.height);
            }
            if ((component = this.getChild(WEST, bl2)) != null) {
                cloneable = component.getMinimumSize();
                dimension.width += cloneable.width + this.hgap;
                dimension.height = Math.max(cloneable.height, dimension.height);
            }
            if ((component = this.getChild(CENTER, bl2)) != null) {
                cloneable = component.getMinimumSize();
                dimension.width += cloneable.width;
                dimension.height = Math.max(cloneable.height, dimension.height);
            }
            if ((component = this.getChild(NORTH, bl2)) != null) {
                cloneable = component.getMinimumSize();
                dimension.width = Math.max(cloneable.width, dimension.width);
                dimension.height += cloneable.height + this.vgap;
            }
            if ((component = this.getChild(SOUTH, bl2)) != null) {
                cloneable = component.getMinimumSize();
                dimension.width = Math.max(cloneable.width, dimension.width);
                dimension.height += cloneable.height + this.vgap;
            }
            cloneable = container.getInsets();
            dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
            dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Cloneable cloneable;
            Dimension dimension = new Dimension(0, 0);
            boolean bl2 = container.getComponentOrientation().isLeftToRight();
            Component component = null;
            component = this.getChild(EAST, bl2);
            if (component != null) {
                cloneable = component.getPreferredSize();
                dimension.width += cloneable.width + this.hgap;
                dimension.height = Math.max(cloneable.height, dimension.height);
            }
            if ((component = this.getChild(WEST, bl2)) != null) {
                cloneable = component.getPreferredSize();
                dimension.width += cloneable.width + this.hgap;
                dimension.height = Math.max(cloneable.height, dimension.height);
            }
            if ((component = this.getChild(CENTER, bl2)) != null) {
                cloneable = component.getPreferredSize();
                dimension.width += cloneable.width;
                dimension.height = Math.max(cloneable.height, dimension.height);
            }
            if ((component = this.getChild(NORTH, bl2)) != null) {
                cloneable = component.getPreferredSize();
                dimension.width = Math.max(cloneable.width, dimension.width);
                dimension.height += cloneable.height + this.vgap;
            }
            if ((component = this.getChild(SOUTH, bl2)) != null) {
                cloneable = component.getPreferredSize();
                dimension.width = Math.max(cloneable.width, dimension.width);
                dimension.height += cloneable.height + this.vgap;
            }
            cloneable = container.getInsets();
            dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
            dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object != null && !(object instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)object, component);
        }
    }
}

