/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.EventQueueItem;
import java.awt.MenuComponent;
import java.awt.Queue;
import java.awt.SentEvent;
import java.awt.SequencedEvent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.LightweightPeer;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EmptyStackException;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.DebugHelper;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;

public class EventQueue {
    private static final DebugHelper dbg = DebugHelper.create(EventQueue.class);
    private static int threadInitNumber;
    private static final int LOW_PRIORITY = 0;
    private static final int NORM_PRIORITY = 1;
    private static final int HIGH_PRIORITY = 2;
    private static final int NUM_PRIORITIES = 3;
    private Queue[] queues = new Queue[3];
    private EventQueue nextQueue;
    private EventQueue previousQueue;
    private EventDispatchThread dispatchThread;
    private final ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static final boolean debug = false;
    private long mostRecentEventTime = System.currentTimeMillis();
    private WeakReference currentEvent;
    private int waitForID;
    private final String name = "AWT-EventQueue-" + EventQueue.nextThreadNum();

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public static long getMostRecentEventTime() {
        return Toolkit.getEventQueue().getMostRecentEventTimeImpl();
    }

    private synchronized long getMostRecentEventTimeImpl() {
        return Thread.currentThread() == this.dispatchThread ? this.mostRecentEventTime : System.currentTimeMillis();
    }

    public EventQueue() {
        for (int i2 = 0; i2 < 3; ++i2) {
            this.queues[i2] = new Queue();
        }
    }

    final void detachDispatchThread() {
        this.dispatchThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initDispatchThread() {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.dispatchThread == null && !this.threadGroup.isDestroyed()) {
                this.dispatchThread = (EventDispatchThread)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        EventDispatchThread eventDispatchThread = new EventDispatchThread(EventQueue.this.threadGroup, EventQueue.this.name, EventQueue.this);
                        eventDispatchThread.setContextClassLoader(EventQueue.this.classLoader);
                        eventDispatchThread.setPriority(6);
                        eventDispatchThread.setDaemon(false);
                        return eventDispatchThread;
                    }
                });
                AWTAutoShutdown.getInstance().notifyThreadBusy(this.dispatchThread);
                this.dispatchThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pop() throws EmptyStackException {
        EventQueue eventQueue = this.previousQueue;
        Object object = eventQueue != null ? eventQueue : this;
        synchronized (object) {
            EventQueue eventQueue2 = this;
            synchronized (eventQueue2) {
                if (this.nextQueue != null) {
                    this.nextQueue.pop();
                    return;
                }
                if (this.previousQueue == null) {
                    throw new EmptyStackException();
                }
                this.previousQueue.nextQueue = null;
                while (this.peekEvent() != null) {
                    try {
                        this.previousQueue.postEventPrivate(this.getNextEvent());
                    }
                    catch (InterruptedException interruptedException) {}
                }
                AppContext appContext = AppContext.getAppContext();
                if (appContext.get(AppContext.EVENT_QUEUE_KEY) == this) {
                    appContext.put(AppContext.EVENT_QUEUE_KEY, this.previousQueue);
                }
                this.previousQueue = null;
            }
        }
        object = this.dispatchThread;
        if (object != null) {
            ((EventDispatchThread)object).stopDispatching();
        }
    }

    public static boolean isDispatchThread() {
        EventQueue eventQueue = Toolkit.getEventQueue();
        EventQueue eventQueue2 = eventQueue.nextQueue;
        while (eventQueue2 != null) {
            eventQueue = eventQueue2;
            eventQueue2 = eventQueue.nextQueue;
        }
        return Thread.currentThread() == eventQueue.dispatchThread;
    }

    private boolean noEvents() {
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.queues[i2].head == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup(boolean bl2) {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.nextQueue != null) {
                this.nextQueue.wakeup(bl2);
            } else if (this.dispatchThread != null) {
                this.notifyAll();
            } else if (!bl2) {
                this.initDispatchThread();
            }
        }
    }

    public static AWTEvent getCurrentEvent() {
        return Toolkit.getEventQueue().getCurrentEventImpl();
    }

    private synchronized AWTEvent getCurrentEventImpl() {
        return Thread.currentThread() == this.dispatchThread ? (AWTEvent)this.currentEvent.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWTEvent getNextEvent() throws InterruptedException {
        while (true) {
            SunToolkit.flushPendingEvents();
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                for (int i2 = 2; i2 >= 0; --i2) {
                    if (this.queues[i2].head == null) continue;
                    EventQueueItem eventQueueItem = this.queues[i2].head;
                    this.queues[i2].head = eventQueueItem.next;
                    if (eventQueueItem.next == null) {
                        this.queues[i2].tail = null;
                    }
                    return eventQueueItem.event;
                }
                AWTAutoShutdown.getInstance().notifyThreadFree(this.dispatchThread);
                this.wait();
            }
        }
    }

    public synchronized AWTEvent peekEvent() {
        for (int i2 = 2; i2 >= 0; --i2) {
            if (this.queues[i2].head == null) continue;
            return this.queues[i2].head.event;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AWTEvent getNextEvent(int n2) throws InterruptedException {
        while (true) {
            SunToolkit.flushPendingEvents();
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                for (int i2 = 0; i2 < 3; ++i2) {
                    EventQueueItem eventQueueItem = this.queues[i2].head;
                    EventQueueItem eventQueueItem2 = null;
                    while (eventQueueItem != null) {
                        if (eventQueueItem.id == n2) {
                            if (eventQueueItem2 == null) {
                                this.queues[i2].head = eventQueueItem.next;
                            } else {
                                eventQueueItem2.next = eventQueueItem.next;
                            }
                            if (this.queues[i2].tail == eventQueueItem) {
                                this.queues[i2].tail = eventQueueItem2;
                            }
                            return eventQueueItem.event;
                        }
                        eventQueueItem2 = eventQueueItem;
                        eventQueueItem = eventQueueItem.next;
                    }
                }
                this.waitForID = n2;
                this.wait();
                this.waitForID = 0;
            }
        }
    }

    public synchronized AWTEvent peekEvent(int n2) {
        for (int i2 = 2; i2 >= 0; --i2) {
            EventQueueItem eventQueueItem = this.queues[i2].head;
            while (eventQueueItem != null) {
                if (eventQueueItem.id == n2) {
                    return eventQueueItem.event;
                }
                eventQueueItem = eventQueueItem.next;
            }
        }
        return null;
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        Object object = aWTEvent.getSource();
        if (aWTEvent instanceof ActiveEvent) {
            this.setCurrentEventAndMostRecentTimeImpl(aWTEvent);
            ((ActiveEvent)((Object)aWTEvent)).dispatch();
        } else if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        } else if (object instanceof AWTAutoShutdown) {
            if (this.noEvents()) {
                this.dispatchThread.stopDispatching();
            }
        } else {
            System.err.println("unable to dispatch event: " + aWTEvent);
        }
    }

    public void postEvent(AWTEvent aWTEvent) {
        SunToolkit.flushPendingEvents();
        this.postEventPrivate(aWTEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void postEventPrivate(AWTEvent aWTEvent) {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            int n2 = aWTEvent.getID();
            if (this.nextQueue != null) {
                this.nextQueue.postEventPrivate(aWTEvent);
            } else if (aWTEvent instanceof PeerEvent && (((PeerEvent)aWTEvent).getFlags() & 1L) != 0L) {
                this.postEvent(aWTEvent, 2);
            } else if (n2 == 800 || n2 == 801) {
                this.postEvent(aWTEvent, 0);
            } else {
                this.postEvent(aWTEvent, 1);
            }
        }
    }

    static void setCurrentEventAndMostRecentTime(AWTEvent aWTEvent) {
        Toolkit.getEventQueue().setCurrentEventAndMostRecentTimeImpl(aWTEvent);
    }

    private synchronized void setCurrentEventAndMostRecentTimeImpl(AWTEvent aWTEvent) {
        if (Thread.currentThread() != this.dispatchThread) {
            return;
        }
        this.currentEvent = new WeakReference(aWTEvent);
        if (aWTEvent instanceof InputEvent) {
            InputEvent inputEvent = (InputEvent)aWTEvent;
            this.mostRecentEventTime = inputEvent.getWhen();
        } else if (aWTEvent instanceof InputMethodEvent) {
            InputMethodEvent inputMethodEvent = (InputMethodEvent)aWTEvent;
            this.mostRecentEventTime = inputMethodEvent.getWhen();
        } else if (aWTEvent instanceof ActionEvent) {
            ActionEvent actionEvent = (ActionEvent)aWTEvent;
            this.mostRecentEventTime = actionEvent.getWhen();
        } else if (aWTEvent instanceof InvocationEvent) {
            InvocationEvent invocationEvent = (InvocationEvent)aWTEvent;
            this.mostRecentEventTime = invocationEvent.getWhen();
        }
    }

    private void postEvent(AWTEvent aWTEvent, int n2) {
        boolean bl2;
        Object object;
        Object object2;
        if (this.dispatchThread == null) {
            if (aWTEvent.getSource() == AWTAutoShutdown.getInstance()) {
                return;
            }
            this.initDispatchThread();
        }
        if ((object2 = aWTEvent.getSource()) instanceof Component && (object = ((Component)object2).peer) != null && aWTEvent instanceof PaintEvent && !(object instanceof LightweightPeer)) {
            object.coalescePaintEvent((PaintEvent)aWTEvent);
        }
        object = new EventQueueItem(aWTEvent);
        boolean bl3 = bl2 = aWTEvent.getID() == this.waitForID;
        if (this.queues[n2].head == null) {
            boolean bl4 = this.noEvents();
            this.queues[n2].head = this.queues[n2].tail = object;
            if (bl4) {
                if (aWTEvent.getSource() != AWTAutoShutdown.getInstance()) {
                    AWTAutoShutdown.getInstance().notifyThreadBusy(this.dispatchThread);
                }
                this.notifyAll();
            } else if (bl2) {
                this.notifyAll();
            }
        } else {
            boolean bl5 = aWTEvent instanceof PeerEvent;
            if (object2 instanceof Component) {
                Object object3;
                EventQueueItem eventQueueItem = this.queues[n2].head;
                if (aWTEvent.id == 503 || aWTEvent.id == 506) {
                    object3 = eventQueueItem;
                    while (object3 != null) {
                        if (((EventQueueItem)object3).event instanceof MouseEvent && ((EventQueueItem)object3).id != aWTEvent.id) {
                            eventQueueItem = object3;
                        }
                        object3 = ((EventQueueItem)object3).next;
                    }
                }
                while (eventQueueItem != null) {
                    if (eventQueueItem.event.getSource() == object2 && eventQueueItem.id == ((EventQueueItem)object).id) {
                        object3 = ((Component)object2).coalesceEvents(eventQueueItem.event, aWTEvent);
                        if (bl5 && object3 == null && eventQueueItem.event instanceof PeerEvent) {
                            object3 = ((PeerEvent)eventQueueItem.event).coalesceEvents((PeerEvent)aWTEvent);
                        }
                        if (object3 != null) {
                            eventQueueItem.event = object3;
                            return;
                        }
                    }
                    eventQueueItem = eventQueueItem.next;
                }
            }
            this.queues[n2].tail.next = object;
            this.queues[n2].tail = object;
            if (bl2) {
                this.notifyAll();
            }
        }
    }

    final EventDispatchThread getDispatchThread() {
        return this.dispatchThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void push(EventQueue eventQueue) {
        if (this.nextQueue != null) {
            this.nextQueue.push(eventQueue);
            return;
        }
        Object object = eventQueue;
        synchronized (object) {
            while (this.peekEvent() != null) {
                try {
                    eventQueue.postEventPrivate(this.getNextEvent());
                }
                catch (InterruptedException interruptedException) {}
            }
            eventQueue.previousQueue = this;
        }
        if (this.dispatchThread != null) {
            this.dispatchThread.stopDispatchingLater();
        }
        this.nextQueue = eventQueue;
        object = AppContext.getAppContext();
        if (((AppContext)object).get(AppContext.EVENT_QUEUE_KEY) == this) {
            ((AppContext)object).put(AppContext.EVENT_QUEUE_KEY, eventQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeSourceEvents(Object object, boolean bl2) {
        SunToolkit.flushPendingEvents();
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            for (int i2 = 0; i2 < 3; ++i2) {
                EventQueueItem eventQueueItem = this.queues[i2].head;
                EventQueueItem eventQueueItem2 = null;
                while (eventQueueItem != null) {
                    if (!(eventQueueItem.event.getSource() != object || !bl2 && (eventQueueItem.event instanceof SequencedEvent || eventQueueItem.event instanceof SentEvent || eventQueueItem.event instanceof FocusEvent || eventQueueItem.event instanceof WindowEvent || eventQueueItem.event instanceof KeyEvent))) {
                        if (eventQueueItem.event instanceof SequencedEvent) {
                            ((SequencedEvent)eventQueueItem.event).dispose();
                        }
                        if (eventQueueItem.event instanceof SentEvent) {
                            ((SentEvent)eventQueueItem.event).dispose();
                        }
                        if (eventQueueItem2 == null) {
                            this.queues[i2].head = eventQueueItem.next;
                        } else {
                            eventQueueItem2.next = eventQueueItem.next;
                        }
                    } else {
                        eventQueueItem2 = eventQueueItem;
                    }
                    eventQueueItem = eventQueueItem.next;
                }
                this.queues[i2].tail = eventQueueItem2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock aWTInvocationLock = new AWTInvocationLock();
        InvocationEvent invocationEvent = new InvocationEvent(Toolkit.getDefaultToolkit(), runnable, aWTInvocationLock, true);
        Object object = aWTInvocationLock;
        synchronized (object) {
            Toolkit.getEventQueue().postEvent(invocationEvent);
            aWTInvocationLock.wait();
        }
        object = invocationEvent.getException();
        if (object != null) {
            throw new InvocationTargetException((Throwable)object);
        }
    }

    public static void invokeLater(Runnable runnable) {
        Toolkit.getEventQueue().postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
    }
}

