/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import sun.reflect.MethodAccessor;
import sun.reflect.Reflection;

public final class Method
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class returnType;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;
    private volatile MethodAccessor methodAccessor;
    private Method root;
    private volatile Class securityCheckTargetClassCache;

    public int getModifiers() {
        return this.modifiers;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    private void acquireMethodAccessor() {
        MethodAccessor methodAccessor = null;
        if (this.root != null) {
            methodAccessor = this.root.getMethodAccessor();
        }
        if (methodAccessor != null) {
            this.methodAccessor = methodAccessor;
            return;
        }
        methodAccessor = reflectionFactory.newMethodAccessor(this);
        this.setMethodAccessor(methodAccessor);
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public Class[] getExceptionTypes() {
        return Method.copy(this.exceptionTypes);
    }

    public Class[] getParameterTypes() {
        return Method.copy(this.parameterTypes);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Method) {
            Class[] classArray;
            Class[] classArray2;
            Method method = (Method)object;
            if (this.getDeclaringClass() == method.getDeclaringClass() && this.getName() == method.getName() && (classArray2 = this.parameterTypes).length == (classArray = method.parameterTypes).length) {
                for (int i2 = 0; i2 < classArray2.length; ++i2) {
                    if (classArray2[i2] == classArray[i2]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.getModifiers();
            if (n2 != 0) {
                stringBuffer.append(Modifier.toString(n2) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getReturnType()) + " ");
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()) + ".");
            stringBuffer.append(this.getName() + "(");
            Class[] classArray = this.parameterTypes;
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                stringBuffer.append(Field.getTypeName(classArray[i2]));
                if (i2 >= classArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            Class[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                for (int i3 = 0; i3 < classArray2.length; ++i3) {
                    stringBuffer.append(classArray2[i3].getName());
                    if (i3 >= classArray2.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    Method copy() {
        Method method = new Method(this.clazz, this.name, this.parameterTypes, this.returnType, this.exceptionTypes, this.modifiers, this.slot);
        method.root = this;
        method.methodAccessor = this.methodAccessor;
        return method;
    }

    MethodAccessor getMethodAccessor() {
        return this.methodAccessor;
    }

    void setMethodAccessor(MethodAccessor methodAccessor) {
        this.methodAccessor = methodAccessor;
        if (this.root != null) {
            this.root.setMethodAccessor(methodAccessor);
        }
    }

    static Class[] copy(Class[] classArray) {
        int n2 = classArray.length;
        if (n2 == 0) {
            return classArray;
        }
        Class[] classArray2 = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray2[i2] = classArray[i2];
        }
        return classArray2;
    }

    public Object invoke(Object object, Object[] objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class clazz;
            Class clazz2 = Reflection.getCallerClass(1);
            Class clazz3 = clazz = object == null || !Modifier.isProtected(this.modifiers) ? this.clazz : object.getClass();
            if (this.securityCheckCache != clazz2 || clazz != this.securityCheckTargetClassCache) {
                Reflection.ensureMemberAccess(clazz2, this.clazz, object, this.modifiers);
                this.securityCheckCache = clazz2;
                this.securityCheckTargetClassCache = clazz;
            }
        }
        if (this.methodAccessor == null) {
            this.acquireMethodAccessor();
        }
        return this.methodAccessor.invoke(object, objectArray);
    }

    Method(Class clazz, String string, Class[] classArray, Class clazz2, Class[] classArray2, int n2, int n3) {
        this.clazz = clazz;
        this.name = string;
        this.parameterTypes = classArray;
        this.returnType = clazz2;
        this.exceptionTypes = classArray2;
        this.modifiers = n2;
        this.slot = n3;
    }
}

