/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.plugins.jpeg;

public class JPEGQTable {
    private int[] table;
    private static final byte QTABLESIZE = 64;
    public static final JPEGQTable K1Luminance = new JPEGQTable();
    public static final JPEGQTable K1Div2Luminance;
    public static final JPEGQTable K2Chrominance;
    public static final JPEGQTable K2Div2Chrominance;

    static {
        int[] nArray = new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
        JPEGQTable.K1Luminance.table = nArray;
        K1Div2Luminance = K1Luminance.getScaledInstance(0.5f, true);
        K2Chrominance = new JPEGQTable();
        nArray = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
        JPEGQTable.K2Chrominance.table = nArray;
        K2Div2Chrominance = K2Chrominance.getScaledInstance(0.5f, true);
    }

    private JPEGQTable() {
    }

    public int[] getTable() {
        return (int[])this.table.clone();
    }

    public JPEGQTable(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("table == null!");
        }
        if (nArray.length != 64) {
            throw new IllegalArgumentException("Quantization table is the wrong size.");
        }
        this.table = (int[])nArray.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JPEGQTable:\n");
        for (int i2 = 0; i2 < 8; ++i2) {
            stringBuffer.append('\t');
            for (int i3 = 0; i3 < 8; ++i3) {
                stringBuffer.append(this.table[i2]).append(" ");
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public JPEGQTable getScaledInstance(float f2, boolean bl2) {
        int n2 = bl2 ? 255 : Short.MAX_VALUE;
        int[] nArray = new int[64];
        for (int i2 = 0; i2 < 64; ++i2) {
            float f3 = Math.round((float)this.table[i2] * f2);
            int n3 = f3 <= 1.0f ? 1 : (f3 >= (float)n2 ? n2 : (int)f3);
            nArray[i2] = n3;
        }
        return new JPEGQTable(nArray);
    }
}

