/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.FrameSetView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

class FrameView
extends ComponentView
implements HyperlinkListener {
    JEditorPane htmlPane;
    JScrollPane scroller;
    boolean editable;
    float width;
    float height;
    URL src;
    private boolean createdComponent;

    private void createScrollPane() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.SCROLLING);
        if (string == null) {
            string = "auto";
        }
        this.scroller = !string.equals("no") ? (string.equals("yes") ? new JScrollPane(22, 32) : new JScrollPane()) : new JScrollPane(21, 31);
        JViewport jViewport = this.scroller.getViewport();
        jViewport.add(this.htmlPane);
        jViewport.setBackingStoreEnabled(true);
        this.scroller.setMinimumSize(new Dimension(5, 5));
        this.scroller.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    private void setBorder() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.FRAMEBORDER);
        if (string != null && (string.equals("no") || string.equals("0"))) {
            this.scroller.setBorder(null);
        }
    }

    private void setMargin() {
        int n2 = 0;
        Insets insets = this.htmlPane.getMargin();
        boolean bl2 = false;
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.MARGINWIDTH);
        Insets insets2 = insets != null ? new Insets(insets.top, insets.left, insets.right, insets.bottom) : new Insets(0, 0, 0, 0);
        if (string != null && (n2 = Integer.parseInt(string)) > 0) {
            insets2.left = n2;
            insets2.right = n2;
            bl2 = true;
        }
        if ((string = (String)attributeSet.getAttribute(HTML.Attribute.MARGINHEIGHT)) != null && (n2 = Integer.parseInt(string)) > 0) {
            insets2.top = n2;
            insets2.bottom = n2;
            bl2 = true;
        }
        if (bl2) {
            this.htmlPane.setMargin(insets2);
        }
    }

    private boolean inNestedFrameSet() {
        FrameSetView frameSetView = (FrameSetView)this.getParent();
        return frameSetView.getParent() instanceof FrameSetView;
    }

    public float getMaximumSpan(int n2) {
        return 2.1474836E9f;
    }

    public float getMinimumSpan(int n2) {
        return 5.0f;
    }

    protected Component createComponent() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.SRC);
        if (string != null && !string.equals("")) {
            try {
                Object object;
                URL uRL = ((HTMLDocument)element.getDocument()).getBase();
                this.src = new URL(uRL, string);
                this.htmlPane = new FrameEditorPane();
                this.htmlPane.addHyperlinkListener(this);
                JEditorPane jEditorPane = this.getHostPane();
                if (jEditorPane != null) {
                    this.htmlPane.setEditable(jEditorPane.isEditable());
                    object = (String)jEditorPane.getClientProperty("charset");
                    if (object != null) {
                        this.htmlPane.putClientProperty("charset", object);
                    }
                }
                this.htmlPane.setPage(this.src);
                object = this.htmlPane.getDocument();
                if (object instanceof HTMLDocument) {
                    ((HTMLDocument)object).setFrameDocumentState(true);
                }
                this.setMargin();
                this.createScrollPane();
                this.setBorder();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.createdComponent = true;
        return this.scroller;
    }

    JEditorPane getHostPane() {
        Container container;
        for (container = this.getContainer(); container != null && !(container instanceof JEditorPane); container = container.getParent()) {
        }
        return (JEditorPane)container;
    }

    private JEditorPane getOutermostJEditorPane() {
        View view = null;
        for (View view2 = this.getParent(); view2 != null; view2 = view2.getParent()) {
            if (!(view2 instanceof FrameSetView)) continue;
            view = (FrameSetView)view2;
        }
        if (view != null) {
            return (JEditorPane)view.getContainer();
        }
        return null;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (!(hyperlinkEvent instanceof HTMLFrameHyperlinkEvent)) {
            return;
        }
        HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
        if (hTMLFrameHyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane jEditorPane = this.getOutermostJEditorPane();
            String string = hTMLFrameHyperlinkEvent.getTarget();
            if (hTMLFrameHyperlinkEvent.getTarget().equals("_parent") && !this.inNestedFrameSet()) {
                string = "_top";
            }
            if (jEditorPane != null && !jEditorPane.isEditable()) {
                jEditorPane.fireHyperlinkUpdate(new HTMLFrameHyperlinkEvent(jEditorPane, hTMLFrameHyperlinkEvent.getEventType(), hTMLFrameHyperlinkEvent.getURL(), hTMLFrameHyperlinkEvent.getDescription(), this.getElement(), string));
                if (string.equals("_top")) {
                    try {
                        jEditorPane.setPage(hTMLFrameHyperlinkEvent.getURL());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public FrameView(Element element) {
        super(element);
    }

    public void setParent(View view) {
        if (view != null) {
            JTextComponent jTextComponent = (JTextComponent)view.getContainer();
            this.editable = jTextComponent.isEditable();
        }
        super.setParent(view);
    }

    public void paint(Graphics graphics, Shape shape) {
        Container container = this.getContainer();
        if (container != null && this.htmlPane != null && this.htmlPane.isEditable() != ((JTextComponent)container).isEditable()) {
            this.editable = ((JTextComponent)container).isEditable();
            this.htmlPane.setEditable(this.editable);
        }
        super.paint(graphics, shape);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        URL uRL = this.src;
        String string = (String)attributeSet.getAttribute(HTML.Attribute.SRC);
        URL uRL2 = ((HTMLDocument)element.getDocument()).getBase();
        try {
            this.src = new URL(uRL2, string);
            if (!this.createdComponent) {
                return;
            }
            if (uRL.equals(this.src)) {
                return;
            }
            this.htmlPane.setPage(this.src);
            Document document = this.htmlPane.getDocument();
            if (document instanceof HTMLDocument) {
                ((HTMLDocument)document).setFrameDocumentState(true);
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class FrameEditorPane
    extends JEditorPane {
        private FrameEditorPane() {
        }

        public EditorKit getEditorKitForContentType(String string) {
            EditorKit editorKit = super.getEditorKitForContentType(string);
            JEditorPane jEditorPane = null;
            jEditorPane = FrameView.this.getOutermostJEditorPane();
            if (jEditorPane != null) {
                EditorKit editorKit2 = jEditorPane.getEditorKitForContentType(string);
                if (!editorKit.getClass().equals(editorKit2.getClass())) {
                    editorKit = (EditorKit)editorKit2.clone();
                    this.setEditorKitForContentType(string, editorKit);
                }
            }
            return editorKit;
        }
    }
}

