/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.crimson.tree.ElementEx;
import org.apache.crimson.tree.ElementFactory;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.XmlDocument;

public class SimpleElementFactory
implements ElementFactory {
    private Dictionary defaultMapping;
    private ClassLoader defaultLoader;
    private String defaultNs;
    private Dictionary nsMappings;
    private Dictionary nsLoaders;
    private Locale locale = Locale.getDefault();

    private static ClassLoader findClassLoader() {
        ClassLoader classLoader;
        try {
            Class clazz = Class.forName(SimpleElementFactory.class.getName() + "$ClassLoaderFinderConcrete");
            ClassLoaderFinder classLoaderFinder = (ClassLoaderFinder)clazz.newInstance();
            classLoader = classLoaderFinder.getContextClassLoader();
        }
        catch (LinkageError linkageError) {
            classLoader = SimpleElementFactory.class.getClassLoader();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoader = SimpleElementFactory.class.getClassLoader();
        }
        catch (Exception exception) {
            classLoader = SimpleElementFactory.class.getClassLoader();
        }
        return classLoader;
    }

    public void setDefaultNamespace(String string) {
        this.defaultNs = string;
    }

    public void addMapping(Dictionary dictionary, ClassLoader classLoader) {
        if (dictionary == null) {
            throw new IllegalArgumentException();
        }
        this.defaultMapping = dictionary;
        this.defaultLoader = classLoader;
    }

    String getMessage(String string) {
        return this.getMessage(string, null);
    }

    public ElementEx createElementEx(String string) {
        return this.doMap(string, this.defaultMapping, this.defaultLoader);
    }

    public void addMapping(String string, Dictionary dictionary, ClassLoader classLoader) {
        if (string == null || dictionary == null) {
            throw new IllegalArgumentException();
        }
        if (this.nsMappings == null) {
            this.nsMappings = new Hashtable();
            this.nsLoaders = new Hashtable();
        }
        this.nsMappings.put(string, dictionary);
        if (classLoader != null) {
            this.nsLoaders.put(string, classLoader);
        }
    }

    String getMessage(String string, Object[] objectArray) {
        return XmlDocument.catalog.getMessage(this.locale, string, objectArray);
    }

    public ElementEx createElementEx(String string, String string2) {
        Dictionary dictionary = null;
        if (string == null) {
            string = this.defaultNs;
        }
        if (this.nsMappings != null) {
            dictionary = (Dictionary)this.nsMappings.get(string);
        }
        if (dictionary == null) {
            return this.doMap(string2, this.defaultMapping, this.defaultLoader);
        }
        return this.doMap(string2, dictionary, (ClassLoader)this.nsLoaders.get(string));
    }

    private Class map2Class(String string, Dictionary dictionary, ClassLoader classLoader) {
        Object object = dictionary.get(string);
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            try {
                Class clazz;
                if (classLoader == null) {
                    classLoader = SimpleElementFactory.findClassLoader();
                }
                if (!ElementNode.class.isAssignableFrom(clazz = classLoader == null ? Class.forName(string2) : classLoader.loadClass(string2))) {
                    throw new IllegalArgumentException(this.getMessage("SEF-000", new Object[]{string, string2}));
                }
                dictionary.put(string, clazz);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(this.getMessage("SEF-001", new Object[]{string, string2, classNotFoundException.getMessage()}));
            }
        }
        throw new IllegalArgumentException(this.getMessage("SEF-002", new Object[]{string}));
    }

    private ElementNode doMap(String string, Dictionary dictionary, ClassLoader classLoader) {
        ElementNode elementNode;
        Class clazz = this.map2Class(string, dictionary, classLoader);
        if (clazz == null) {
            clazz = this.map2Class("*Element", dictionary, classLoader);
        }
        if (clazz == null) {
            elementNode = new ElementNode(string);
        } else {
            try {
                elementNode = (ElementNode)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(this.getMessage("SEF-003", new Object[]{string, clazz.getName(), exception.getMessage()}));
            }
        }
        return elementNode;
    }

    private static abstract class ClassLoaderFinder {
        private ClassLoaderFinder() {
        }

        abstract ClassLoader getContextClassLoader();
    }

    static class ClassLoaderFinderConcrete
    extends ClassLoaderFinder {
        ClassLoaderFinderConcrete() {
        }

        ClassLoader getContextClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

