/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.security.AccessController;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import sun.awt.windows.WPathGraphics;
import sun.print.PeekGraphics;
import sun.print.PeekMetrics;
import sun.print.RasterPrinterJob;
import sun.print.SunAlternateMedia;
import sun.print.Win32MediaTray;
import sun.security.action.GetPropertyAction;

public class WPrinterJob
extends RasterPrinterJob {
    protected static final long PS_ENDCAP_ROUND = 0L;
    protected static final long PS_ENDCAP_SQUARE = 256L;
    protected static final long PS_ENDCAP_FLAT = 512L;
    protected static final long PS_JOIN_ROUND = 0L;
    protected static final long PS_JOIN_BEVEL = 4096L;
    protected static final long PS_JOIN_MITER = 8192L;
    protected static final int POLYFILL_ALTERNATE = 1;
    protected static final int POLYFILL_WINDING = 2;
    private static final int MAX_WCOLOR = 255;
    private static final String FORCE_PIPE_PROP = "sun.java2d.print.pipeline";
    private static final String FORCE_RASTER = "raster";
    private static final String FORCE_PDL = "pdl";
    private static final String SHAPE_TEXT_PROP = "sun.java2d.print.shapetext";
    private static boolean forcePDL;
    private static boolean forceRaster;
    static boolean shapeTextProp;
    private boolean driverDoesMultipleCopies = true;
    private boolean driverDoesCollation = true;
    private boolean userRequestedCollation = false;
    private boolean noDefaultPrinter = false;
    private long mPrintDC;
    private long mPrintHDevMode;
    private long mPrintHDevNames;
    private int mPrintPaperSize;
    private int mPrintXRes;
    private int mPrintYRes;
    private int mPrintPhysX;
    private int mPrintPhysY;
    private int mPrintWidth;
    private int mPrintHeight;
    private int mPageWidth;
    private int mPageHeight;
    private int mAttSides;
    private int mAttChromaticity;
    private int mAttXRes;
    private int mAttYRes;
    private int mAttQuality;
    private int mAttCollate;
    private int mAttCopies;
    private int mAttOrientation;
    private int mAttMediaSizeName;
    private int mAttMediaTray;
    private String mDestination = null;
    private Color mLastColor;
    private Color mLastTextColor;
    private Font mLastFont;
    private int mLastRotation;
    private float mLastAwScale;
    static /* synthetic */ Class class$javax$print$attribute$standard$Sides;
    static /* synthetic */ Class class$javax$print$attribute$standard$Chromaticity;
    static /* synthetic */ Class class$javax$print$attribute$standard$PrinterResolution;
    static /* synthetic */ Class class$javax$print$attribute$standard$PrintQuality;
    static /* synthetic */ Class class$javax$print$attribute$standard$SheetCollate;
    static /* synthetic */ Class class$javax$print$attribute$standard$Media;
    static /* synthetic */ Class class$sun$print$SunAlternateMedia;

    protected double getXRes() {
        if (this.mAttXRes != 0) {
            return this.mAttXRes;
        }
        return this.mPrintXRes;
    }

    protected double getYRes() {
        if (this.mAttYRes != 0) {
            return this.mAttYRes;
        }
        return this.mPrintYRes;
    }

    protected int getCollatedCopies() {
        if (!this.driverDoesCollation) {
            if (super.isCollated()) {
                this.mAttCollate = 0;
                this.mAttCopies = 1;
                return this.getCopiesInt();
            }
            if (this.isCollated() && !this.collateAttReq) {
                this.mAttCollate = 0;
                this.mAttCopies = 1;
                return this.getCopies();
            }
        }
        return 1;
    }

    protected int getNoncollatedCopies() {
        if (this.driverDoesMultipleCopies || this.isCollated()) {
            return 1;
        }
        return this.getCopies();
    }

    protected int getPenX() {
        return this.getPenX(this.mPrintDC);
    }

    protected int getPenY() {
        return this.getPenY(this.mPrintDC);
    }

    protected long getPrintDC() {
        return this.mPrintDC;
    }

    static {
        String string;
        forcePDL = false;
        forceRaster = false;
        shapeTextProp = false;
        Toolkit.getDefaultToolkit();
        forcePDL = false;
        forceRaster = false;
        shapeTextProp = false;
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction(FORCE_PIPE_PROP));
        if (string2 != null) {
            if (string2.equalsIgnoreCase(FORCE_PDL)) {
                forcePDL = true;
            } else if (string2.equalsIgnoreCase(FORCE_RASTER)) {
                forceRaster = true;
            }
        }
        if ((string = (String)AccessController.doPrivileged(new GetPropertyAction(SHAPE_TEXT_PROP))) != null) {
            shapeTextProp = true;
        }
    }

    public WPrinterJob() {
        this.initAttributeMembers();
    }

    protected native void abortDoc();

    protected void beginPath() {
        this.beginPath(this.mPrintDC);
    }

    protected void closeFigure() {
        this.closeFigure(this.mPrintDC);
    }

    protected native void deleteDC();

    protected native void endDoc();

    protected void endPath() {
        this.endPath(this.mPrintDC);
    }

    protected void fillPath() {
        this.fillPath(this.mPrintDC);
    }

    protected void finalize() {
        this.deleteDC();
    }

    private void initAttributeMembers() {
        this.mAttSides = 0;
        this.mAttChromaticity = 0;
        this.mAttXRes = 0;
        this.mAttYRes = 0;
        this.mAttQuality = 0;
        this.mAttCollate = -1;
        this.mAttCopies = 0;
        this.mAttOrientation = 0;
        this.mAttMediaTray = 0;
        this.mAttMediaSizeName = 0;
        this.mDestination = null;
    }

    protected native void initPrinter();

    private void invalidateCachedState() {
        this.mLastColor = null;
        this.mLastTextColor = null;
        this.mLastFont = null;
    }

    protected void selectClipPath() {
        this.selectClipPath(this.mPrintDC);
    }

    protected void startDoc() {
        this._startDoc(this.mDestination);
    }

    protected boolean isCollated() {
        return this.userRequestedCollation;
    }

    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.noDefaultPrinter) {
            return false;
        }
        return this.jobSetup(this.getPageable(), this.checkAllowedToPrintToFile());
    }

    protected void lineTo(float f2, float f3) {
        this.lineTo(this.mPrintDC, f2, f3);
    }

    protected void moveTo(float f2, float f3) {
        this.moveTo(this.mPrintDC, f2, f3);
    }

    protected void frameRect(float f2, float f3, float f4, float f5) {
        this.frameRect(this.mPrintDC, f2, f3, f4, f5);
    }

    protected void polyBezierTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.polyBezierTo(this.mPrintDC, f2, f3, f4, f5, f6, f7);
    }

    public void setCopies(int n2) {
        super.setCopies(n2);
        this.setNativeCopies(n2);
    }

    public native void setNativeCopies(int var1);

    protected void setPolyFillMode(int n2) {
        this.setPolyFillMode(this.mPrintDC, n2);
    }

    protected native int getPenX(long var1);

    protected native int getPenY(long var1);

    protected native void beginPath(long var1);

    protected native void closeFigure(long var1);

    protected native void endPath(long var1);

    protected native void fillPath(long var1);

    protected native void selectClipPath(long var1);

    protected native void lineTo(long var1, float var3, float var4);

    protected native void moveTo(long var1, float var3, float var4);

    protected native void frameRect(long var1, float var3, float var4, float var5, float var6);

    protected native void polyBezierTo(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    protected native void fillRect(long var1, float var3, float var4, float var5, float var6, int var7, int var8, int var9);

    protected native void selectPen(long var1, float var3, int var4, int var5, int var6);

    protected native void setPolyFillMode(long var1, int var3);

    protected native void selectSolidBrush(long var1, int var3, int var4, int var5);

    protected native void setTextColor(long var1, int var3, int var4, int var5);

    protected native boolean selectStylePen(long var1, long var3, long var5, float var7, int var8, int var9, int var10);

    protected native void drawImage3ByteBGR(long var1, byte[] var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11);

    protected void drawImage3ByteBGR(byte[] byArray, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.drawImage3ByteBGR(this.mPrintDC, byArray, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    protected native void printBand(byte[] var1, int var2, int var3, int var4, int var5);

    protected void fillRect(float f2, float f3, float f4, float f5, Color color) {
        float[] fArray = color.getColorComponents(null);
        this.fillRect(this.mPrintDC, f2, f3, f4, f5, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
    }

    protected void selectPen(float f2, Color color) {
        float[] fArray = color.getColorComponents(null);
        this.selectPen(this.mPrintDC, f2, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
    }

    protected boolean selectStylePen(int n2, int n3, float f2, Color color) {
        long l2;
        long l3;
        float[] fArray = color.getColorComponents(null);
        switch (n2) {
            case 0: {
                l3 = 512L;
                break;
            }
            case 1: {
                l3 = 0L;
                break;
            }
            default: {
                l3 = 256L;
            }
        }
        switch (n3) {
            case 2: {
                l2 = 4096L;
                break;
            }
            default: {
                l2 = 8192L;
                break;
            }
            case 1: {
                l2 = 0L;
            }
        }
        return this.selectStylePen(this.mPrintDC, l3, l2, f2, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
    }

    protected void selectSolidBrush(Color color) {
        if (!color.equals(this.mLastColor)) {
            this.mLastColor = color;
            float[] fArray = color.getColorComponents(null);
            this.selectSolidBrush(this.mPrintDC, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
        }
    }

    protected void setTextColor(Color color) {
        if (!color.equals(this.mLastTextColor)) {
            this.mLastTextColor = color;
            float[] fArray = color.getColorComponents(null);
            this.setTextColor(this.mPrintDC, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
        }
    }

    protected boolean setFont(Font font, int n2, float f2) {
        boolean bl2 = true;
        if (!font.equals(this.mLastFont) || n2 != this.mLastRotation || f2 != this.mLastAwScale) {
            int n3 = font.getStyle();
            bl2 = this.setFont(this.mPrintDC, font.getFontName(), font.getSize2D(), (n3 & 1) != 0, (n3 & 2) != 0, n2, f2);
            if (bl2) {
                this.mLastFont = font;
                this.mLastRotation = n2;
                this.mLastAwScale = f2;
            }
        }
        return bl2;
    }

    protected native boolean setLogicalFont(Font var1, int var2, float var3);

    private native void getDefaultPage(PageFormat var1);

    private native boolean jobSetup(Pageable var1, boolean var2);

    protected double getPhysicalPageHeight(Paper paper) {
        return this.mPageHeight;
    }

    protected double getPhysicalPageWidth(Paper paper) {
        return this.mPageWidth;
    }

    protected double getPhysicalPrintableHeight(Paper paper) {
        return this.mPrintHeight;
    }

    protected double getPhysicalPrintableWidth(Paper paper) {
        return this.mPrintWidth;
    }

    protected double getPhysicalPrintableX(Paper paper) {
        return this.mPrintPhysX;
    }

    protected double getPhysicalPrintableY(Paper paper) {
        return this.mPrintPhysY;
    }

    private native String getNativePrintService();

    protected native boolean setFont(long var1, String var3, float var4, boolean var5, boolean var6, int var7, float var8);

    private native void _startDoc(String var1);

    private native void setNativePrintService(String var1);

    public PrintService getPrintService() {
        String string = this.getNativePrintService();
        if (string != null) {
            PrintService printService = RasterPrinterJob.lookupDefaultPrintService();
            if (printService != null && printService.getName().equals(string)) {
                return printService;
            }
            PrintService[] printServiceArray = RasterPrinterJob.lookupPrintServices();
            for (int i2 = 0; i2 < printServiceArray.length; ++i2) {
                if (!printServiceArray[i2].getName().equals(string)) continue;
                return printServiceArray[i2];
            }
        }
        return super.getPrintService();
    }

    public void setPrintService(PrintService printService) throws PrinterException {
        super.setPrintService(printService);
        this.setNativePrintService(printService.getName());
    }

    protected void setAttributes(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        this.initAttributeMembers();
        super.setAttributes(printRequestAttributeSet);
        this.mAttCopies = this.getCopiesInt();
        this.mDestination = this.destinationAttr;
        if (printRequestAttributeSet == null) {
            return;
        }
        Attribute[] attributeArray = printRequestAttributeSet.toArray();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            try {
                Cloneable cloneable;
                Attribute attribute = attributeArray[i2];
                if (attribute.getCategory() == (class$javax$print$attribute$standard$Sides == null ? WPrinterJob.class$("javax.print.attribute.standard.Sides") : class$javax$print$attribute$standard$Sides)) {
                    if (attribute.equals(Sides.TWO_SIDED_LONG_EDGE)) {
                        this.mAttSides = 2;
                        continue;
                    }
                    if (attribute.equals(Sides.TWO_SIDED_SHORT_EDGE)) {
                        this.mAttSides = 3;
                        continue;
                    }
                    this.mAttSides = 1;
                    continue;
                }
                if (attribute.getCategory() == (class$javax$print$attribute$standard$Chromaticity == null ? WPrinterJob.class$("javax.print.attribute.standard.Chromaticity") : class$javax$print$attribute$standard$Chromaticity)) {
                    if (attribute.equals(Chromaticity.COLOR)) {
                        this.mAttChromaticity = 2;
                        continue;
                    }
                    this.mAttChromaticity = 1;
                    continue;
                }
                if (attribute.getCategory() == (class$javax$print$attribute$standard$PrinterResolution == null ? WPrinterJob.class$("javax.print.attribute.standard.PrinterResolution") : class$javax$print$attribute$standard$PrinterResolution)) {
                    cloneable = (PrinterResolution)attribute;
                    this.mAttXRes = cloneable.getCrossFeedResolution(100);
                    this.mAttYRes = cloneable.getFeedResolution(100);
                    continue;
                }
                if (attribute.getCategory() == (class$javax$print$attribute$standard$PrintQuality == null ? WPrinterJob.class$("javax.print.attribute.standard.PrintQuality") : class$javax$print$attribute$standard$PrintQuality)) {
                    if (attribute.equals(PrintQuality.HIGH)) {
                        this.mAttQuality = -4;
                        continue;
                    }
                    if (attribute.equals(PrintQuality.NORMAL)) {
                        this.mAttQuality = -3;
                        continue;
                    }
                    this.mAttQuality = -2;
                    continue;
                }
                if (attribute.getCategory() == (class$javax$print$attribute$standard$SheetCollate == null ? WPrinterJob.class$("javax.print.attribute.standard.SheetCollate") : class$javax$print$attribute$standard$SheetCollate)) {
                    if (attribute.equals(SheetCollate.COLLATED)) {
                        this.mAttCollate = 1;
                        continue;
                    }
                    this.mAttCollate = 0;
                    continue;
                }
                if (attribute.getCategory() != (class$javax$print$attribute$standard$Media == null ? WPrinterJob.class$("javax.print.attribute.standard.Media") : class$javax$print$attribute$standard$Media) && attribute.getCategory() != (class$sun$print$SunAlternateMedia == null ? WPrinterJob.class$("sun.print.SunAlternateMedia") : class$sun$print$SunAlternateMedia)) continue;
                if (!(attribute.getCategory() != (class$sun$print$SunAlternateMedia == null ? WPrinterJob.class$("sun.print.SunAlternateMedia") : class$sun$print$SunAlternateMedia) || (cloneable = (Media)printRequestAttributeSet.get(class$javax$print$attribute$standard$Media == null ? WPrinterJob.class$("javax.print.attribute.standard.Media") : class$javax$print$attribute$standard$Media)) != null && cloneable instanceof MediaTray)) {
                    attribute = ((SunAlternateMedia)attribute).getMedia();
                }
                if (attribute instanceof MediaSizeName) {
                    // empty if block
                }
                if (!(attribute instanceof MediaTray)) continue;
                if (attribute.equals(MediaTray.BOTTOM)) {
                    this.mAttMediaTray = 2;
                    continue;
                }
                if (attribute.equals(MediaTray.ENVELOPE)) {
                    this.mAttMediaTray = 5;
                    continue;
                }
                if (attribute.equals(MediaTray.LARGE_CAPACITY)) {
                    this.mAttMediaTray = 11;
                    continue;
                }
                if (attribute.equals(MediaTray.MAIN)) {
                    this.mAttMediaTray = 1;
                    continue;
                }
                if (attribute.equals(MediaTray.MANUAL)) {
                    this.mAttMediaTray = 4;
                    continue;
                }
                if (attribute.equals(MediaTray.MIDDLE)) {
                    this.mAttMediaTray = 3;
                    continue;
                }
                if (attribute.equals(MediaTray.SIDE)) {
                    this.mAttMediaTray = 7;
                    continue;
                }
                if (attribute.equals(MediaTray.TOP)) {
                    this.mAttMediaTray = 1;
                    continue;
                }
                if (attribute instanceof Win32MediaTray) {
                    this.mAttMediaTray = ((Win32MediaTray)attribute).winID;
                    continue;
                }
                this.mAttMediaTray = 1;
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    protected native void textOut(long var1, String var3, float var4, float var5, Font var6);

    protected void textOut(String string, float f2, float f3, Font font) {
        this.textOut(this.mPrintDC, string, f2, f3, font);
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        this.getDefaultPage(pageFormat2);
        return pageFormat2;
    }

    public PageFormat pageDialog(PageFormat pageFormat) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.noDefaultPrinter) {
            return pageFormat;
        }
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        boolean bl2 = this.pageSetup(pageFormat2, null);
        return bl2 ? pageFormat2 : pageFormat;
    }

    protected native void validatePaper(Paper var1, Paper var2);

    public native boolean pageSetup(PageFormat var1, Printable var2);

    protected native void deviceEndPage(PageFormat var1, Printable var2, int var3);

    protected native void deviceStartPage(PageFormat var1, Printable var2, int var3);

    protected void endPage(PageFormat pageFormat, Printable printable, int n2) {
        this.deviceEndPage(pageFormat, printable, n2);
    }

    protected void startPage(PageFormat pageFormat, Printable printable, int n2) {
        this.invalidateCachedState();
        this.deviceStartPage(pageFormat, printable, n2);
    }

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n2) {
        WPathGraphics wPathGraphics;
        PeekMetrics peekMetrics = peekGraphics.getMetrics();
        if (!forcePDL && (forceRaster || peekMetrics.hasNonSolidColors() || peekMetrics.hasCompositing())) {
            wPathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            boolean bl2 = !peekGraphics.getAWTDrawingOnly();
            wPathGraphics = new WPathGraphics(graphics2D, printerJob, printable, pageFormat, n2, bl2);
        }
        return wPathGraphics;
    }
}

