/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.Properties;
import sun.io.CharacterEncoding;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class Converters {
    private static Object lock = Converters.class;
    private static String converterPackageName = null;
    private static String defaultEncoding = null;
    public static final int BYTE_TO_CHAR = 0;
    public static final int CHAR_TO_BYTE = 1;
    private static final String[] converterPrefix = new String[]{"ByteToChar", "CharToByte"};
    private static final int CACHE_SIZE = 3;
    private static final Object DEFAULT_NAME = new Object();
    private static SoftReference[][] classCache = new SoftReference[][]{new SoftReference[3], new SoftReference[3]};

    private Converters() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDefaultEncodingName() {
        if (VM.isBooted()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            defaultEncoding = "ISO-8859-1";
            Properties properties = System.getProperties();
            properties.setProperty("file.encoding", defaultEncoding);
            System.setProperties(properties);
        }
    }

    private static Class getDefaultConverterClass(int n2) {
        boolean bl2 = false;
        Class clazz = Converters.cache(n2, DEFAULT_NAME);
        if (clazz != null) {
            return clazz;
        }
        String string = Converters.getDefaultEncodingName();
        if (string != null) {
            bl2 = true;
        } else {
            string = "ISO8859_1";
        }
        try {
            clazz = Converters.getConverterClass(n2, string);
            if (bl2) {
                Converters.cache(n2, DEFAULT_NAME, clazz);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                clazz = Converters.getConverterClass(n2, "ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                throw new InternalError("Cannot find default " + converterPrefix[n2] + " converter class");
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object newDefaultConverter(int n2) {
        Class clazz;
        Object object = lock;
        synchronized (object) {
            clazz = Converters.getDefaultConverterClass(n2);
        }
        try {
            return Converters.newConverter("", clazz);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Cannot instantiate default converter class " + clazz.getName());
        }
    }

    private static void moveToFront(Object[] objectArray, int n2) {
        Object object = objectArray[n2];
        for (int i2 = n2; i2 > 0; --i2) {
            objectArray[i2] = objectArray[i2 - 1];
        }
        objectArray[0] = object;
    }

    private static String getConverterPackageName() {
        String string = converterPackageName;
        if (string != null) {
            return string;
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("file.encoding.pkg");
        string = (String)AccessController.doPrivileged(getPropertyAction);
        if (string != null) {
            converterPackageName = string;
        } else {
            string = "sun.io";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultEncodingName() {
        Object object = lock;
        synchronized (object) {
            if (defaultEncoding == null) {
                GetPropertyAction getPropertyAction = new GetPropertyAction("file.encoding");
                defaultEncoding = (String)AccessController.doPrivileged(getPropertyAction);
            }
        }
        return defaultEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCached(int n2, String string) {
        Object object = lock;
        synchronized (object) {
            SoftReference[] softReferenceArray = classCache[n2];
            for (int i2 = 0; i2 < 3; ++i2) {
                SoftReference softReference = softReferenceArray[i2];
                if (softReference == null) continue;
                Object[] objectArray = (Object[])softReference.get();
                if (objectArray == null) {
                    softReferenceArray[i2] = null;
                    continue;
                }
                if (!objectArray[1].equals(string)) continue;
                return true;
            }
            return false;
        }
    }

    private static Class cache(int n2, Object object) {
        Object[] objectArray = classCache[n2];
        for (int i2 = 0; i2 < 3; ++i2) {
            SoftReference softReference = objectArray[i2];
            if (softReference == null) continue;
            Object[] objectArray2 = (Object[])softReference.get();
            if (objectArray2 == null) {
                objectArray[i2] = null;
                continue;
            }
            if (!objectArray2[1].equals(object)) continue;
            Converters.moveToFront(objectArray, i2);
            return (Class)objectArray2[0];
        }
        return null;
    }

    private static Class getConverterClass(int n2, String string) throws UnsupportedEncodingException {
        String string2 = null;
        if (!string.equals("ISO8859_1")) {
            string2 = string.equals("8859_1") ? "ISO8859_1" : (string.equals("ISO8859-1") ? "ISO8859_1" : (string.equals("646") ? "ASCII" : CharacterEncoding.aliasName(string)));
        }
        if (string2 == null) {
            string2 = string;
        }
        try {
            return Class.forName(Converters.getConverterPackageName() + "." + converterPrefix[n2] + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedEncodingException(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object newConverter(int n2, String string) throws UnsupportedEncodingException {
        Class clazz;
        Object object = lock;
        synchronized (object) {
            clazz = Converters.cache(n2, string);
            if (clazz == null) {
                clazz = Converters.getConverterClass(n2, string);
                Converters.cache(n2, string, clazz);
            }
        }
        return Converters.newConverter(string, clazz);
    }

    private static Class cache(int n2, Object object, Class clazz) {
        Object[] objectArray = classCache[n2];
        objectArray[2] = new SoftReference(new Object[]{clazz, object});
        Converters.moveToFront(objectArray, 2);
        return clazz;
    }

    private static Object newConverter(String string, Class clazz) throws UnsupportedEncodingException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedEncodingException(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedEncodingException(string);
        }
    }
}

