/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import sun.net.www.ParseUtil;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;
import sun.security.util.ResourcesMgr;

public class PolicyParser {
    public static final String REPLACE_NAME = "PolicyParser.REPLACE_NAME";
    private Vector grantEntries = new Vector();
    private static final Debug debug = Debug.getInstance("parser", "\t[Policy Parser]");
    private StreamTokenizer st;
    private int lookahead;
    private int linenum;
    private boolean expandProp = false;
    private String keyStoreUrlString = null;
    private String keyStoreType = null;

    public PolicyParser() {
    }

    private void parseKeyStoreEntry() throws ParsingException, IOException {
        this.match("keystore");
        this.keyStoreUrlString = this.match("quoted string");
        if (!this.peek(",")) {
            return;
        }
        this.match(",");
        if (!this.peek("\"")) {
            throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected keystore type"));
        }
        this.keyStoreType = this.match("quoted string");
    }

    private void skipEntry() throws ParsingException, IOException {
        while (this.lookahead != 59) {
            switch (this.lookahead) {
                case -2: {
                    throw new ParsingException(this.st.lineno(), ";", ResourcesMgr.getString("number ") + String.valueOf(this.st.nval));
                }
                case -1: {
                    throw new ParsingException(ResourcesMgr.getString("expected [;], read [end of file]"));
                }
            }
            this.lookahead = this.st.nextToken();
        }
    }

    public PolicyParser(boolean bl2) {
        this();
        this.expandProp = bl2;
    }

    private void writeKeyStoreEntry(PrintWriter printWriter) {
        printWriter.print("keystore \"");
        printWriter.print(this.keyStoreUrlString);
        printWriter.print('\"');
        if (this.keyStoreType != null && this.keyStoreType.length() > 0) {
            printWriter.print(", \"" + this.keyStoreType + "\"");
        }
        printWriter.println(";");
        printWriter.println();
    }

    public void read(Reader reader) throws ParsingException, IOException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.st = new StreamTokenizer(reader);
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(46, 46);
        this.st.wordChars(48, 57);
        this.st.wordChars(95, 95);
        this.st.wordChars(36, 36);
        this.st.wordChars(160, 255);
        this.st.whitespaceChars(0, 32);
        this.st.commentChar(47);
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.lowerCaseMode(false);
        this.st.ordinaryChar(47);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.lookahead = this.st.nextToken();
        while (this.lookahead != -1) {
            if (this.peek("grant")) {
                GrantEntry grantEntry = this.parseGrantEntry();
                if (grantEntry != null) {
                    this.add(grantEntry);
                }
            } else if (this.peek("keystore") && this.keyStoreUrlString == null) {
                this.parseKeyStoreEntry();
            }
            this.match(";");
        }
    }

    public void write(Writer writer) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        Enumeration enumeration = this.grantElements();
        printWriter.println("/* AUTOMATICALLY GENERATED ON " + new Date() + "*/");
        printWriter.println("/* DO NOT EDIT */");
        printWriter.println();
        if (this.keyStoreUrlString != null) {
            this.writeKeyStoreEntry(printWriter);
        }
        while (enumeration.hasMoreElements()) {
            GrantEntry grantEntry = (GrantEntry)enumeration.nextElement();
            grantEntry.write(printWriter);
            printWriter.println();
        }
        printWriter.flush();
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStoreUrl() {
        try {
            if (this.keyStoreUrlString != null && this.keyStoreUrlString.length() != 0) {
                return this.expand(this.keyStoreUrlString, true).replace(File.separatorChar, '/');
            }
        }
        catch (PropertyExpander.ExpandException expandException) {
            if (debug != null) {
                debug.println(expandException.toString());
            }
            return null;
        }
        return null;
    }

    private String[] parseExtDirs() {
        String string = System.getProperty("java.ext.dirs");
        String[] stringArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            int n2 = stringTokenizer.countTokens();
            stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                File file = new File(stringTokenizer.nextToken());
                stringArray[i2] = ParseUtil.encodePath(file.getAbsolutePath());
                if (!stringArray[i2].startsWith("/")) {
                    stringArray[i2] = "/" + stringArray[i2];
                }
                stringArray[i2] = stringArray[i2].endsWith("/") ? "file:" + stringArray[i2] + "*" : "file:" + stringArray[i2] + "/*";
            }
        }
        return stringArray;
    }

    public void setKeyStoreType(String string) {
        this.keyStoreType = string;
    }

    public void setKeyStoreUrl(String string) {
        this.keyStoreUrlString = string;
    }

    private boolean peek(String string) {
        boolean bl2 = false;
        switch (this.lookahead) {
            case -3: {
                if (!string.equalsIgnoreCase(this.st.sval)) break;
                bl2 = true;
                break;
            }
            case 44: {
                if (!string.equalsIgnoreCase(",")) break;
                bl2 = true;
                break;
            }
            case 123: {
                if (!string.equalsIgnoreCase("{")) break;
                bl2 = true;
                break;
            }
            case 125: {
                if (!string.equalsIgnoreCase("}")) break;
                bl2 = true;
                break;
            }
            case 34: {
                if (!string.equalsIgnoreCase("\"")) break;
                bl2 = true;
                break;
            }
            case 42: {
                if (!string.equalsIgnoreCase("*")) break;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    private boolean peekAndMatch(String string) throws ParsingException, IOException {
        if (this.peek(string)) {
            this.match(string);
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) throws Exception {
        PolicyParser policyParser = new PolicyParser(true);
        policyParser.read(new FileReader(stringArray[0]));
        FileWriter fileWriter = new FileWriter(stringArray[1]);
        policyParser.write(fileWriter);
        fileWriter.close();
    }

    public Enumeration grantElements() {
        return this.grantEntries.elements();
    }

    private GrantEntry parseGrantEntry() throws ParsingException, IOException {
        int n2;
        String[] stringArray;
        GrantEntry grantEntry = new GrantEntry();
        LinkedList linkedList = null;
        boolean bl2 = false;
        this.match("grant");
        while (!this.peek("{")) {
            if (this.peekAndMatch("Codebase")) {
                if (grantEntry.codeBase != null) {
                    throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("multiple Codebase expressions"));
                }
                grantEntry.codeBase = this.match("quoted string");
                this.peekAndMatch(",");
                continue;
            }
            if (this.peekAndMatch("SignedBy")) {
                if (grantEntry.signedBy != null) {
                    throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("multiple SignedBy expressions"));
                }
                grantEntry.signedBy = this.match("quoted string");
                stringArray = new StringTokenizer(grantEntry.signedBy, ",", true);
                n2 = 0;
                int n3 = 0;
                while (stringArray.hasMoreTokens()) {
                    String string = stringArray.nextToken().trim();
                    if (string.equals(",")) {
                        ++n3;
                        continue;
                    }
                    if (string.length() <= 0) continue;
                    ++n2;
                }
                if (n2 <= n3) {
                    throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("SignedBy has empty alias"));
                }
                this.peekAndMatch(",");
                continue;
            }
            if (this.peekAndMatch("Principal")) {
                String string;
                if (linkedList == null) {
                    linkedList = new LinkedList();
                }
                if (this.peek("\"")) {
                    stringArray = REPLACE_NAME;
                    string = this.match("principal type");
                } else {
                    if (this.peek("*")) {
                        this.match("*");
                        stringArray = "WILDCARD_PRINCIPAL_CLASS";
                    } else {
                        stringArray = this.match("principal type");
                    }
                    if (this.peek("*")) {
                        this.match("*");
                        string = "WILDCARD_PRINCIPAL_NAME";
                    } else {
                        string = this.match("quoted string");
                    }
                    if (stringArray.equals("WILDCARD_PRINCIPAL_CLASS") && !string.equals("WILDCARD_PRINCIPAL_NAME")) {
                        if (debug != null) {
                            debug.println("disallowing principal that has WILDCARD class but no WILDCARD name");
                        }
                        throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("can not specify Principal with a wildcard class without a wildcard name"));
                    }
                }
                try {
                    string = this.expand(string);
                    if (stringArray.equals("javax.security.auth.x500.X500Principal") && !string.equals("WILDCARD_PRINCIPAL_NAME")) {
                        X500Principal x500Principal = new X500Principal(new X500Principal(string).toString());
                        string = x500Principal.getName();
                    }
                    linkedList.add(new PrincipalEntry((String)stringArray, string));
                }
                catch (PropertyExpander.ExpandException expandException) {
                    if (debug != null) {
                        debug.println("principal name expansion failed: " + string);
                    }
                    bl2 = true;
                }
                this.peekAndMatch(",");
                continue;
            }
            throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected codeBase or SignedBy or Principal"));
        }
        if (linkedList != null) {
            grantEntry.principals = linkedList;
        }
        this.match("{");
        while (!this.peek("}")) {
            if (this.peek("Permission")) {
                try {
                    stringArray = this.parsePermissionEntry();
                    grantEntry.add((PermissionEntry)stringArray);
                }
                catch (PropertyExpander.ExpandException expandException) {
                    if (debug != null) {
                        debug.println(expandException.toString());
                    }
                    this.skipEntry();
                }
                this.match(";");
                continue;
            }
            throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected permission entry"));
        }
        this.match("}");
        try {
            if (grantEntry.signedBy != null) {
                grantEntry.signedBy = this.expand(grantEntry.signedBy);
            }
            if (grantEntry.codeBase != null) {
                if (!grantEntry.codeBase.equals("${java.ext.dirs}")) {
                    grantEntry.codeBase = this.expand(grantEntry.codeBase, true).replace(File.separatorChar, '/');
                } else {
                    stringArray = this.parseExtDirs();
                    if (stringArray != null && stringArray.length > 0) {
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            GrantEntry grantEntry2 = (GrantEntry)grantEntry.clone();
                            grantEntry2.codeBase = stringArray[n2];
                            this.add(grantEntry2);
                            if (debug == null) continue;
                            debug.println("creating policy entry for expanded java.ext.dirs path:\n\t\t" + stringArray[n2]);
                        }
                    }
                    bl2 = true;
                }
            }
        }
        catch (PropertyExpander.ExpandException expandException) {
            if (debug != null) {
                debug.println(expandException.toString());
            }
            return null;
        }
        return bl2 ? null : grantEntry;
    }

    public void add(GrantEntry grantEntry) {
        this.grantEntries.addElement(grantEntry);
    }

    public boolean remove(GrantEntry grantEntry) {
        return this.grantEntries.removeElement(grantEntry);
    }

    private PermissionEntry parsePermissionEntry() throws ParsingException, IOException, PropertyExpander.ExpandException {
        PermissionEntry permissionEntry = new PermissionEntry();
        this.match("Permission");
        permissionEntry.permission = this.match("permission type");
        if (this.peek("\"")) {
            permissionEntry.name = this.expand(this.match("quoted string"));
        }
        if (!this.peek(",")) {
            return permissionEntry;
        }
        this.match(",");
        if (this.peek("\"")) {
            permissionEntry.action = this.expand(this.match("quoted string"));
            if (!this.peek(",")) {
                return permissionEntry;
            }
            this.match(",");
        }
        if (this.peekAndMatch("SignedBy")) {
            permissionEntry.signedBy = this.expand(this.match("quoted string"));
        }
        return permissionEntry;
    }

    private String expand(String string) throws PropertyExpander.ExpandException {
        return this.expand(string, false);
    }

    private String match(String string) throws ParsingException, IOException {
        String string2 = null;
        switch (this.lookahead) {
            case -2: {
                throw new ParsingException(this.st.lineno(), string, ResourcesMgr.getString("number ") + String.valueOf(this.st.nval));
            }
            case -1: {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("expected [expect], read [end of file]"));
                Object[] objectArray = new Object[]{string};
                throw new ParsingException(messageFormat.format(objectArray));
            }
            case -3: {
                if (string.equalsIgnoreCase(this.st.sval)) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("permission type")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("principal type")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, this.st.sval);
            }
            case 34: {
                if (string.equalsIgnoreCase("quoted string")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("permission type")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("principal type")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, this.st.sval);
            }
            case 44: {
                if (string.equalsIgnoreCase(",")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, ",");
            }
            case 123: {
                if (string.equalsIgnoreCase("{")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, "{");
            }
            case 125: {
                if (string.equalsIgnoreCase("}")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, "}");
            }
            case 59: {
                if (string.equalsIgnoreCase(";")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, ";");
            }
            case 42: {
                if (string.equalsIgnoreCase("*")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, "*");
            }
            default: {
                throw new ParsingException(this.st.lineno(), string, new String(new char[]{(char)this.lookahead}));
            }
        }
        return string2;
    }

    private String expand(String string, boolean bl2) throws PropertyExpander.ExpandException {
        if (!this.expandProp) {
            return string;
        }
        return PropertyExpander.expand(string, bl2);
    }

    public void replace(GrantEntry grantEntry, GrantEntry grantEntry2) {
        this.grantEntries.setElementAt(grantEntry2, this.grantEntries.indexOf(grantEntry));
    }

    public static class GrantEntry {
        public String signedBy;
        public String codeBase;
        public LinkedList principals;
        public Vector permissionEntries;

        public GrantEntry() {
            this.principals = new LinkedList();
            this.permissionEntries = new Vector();
        }

        public void write(PrintWriter printWriter) {
            Object object;
            Object object2;
            printWriter.print("grant");
            if (this.signedBy != null) {
                printWriter.print(" signedBy \"");
                printWriter.print(this.signedBy);
                printWriter.print('\"');
                if (this.codeBase != null) {
                    printWriter.print(", ");
                }
            }
            if (this.codeBase != null) {
                printWriter.print(" codeBase \"");
                printWriter.print(this.codeBase);
                printWriter.print('\"');
                if (this.principals != null && this.principals.size() > 0) {
                    printWriter.print(",\n");
                }
            }
            if (this.principals != null && this.principals.size() > 0) {
                object2 = this.principals.listIterator();
                while (object2.hasNext()) {
                    printWriter.print("      ");
                    object = (PrincipalEntry)object2.next();
                    ((PrincipalEntry)object).write(printWriter);
                    if (!object2.hasNext()) continue;
                    printWriter.print(",\n");
                }
            }
            printWriter.println(" {");
            object2 = this.permissionEntries.elements();
            while (object2.hasMoreElements()) {
                object = (PermissionEntry)object2.nextElement();
                printWriter.write("  ");
                ((PermissionEntry)object).write(printWriter);
            }
            printWriter.println("};");
        }

        public Object clone() {
            GrantEntry grantEntry = new GrantEntry();
            grantEntry.codeBase = this.codeBase;
            grantEntry.signedBy = this.signedBy;
            grantEntry.principals = new LinkedList(this.principals);
            grantEntry.permissionEntries = new Vector(this.permissionEntries);
            return grantEntry;
        }

        public Enumeration permissionElements() {
            return this.permissionEntries.elements();
        }

        public void add(PermissionEntry permissionEntry) {
            this.permissionEntries.addElement(permissionEntry);
        }

        public boolean contains(PermissionEntry permissionEntry) {
            return this.permissionEntries.contains(permissionEntry);
        }

        public boolean remove(PermissionEntry permissionEntry) {
            return this.permissionEntries.removeElement(permissionEntry);
        }

        public boolean contains(PrincipalEntry principalEntry) {
            return this.principals.contains(principalEntry);
        }

        public boolean remove(PrincipalEntry principalEntry) {
            return this.principals.remove(principalEntry);
        }

        public GrantEntry(String string, String string2) {
            this.codeBase = string2;
            this.signedBy = string;
            this.principals = new LinkedList();
            this.permissionEntries = new Vector();
        }
    }

    public static class ParsingException
    extends GeneralSecurityException {
        private String i18nMessage;

        public String getLocalizedMessage() {
            return this.i18nMessage;
        }

        public ParsingException(int n2, String string) {
            super("line " + n2 + ": " + string);
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("line number: msg"));
            Object[] objectArray = new Object[]{new Integer(n2), string};
            this.i18nMessage = messageFormat.format(objectArray);
        }

        public ParsingException(String string) {
            super(string);
            this.i18nMessage = string;
        }

        public ParsingException(int n2, String string, String string2) {
            super("line " + n2 + ": expected [" + string + "], found [" + string2 + "]");
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("line number: expected [expect], found [actual]"));
            Object[] objectArray = new Object[]{new Integer(n2), string, string2};
            this.i18nMessage = messageFormat.format(objectArray);
        }
    }

    public static class PermissionEntry {
        public String permission;
        public String name;
        public String action;
        public String signedBy;

        public int hashCode() {
            int n2 = this.permission.hashCode();
            if (this.name != null) {
                n2 ^= this.name.hashCode();
            }
            if (this.action != null) {
                n2 ^= this.action.hashCode();
            }
            return n2;
        }

        public PermissionEntry() {
        }

        public void write(PrintWriter printWriter) {
            printWriter.print("permission ");
            printWriter.print(this.permission);
            if (this.name != null) {
                printWriter.print(" \"");
                if (this.name.indexOf("\"") != -1) {
                    int n2 = 0;
                    char[] cArray = this.name.toCharArray();
                    for (int i2 = 0; i2 < cArray.length; ++i2) {
                        if (cArray[i2] != '\"') continue;
                        ++n2;
                    }
                    char[] cArray2 = new char[cArray.length + n2];
                    int n3 = 0;
                    for (int i3 = 0; i3 < cArray.length; ++i3) {
                        if (cArray[i3] != '\"') {
                            cArray2[n3++] = cArray[i3];
                            continue;
                        }
                        cArray2[n3++] = 92;
                        cArray2[n3++] = cArray[i3];
                    }
                    this.name = new String(cArray2);
                }
                printWriter.print(this.name);
                printWriter.print('\"');
            }
            if (this.action != null) {
                printWriter.print(", \"");
                printWriter.print(this.action);
                printWriter.print('\"');
            }
            if (this.signedBy != null) {
                printWriter.print(", signedBy \"");
                printWriter.print(this.signedBy);
                printWriter.print('\"');
            }
            printWriter.println(";");
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PermissionEntry)) {
                return false;
            }
            PermissionEntry permissionEntry = (PermissionEntry)object;
            if (this.permission == null ? permissionEntry.permission != null : !this.permission.equals(permissionEntry.permission)) {
                return false;
            }
            if (this.name == null ? permissionEntry.name != null : !this.name.equals(permissionEntry.name)) {
                return false;
            }
            if (this.action == null ? permissionEntry.action != null : !this.action.equals(permissionEntry.action)) {
                return false;
            }
            return !(this.signedBy == null ? permissionEntry.signedBy != null : !this.signedBy.equals(permissionEntry.signedBy));
        }

        public PermissionEntry(String string, String string2, String string3) {
            this.permission = string;
            this.name = string2;
            this.action = string3;
        }
    }

    public static class PrincipalEntry {
        public static final String WILDCARD_CLASS = "WILDCARD_PRINCIPAL_CLASS";
        public static final String WILDCARD_NAME = "WILDCARD_PRINCIPAL_NAME";
        String principalClass;
        String principalName;

        public int hashCode() {
            return this.principalClass.hashCode();
        }

        public void write(PrintWriter printWriter) {
            printWriter.print("principal " + this.getDisplayClass() + " " + this.getDisplayName(true));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PrincipalEntry)) {
                return false;
            }
            PrincipalEntry principalEntry = (PrincipalEntry)object;
            return this.principalClass.equals(principalEntry.principalClass) && this.principalName.equals(principalEntry.principalName);
        }

        public String getDisplayClass() {
            if (this.principalClass.equals(WILDCARD_CLASS)) {
                return "*";
            }
            if (this.principalClass.equals(PolicyParser.REPLACE_NAME)) {
                return "";
            }
            return this.principalClass;
        }

        public String getDisplayName() {
            return this.getDisplayName(false);
        }

        public String getPrincipalClass() {
            return this.principalClass;
        }

        public String getPrincipalName() {
            return this.principalName;
        }

        public String toString() {
            if (!this.principalClass.equals(PolicyParser.REPLACE_NAME)) {
                return this.getDisplayClass() + "/" + this.getDisplayName();
            }
            return this.getDisplayName();
        }

        public String getDisplayName(boolean bl2) {
            if (this.principalName.equals(WILDCARD_NAME)) {
                return "*";
            }
            if (bl2) {
                return "\"" + this.principalName + "\"";
            }
            return this.principalName;
        }

        public PrincipalEntry(String string, String string2) {
            if (string == null || string2 == null) {
                throw new NullPointerException(ResourcesMgr.getString("null principalClass or principalName"));
            }
            this.principalClass = string;
            this.principalName = string2;
        }
    }
}

