/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public final class Region {
    public int handle;

    public Region() {
        this.handle = OS.CreateRectRgn(0, 0, 0, 0);
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    Region(int handle) {
        this.handle = handle;
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        if (rect.width < 0 || rect.height < 0) {
            SWT.error(5);
        }
        int rectRgn = OS.CreateRectRgn(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
        OS.CombineRgn(this.handle, this.handle, rectRgn, 2);
        OS.DeleteObject(rectRgn);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.CombineRgn(this.handle, this.handle, region.handle, 2);
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.PtInRegion(this.handle, x, y);
    }

    public boolean contains(Point pt) {
        if (pt == null) {
            SWT.error(4);
        }
        return this.contains(pt.x, pt.y);
    }

    public void dispose() {
        if (this.handle != 0) {
            OS.DeleteObject(this.handle);
        }
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region rgn = (Region)object;
        return this.handle == rgn.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RECT rect = new RECT();
        OS.GetRgnBox(this.handle, rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RECT r = new RECT();
        OS.SetRect(r, x, y, x + width, y + height);
        return OS.RectInRegion(this.handle, r);
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        RECT rect;
        int result;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if ((result = OS.GetRgnBox(this.handle, rect = new RECT())) == 1) {
            return true;
        }
        return rect.right - rect.left <= 0 || rect.bottom - rect.top <= 0;
    }

    public static Region win32_new(int handle) {
        return new Region(handle);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

