/*
 * Decompiled with CFR 0.152.
 */
package latte;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import latte.LMChangedEvent;
import latte.Latte;
import latte.action.ActionCancelException;
import latte.action.AllAction;
import latte.model.IRNode;
import latte.model.LM13Model;
import latte.model.LM13NamespaceOwnedElement;
import latte.model.LM13XMI;
import latte.model.LM13XMIContent;
import latte.model.LM13XMIDocumentation;
import latte.model.LM13XMIHeader;
import latte.model.LM13XMIMetamodel;
import latte.model.RString;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;

public class LatteData
extends Observable {
    private List curElementList_ = new ArrayList();
    private boolean isNeedSaving_ = false;
    private File file_ = null;
    private LM13XMI xmi_ = new LM13XMI();
    private HashMap idReference_ = new HashMap();
    private String encoding_ = "Shift_JIS";
    static /* synthetic */ Class class$0;

    public LatteData() {
        ModelUtil.initId();
        this.xmi_.setXmiVersion("1.1");
        LM13XMIHeader header = new LM13XMIHeader();
        LM13XMIMetamodel metamodel = new LM13XMIMetamodel();
        metamodel.setXmiName("UML");
        metamodel.setXmiVersion("1.3");
        header.setXMIMetamodel(metamodel);
        LM13XMIDocumentation doc = new LM13XMIDocumentation();
        header.setXMIDocumentation(doc);
        this.xmi_.setXMIHeader(header);
        LM13XMIContent content = new LM13XMIContent();
        this.xmi_.setXMIContent(content);
        LM13Model model = new LM13Model();
        model.setXmiId(ModelUtil.getGlobalId());
        model.setName("\u30e2\u30c7\u30eb");
        model.addUMLPackageFeatures(new LM13NamespaceOwnedElement());
        content.addContent(model);
    }

    public Set idrefEntrySet() {
        return this.idReference_.entrySet();
    }

    public void addIdref(Object xmiid, Object value) {
        this.idReference_.put(xmiid, value);
    }

    public void checkSaving() throws ActionCancelException, IOException {
        if (!this.isNeedSaving_) {
            return;
        }
        int ret = MsgUtil.showYesNoCancelMsg("\u30c7\u30fc\u30bf\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f");
        switch (ret) {
            case 64: {
                break;
            }
            case 128: {
                return;
            }
            case 256: {
                throw new ActionCancelException();
            }
        }
        AllAction.FILE_SAVE.execute(null);
    }

    public void destroy() throws ActionCancelException, IOException {
        this.deleteObservers();
    }

    public void load() throws Exception {
        if (this.file_ == null) {
            throw new IllegalStateException("\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        this.xmi_ = new LM13XMI(this.file_);
        LogUtil.writeln("\n<<<<<\u30ea\u30d5\u30a1\u30ec\u30f3\u30b9\u4f5c\u6210 at createReference()>>>>>");
        this.createReference(this.xmi_.rGetRNodes());
        if (this.xmi_.getXMIHeader().getXMIDocumentation() != null && this.xmi_.getXMIHeader().getXMIDocumentation().getContent(0) != null) {
            RString ids = (RString)this.xmi_.getXMIHeader().getXMIDocumentation().getContent(0);
            ModelUtil.unmarshallIds(ids.getContent());
        }
        LogUtil.writeln("ID\u53c2\u7167\u6570=" + this.idReference_.size());
        this.isNeedSaving_ = false;
    }

    private void createReference(IRNode[] node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int i = 0;
        while (i < node.length) {
            IRNode o = node[i];
            try {
                Method methodGetXmiid = o.getClass().getMethod("getXmiId", null);
                Class<?> clazz = o.getClass();
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Method methodSetName = clazz.getMethod("setName", classArray);
                Method methodGetName = o.getClass().getMethod("getName", null);
                String xmiId = (String)methodGetXmiid.invoke((Object)o, null);
                String name = (String)methodGetName.invoke((Object)o, null);
                this.idReference_.put(xmiId, o);
                LogUtil.writeln(String.valueOf(xmiId) + "=" + name + ":" + o.getClass());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.createReference(node[i].rGetRNodes());
            ++i;
        }
    }

    public Object lookup(String xmiid) {
        return this.idReference_.get(xmiid);
    }

    public void setNeedSaving() {
        this.isNeedSaving_ = true;
    }

    public void notifyObserversForce(LMChangedEvent lmce) {
        this.setChanged();
        this.notifyObservers(lmce);
    }

    public void save() throws IllegalStateException, IOException {
        if (this.file_ == null) {
            throw new IllegalStateException("\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        Latte.getLatteData().getXMI().getXMIHeader().getXMIDocumentation().setContent(ModelUtil.marshallIds());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file_), this.encoding_));
        writer.write("<?xml version=\"1.0\" encoding=\"");
        writer.write(this.encoding_);
        writer.write("\" ?>\n");
        this.xmi_.makeTextElement(writer);
        writer.flush();
        writer.close();
        this.isNeedSaving_ = false;
    }

    public Object getCurrentElement() {
        if (this.curElementList_.size() > 0) {
            return this.curElementList_.get(0);
        }
        return null;
    }

    public void setCurrentElement(Object element) {
        LogUtil.writeln("LatteData.CurrentElement = " + element);
        this.curElementList_.clear();
        this.curElementList_.add(element);
    }

    public File getFile() {
        return this.file_;
    }

    public void setFile(File file) {
        this.file_ = file;
    }

    public LM13XMI getXMI() {
        return this.xmi_;
    }
}

