/*
 * Decompiled with CFR 0.152.
 */
package latte.action;

import latte.LMChangedEvent;
import latte.Latte;
import latte.LatteData;
import latte.action.AbstractLatteAction;
import latte.model.LM13Class;
import latte.model.LM13ClassifierFeature;
import latte.model.LM13Interface;
import latte.model.LM13Model;
import latte.model.LM13NamespaceOwnedElement;
import latte.model.LM13Package;
import latte.util.ModelUtil;
import latte.util.MsgUtil;

public abstract class AbstractAddAction
extends AbstractLatteAction {
    public AbstractAddAction(String title, String imageFile) {
        super(title, imageFile);
    }

    public void execMain(Object param) {
        try {
            LatteData ld = Latte.getLatteData();
            Object parent = ModelUtil.getCurElement();
            parent = this.checkParent(parent);
            Object newDef = this.createNewDef();
            this.addNewDef(parent, newDef);
            ld.addIdref(ModelUtil.getXmiId(newDef), newDef);
            ld.setNeedSaving();
            LMChangedEvent ldce = new LMChangedEvent(11, parent, newDef);
            ld.notifyObserversForce(ldce);
        }
        catch (Exception e) {
            MsgUtil.showMsg("\u30a8\u30e9\u30fc\u767a\u751f\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    protected Object checkParent(Object parent) {
        LM13Model m;
        if (parent == null) {
            return new IllegalStateException("\u89aa\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (parent instanceof LM13Class) {
            LM13Class c = (LM13Class)parent;
            if (ModelUtil.getClassifierFeature(c) == null) {
                c.addUMLClassFeatures(new LM13ClassifierFeature());
            }
        } else if (parent instanceof LM13Interface) {
            LM13Interface i = (LM13Interface)parent;
            if (ModelUtil.getClassifierFeature(i) == null) {
                i.addUMLClassifierFeatures(new LM13ClassifierFeature());
            }
        } else if (parent instanceof LM13Package) {
            LM13Package p = (LM13Package)parent;
            if (ModelUtil.getOwnedElement(p) == null) {
                p.addUMLPackageFeatures(new LM13NamespaceOwnedElement());
            }
        } else if (parent instanceof LM13Model && ModelUtil.getOwnedElement(m = (LM13Model)parent) == null) {
            m.addUMLPackageFeatures(new LM13NamespaceOwnedElement());
        }
        return parent;
    }

    abstract Object createNewDef();

    abstract void addNewDef(Object var1, Object var2);
}

