/*
 * Decompiled with CFR 0.152.
 */
package latte.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import latte.model.IRNSContainer;
import latte.model.IRNode;
import latte.model.IRVisitable;
import latte.model.IRVisitor;
import latte.model.LM13XMIExtension;
import latte.model.RNSContext;
import latte.model.RStack;
import latte.model.UJAXP;
import latte.model.URelaxer;
import latte.model.URelaxer2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LM13Element
implements Serializable,
Cloneable,
IRNSContainer,
IRVisitable,
IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "href://org.omg/UML/1.3");
    private String xmiId_;
    private String xmiLabel_;
    private String xmiUuid_;
    private String href_;
    private String xmiIdref_;
    private String xmlLink_;
    private List xMIExtension_ = new ArrayList();
    private IRNode parentRNode_;

    public LM13Element() {
    }

    public LM13Element(LM13Element source) {
        this.setup(source);
    }

    public LM13Element(RStack stack) {
        this.setup(stack);
    }

    public LM13Element(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public LM13Element(Element element) {
        this.setup(element);
    }

    public LM13Element(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public LM13Element(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public LM13Element(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public LM13Element(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public LM13Element(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public LM13Element(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(LM13Element source) {
        this.setXmiId(source.getXmiId());
        this.setXmiLabel(source.getXmiLabel());
        this.setXmiUuid(source.getXmiUuid());
        this.setHref(source.getHref());
        this.setXmiIdref(source.getXmiIdref());
        this.setXmlLink(source.getXmlLink());
        this.xMIExtension_.clear();
        int size = source.xMIExtension_.size();
        int i = 0;
        while (i < size) {
            this.addXMIExtension((LM13XMIExtension)source.getXMIExtension(i).clone());
            ++i;
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.rNSContext_.declareNamespace(element);
        this.xmiId_ = URelaxer.getAttributePropertyAsString(element, "xmi.id");
        this.xmiLabel_ = URelaxer.getAttributePropertyAsString(element, "xmi.label");
        this.xmiUuid_ = URelaxer.getAttributePropertyAsString(element, "xmi.uuid");
        this.href_ = URelaxer.getAttributePropertyAsString(element, "href");
        this.xmiIdref_ = URelaxer.getAttributePropertyAsString(element, "xmi.idref");
        this.xmlLink_ = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/XML/1998/namespace", "link");
        this.xMIExtension_.clear();
        while (LM13XMIExtension.isMatch(stack)) {
            this.addXMIExtension(new LM13XMIExtension(stack));
        }
    }

    public Object clone() {
        return new LM13Element(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElementNS("href://org.omg/UML/1.3", "Element");
        this.rNSContext_.setupNamespace(element);
        if (this.xmiId_ != null) {
            URelaxer.setAttributePropertyByString(element, "xmi.id", this.xmiId_);
        }
        if (this.xmiLabel_ != null) {
            URelaxer.setAttributePropertyByString(element, "xmi.label", this.xmiLabel_);
        }
        if (this.xmiUuid_ != null) {
            URelaxer.setAttributePropertyByString(element, "xmi.uuid", this.xmiUuid_);
        }
        if (this.href_ != null) {
            URelaxer.setAttributePropertyByString(element, "href", this.href_);
        }
        if (this.xmiIdref_ != null) {
            URelaxer.setAttributePropertyByString(element, "xmi.idref", this.xmiIdref_);
        }
        if (this.xmlLink_ != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/XML/1998/namespace", "link", this.xmlLink_, this.rNSContext_);
        }
        int size = this.xMIExtension_.size();
        int i = 0;
        while (i < size) {
            LM13XMIExtension value = (LM13XMIExtension)this.xMIExtension_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 2));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 2));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 2));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 2));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 2));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public final String getXmiId() {
        return this.xmiId_;
    }

    public final void setXmiId(String xmiId) {
        this.xmiId_ = xmiId;
    }

    public final String getXmiLabel() {
        return this.xmiLabel_;
    }

    public final void setXmiLabel(String xmiLabel) {
        this.xmiLabel_ = xmiLabel;
    }

    public final String getXmiUuid() {
        return this.xmiUuid_;
    }

    public final void setXmiUuid(String xmiUuid) {
        this.xmiUuid_ = xmiUuid;
    }

    public final String getHref() {
        return this.href_;
    }

    public final void setHref(String href) {
        this.href_ = href;
    }

    public final String getXmiIdref() {
        return this.xmiIdref_;
    }

    public final void setXmiIdref(String xmiIdref) {
        this.xmiIdref_ = xmiIdref;
    }

    public final String getXmlLink() {
        return this.xmlLink_;
    }

    public final void setXmlLink(String xmlLink) {
        this.xmlLink_ = xmlLink;
    }

    public final LM13XMIExtension[] getXMIExtension() {
        LM13XMIExtension[] array = new LM13XMIExtension[this.xMIExtension_.size()];
        return this.xMIExtension_.toArray(array);
    }

    public final void setXMIExtension(LM13XMIExtension[] xMIExtension) {
        this.xMIExtension_.clear();
        int i = 0;
        while (i < xMIExtension.length) {
            this.addXMIExtension(xMIExtension[i]);
            ++i;
        }
        i = 0;
        while (i < xMIExtension.length) {
            xMIExtension[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final void setXMIExtension(LM13XMIExtension xMIExtension) {
        this.xMIExtension_.clear();
        this.addXMIExtension(xMIExtension);
        if (xMIExtension != null) {
            xMIExtension.rSetParentRNode(this);
        }
    }

    public final void addXMIExtension(LM13XMIExtension xMIExtension) {
        this.xMIExtension_.add(xMIExtension);
        if (xMIExtension != null) {
            xMIExtension.rSetParentRNode(this);
        }
    }

    public final void addXMIExtension(LM13XMIExtension[] xMIExtension) {
        int i = 0;
        while (i < xMIExtension.length) {
            this.addXMIExtension(xMIExtension[i]);
            ++i;
        }
        i = 0;
        while (i < xMIExtension.length) {
            xMIExtension[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final int sizeXMIExtension() {
        return this.xMIExtension_.size();
    }

    public final LM13XMIExtension getXMIExtension(int index) {
        return (LM13XMIExtension)this.xMIExtension_.get(index);
    }

    public final void setXMIExtension(int index, LM13XMIExtension xMIExtension) {
        this.xMIExtension_.set(index, xMIExtension);
        if (xMIExtension != null) {
            xMIExtension.rSetParentRNode(this);
        }
    }

    public final void addXMIExtension(int index, LM13XMIExtension xMIExtension) {
        this.xMIExtension_.add(index, xMIExtension);
        if (xMIExtension != null) {
            xMIExtension.rSetParentRNode(this);
        }
    }

    public final void removeXMIExtension(int index) {
        this.xMIExtension_.remove(index);
    }

    public final void removeXMIExtension(LM13XMIExtension xMIExtension) {
        this.xMIExtension_.remove(xMIExtension);
    }

    public final void clearXMIExtension() {
        this.xMIExtension_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("href://org.omg/UML/1.3");
        buffer.append("<");
        URelaxer.makeQName(prefix, "Element", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.xmiId_ != null) {
            buffer.append(" ");
            this.rNSContext_.makeQName("", "xmi.id", buffer);
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiId())));
            buffer.append("\"");
        }
        if (this.xmiLabel_ != null) {
            buffer.append(" ");
            this.rNSContext_.makeQName("", "xmi.label", buffer);
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiLabel())));
            buffer.append("\"");
        }
        if (this.xmiUuid_ != null) {
            buffer.append(" ");
            this.rNSContext_.makeQName("", "xmi.uuid", buffer);
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiUuid())));
            buffer.append("\"");
        }
        if (this.href_ != null) {
            buffer.append(" ");
            this.rNSContext_.makeQName("", "href", buffer);
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHref())));
            buffer.append("\"");
        }
        if (this.xmiIdref_ != null) {
            buffer.append(" ");
            this.rNSContext_.makeQName("", "xmi.idref", buffer);
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiIdref())));
            buffer.append("\"");
        }
        if (this.xmlLink_ != null) {
            buffer.append(" ");
            this.rNSContext_.makeQName("http://www.w3.org/XML/1998/namespace", "link", buffer);
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmlLink())));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.xMIExtension_.size();
        int i = 0;
        while (i < size) {
            LM13XMIExtension value = (LM13XMIExtension)this.xMIExtension_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "Element", buffer);
        buffer.append(">");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        String prefix = this.rNSContext_.getPrefixByUri("href://org.omg/UML/1.3");
        buffer.write("<");
        URelaxer.makeQName(prefix, "Element", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.xmiId_ != null) {
            buffer.write(" ");
            this.rNSContext_.makeQName("", "xmi.id", buffer);
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiId())));
            buffer.write("\"");
        }
        if (this.xmiLabel_ != null) {
            buffer.write(" ");
            this.rNSContext_.makeQName("", "xmi.label", buffer);
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiLabel())));
            buffer.write("\"");
        }
        if (this.xmiUuid_ != null) {
            buffer.write(" ");
            this.rNSContext_.makeQName("", "xmi.uuid", buffer);
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiUuid())));
            buffer.write("\"");
        }
        if (this.href_ != null) {
            buffer.write(" ");
            this.rNSContext_.makeQName("", "href", buffer);
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHref())));
            buffer.write("\"");
        }
        if (this.xmiIdref_ != null) {
            buffer.write(" ");
            this.rNSContext_.makeQName("", "xmi.idref", buffer);
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiIdref())));
            buffer.write("\"");
        }
        if (this.xmlLink_ != null) {
            buffer.write(" ");
            this.rNSContext_.makeQName("http://www.w3.org/XML/1998/namespace", "link", buffer);
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmlLink())));
            buffer.write("\"");
        }
        buffer.write(">");
        int size = this.xMIExtension_.size();
        int i = 0;
        while (i < size) {
            LM13XMIExtension value = (LM13XMIExtension)this.xMIExtension_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "Element", buffer);
        buffer.write(">");
    }

    public void makeTextElement(PrintWriter buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("href://org.omg/UML/1.3");
        buffer.print("<");
        URelaxer.makeQName(prefix, "Element", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.xmiId_ != null) {
            buffer.print(" ");
            this.rNSContext_.makeQName("", "xmi.id", buffer);
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiId())));
            buffer.print("\"");
        }
        if (this.xmiLabel_ != null) {
            buffer.print(" ");
            this.rNSContext_.makeQName("", "xmi.label", buffer);
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiLabel())));
            buffer.print("\"");
        }
        if (this.xmiUuid_ != null) {
            buffer.print(" ");
            this.rNSContext_.makeQName("", "xmi.uuid", buffer);
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiUuid())));
            buffer.print("\"");
        }
        if (this.href_ != null) {
            buffer.print(" ");
            this.rNSContext_.makeQName("", "href", buffer);
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHref())));
            buffer.print("\"");
        }
        if (this.xmiIdref_ != null) {
            buffer.print(" ");
            this.rNSContext_.makeQName("", "xmi.idref", buffer);
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiIdref())));
            buffer.print("\"");
        }
        if (this.xmlLink_ != null) {
            buffer.print(" ");
            this.rNSContext_.makeQName("http://www.w3.org/XML/1998/namespace", "link", buffer);
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmlLink())));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.xMIExtension_.size();
        int i = 0;
        while (i < size) {
            LM13XMIExtension value = (LM13XMIExtension)this.xMIExtension_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "Element", buffer);
        buffer.print(">");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getXmiIdAsString() {
        return URelaxer.getString(this.getXmiId());
    }

    public String getXmiLabelAsString() {
        return URelaxer.getString(this.getXmiLabel());
    }

    public String getXmiUuidAsString() {
        return URelaxer.getString(this.getXmiUuid());
    }

    public String getHrefAsString() {
        return URelaxer.getString(this.getHref());
    }

    public String getXmiIdrefAsString() {
        return URelaxer.getString(this.getXmiIdref());
    }

    public String getXmlLinkAsString() {
        return URelaxer.getString(this.getXmlLink());
    }

    public void setXmiIdByString(String string) {
        this.setXmiId(string);
    }

    public void setXmiLabelByString(String string) {
        this.setXmiLabel(string);
    }

    public void setXmiUuidByString(String string) {
        this.setXmiUuid(string);
    }

    public void setHrefByString(String string) {
        this.setHref(string);
    }

    public void setXmiIdrefByString(String string) {
        this.setXmiIdref(string);
    }

    public void setXmlLinkByString(String string) {
        this.setXmlLink(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public boolean enter(IRVisitor visitor) {
        return visitor.enter(this);
    }

    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.xMIExtension_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "href://org.omg/UML/1.3", "Element")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (LM13XMIExtension.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return LM13Element.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (LM13Element.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

