/*
 * Decompiled with CFR 0.152.
 */
package latte.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import latte.model.IRNSContainer;
import latte.model.IRNode;
import latte.model.IRVisitable;
import latte.model.IRVisitor;
import latte.model.LM13XMIContent;
import latte.model.LM13XMIDifference;
import latte.model.LM13XMIExtensions;
import latte.model.LM13XMIHeader;
import latte.model.RNSContext;
import latte.model.RStack;
import latte.model.UJAXP;
import latte.model.URelaxer;
import latte.model.URelaxer2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LM13XMI
implements Serializable,
Cloneable,
IRNSContainer,
IRVisitable,
IRNode {
    public static final String XMIVERSION_1_1 = "1.1";
    public static final String VERIFIED_TRUE = "true";
    public static final String VERIFIED_FALSE = "false";
    private RNSContext rNSContext_ = new RNSContext(this, "");
    private String xmiVersion_;
    private String timestamp_;
    private String verified_;
    private LM13XMIHeader xMIHeader_;
    private LM13XMIContent xMIContent_;
    private List xMIDifference_ = new ArrayList();
    private List xMIExtensions_ = new ArrayList();
    private IRNode parentRNode_;

    public LM13XMI() {
        this.rNSContext_.declareNamespace("UML", "href://org.omg/UML/1.3");
    }

    public LM13XMI(LM13XMI source) {
        this.rNSContext_.declareNamespace("UML", "href://org.omg/UML/1.3");
        this.setup(source);
    }

    public LM13XMI(RStack stack) {
        this.rNSContext_.declareNamespace("UML", "href://org.omg/UML/1.3");
        this.setup(stack);
    }

    public LM13XMI(Document doc) {
        this.rNSContext_.declareNamespace("UML", "href://org.omg/UML/1.3");
        this.setup(doc.getDocumentElement());
    }

    public LM13XMI(Element element) {
        this.rNSContext_.declareNamespace("UML", "href://org.omg/UML/1.3");
        this.setup(element);
    }

    public LM13XMI(File file) throws IOException, SAXException, ParserConfigurationException {
        this.rNSContext_.declareNamespace("UML", "href://org.omg/UML/1.3");
        this.setup(file);
    }

    public LM13XMI(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.rNSContext_.declareNamespace("UML", "href://org.omg/UML/1.3");
        this.setup(uri);
    }

    public LM13XMI(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.rNSContext_.declareNamespace("UML", "href://org.omg/UML/1.3");
        this.setup(url);
    }

    public LM13XMI(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.rNSContext_.declareNamespace("UML", "href://org.omg/UML/1.3");
        this.setup(in);
    }

    public LM13XMI(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.rNSContext_.declareNamespace("UML", "href://org.omg/UML/1.3");
        this.setup(is);
    }

    public LM13XMI(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.rNSContext_.declareNamespace("UML", "href://org.omg/UML/1.3");
        this.setup(reader);
    }

    public void setup(LM13XMI source) {
        this.setXmiVersion(source.getXmiVersion());
        this.setTimestamp(source.getTimestamp());
        this.setVerified(source.getVerified());
        if (source.xMIHeader_ != null) {
            this.setXMIHeader((LM13XMIHeader)source.getXMIHeader().clone());
        }
        if (source.xMIContent_ != null) {
            this.setXMIContent((LM13XMIContent)source.getXMIContent().clone());
        }
        this.xMIDifference_.clear();
        int size = source.xMIDifference_.size();
        int i = 0;
        while (i < size) {
            this.addXMIDifference((LM13XMIDifference)source.getXMIDifference(i).clone());
            ++i;
        }
        this.xMIExtensions_.clear();
        size = source.xMIExtensions_.size();
        i = 0;
        while (i < size) {
            this.addXMIExtensions((LM13XMIExtensions)source.getXMIExtensions(i).clone());
            ++i;
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.rNSContext_.declareNamespace(element);
        this.xmiVersion_ = URelaxer.getAttributePropertyAsString(element, "xmi.version");
        this.timestamp_ = URelaxer.getAttributePropertyAsString(element, "timestamp");
        this.verified_ = URelaxer.getAttributePropertyAsString(element, "verified");
        if (LM13XMIHeader.isMatch(stack)) {
            this.setXMIHeader(new LM13XMIHeader(stack));
        }
        if (LM13XMIContent.isMatch(stack)) {
            this.setXMIContent(new LM13XMIContent(stack));
        }
        this.xMIDifference_.clear();
        while (LM13XMIDifference.isMatch(stack)) {
            this.addXMIDifference(new LM13XMIDifference(stack));
        }
        this.xMIExtensions_.clear();
        while (LM13XMIExtensions.isMatch(stack)) {
            this.addXMIExtensions(new LM13XMIExtensions(stack));
        }
    }

    public Object clone() {
        return new LM13XMI(this);
    }

    public void makeElement(Node parent) {
        IRNode value;
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElementNS("", "XMI");
        this.rNSContext_.setupNamespace(element);
        if (this.xmiVersion_ != null) {
            URelaxer.setAttributePropertyByString(element, "xmi.version", this.xmiVersion_);
        }
        if (this.timestamp_ != null) {
            URelaxer.setAttributePropertyByString(element, "timestamp", this.timestamp_);
        }
        if (this.verified_ != null) {
            URelaxer.setAttributePropertyByString(element, "verified", this.verified_);
        }
        if (this.xMIHeader_ != null) {
            this.xMIHeader_.makeElement(element);
        }
        if (this.xMIContent_ != null) {
            this.xMIContent_.makeElement(element);
        }
        int size = this.xMIDifference_.size();
        int i = 0;
        while (i < size) {
            value = (LM13XMIDifference)this.xMIDifference_.get(i);
            ((LM13XMIDifference)value).makeElement(element);
            ++i;
        }
        size = this.xMIExtensions_.size();
        i = 0;
        while (i < size) {
            value = (LM13XMIExtensions)this.xMIExtensions_.get(i);
            ((LM13XMIExtensions)value).makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 2));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 2));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 2));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 2));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 2));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public final String getXmiVersion() {
        return this.xmiVersion_;
    }

    public final void setXmiVersion(String xmiVersion) {
        this.xmiVersion_ = xmiVersion;
    }

    public final String getTimestamp() {
        return this.timestamp_;
    }

    public final void setTimestamp(String timestamp) {
        this.timestamp_ = timestamp;
    }

    public final String getVerified() {
        return this.verified_;
    }

    public final void setVerified(String verified) {
        this.verified_ = verified;
    }

    public final LM13XMIHeader getXMIHeader() {
        return this.xMIHeader_;
    }

    public final void setXMIHeader(LM13XMIHeader xMIHeader) {
        this.xMIHeader_ = xMIHeader;
        if (xMIHeader != null) {
            xMIHeader.rSetParentRNode(this);
        }
    }

    public final LM13XMIContent getXMIContent() {
        return this.xMIContent_;
    }

    public final void setXMIContent(LM13XMIContent xMIContent) {
        this.xMIContent_ = xMIContent;
        if (xMIContent != null) {
            xMIContent.rSetParentRNode(this);
        }
    }

    public final LM13XMIDifference[] getXMIDifference() {
        LM13XMIDifference[] array = new LM13XMIDifference[this.xMIDifference_.size()];
        return this.xMIDifference_.toArray(array);
    }

    public final void setXMIDifference(LM13XMIDifference[] xMIDifference) {
        this.xMIDifference_.clear();
        int i = 0;
        while (i < xMIDifference.length) {
            this.addXMIDifference(xMIDifference[i]);
            ++i;
        }
        i = 0;
        while (i < xMIDifference.length) {
            xMIDifference[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final void setXMIDifference(LM13XMIDifference xMIDifference) {
        this.xMIDifference_.clear();
        this.addXMIDifference(xMIDifference);
        if (xMIDifference != null) {
            xMIDifference.rSetParentRNode(this);
        }
    }

    public final void addXMIDifference(LM13XMIDifference xMIDifference) {
        this.xMIDifference_.add(xMIDifference);
        if (xMIDifference != null) {
            xMIDifference.rSetParentRNode(this);
        }
    }

    public final void addXMIDifference(LM13XMIDifference[] xMIDifference) {
        int i = 0;
        while (i < xMIDifference.length) {
            this.addXMIDifference(xMIDifference[i]);
            ++i;
        }
        i = 0;
        while (i < xMIDifference.length) {
            xMIDifference[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final int sizeXMIDifference() {
        return this.xMIDifference_.size();
    }

    public final LM13XMIDifference getXMIDifference(int index) {
        return (LM13XMIDifference)this.xMIDifference_.get(index);
    }

    public final void setXMIDifference(int index, LM13XMIDifference xMIDifference) {
        this.xMIDifference_.set(index, xMIDifference);
        if (xMIDifference != null) {
            xMIDifference.rSetParentRNode(this);
        }
    }

    public final void addXMIDifference(int index, LM13XMIDifference xMIDifference) {
        this.xMIDifference_.add(index, xMIDifference);
        if (xMIDifference != null) {
            xMIDifference.rSetParentRNode(this);
        }
    }

    public final void removeXMIDifference(int index) {
        this.xMIDifference_.remove(index);
    }

    public final void removeXMIDifference(LM13XMIDifference xMIDifference) {
        this.xMIDifference_.remove(xMIDifference);
    }

    public final void clearXMIDifference() {
        this.xMIDifference_.clear();
    }

    public final LM13XMIExtensions[] getXMIExtensions() {
        LM13XMIExtensions[] array = new LM13XMIExtensions[this.xMIExtensions_.size()];
        return this.xMIExtensions_.toArray(array);
    }

    public final void setXMIExtensions(LM13XMIExtensions[] xMIExtensions) {
        this.xMIExtensions_.clear();
        int i = 0;
        while (i < xMIExtensions.length) {
            this.addXMIExtensions(xMIExtensions[i]);
            ++i;
        }
        i = 0;
        while (i < xMIExtensions.length) {
            xMIExtensions[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final void setXMIExtensions(LM13XMIExtensions xMIExtensions) {
        this.xMIExtensions_.clear();
        this.addXMIExtensions(xMIExtensions);
        if (xMIExtensions != null) {
            xMIExtensions.rSetParentRNode(this);
        }
    }

    public final void addXMIExtensions(LM13XMIExtensions xMIExtensions) {
        this.xMIExtensions_.add(xMIExtensions);
        if (xMIExtensions != null) {
            xMIExtensions.rSetParentRNode(this);
        }
    }

    public final void addXMIExtensions(LM13XMIExtensions[] xMIExtensions) {
        int i = 0;
        while (i < xMIExtensions.length) {
            this.addXMIExtensions(xMIExtensions[i]);
            ++i;
        }
        i = 0;
        while (i < xMIExtensions.length) {
            xMIExtensions[i].rSetParentRNode(this);
            ++i;
        }
    }

    public final int sizeXMIExtensions() {
        return this.xMIExtensions_.size();
    }

    public final LM13XMIExtensions getXMIExtensions(int index) {
        return (LM13XMIExtensions)this.xMIExtensions_.get(index);
    }

    public final void setXMIExtensions(int index, LM13XMIExtensions xMIExtensions) {
        this.xMIExtensions_.set(index, xMIExtensions);
        if (xMIExtensions != null) {
            xMIExtensions.rSetParentRNode(this);
        }
    }

    public final void addXMIExtensions(int index, LM13XMIExtensions xMIExtensions) {
        this.xMIExtensions_.add(index, xMIExtensions);
        if (xMIExtensions != null) {
            xMIExtensions.rSetParentRNode(this);
        }
    }

    public final void removeXMIExtensions(int index) {
        this.xMIExtensions_.remove(index);
    }

    public final void removeXMIExtensions(LM13XMIExtensions xMIExtensions) {
        this.xMIExtensions_.remove(xMIExtensions);
    }

    public final void clearXMIExtensions() {
        this.xMIExtensions_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        IRNode value;
        String prefix = this.rNSContext_.getPrefixByUri("");
        buffer.append("<");
        URelaxer.makeQName(prefix, "XMI", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.xmiVersion_ != null) {
            buffer.append(" ");
            this.rNSContext_.makeQName("", "xmi.version", buffer);
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiVersion())));
            buffer.append("\"");
        }
        if (this.timestamp_ != null) {
            buffer.append(" ");
            this.rNSContext_.makeQName("", "timestamp", buffer);
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTimestamp())));
            buffer.append("\"");
        }
        if (this.verified_ != null) {
            buffer.append(" ");
            this.rNSContext_.makeQName("", "verified", buffer);
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getVerified())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.xMIHeader_ != null) {
            this.xMIHeader_.makeTextElement(buffer);
        }
        if (this.xMIContent_ != null) {
            this.xMIContent_.makeTextElement(buffer);
        }
        int size = this.xMIDifference_.size();
        int i = 0;
        while (i < size) {
            value = (LM13XMIDifference)this.xMIDifference_.get(i);
            ((LM13XMIDifference)value).makeTextElement(buffer);
            ++i;
        }
        size = this.xMIExtensions_.size();
        i = 0;
        while (i < size) {
            value = (LM13XMIExtensions)this.xMIExtensions_.get(i);
            ((LM13XMIExtensions)value).makeTextElement(buffer);
            ++i;
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "XMI", buffer);
        buffer.append(">");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        IRNode value;
        String prefix = this.rNSContext_.getPrefixByUri("");
        buffer.write("<");
        URelaxer.makeQName(prefix, "XMI", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.xmiVersion_ != null) {
            buffer.write(" ");
            this.rNSContext_.makeQName("", "xmi.version", buffer);
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiVersion())));
            buffer.write("\"");
        }
        if (this.timestamp_ != null) {
            buffer.write(" ");
            this.rNSContext_.makeQName("", "timestamp", buffer);
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTimestamp())));
            buffer.write("\"");
        }
        if (this.verified_ != null) {
            buffer.write(" ");
            this.rNSContext_.makeQName("", "verified", buffer);
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getVerified())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.xMIHeader_ != null) {
            this.xMIHeader_.makeTextElement(buffer);
        }
        if (this.xMIContent_ != null) {
            this.xMIContent_.makeTextElement(buffer);
        }
        int size = this.xMIDifference_.size();
        int i = 0;
        while (i < size) {
            value = (LM13XMIDifference)this.xMIDifference_.get(i);
            ((LM13XMIDifference)value).makeTextElement(buffer);
            ++i;
        }
        size = this.xMIExtensions_.size();
        i = 0;
        while (i < size) {
            value = (LM13XMIExtensions)this.xMIExtensions_.get(i);
            ((LM13XMIExtensions)value).makeTextElement(buffer);
            ++i;
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "XMI", buffer);
        buffer.write(">");
    }

    public void makeTextElement(PrintWriter buffer) {
        IRNode value;
        String prefix = this.rNSContext_.getPrefixByUri("");
        buffer.print("<");
        URelaxer.makeQName(prefix, "XMI", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.xmiVersion_ != null) {
            buffer.print(" ");
            this.rNSContext_.makeQName("", "xmi.version", buffer);
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmiVersion())));
            buffer.print("\"");
        }
        if (this.timestamp_ != null) {
            buffer.print(" ");
            this.rNSContext_.makeQName("", "timestamp", buffer);
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTimestamp())));
            buffer.print("\"");
        }
        if (this.verified_ != null) {
            buffer.print(" ");
            this.rNSContext_.makeQName("", "verified", buffer);
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getVerified())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.xMIHeader_ != null) {
            this.xMIHeader_.makeTextElement(buffer);
        }
        if (this.xMIContent_ != null) {
            this.xMIContent_.makeTextElement(buffer);
        }
        int size = this.xMIDifference_.size();
        int i = 0;
        while (i < size) {
            value = (LM13XMIDifference)this.xMIDifference_.get(i);
            ((LM13XMIDifference)value).makeTextElement(buffer);
            ++i;
        }
        size = this.xMIExtensions_.size();
        i = 0;
        while (i < size) {
            value = (LM13XMIExtensions)this.xMIExtensions_.get(i);
            ((LM13XMIExtensions)value).makeTextElement(buffer);
            ++i;
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "XMI", buffer);
        buffer.print(">");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getXmiVersionAsString() {
        return URelaxer.getString(this.getXmiVersion());
    }

    public String getTimestampAsString() {
        return URelaxer.getString(this.getTimestamp());
    }

    public String getVerifiedAsString() {
        return URelaxer.getString(this.getVerified());
    }

    public void setXmiVersionByString(String string) {
        this.setXmiVersion(string);
    }

    public void setTimestampByString(String string) {
        this.setTimestamp(string);
    }

    public void setVerifiedByString(String string) {
        this.setVerified(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public boolean enter(IRVisitor visitor) {
        return visitor.enter(this);
    }

    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<IRNode> classNodes = new ArrayList<IRNode>();
        if (this.xMIHeader_ != null) {
            classNodes.add(this.xMIHeader_);
        }
        if (this.xMIContent_ != null) {
            classNodes.add(this.xMIContent_);
        }
        classNodes.addAll(this.xMIDifference_);
        classNodes.addAll(this.xMIExtensions_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "", "XMI")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        LM13XMIHeader.isMatchHungry(target);
        LM13XMIContent.isMatchHungry(target);
        while (LM13XMIDifference.isMatchHungry(target)) {
            $match$ = true;
        }
        while (LM13XMIExtensions.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return LM13XMI.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (LM13XMI.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

