/*
 * Decompiled with CFR 0.152.
 */
package latte.model;

import latte.model.IRNode;
import latte.model.IRVisitable;
import latte.model.IRVisitor;

public final class URVisitor {
    public static void traverse(IRNode node, IRVisitor visitor) {
        URVisitor.traverseDepth(node, visitor);
    }

    public static void traverseDepth(IRNode node, IRVisitor visitor) {
        IRVisitable visitable = (IRVisitable)((Object)node);
        if (visitable.enter(visitor)) {
            URVisitor.traverseDepthChildren(node, visitor);
            visitable.leave(visitor);
        }
    }

    public static void traverseDepthChildren(IRNode node, IRVisitor visitor) {
        URVisitor.traverseDepthChildren(node.rGetRNodes(), visitor);
    }

    public static void traverseDepthChildren(IRNode[] children, IRVisitor visitor) {
        int i = 0;
        while (i < children.length) {
            URVisitor.traverseDepth(children[i], visitor);
            ++i;
        }
    }

    public static void traverseBreadth(IRNode node, IRVisitor visitor) {
        IRVisitable visitable = (IRVisitable)((Object)node);
        if (visitable.enter(visitor)) {
            URVisitor.traverseBreadthChildren(node, visitor);
        }
        visitable.leave(visitor);
    }

    public static void traverseBreadthChildren(IRNode node, IRVisitor visitor) {
        IRNode[] children = node.rGetRNodes();
        boolean[] enterResult = new boolean[children.length];
        int i = 0;
        while (i < children.length) {
            IRVisitable visitable = (IRVisitable)((Object)children[i]);
            enterResult[i] = visitable.enter(visitor);
            visitable.leave(visitor);
            ++i;
        }
        i = 0;
        while (i < children.length) {
            IRNode child = children[i];
            if (enterResult[i]) {
                URVisitor.traverseBreadthChildren(child, visitor);
            }
            ++i;
        }
    }
}

