/*
 * Decompiled with CFR 0.152.
 */
package latte.util;

import java.io.InputStream;
import latte.action.AbstractLatteAction;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class GuiUtil {
    public static final String[] LATTE_EXTENTION = new String[]{"*.lat", "*.*"};
    public static final String[] XMI_EXTENTION = new String[]{"*.xml", "*.xmi", "*.*"};
    public static final String[] RXP_EXTENTION = new String[]{"*.rxp", "*.*"};
    private static Display display_ = null;
    private static Shell shell_ = null;

    public static void syncExce(Runnable runnable) {
        display_.syncExec(runnable);
    }

    public static void setWaitMouseCursor() {
        display_.syncExec(new Runnable(){

            public void run() {
                shell_.setCursor(new Cursor((Device)display_, 1));
            }
        });
    }

    public static void setNormalMouseCursor() {
        display_.syncExec(new Runnable(){

            public void run() {
                shell_.setCursor(null);
            }
        });
    }

    public static Button createButtonInForm(Shell dialog, String text, int x, int y, int width, int height, SelectionListener listener) {
        Button b = new Button((Composite)dialog, 0);
        b.setText(text);
        GuiUtil.setBoundInForm(dialog, (Control)b, x, y, width, height);
        b.addSelectionListener(listener);
        return b;
    }

    public static Label createLabelInForm(Shell dialog, String text, int x, int y, int width, int height) {
        Label l = new Label((Composite)dialog, 0);
        l.setText(text);
        GuiUtil.setBoundInForm(dialog, (Control)l, x, y, width, height);
        return l;
    }

    public static Text createTextInForm(Shell dialog, int x, int y, int width, int height) {
        Text t = new Text((Composite)dialog, 2052);
        GuiUtil.setBoundInForm(dialog, (Control)t, x, y, width, height);
        return t;
    }

    public static void setBoundInForm(Shell dialog, Control c, int x, int y, int width, int height) {
        FormData fd = new FormData(width, height);
        fd.left = new FormAttachment(x, dialog.getSize().x, 0);
        fd.top = new FormAttachment(y, dialog.getSize().y, 0);
        c.setLayoutData((Object)fd);
    }

    public static Shell createDialog(int width, int height, String title) {
        Shell dialog = new Shell(shell_, 67680);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialog.setLayout((Layout)layout);
        dialog.setSize(width, height);
        org.eclipse.swt.graphics.Rectangle diagRect = dialog.getBounds();
        org.eclipse.swt.graphics.Rectangle dispRect = display_.getBounds();
        int x = (dispRect.width - diagRect.width) / 2;
        int y = (dispRect.height - diagRect.height) / 2;
        dialog.setLocation(x, y);
        dialog.setText(title);
        return dialog;
    }

    public static Color getColor(int color) {
        Display d = shell_.getDisplay();
        return d.getSystemColor(color);
    }

    public static void createMenuItem(Menu menu, AbstractLatteAction laction) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(laction.getTitle());
        menuItem.setImage(laction.getImage());
        menuItem.addSelectionListener((SelectionListener)laction);
        laction.addListener((Item)menuItem);
    }

    public static Menu createMenu(Menu menuBar, String title) {
        MenuItem menuItem = new MenuItem(menuBar, 64);
        menuItem.setText(title);
        Menu menu = new Menu(menuItem);
        menuItem.setMenu(menu);
        return menu;
    }

    public static void createCoolItem(CoolBar coolbar, Control control) {
        CoolItem coolItem = new CoolItem(coolbar, 8);
        coolItem.setControl(control);
        org.eclipse.swt.graphics.Point pt = control.computeSize(-1, -1);
        pt = coolItem.computeSize(pt.x, pt.y);
        coolItem.setSize(pt);
    }

    public static void createToolbarItem(ToolBar toolBar, int style, AbstractLatteAction laction, boolean selected) {
        ToolItem item = new ToolItem(toolBar, style);
        item.setImage(laction.getImage());
        item.setToolTipText(laction.getTitle());
        item.addSelectionListener((SelectionListener)laction);
        item.setSelection(selected);
        laction.addListener((Item)item);
    }

    public static void createToolbarItem(ToolBar toolBar, int style, AbstractLatteAction laction) {
        GuiUtil.createToolbarItem(toolBar, style, laction, false);
    }

    public static Image createImage(InputStream is) {
        Image image = new Image((Device)shell_.getDisplay(), is);
        ImageData mask = image.getImageData().getTransparencyMask();
        return new Image((Device)shell_.getDisplay(), image.getImageData(), mask);
    }

    public static String openFileDialog(int mode, String[] extention) {
        FileDialog dialog = new FileDialog(shell_, mode);
        dialog.setFilterExtensions(extention);
        return dialog.open();
    }

    public static String openFileDialog(int mode) {
        return GuiUtil.openFileDialog(mode, LATTE_EXTENTION);
    }

    public static PrinterData openPrintDialog() {
        PrintDialog dialog = new PrintDialog(shell_);
        return dialog.open();
    }

    public static void init(Display display, Shell shell) {
        display_ = display;
        shell_ = shell;
    }

    public static Font getBoldFont() {
        Font f = shell_.getFont();
        FontData[] fds = f.getFontData();
        fds[0].setStyle(1);
        return new Font(null, fds[0]);
    }

    public static void addFigure(IFigure parent, IFigure child) {
        if (!(parent.getLayoutManager() instanceof XYLayout)) {
            throw new IllegalArgumentException("\u5f15\u6570parent\u306eLayoutManager\u304cXYLayout\u3067\u3042\u308a\u307e\u305b\u3093");
        }
        Point p = child.getBounds().getLocation();
        Rectangle rect = new Rectangle(p.x, p.y, -1, -1);
        parent.getLayoutManager().setConstraint(child, (Object)rect);
        parent.add(child);
    }

    public static int stringExtent(String s) {
        GC gc = new GC((Drawable)shell_);
        int x = gc.stringExtent((String)s).x;
        gc.dispose();
        return x;
    }
}

