/*
 * Decompiled with CFR 0.152.
 */
package latte.util;

import latte.Latte;
import latte.model.ILM13ClassifierFeatureChoice;
import latte.model.ILM13NamespaceOwnedElementChoice;
import latte.model.ILM13UMLClassFeaturesChoice;
import latte.model.ILM13UMLClassifierFeaturesChoice;
import latte.model.ILM13UMLDiagramFeaturesChoice;
import latte.model.ILM13UMLPackageFeaturesChoice;
import latte.model.ILM13XMIContentChoice;
import latte.model.IRNode;
import latte.model.LM13Abstraction;
import latte.model.LM13Actor;
import latte.model.LM13Association;
import latte.model.LM13AssociationConnection;
import latte.model.LM13Attribute;
import latte.model.LM13Class;
import latte.model.LM13ClassifierFeature;
import latte.model.LM13ClassifierRole;
import latte.model.LM13Comment;
import latte.model.LM13Dependency;
import latte.model.LM13Diagram;
import latte.model.LM13DiagramElement1;
import latte.model.LM13DiagramElement2;
import latte.model.LM13Generalization;
import latte.model.LM13Interface;
import latte.model.LM13Model;
import latte.model.LM13NamespaceOwnedElement;
import latte.model.LM13Operation;
import latte.model.LM13Package;
import latte.model.LM13XMIContent;
import latte.model.RVisitorBase;
import latte.model.URVisitor;
import latte.util.LogUtil;
import latte.view.LVDiag;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class ModelUtil {
    static int globalNo__ = 0;
    static int scopedNo__ = 0;
    static int xxNo__ = 0;

    public static String getGlobalId() {
        return "LG." + globalNo__++;
    }

    public static String getScopedId() {
        return "LS." + scopedNo__++;
    }

    public static String getXxid() {
        return "LXX." + xxNo__++;
    }

    public static void initId() {
        globalNo__ = 0;
        scopedNo__ = 0;
        xxNo__ = 0;
    }

    public static void unmarshallIds(String ids) {
        String[] nos = ids.split(",");
        if (nos.length == 3) {
            globalNo__ = Integer.parseInt(nos[0]);
            scopedNo__ = Integer.parseInt(nos[1]);
            xxNo__ = Integer.parseInt(nos[2]);
        }
    }

    public static String marshallIds() {
        return String.valueOf(globalNo__) + "," + scopedNo__ + "," + xxNo__;
    }

    public static LVDiag getCurDiag() {
        return Latte.getMainForm().getDiagFolder().getCurDiag();
    }

    public static Object getCurElement() {
        return Latte.getLatteData().getCurrentElement();
    }

    public static LM13NamespaceOwnedElement getModelNamespace(LM13DiagramElement2 de2) {
        LM13NamespaceOwnedElement namespace = null;
        IRNode model = (IRNode)ModelUtil.getModel(de2);
        namespace = (LM13NamespaceOwnedElement)model.rGetParentRNode();
        return namespace;
    }

    public static LM13DiagramElement1 getDiagramElement(LM13Diagram diag) {
        ILM13UMLDiagramFeaturesChoice[] diagramFeatures = diag.getUMLDiagramFeatures();
        int i = 0;
        while (i < diagramFeatures.length) {
            if (diagramFeatures[i] instanceof LM13DiagramElement1) {
                return (LM13DiagramElement1)diagramFeatures[i];
            }
            ++i;
        }
        LogUtil.writeln("No diagramFeatures in \u30c0\u30a4\u30a2\u30b0\u30e9\u30e0:" + diag.getName());
        return null;
    }

    public static LM13NamespaceOwnedElement getOwnedElement(LM13Model model) {
        ILM13UMLPackageFeaturesChoice[] packageFeatures = model.getUMLPackageFeatures();
        int i = 0;
        while (i < packageFeatures.length) {
            if (packageFeatures[i] instanceof LM13NamespaceOwnedElement) {
                return (LM13NamespaceOwnedElement)packageFeatures[i];
            }
            ++i;
        }
        LogUtil.writeln("No OwnedElement in \u30e2\u30c7\u30eb:" + model.getName());
        return null;
    }

    public static LM13NamespaceOwnedElement getOwnedElement(LM13Package pkg) {
        ILM13UMLPackageFeaturesChoice[] packageFeatures = pkg.getUMLPackageFeatures();
        int i = 0;
        while (i < packageFeatures.length) {
            if (packageFeatures[i] instanceof LM13NamespaceOwnedElement) {
                return (LM13NamespaceOwnedElement)packageFeatures[i];
            }
            ++i;
        }
        LogUtil.writeln("No OwnedElement in \u30d1\u30c3\u30b1\u30fc\u30b8:" + pkg.getName());
        return null;
    }

    public static LM13ClassifierFeature getClassifierFeature(LM13Class cls) {
        ILM13UMLClassFeaturesChoice[] classFeatures = cls.getUMLClassFeatures();
        int i = 0;
        while (i < classFeatures.length) {
            if (classFeatures[i] instanceof LM13ClassifierFeature) {
                return (LM13ClassifierFeature)classFeatures[i];
            }
            ++i;
        }
        LogUtil.writeln("No Classifier in \u30af\u30e9\u30b9:" + cls.getName());
        return null;
    }

    public static LM13ClassifierFeature getClassifierFeature(LM13Interface intf) {
        ILM13UMLClassifierFeaturesChoice[] classifierFeatures = intf.getUMLClassifierFeatures();
        int i = 0;
        while (i < classifierFeatures.length) {
            if (classifierFeatures[i] instanceof LM13ClassifierFeature) {
                return (LM13ClassifierFeature)classifierFeatures[i];
            }
            ++i;
        }
        LogUtil.writeln("No Classifier in \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30a4\u30b9:" + intf.getName());
        return null;
    }

    public static String getXmiId(Object model) {
        String xmiid = null;
        if (model instanceof LM13Class) {
            LM13Class c = (LM13Class)model;
            xmiid = c.getXmiId();
        } else if (model instanceof LM13Interface) {
            LM13Interface i = (LM13Interface)model;
            xmiid = i.getXmiId();
        } else if (model instanceof LM13Package) {
            LM13Package p = (LM13Package)model;
            xmiid = p.getXmiId();
        } else if (model instanceof LM13Attribute) {
            LM13Attribute a = (LM13Attribute)model;
            xmiid = a.getXmiId();
        } else if (model instanceof LM13Operation) {
            LM13Operation o = (LM13Operation)model;
            xmiid = o.getXmiId();
        } else if (model instanceof LM13Model) {
            LM13Model m = (LM13Model)model;
            xmiid = m.getXmiId();
        } else if (model instanceof LM13DiagramElement2) {
            LM13DiagramElement2 e = (LM13DiagramElement2)model;
            xmiid = e.getXmiId();
        }
        return xmiid;
    }

    public static String getSubject(Object model) {
        String subject = null;
        if (model instanceof LM13DiagramElement2) {
            LM13DiagramElement2 e = (LM13DiagramElement2)model;
            subject = e.getSubject(0);
        }
        return subject;
    }

    public static String getName(Object model) {
        String name = null;
        if (model instanceof LM13Class) {
            LM13Class c = (LM13Class)model;
            name = c.getName();
        } else if (model instanceof LM13Interface) {
            LM13Interface i = (LM13Interface)model;
            name = i.getName();
        } else if (model instanceof LM13Package) {
            LM13Package p = (LM13Package)model;
            name = p.getName();
        } else if (model instanceof LM13Attribute) {
            LM13Attribute a = (LM13Attribute)model;
            name = a.getName();
        } else if (model instanceof LM13Operation) {
            LM13Operation o = (LM13Operation)model;
            name = o.getName();
        } else if (model instanceof LM13Diagram) {
            LM13Diagram d = (LM13Diagram)model;
            name = d.getName();
        } else if (model instanceof LM13Model) {
            LM13Model m = (LM13Model)model;
            name = m.getName();
        }
        return name;
    }

    public static boolean setName(Object model, String newName) {
        LM13Model m;
        boolean isDuty = false;
        if (model instanceof LM13Class) {
            LM13Class c = (LM13Class)model;
            if (!c.getName().equals(newName)) {
                isDuty = true;
                c.setName(newName);
            }
        } else if (model instanceof LM13Interface) {
            LM13Interface i = (LM13Interface)model;
            if (!i.getName().equals(newName)) {
                isDuty = true;
                i.setName(newName);
            }
        } else if (model instanceof LM13Package) {
            LM13Package p = (LM13Package)model;
            if (!p.getName().equals(newName)) {
                isDuty = true;
                p.setName(newName);
            }
        } else if (model instanceof LM13Attribute) {
            LM13Attribute a = (LM13Attribute)model;
            if (!a.getName().equals(newName)) {
                isDuty = true;
                a.setName(newName);
            }
        } else if (model instanceof LM13Operation) {
            LM13Operation o = (LM13Operation)model;
            if (!o.getName().equals(newName)) {
                isDuty = true;
                o.setName(newName);
            }
        } else if (model instanceof LM13Diagram) {
            LM13Diagram d = (LM13Diagram)model;
            if (!d.getName().equals(newName)) {
                isDuty = true;
                d.setName(newName);
            }
        } else if (model instanceof LM13Model && !(m = (LM13Model)model).getName().equals(newName)) {
            isDuty = true;
            m.setName(newName);
        }
        return isDuty;
    }

    public static Point getLocation(LM13DiagramElement2 diagElement) {
        return ModelUtil.getLocation(diagElement, new Point(0, 0));
    }

    public static Point getLocation(LM13DiagramElement2 diagElement, Point offset) {
        String geometory = diagElement.getGeometry();
        String[] s = geometory.split(",");
        int x = Integer.parseInt(s[0].trim());
        int y = Integer.parseInt(s[1].trim());
        Point p = new Point(x, y);
        p.translate(offset);
        return p;
    }

    public static void setLocation(LM13DiagramElement2 diagElement, Point newLocation) {
        String geo = diagElement.getGeometry();
        String[] s = geo.split(",");
        int x = newLocation.x;
        int y = newLocation.y;
        int w = Integer.parseInt(s[2].trim());
        int h = Integer.parseInt(s[3].trim());
        String newGeo = String.valueOf(x) + ", " + y + ", " + w + ", " + h;
        diagElement.setGeometry(newGeo);
    }

    public static Dimension getSize(LM13DiagramElement2 diagElement) {
        String geometory = diagElement.getGeometry();
        String[] s = geometory.split(",");
        int w = Integer.parseInt(s[2].trim());
        int h = Integer.parseInt(s[3].trim());
        return new Dimension(w, h);
    }

    public static Object getModel(LM13DiagramElement2 diagElement) {
        LM13Diagram diagram = (LM13Diagram)diagElement.rGetParentRNode().rGetParentRNode();
        String diagType = diagram.getDiagramType();
        if (diagType.equals("ClassDiagram")) {
            String xmiid = diagElement.getSubject(0);
            return ModelUtil.getModel(xmiid);
        }
        if (diagType.equals("SequenceDiagram")) {
            String subjectXmiid = diagElement.getSubject(0);
            return ModelUtil.getModel(subjectXmiid);
        }
        throw new IllegalArgumentException("\u672a\u30b5\u30dd\u30fc\u30c8\u306e\u5f15\u6570\u3067\u3059");
    }

    public static Object getModel(LM13ClassifierRole cRole) {
        String modelXmiid = cRole.getBase(0);
        return ModelUtil.getModel(modelXmiid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getName(LM13ClassifierRole cRole) {
        String name = cRole.getName();
        Object model = ModelUtil.getModel(cRole);
        if (!name.startsWith("{")) return name.split("\\{")[0];
        if (model instanceof LM13Class) {
            return ((LM13Class)model).getName();
        }
        if (model instanceof LM13Interface) {
            return ((LM13Interface)model).getName();
        }
        if (model instanceof LM13Actor) {
            return ((LM13Actor)model).getName();
        }
        LogUtil.writeln("Class=" + model.getClass().getName());
        throw new IllegalArgumentException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u306a\u3044\u5f15\u6570\u3067\u3059");
    }

    public static Object getModel(String xmiid) {
        return Latte.getLatteData().lookup(xmiid);
    }

    public static LM13Model getLM13Model() {
        LM13Model model = null;
        ILM13XMIContentChoice[] content = Latte.getLatteData().getXMI().getXMIContent().getContent();
        int i = 0;
        while (i < content.length) {
            if (content[i] instanceof LM13Model) {
                model = (LM13Model)content[i];
                return model;
            }
            ++i;
        }
        return model;
    }

    public static void deleteModel(Object deleteDef) {
        LM13XMIContent node = Latte.getLatteData().getXMI().getXMIContent();
        URVisitor.traverse(node, new DeleteVisitor(deleteDef));
    }

    static class DeleteVisitor
    extends RVisitorBase {
        private Object deleteDef_ = null;

        DeleteVisitor(Object deleteDef) {
            this.deleteDef_ = deleteDef;
        }

        public boolean enter(LM13NamespaceOwnedElement ownedElement) {
            ILM13NamespaceOwnedElementChoice[] contents = ownedElement.getContent();
            int i = 0;
            while (i < contents.length) {
                if (contents[i] == this.deleteDef_) {
                    ownedElement.removeContent(contents[i]);
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean enter(LM13ClassifierFeature classifierFeature) {
            ILM13ClassifierFeatureChoice[] contents = classifierFeature.getContent();
            int i = 0;
            while (i < contents.length) {
                if (contents[i] == this.deleteDef_) {
                    classifierFeature.removeContent(contents[i]);
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean enter(LM13DiagramElement1 diagElement) {
            LM13DiagramElement2[] elements = diagElement.getDiagramElement();
            String deleteXmiid = ModelUtil.getSubject(this.deleteDef_);
            int i = 0;
            while (i < elements.length) {
                LM13Comment cmt;
                LM13NamespaceOwnedElement ownedElement;
                Object modelElement;
                if (elements[i] == this.deleteDef_) {
                    LogUtil.writeln("remove DiagramElement2");
                    diagElement.removeDiagramElement(elements[i]);
                    IRNode model = (IRNode)ModelUtil.getModel(elements[i]);
                    LM13NamespaceOwnedElement ownedElement2 = (LM13NamespaceOwnedElement)model.rGetParentRNode();
                    ownedElement2.removeContent((ILM13NamespaceOwnedElementChoice)model);
                }
                if ((modelElement = ModelUtil.getModel(elements[i])) instanceof LM13Generalization) {
                    LM13Generalization gen = (LM13Generalization)modelElement;
                    if (gen.getChild(0).equals(deleteXmiid) || gen.getParent(0).equals(deleteXmiid)) {
                        LogUtil.writeln("remove DiagramElement2");
                        diagElement.removeDiagramElement(elements[i]);
                        ownedElement = (LM13NamespaceOwnedElement)gen.rGetParentRNode();
                        ownedElement.removeContent(gen);
                    }
                } else if (modelElement instanceof LM13Association) {
                    LM13Association ass = (LM13Association)modelElement;
                    LM13AssociationConnection con = (LM13AssociationConnection)ass.getUMLAssociationFeatures(0);
                    if (con.getContent(0).getType(0).equals(deleteXmiid) || con.getContent(1).getType(0).equals(deleteXmiid)) {
                        LogUtil.writeln("remove DiagramElement2");
                        diagElement.removeDiagramElement(elements[i]);
                        LM13NamespaceOwnedElement ownedElement3 = (LM13NamespaceOwnedElement)ass.rGetParentRNode();
                        ownedElement3.removeContent(ass);
                    }
                } else if (modelElement instanceof LM13Dependency) {
                    LM13Dependency dep = (LM13Dependency)modelElement;
                    if (dep.getClient(0).equals(deleteXmiid) || dep.getSupplier(0).equals(deleteXmiid)) {
                        LogUtil.writeln("remove DiagramElement2");
                        diagElement.removeDiagramElement(elements[i]);
                        ownedElement = (LM13NamespaceOwnedElement)dep.rGetParentRNode();
                        ownedElement.removeContent(dep);
                    }
                } else if (modelElement instanceof LM13Abstraction) {
                    LM13Abstraction abs = (LM13Abstraction)modelElement;
                    if (abs.getClient(0).equals(deleteXmiid) || abs.getSupplier(0).equals(deleteXmiid)) {
                        LogUtil.writeln("remove DiagramElement2");
                        diagElement.removeDiagramElement(elements[i]);
                        ownedElement = (LM13NamespaceOwnedElement)abs.rGetParentRNode();
                        ownedElement.removeContent(abs);
                    }
                } else if (modelElement instanceof LM13Comment && (cmt = (LM13Comment)modelElement).getAnnotatedElement() != null && cmt.getAnnotatedElement(0).equals(deleteXmiid)) {
                    LogUtil.writeln("remove DiagramElement2");
                    cmt.setAnnotatedElement((String)null);
                }
                ++i;
            }
            return true;
        }
    }
}

