/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.Iterator;
import latte.action.AllAction;
import latte.model.LM13DiagramElement2;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.view.LVDiag;
import latte.view.LVDiagFolder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DropTargetEnabler
implements DropTargetListener {
    private LVDiagFolder latteDiagFolder_ = null;
    private static Transfer[] TYPE = new Transfer[]{TextTransfer.getInstance()};
    private static int OPERATION = 7;

    public DropTargetEnabler(LVDiagFolder folder, Control control) {
        this.latteDiagFolder_ = folder;
        DropTarget target = new DropTarget(control, OPERATION);
        target.setTransfer(TYPE);
        target.addDropListener((DropTargetListener)this);
    }

    public void drop(DropTargetEvent event) {
        LogUtil.write("DropTarget.drop():");
        if (event.data == null) {
            event.detail = 0;
            LogUtil.writeln("none");
            return;
        }
        Viewport viewport = (Viewport)ModelUtil.getCurDiag().getDraw2dView().getParent();
        Point offset = viewport.getViewLocation();
        Canvas c = ModelUtil.getCurDiag().getSwtView();
        Composite comp = c.getParent();
        org.eclipse.swt.graphics.Point p = c.toControl(new org.eclipse.swt.graphics.Point(event.x + offset.x, event.y + offset.y));
        LogUtil.writeln(String.valueOf((String)event.data) + " on " + p);
        AllAction.ADD_FIGURE.execute(p);
    }

    public void dragEnter(DropTargetEvent event) {
        LogUtil.writeln("DropTarget.dragEnter()");
        LVDiag diag = this.latteDiagFolder_.getCurDiag();
        String curXmiid = ModelUtil.getXmiId(ModelUtil.getCurElement());
        Iterator ite = diag.getDiagElementList().iterator();
        while (ite.hasNext()) {
            LM13DiagramElement2 de2 = (LM13DiagramElement2)ite.next();
            if (!de2.getSubject()[0].equals(curXmiid)) continue;
            event.detail = 0;
            return;
        }
    }

    public void dragLeave(DropTargetEvent event) {
        LogUtil.writeln("DropTarget.dragLeave()");
    }

    public void dragOperationChanged(DropTargetEvent event) {
        LogUtil.writeln("DropTarget.dragOperationChanged()");
        if (event.detail == 16) {
            event.detail = 4;
        }
    }

    public void dropAccept(DropTargetEvent event) {
        LogUtil.writeln("DropTarget.dropAccept()");
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 25;
    }
}

