/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import latte.action.AllAction;
import latte.model.LM13Abstraction;
import latte.model.LM13Association;
import latte.model.LM13Comment;
import latte.model.LM13Dependency;
import latte.model.LM13DiagramElement2;
import latte.model.LM13Generalization;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.view.LVClassDiag;
import latte.view.LVClassDiagAbstractionConnection;
import latte.view.LVClassDiagAssociationConnection;
import latte.view.LVClassDiagCommentConnection;
import latte.view.LVClassDiagDependencyConnection;
import latte.view.LVClassDiagGeneralizationConnection;
import latte.view.LVConst;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public abstract class LVClassDiagConnection
extends PolylineConnection {
    protected LVClassDiag parent_ = null;
    protected LM13DiagramElement2 lmDiagElement_ = null;
    private int clickPos_ = 0;
    public static final int WIDTH_NORMAL = 1;
    public static final int WIDTH_SELECTED = 2;
    public static final int CLICKPOS_SOURCE = 1;
    public static final int CLICKPOS_TARGET = 2;

    public LVClassDiagConnection(LVClassDiag parent, LM13DiagramElement2 element) {
        this.parent_ = parent;
        this.lmDiagElement_ = element;
        this.setForegroundColor(LVConst.ForeColor);
        this.addMouseListener(new ClassDiagConnectionMouseListener(this));
        this.addMouseMotionListener(new ClassDiagConnectionMouseMotionListener(this));
    }

    public static LVClassDiagConnection createConnection(LVClassDiag parent, LM13DiagramElement2 element) {
        LVClassDiagConnection createdConnection = null;
        Object subject = ModelUtil.getModel(element);
        if (subject instanceof LM13Generalization) {
            createdConnection = new LVClassDiagGeneralizationConnection(parent, element);
        } else if (subject instanceof LM13Association) {
            createdConnection = new LVClassDiagAssociationConnection(parent, element);
        } else if (subject instanceof LM13Dependency) {
            createdConnection = new LVClassDiagDependencyConnection(parent, element);
        } else if (subject instanceof LM13Abstraction) {
            createdConnection = new LVClassDiagAbstractionConnection(parent, element);
        } else if (subject instanceof LM13Comment) {
            createdConnection = new LVClassDiagCommentConnection(parent, element);
        } else {
            throw new IllegalArgumentException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044element\u306e\u578b\u3067\u3059");
        }
        ((LVClassDiagConnection)createdConnection).setupConnectionStyle();
        return createdConnection;
    }

    abstract ConnectionAnchor createSourceConnectionAnchor();

    abstract ConnectionAnchor createTargetConnectionAnchor();

    protected void setupConnectionStyle() {
        this.setSourceAnchor(this.createSourceConnectionAnchor());
        this.setTargetAnchor(this.createTargetConnectionAnchor());
        this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
    }

    public void createConstraint() {
    }

    public void updateConnection() {
        LogUtil.writeln("LVClassDiagConnection.updateConnection()");
        Object cur = ModelUtil.getCurElement();
        if (cur == this.getDiagElement()) {
            this.setLineWidth(2);
        } else {
            this.setLineWidth(1);
        }
        this.setupConnectionStyle();
        this.repaint();
    }

    public Object getModel() {
        return ModelUtil.getModel(this.lmDiagElement_);
    }

    public int getClickPos() {
        return this.clickPos_;
    }

    public LM13DiagramElement2 getDiagElement() {
        return this.lmDiagElement_;
    }

    static class ClassDiagConnectionMouseListener
    implements MouseListener {
        private LVClassDiagConnection conn_ = null;

        ClassDiagConnectionMouseListener(LVClassDiagConnection conn) {
            this.conn_ = conn;
        }

        public void mousePressed(MouseEvent me) {
            LogUtil.writeln("ClassDiagConnectionMouseListener.mousePressed()");
            Point sPoint = this.conn_.getStart();
            Point ePoint = this.conn_.getEnd();
            int lenStart = Math.abs(sPoint.x - me.x) + Math.abs(sPoint.y - me.y);
            int lenEnd = Math.abs(ePoint.x - me.x) + Math.abs(ePoint.y - me.y);
            if (lenStart < lenEnd) {
                this.conn_.clickPos_ = 1;
            } else {
                this.conn_.clickPos_ = 2;
            }
            if (ModelUtil.getModel(this.conn_.getDiagElement()) instanceof LM13Association) {
                this.conn_.parent_.setPopupMenu(4);
            } else {
                this.conn_.parent_.setPopupMenu(3);
            }
            this.conn_.getParent().handleMousePressed(me);
            AllAction.SELECT_DEF.execute(this.conn_.getDiagElement());
        }

        public void mouseReleased(MouseEvent me) {
            this.conn_.getParent().handleMouseReleased(me);
        }

        public void mouseDoubleClicked(MouseEvent me) {
            AllAction.ROUTECONS_DELETE.execute(null);
        }
    }

    static class ClassDiagConnectionMouseMotionListener
    implements MouseMotionListener {
        private LVClassDiagConnection conn_ = null;

        ClassDiagConnectionMouseMotionListener(LVClassDiagConnection conn) {
            this.conn_ = conn;
        }

        public void mouseDragged(MouseEvent me) {
            this.conn_.getParent().handleMouseDragged(me);
        }

        public void mouseMoved(MouseEvent me) {
            this.conn_.getParent().handleMouseMoved(me);
        }

        public void mouseEntered(MouseEvent me) {
            this.conn_.getParent().handleMouseEntered(me);
        }

        public void mouseExited(MouseEvent me) {
            this.conn_.getParent().handleMouseExited(me);
        }

        public void mouseHover(MouseEvent me) {
            this.conn_.getParent().handleMouseHover(me);
        }
    }

    static class LineArrowDecoration
    extends PolylineDecoration {
        LineArrowDecoration() {
            this.setScale(8.0, 5.0);
        }
    }

    static class TriangleDecoration
    extends PolygonDecoration {
        TriangleDecoration() {
            this.setBackgroundColor(ColorConstants.white);
            this.setScale(8.0, 5.0);
        }
    }

    static class AggregationDecoration
    extends PolygonDecoration {
        static final PointList DIAMOND_TIP = new PointList();

        static {
            DIAMOND_TIP.addPoint(0, 0);
            DIAMOND_TIP.addPoint(-1, 1);
            DIAMOND_TIP.addPoint(-2, 0);
            DIAMOND_TIP.addPoint(-1, -1);
        }

        AggregationDecoration() {
            this.setTemplate(DIAMOND_TIP);
            this.setBackgroundColor(ColorConstants.white);
            this.setScale(6.0, 4.0);
        }
    }

    static class CompositionDecoration
    extends PolygonDecoration {
        static final PointList DIAMOND_TIP = new PointList();

        static {
            DIAMOND_TIP.addPoint(0, 0);
            DIAMOND_TIP.addPoint(-1, 1);
            DIAMOND_TIP.addPoint(-2, 0);
            DIAMOND_TIP.addPoint(-1, -1);
        }

        CompositionDecoration() {
            this.setTemplate(DIAMOND_TIP);
            this.setScale(6.0, 4.0);
        }
    }
}

