/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.List;
import latte.InternalLogicException;
import latte.action.AllAction;
import latte.model.LM13Class;
import latte.model.LM13Comment;
import latte.model.LM13DiagramElement2;
import latte.model.LM13Interface;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.view.LVClassDiag;
import latte.view.LVClassDiagClassFigure;
import latte.view.LVClassDiagCommentFigure;
import latte.view.LVClassDiagInterfaceFigure;
import latte.view.LVConst;
import latte.view.LVDiagFigure;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;

public abstract class LVClassDiagFigure
extends LVDiagFigure {
    private static AddingConnection addingConn_ = new AddingConnection();

    public LVClassDiagFigure(LVClassDiag lvClassDiag, LM13DiagramElement2 lmDiagElement) {
        super(lvClassDiag, lmDiagElement);
        this.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.addMouseListener(new ClassDiagFigureMouseListener(this));
        this.addMouseMotionListener(new ClassDiagFigureMouseMotionListener(this));
    }

    protected static LVClassDiagFigure createFigure(LVClassDiag parent, LM13DiagramElement2 lmDiagElement) {
        LVClassDiagFigure createdFigure = null;
        Object subject = ModelUtil.getModel(lmDiagElement);
        if (subject instanceof LM13Class) {
            createdFigure = new LVClassDiagClassFigure(parent, lmDiagElement);
        } else if (subject instanceof LM13Interface) {
            createdFigure = new LVClassDiagInterfaceFigure(parent, lmDiagElement);
        } else if (subject instanceof LM13Comment) {
            createdFigure = new LVClassDiagCommentFigure(parent, lmDiagElement);
        } else {
            throw new IllegalArgumentException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044lmDiagElement\u306e\u578b\u3067\u3059");
        }
        ((LVClassDiagFigure)createdFigure).createFigureContents();
        return createdFigure;
    }

    public abstract void createFigureContents();

    protected void setStereoType(String stereoType) {
        Object o;
        List l = this.getChildren();
        if (l.size() > 0 && (o = l.get(0)) instanceof LVDiagFigure.StereoType) {
            this.remove((IFigure)((LVDiagFigure.StereoType)((Object)o)));
        }
        LVDiagFigure.StereoType streoType = new LVDiagFigure.StereoType(this, "<< " + stereoType + " >>");
        streoType.setFont(LVDiagFigure.BOLD);
        this.add((IFigure)streoType, 0);
    }

    public LM13DiagramElement2 getDiagElement() {
        return this.lmDiagElement_;
    }

    public Object getModel() {
        return ModelUtil.getModel(this.lmDiagElement_);
    }

    public void updateFigure() {
        this.updateFigure(false);
    }

    public void updateFigure(boolean contents) {
        LogUtil.writeln("LVClassDiagFigure.updateFigure() new location=" + ModelUtil.getLocation(this.lmDiagElement_));
        Point p = ((Viewport)this.getParent().getParent()).getViewLocation();
        this.setLocation(ModelUtil.getLocation(this.lmDiagElement_).translate(-p.x, -p.y));
        if (ModelUtil.getCurElement() == this.getDiagElement() || ModelUtil.getCurElement() == ModelUtil.getModel(this.getDiagElement())) {
            this.setBackgroundColor(LVConst.SelectedBackColor);
        } else {
            this.setBackgroundColor(LVConst.ClassBackColor);
        }
        if (contents) {
            this.createFigureContents();
            this.invalidate();
        }
        this.repaint();
    }

    public static AddingConnection getAddingConn() {
        return addingConn_;
    }

    protected static class CompartmentFigure
    extends Figure {
        public CompartmentFigure() {
            ToolbarLayout layout = new ToolbarLayout();
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(false);
            layout.setSpacing(1);
            this.setLayoutManager((LayoutManager)layout);
            this.setBorder((Border)new CompartmentFigureBorder());
        }

        public class CompartmentFigureBorder
        extends AbstractBorder {
            public Insets getInsets(IFigure figure) {
                return new Insets(1, 0, 1, 0);
            }

            public void paint(IFigure figure, Graphics graphics, Insets insets) {
                graphics.drawLine(AbstractBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getTopLeft(), AbstractBorder.tempRect.getTopRight());
            }
        }
    }

    static class AddingConnection
    extends PolylineConnection {
        static IFigure parent_ = null;
        private LVClassDiagFigure fromFig_ = null;
        private LVClassDiagFigure toFig_ = null;

        AddingConnection() {
            this.setForegroundColor(LVConst.ForeColor);
        }

        public void start(LVClassDiagFigure figure, Point p) {
            parent_ = figure.getParent();
            this.fromFig_ = figure;
            this.toFig_ = null;
            this.setStart(p);
            this.setEnd(p);
            parent_.add((IFigure)this, 0);
        }

        public void move(Point p) {
            if (this.fromFig_ != null) {
                this.setEnd(p);
            }
        }

        public void end() {
            if (this.fromFig_ != null) {
                parent_.remove((IFigure)this);
                if (this.toFig_ != null) {
                    AllAction.ADD_RELATION.execute(new Object[]{this.fromFig_.getDiagElement(), this.toFig_.getDiagElement()});
                }
                AllAction.SELECT_NONE.execute(null);
                this.fromFig_ = null;
                this.toFig_ = null;
            }
        }

        public boolean isToFigCandidate(LVClassDiagFigure toFig) {
            return this.fromFig_ != null && this.fromFig_ != toFig;
        }

        public void setToFig(LVClassDiagFigure figure) {
            this.toFig_ = figure;
        }
    }

    static class ClassDiagFigureMouseListener
    implements MouseListener {
        private LVClassDiagFigure figure_ = null;

        ClassDiagFigureMouseListener(LVClassDiagFigure figure) {
            this.figure_ = figure;
        }

        public void mousePressed(MouseEvent me) {
            LVClassDiag lvDiag = (LVClassDiag)this.figure_.getLvDiag();
            lvDiag.setPopupMenu(2);
            this.figure_.getParent().handleMousePressed(me);
            AllAction.SELECT_DEF.execute(this.figure_.getDiagElement());
            switch (lvDiag.getMode()) {
                case 1: {
                    lvDiag.getDraw2dView().remove((IFigure)this.figure_);
                    lvDiag.getDraw2dView().add((IFigure)this.figure_);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    addingConn_.start(this.figure_, me.getLocation());
                    break;
                }
                default: {
                    throw new InternalLogicException("mousePressed()\u8003\u616e\u6f0f\u308c");
                }
            }
        }

        public void mouseReleased(MouseEvent me) {
            LVClassDiag lvDiag = (LVClassDiag)this.figure_.getLvDiag();
            this.figure_.getParent().handleMouseReleased(me);
            addingConn_.end();
        }

        public void mouseDoubleClicked(MouseEvent me) {
            this.figure_.getParent().handleMouseDoubleClicked(me);
        }
    }

    static class ClassDiagFigureMouseMotionListener
    implements MouseMotionListener {
        private LVClassDiagFigure figure_ = null;

        ClassDiagFigureMouseMotionListener(LVClassDiagFigure figure) {
            this.figure_ = figure;
        }

        public void mouseDragged(MouseEvent me) {
            this.figure_.getParent().handleMouseDragged(me);
        }

        public void mouseMoved(MouseEvent me) {
            this.figure_.getParent().handleMouseMoved(me);
        }

        public void mouseEntered(MouseEvent me) {
            this.figure_.getParent().handleMouseEntered(me);
            if (addingConn_.isToFigCandidate(this.figure_)) {
                addingConn_.setToFig(this.figure_);
                AllAction.SELECT_DEF.execute(this.figure_.getDiagElement());
            }
        }

        public void mouseExited(MouseEvent me) {
            this.figure_.getParent().handleMouseExited(me);
            if (addingConn_.isToFigCandidate(this.figure_)) {
                addingConn_.setToFig(null);
                AllAction.SELECT_NONE.execute(this.figure_.getDiagElement());
            }
        }

        public void mouseHover(MouseEvent me) {
            this.figure_.getParent().handleMouseHover(me);
        }
    }
}

