/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import latte.LMChangedEvent;
import latte.Latte;
import latte.model.LM13Diagram;
import latte.model.LM13DiagramElement2;
import latte.util.ModelUtil;
import latte.view.LVClassDiagConnection;
import latte.view.LVConst;
import latte.view.LVDiagFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.SimpleLoweredBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class LVDiag {
    private LM13Diagram lmDiag_ = null;
    private CTabItem tabItem_ = null;
    private Canvas swtView_ = null;
    private Figure draw2dView_ = null;
    protected ArrayList diagElementList_ = new ArrayList();
    public static final int MODE_SELECTION = 1;
    public static final int MODE_ASSOCIATION = 2;
    public static final int MODE_GENELIZATION = 3;
    public static final int MODE_IMPLEMENTATION = 4;
    public static final int MODE_DEPENDENCY = 5;
    public static final int MODE_NOTELINK = 6;
    private static final int SIZE_X = 2048;
    private static final int SIZE_Y = 2048;
    private int mode_ = 1;
    private static final int PAGE_DELTA = 50;
    public static final String TYPE_CLASS_DIAG = "ClassDiagram";
    public static final String TYPE_SEQ_DIAG = "SequenceDiagram";
    public static final String TOOL_NAME = "Latte ver1";

    LVDiag(LM13Diagram lmDiag) {
        this.lmDiag_ = lmDiag;
        CTabFolder tabFolder = Latte.getMainForm().getDiagFolder().getTabFolder();
        this.tabItem_ = new CTabItem(tabFolder, 0);
        this.tabItem_.setText(lmDiag.getName());
        this.tabItem_.setImage(this.getTabImage());
        this.tabItem_.setControl(this.createTabItemControl((Composite)tabFolder));
    }

    private Control createTabItemControl(Composite tabFolder) {
        Composite tabItemControl = new Composite(tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tabItemControl.setLayout((Layout)layout);
        this.createDiagModeBar(tabItemControl);
        this.createDiagContentBase(tabItemControl);
        return tabItemControl;
    }

    private void createDiagContentBase(Composite parent) {
        this.draw2dView_ = new Figure();
        this.draw2dView_.setBackgroundColor(LVConst.diagColor_);
        this.draw2dView_.setOpaque(true);
        this.draw2dView_.setPreferredSize(new Dimension(2048, 2048));
        this.draw2dView_.setLayoutManager((LayoutManager)new XYLayout());
        final ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContents((IFigure)this.draw2dView_);
        scrollPane.setBorder((Border)new SimpleLoweredBorder());
        LightweightSystem lws = new LightweightSystem();
        lws.setContents((IFigure)scrollPane);
        this.swtView_ = new Canvas(parent, 768);
        this.swtView_.getVerticalBar().setVisible(false);
        this.swtView_.getHorizontalBar().setVisible(false);
        this.swtView_.setLayoutData((Object)new GridData(1808));
        this.swtView_.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                LVDiag.this.scrollVerticalDraw2dView(scrollPane, e.keyCode);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.swtView_.getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LVDiag.this.scrollVerticalDraw2dView(scrollPane, e.detail);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.swtView_.getHorizontalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LVDiag.this.scrollHorizontalDraw2dView(scrollPane, e.detail);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        lws.setControl(this.swtView_);
    }

    void scrollVerticalDraw2dView(ScrollPane scrollPane, int event) {
        switch (event) {
            case 0x1000001: 
            case 0x1000005: {
                int y = scrollPane.getViewport().getViewLocation().y - 50;
                scrollPane.scrollVerticalTo(y);
                break;
            }
            case 0x1000002: 
            case 0x1000006: {
                int y = scrollPane.getViewport().getViewLocation().y + 50;
                scrollPane.scrollVerticalTo(y);
            }
        }
    }

    void scrollHorizontalDraw2dView(ScrollPane scrollPane, int event) {
        switch (event) {
            case 0x1000001: 
            case 0x1000005: {
                int x = scrollPane.getViewport().getViewLocation().x - 50;
                scrollPane.scrollHorizontalTo(x);
                break;
            }
            case 0x1000002: 
            case 0x1000006: {
                int x = scrollPane.getViewport().getViewLocation().x + 50;
                scrollPane.scrollHorizontalTo(x);
            }
        }
    }

    abstract Image getTabImage();

    abstract void createDiagModeBar(Composite var1);

    abstract void updateDiag(LMChangedEvent var1);

    public void setTabText(String text) {
        this.tabItem_.setText(text);
    }

    public int getMode() {
        return this.mode_;
    }

    public void setMode(int mode) {
        this.mode_ = mode;
    }

    Composite getTabItemComposite() {
        return (Composite)this.tabItem_.getControl();
    }

    public LM13Diagram getLmDiag() {
        return this.lmDiag_;
    }

    public void setLmDiag(LM13Diagram lmDiag) {
        this.lmDiag_ = lmDiag;
    }

    public CTabItem getTabItem() {
        return this.tabItem_;
    }

    public void dispose() {
        this.tabItem_.dispose();
    }

    public Figure getDraw2dView() {
        return this.draw2dView_;
    }

    public Canvas getSwtView() {
        return this.swtView_;
    }

    public LVDiagFigure lookupFigure(String xmiid) {
        List figureList = this.getDiagFigureList();
        Object figureSubject = ModelUtil.getModel(xmiid);
        LVDiagFigure diagFigure = null;
        Iterator ite = figureList.iterator();
        while (ite.hasNext()) {
            diagFigure = (LVDiagFigure)((Object)ite.next());
            if (diagFigure.getModel() != figureSubject) continue;
            return diagFigure;
        }
        return null;
    }

    public List getDiagFigureList() {
        List l = this.getDraw2dView().getChildren();
        ArrayList l2 = new ArrayList();
        Iterator ite = l.iterator();
        while (ite.hasNext()) {
            Object o = ite.next();
            if (!(o instanceof LVDiagFigure)) continue;
            l2.add(o);
        }
        return l2;
    }

    public List getDiagConnectionList() {
        List l = this.getDraw2dView().getChildren();
        ArrayList l2 = new ArrayList();
        Iterator ite = l.iterator();
        while (ite.hasNext()) {
            Object o = ite.next();
            if (!(o instanceof LVClassDiagConnection)) continue;
            l2.add(o);
        }
        return l2;
    }

    public void addDiagElement(LM13DiagramElement2 e) {
        this.diagElementList_.add(e);
    }

    public List getDiagElementList() {
        return this.diagElementList_;
    }

    public void removeDiagElement(LM13DiagramElement2 e) {
        this.diagElementList_.remove(e);
    }

    LVDiagFigure getLvfigByDiagElement(LM13DiagramElement2 diagElement) {
        Iterator ite = this.getDiagFigureList().iterator();
        while (ite.hasNext()) {
            LVDiagFigure lvDiagFig = (LVDiagFigure)((Object)ite.next());
            if (diagElement != lvDiagFig.getDiagElement()) continue;
            return lvDiagFig;
        }
        return null;
    }

    public LVClassDiagConnection getLvconnByDiagElement(LM13DiagramElement2 diagElement) {
        Iterator ite = this.getDiagConnectionList().iterator();
        while (ite.hasNext()) {
            LVClassDiagConnection lvDiagConn = (LVClassDiagConnection)((Object)ite.next());
            if (diagElement != lvDiagConn.getDiagElement()) continue;
            return lvDiagConn;
        }
        return null;
    }

    LVDiagFigure getLvfigByModel(Object model) {
        Iterator ite = this.getDiagFigureList().iterator();
        while (ite.hasNext()) {
            LVDiagFigure lvDiagFig = (LVDiagFigure)((Object)ite.next());
            if (model != ModelUtil.getModel(lvDiagFig.getDiagElement())) continue;
            return lvDiagFig;
        }
        return null;
    }
}

