/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import latte.LMChangedEvent;
import latte.Latte;
import latte.LatteData;
import latte.action.AllAction;
import latte.model.ILM13ClassifierFeatureChoice;
import latte.model.ILM13NamespaceOwnedElementChoice;
import latte.model.ILM13XMIContentChoice;
import latte.model.LM13Attribute;
import latte.model.LM13Class;
import latte.model.LM13ClassifierFeature;
import latte.model.LM13Diagram;
import latte.model.LM13Interface;
import latte.model.LM13Model;
import latte.model.LM13NamespaceOwnedElement;
import latte.model.LM13Operation;
import latte.model.LM13Package;
import latte.util.GuiUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;
import latte.view.DragSourceEnabler;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class LVTree
extends Tree {
    private TreeItem curItem_ = null;
    private TreeItem lastItem_ = null;
    private long lastSelectTime_ = 0L;
    private TreeItem rootModel_ = null;
    private TreeItem rootDiag_ = null;
    TreeEditor treeEditor_ = new TreeEditor((Tree)this);
    private ItemEditor itemEditor_ = null;
    public static final String LATTE_DATA = "LATTE_DATA";

    LVTree(Composite parent) {
        super(parent, 0);
        new DragSourceEnabler(this);
        this.createTreePopupMenu();
        this.addSelectionListener(new LVTreeSelectionListener());
        this.addTreeListener(new LVTreeListener());
        this.addKeyListener(new LVKeyListener());
    }

    void createTreePopupMenu() {
        Menu menu = new Menu((Control)this);
        this.setMenu(menu);
        GuiUtil.createMenuItem(menu, AllAction.ADD_ATTRIBUTE);
        GuiUtil.createMenuItem(menu, AllAction.ADD_METHOD);
        GuiUtil.createMenuItem(menu, AllAction.ADD_CLASS);
        GuiUtil.createMenuItem(menu, AllAction.ADD_INTERFACE);
        GuiUtil.createMenuItem(menu, AllAction.ADD_PACKAGE);
        new MenuItem(menu, 2);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_CUT);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_COPY);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_PASTE);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_DELETE);
    }

    void updateTree(LMChangedEvent ldce) {
        switch (ldce.getChangedType()) {
            case 0: 
            case 1: {
                this.createNewTree();
                break;
            }
            case 11: {
                Object parentDef = ldce.getParent();
                Object newDef = ldce.getElement();
                TreeItem newTreeItem = null;
                if (newDef instanceof LM13Diagram) {
                    newTreeItem = this.createDiagram((LM13Diagram)newDef);
                } else if (newDef instanceof ILM13NamespaceOwnedElementChoice) {
                    TreeItem parentTreeItem = this.searchTreeItemByDef(this.getItems(), parentDef);
                    newTreeItem = this.addItem(parentTreeItem, (ILM13NamespaceOwnedElementChoice)newDef);
                }
                this.showItem(newTreeItem);
                this.editItem(newTreeItem);
                break;
            }
            case 12: {
                Object renameDef = ldce.getElement();
                String newName = ModelUtil.getName(renameDef);
                TreeItem treeItem = this.searchTreeItemByDef(this.getItems(), renameDef);
                treeItem.setText(newName);
                break;
            }
            case 13: {
                Object deleteDef = ldce.getElement();
                TreeItem deleteTreeItem = this.searchTreeItemByDef(this.getItems(), deleteDef);
                deleteTreeItem.dispose();
                break;
            }
            case 14: {
                Object selectDef = ldce.getElement();
                TreeItem selectTreeItem = this.searchTreeItemByDef(this.getItems(), selectDef);
                this.showItem(selectTreeItem);
                this.setSelection(new TreeItem[]{selectTreeItem});
            }
        }
    }

    private TreeItem searchTreeItemByDef(TreeItem[] treeItems, Object def) {
        int i = 0;
        while (i < treeItems.length) {
            if (treeItems[i].getData(LATTE_DATA) == def) {
                return treeItems[i];
            }
            TreeItem treeItem = this.searchTreeItemByDef(treeItems[i].getItems(), def);
            if (treeItem != null) {
                return treeItem;
            }
            ++i;
        }
        return null;
    }

    private void createNewTree() {
        this.removeAll();
        LatteData latteData = Latte.getLatteData();
        if (latteData.getXMI().getXMIContent() == null) {
            throw new RuntimeException("\u30b3\u30f3\u30c6\u30f3\u30c4\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.rootModel_ = new TreeItem((Tree)this, 0);
        this.rootDiag_ = new TreeItem((Tree)this, 0);
        this.rootDiag_.setText("\u30c0\u30a4\u30a2\u30b0\u30e9\u30e0");
        this.rootDiag_.setImage(AllAction.ADD_PACKAGE.getImage());
        ILM13XMIContentChoice[] content = latteData.getXMI().getXMIContent().getContent();
        int i = 0;
        while (i < content.length) {
            if (content[i] instanceof LM13Model) {
                LM13Model model = (LM13Model)content[i];
                this.rootModel_.setText(model.getName());
                this.rootModel_.setData(LATTE_DATA, (Object)model);
                this.rootModel_.setImage(AllAction.ADD_PACKAGE.getImage());
                LM13NamespaceOwnedElement ownedElement = ModelUtil.getOwnedElement(model);
                this.createTreeRecursivly(this.rootModel_, ownedElement);
            }
            ++i;
        }
        i = 0;
        while (i < content.length) {
            LM13Diagram diag;
            if (content[i] instanceof LM13Diagram && (diag = (LM13Diagram)content[i]).getDiagramType().equals("ClassDiagram")) {
                this.createDiagram(diag);
            }
            ++i;
        }
        int offset = this.rootDiag_.getItemCount();
        int i2 = 0;
        while (i2 < content.length) {
            LM13Diagram diag;
            if (content[i2] instanceof LM13Diagram && (diag = (LM13Diagram)content[i2]).getDiagramType().equals("SequenceDiagram")) {
                this.createDiagram(diag);
            }
            ++i2;
        }
        this.lastItem_ = this.rootModel_;
        this.curItem_ = this.rootModel_;
        Latte.getMainForm().getTree().setSelection(new TreeItem[]{this.rootModel_});
    }

    private TreeItem createDiagram(LM13Diagram lmDiag) {
        int index = this.getInsertIndex(this.rootDiag_, lmDiag);
        TreeItem treeItem = new TreeItem(this.rootDiag_, 0, index);
        treeItem.setText(lmDiag.getName());
        treeItem.setData(LATTE_DATA, (Object)lmDiag);
        if (lmDiag.getDiagramType().equals("ClassDiagram")) {
            treeItem.setImage(AllAction.ADD_CLASS_DIAGRAM.getImage());
        } else if (lmDiag.getDiagramType().equals("SequenceDiagram")) {
            treeItem.setImage(AllAction.ADD_SEQUENCE_DIAGRAM.getImage());
        }
        return treeItem;
    }

    private int getInsertIndex(TreeItem parentTreeItem, Object newModel) {
        int i;
        block23: {
            Object model;
            TreeItem[] items;
            block26: {
                block25: {
                    block24: {
                        block22: {
                            i = 0;
                            items = parentTreeItem.getItems();
                            if (newModel instanceof LM13Diagram) {
                                LM13Diagram diags;
                                LM13Diagram newDiag = (LM13Diagram)newModel;
                                if (newDiag.getDiagramType().equals("ClassDiagram")) {
                                    i = 0;
                                    while (i < items.length) {
                                        diags = (LM13Diagram)items[i].getData(LATTE_DATA);
                                        if (!diags.getDiagramType().equals("ClassDiagram")) {
                                            return i;
                                        }
                                        if (diags.getName().compareTo(newDiag.getName()) > 0) {
                                            return i;
                                        }
                                        ++i;
                                    }
                                }
                                if (newDiag.getDiagramType().equals("SequenceDiagram")) {
                                    i = 0;
                                    while (i < items.length) {
                                        diags = (LM13Diagram)items[i].getData(LATTE_DATA);
                                        if (!diags.getDiagramType().equals("ClassDiagram") && diags.getName().compareTo(newDiag.getName()) > 0) {
                                            return i;
                                        }
                                        ++i;
                                    }
                                }
                            }
                            if (!(newModel instanceof LM13Package)) break block22;
                            LM13Package newPkg = (LM13Package)newModel;
                            i = 0;
                            while (i < items.length) {
                                model = items[i].getData(LATTE_DATA);
                                if (model instanceof LM13Class || model instanceof LM13Interface) {
                                    return i;
                                }
                                LM13Package pkg = (LM13Package)model;
                                if (pkg.getName().compareTo(newPkg.getName()) > 0) {
                                    return i;
                                }
                                ++i;
                            }
                            break block23;
                        }
                        if (!(newModel instanceof LM13Interface)) break block24;
                        LM13Interface newIf = (LM13Interface)newModel;
                        i = 0;
                        while (i < items.length) {
                            model = items[i].getData(LATTE_DATA);
                            if (!(model instanceof LM13Package)) {
                                if (model instanceof LM13Class) {
                                    return i;
                                }
                                LM13Interface interf = (LM13Interface)model;
                                if (interf.getName().compareTo(newIf.getName()) > 0) {
                                    return i;
                                }
                            }
                            ++i;
                        }
                        break block23;
                    }
                    if (!(newModel instanceof LM13Class)) break block25;
                    LM13Class newClass = (LM13Class)newModel;
                    i = 0;
                    while (i < items.length) {
                        LM13Class c;
                        model = items[i].getData(LATTE_DATA);
                        if (!(model instanceof LM13Package) && !(model instanceof LM13Interface) && (c = (LM13Class)model).getName().compareTo(newClass.getName()) > 0) {
                            return i;
                        }
                        ++i;
                    }
                    break block23;
                }
                if (!(newModel instanceof LM13Attribute)) break block26;
                LM13Attribute newAttr = (LM13Attribute)newModel;
                i = 0;
                while (i < items.length) {
                    model = items[i].getData(LATTE_DATA);
                    if (model instanceof LM13Operation) {
                        return i;
                    }
                    LM13Attribute attr = (LM13Attribute)model;
                    if (attr.getName().compareTo(newAttr.getName()) > 0) {
                        return i;
                    }
                    ++i;
                }
                break block23;
            }
            if (!(newModel instanceof LM13Operation)) break block23;
            LM13Operation newMethod = (LM13Operation)newModel;
            i = 0;
            while (i < items.length) {
                LM13Operation method;
                model = items[i].getData(LATTE_DATA);
                if (!(model instanceof LM13Attribute) && (method = (LM13Operation)model).getName().compareTo(newMethod.getName()) > 0) {
                    return i;
                }
                ++i;
            }
        }
        return i;
    }

    private void createTreeRecursivly(TreeItem parent, LM13NamespaceOwnedElement element) {
        ILM13NamespaceOwnedElementChoice[] contents = element.getContent();
        int i = 0;
        while (i < contents.length) {
            int j;
            ILM13ClassifierFeatureChoice[] classifierContents;
            LM13ClassifierFeature classifier;
            TreeItem newItem;
            if (contents[i] instanceof LM13Class) {
                LM13Class c = (LM13Class)contents[i];
                newItem = this.addItem(parent, c);
                classifier = ModelUtil.getClassifierFeature(c);
                if (classifier != null) {
                    classifierContents = classifier.getContent();
                    j = 0;
                    while (j < classifierContents.length) {
                        if (classifierContents[j] instanceof LM13Attribute || classifierContents[j] instanceof LM13Operation) {
                            this.addItem(newItem, (ILM13NamespaceOwnedElementChoice)((Object)classifierContents[j]));
                        }
                        ++j;
                    }
                }
            } else if (contents[i] instanceof LM13Interface) {
                LM13Interface intf = (LM13Interface)contents[i];
                newItem = this.addItem(parent, intf);
                classifier = ModelUtil.getClassifierFeature(intf);
                if (classifier != null) {
                    classifierContents = classifier.getContent();
                    j = 0;
                    while (j < classifierContents.length) {
                        if (classifierContents[j] instanceof LM13Operation) {
                            this.addItem(newItem, (ILM13NamespaceOwnedElementChoice)((Object)classifierContents[j]));
                        }
                        ++j;
                    }
                }
            } else if (contents[i] instanceof LM13Package) {
                LM13Package p = (LM13Package)contents[i];
                newItem = this.addItem(parent, p);
                LM13NamespaceOwnedElement ownedElement = ModelUtil.getOwnedElement(p);
                if (ownedElement != null) {
                    this.createTreeRecursivly(newItem, ownedElement);
                }
            }
            ++i;
        }
    }

    public TreeItem addItem(TreeItem parentTreeItem, ILM13NamespaceOwnedElementChoice elementChoice) {
        int index = this.getInsertIndex(parentTreeItem, elementChoice);
        TreeItem item = new TreeItem(parentTreeItem, 0, index);
        item.setText(elementChoice.getName());
        item.setData(LATTE_DATA, (Object)elementChoice);
        if (elementChoice instanceof LM13Operation) {
            item.setImage(AllAction.ADD_METHOD.getImage());
        } else if (elementChoice instanceof LM13Attribute) {
            item.setImage(AllAction.ADD_ATTRIBUTE.getImage());
        } else if (elementChoice instanceof LM13Class) {
            item.setImage(AllAction.ADD_CLASS.getImage());
        } else if (elementChoice instanceof LM13Interface) {
            item.setImage(AllAction.ADD_INTERFACE.getImage());
        } else if (elementChoice instanceof LM13Package) {
            item.setImage(AllAction.ADD_PACKAGE.getImage());
        }
        return item;
    }

    public void deselectAll() {
        super.deselectAll();
        this.lastItem_ = null;
    }

    public ItemEditor getItemEditor() {
        return this.itemEditor_;
    }

    public TreeItem getCurItem() {
        return this.curItem_;
    }

    private void editItem(TreeItem item) {
        Control c = this.treeEditor_.getEditor();
        if (c != null) {
            c.dispose();
        }
        this.treeEditor_.horizontalAlignment = 16384;
        this.treeEditor_.grabHorizontal = true;
        this.treeEditor_.minimumWidth = 50;
        this.itemEditor_ = new ItemEditor(this, this.treeEditor_, item);
        this.treeEditor_.setEditor((Control)this.itemEditor_, item);
        this.itemEditor_.setFocus();
    }

    public TreeItem getRootModel() {
        return this.rootModel_;
    }

    class ItemEditor
    extends Composite {
        LVTree latteTree_;
        TreeItem treeItem_;
        Text text_;

        ItemEditor(LVTree latteTree, TreeEditor treeEditor, TreeItem treeItem) {
            super((Composite)latteTree, 0);
            this.latteTree_ = null;
            this.treeItem_ = null;
            this.text_ = new Text((Composite)this, 0);
            this.latteTree_ = latteTree;
            LVTree.this.treeEditor_ = treeEditor;
            this.treeItem_ = treeItem;
            this.text_.setText(this.treeItem_.getText());
            this.text_.selectAll();
            this.text_.addFocusListener(new FocusListener(this){
                final /* synthetic */ ItemEditor this$1;
                {
                    this.this$1 = itemEditor;
                }

                public void focusLost(FocusEvent e) {
                    ItemEditor.access$0(this.this$1);
                }

                public void focusGained(FocusEvent e) {
                }
            });
            this.text_.addTraverseListener(new TraverseListener(this){
                final /* synthetic */ ItemEditor this$1;
                {
                    this.this$1 = itemEditor;
                }

                public void keyTraversed(TraverseEvent te) {
                    switch (te.detail) {
                        case 2: {
                            this.this$1.roolback();
                            te.doit = false;
                            break;
                        }
                        case 4: {
                            ItemEditor.access$0(this.this$1);
                            te.doit = true;
                        }
                    }
                }
            });
            this.addListener(11, new Listener(this){
                final /* synthetic */ ItemEditor this$1;
                {
                    this.this$1 = itemEditor;
                }

                public void handleEvent(Event e) {
                    Rectangle rect = this.this$1.getClientArea();
                    this.this$1.text_.setBounds(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
                }
            });
            this.treeItem_.addDisposeListener(new DisposeListener(this){
                final /* synthetic */ ItemEditor this$1;
                {
                    this.this$1 = itemEditor;
                }

                public void widgetDisposed(DisposeEvent e) {
                    this.this$1.roolback();
                }
            });
        }

        private void commit() {
            String newName = this.text_.getText();
            Object o = this.treeItem_.getData(LVTree.LATTE_DATA);
            this.closeItemEditor();
            AllAction.EDIT_RENAME.execute(new Object[]{o, newName});
        }

        public void roolback() {
            this.closeItemEditor();
        }

        private void closeItemEditor() {
            this.dispose();
            LVTree.this.treeEditor_.setEditor(null);
        }

        static /* synthetic */ void access$0(ItemEditor itemEditor) {
            itemEditor.commit();
        }
    }

    class LVTreeSelectionListener
    implements SelectionListener {
        LVTreeSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            long curTime = System.currentTimeMillis();
            AllAction.SELECT_NONE.execute(null);
            LVTree.this.curItem_ = (TreeItem)e.item;
            Object o = LVTree.this.curItem_.getData(LVTree.LATTE_DATA);
            AllAction.SELECT_DEF.execute(o);
            if (LVTree.this.lastItem_ == LVTree.this.curItem_ && curTime - LVTree.this.lastSelectTime_ < 1500L) {
                LVTree.this.editItem(LVTree.this.curItem_);
            }
            LVTree.this.lastItem_ = LVTree.this.curItem_;
            LVTree.this.lastSelectTime_ = System.currentTimeMillis();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            try {
                LVTree.this.curItem_ = (TreeItem)e.item;
                Object o = LVTree.this.curItem_.getData(LVTree.LATTE_DATA);
                AllAction.SELECT_DEF.execute(o);
                if (o instanceof LM13Diagram) {
                    Latte.getMainForm().getDiagFolder().showDiag((LM13Diagram)o);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                MsgUtil.showMsg("\u30a8\u30e9\u30fc\u767a\u751f\uff1a" + ex.getMessage());
            }
        }
    }

    class LVKeyListener
    implements KeyListener {
        LVKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x100000B && LVTree.this.curItem_ != null) {
                LVTree.this.editItem(LVTree.this.curItem_);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    class LVTreeListener
    implements TreeListener {
        LVTreeListener() {
        }

        public void treeCollapsed(TreeEvent e) {
        }

        public void treeExpanded(TreeEvent e) {
        }
    }
}

