/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Iterator;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.ButtonBorder;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.ClickableEventHandler;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToggleModel;
import org.eclipse.draw2d.geometry.Rectangle;

public class Clickable
extends Figure {
    private static final int ROLLOVER_ENABLED_FLAG = Figure.MAX_FLAG << 1;
    private static final int STYLE_BUTTON_FLAG = Figure.MAX_FLAG << 2;
    private static final int STYLE_TOGGLE_FLAG;
    private static final int MAX_FLAG;
    public static final int STYLE_BUTTON;
    public static final int STYLE_TOGGLE;
    public static final int DEFAULT_FIRING = 0;
    public static final int REPEAT_FIRING = 1;
    private ClickableEventHandler eventHandler;
    private ButtonModel model;
    private ModelObserver modelObserver;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        MAX_FLAG = STYLE_TOGGLE_FLAG = Figure.MAX_FLAG << 3;
        STYLE_BUTTON = STYLE_BUTTON_FLAG;
        STYLE_TOGGLE = STYLE_TOGGLE_FLAG;
    }

    public Clickable() {
        this.init();
        this.setRequestFocusEnabled(true);
        this.setFocusTraversable(true);
    }

    public Clickable(IFigure contents) {
        this(contents, 0);
    }

    public Clickable(IFigure contents, int style) {
        this.init();
        this.setRequestFocusEnabled(true);
        this.setFocusTraversable(true);
        this.setContents(contents);
        this.setStyle(style);
    }

    public void addActionListener(ActionListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addListener(clazz, listener);
    }

    public void addChangeListener(ChangeListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.draw2d.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addListener(clazz, listener);
    }

    protected ButtonModel createDefaultModel() {
        if (this.isStyle(STYLE_TOGGLE)) {
            return new ToggleModel();
        }
        return new ButtonModel();
    }

    protected ClickableEventHandler createEventHandler() {
        return new ClickableEventHandler();
    }

    protected ModelObserver createModelObserver() {
        return new ModelObserver(){

            public void actionPerformed(ActionEvent action) {
                Clickable.this.fireActionPerformed();
            }

            public void handleStateChanged(ChangeEvent change) {
                Clickable.this.fireStateChanged(change);
            }
        };
    }

    public void doClick() {
        this.fireActionPerformed();
    }

    protected void fireActionPerformed() {
        ActionEvent action = new ActionEvent(this);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator listeners = this.getListeners(clazz);
        while (listeners.hasNext()) {
            ((ActionListener)listeners.next()).actionPerformed(action);
        }
    }

    protected void fireStateChanged(ChangeEvent modelChange) {
        ChangeEvent change = new ChangeEvent(this, modelChange.getPropertyName());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.draw2d.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator listeners = this.getListeners(clazz);
        while (listeners.hasNext()) {
            ((ChangeListener)listeners.next()).handleStateChanged(change);
        }
    }

    public ButtonModel getModel() {
        return this.model;
    }

    protected void hookEventHandler(ClickableEventHandler handler) {
        if (handler == null) {
            return;
        }
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        this.addChangeListener(handler);
        this.addKeyListener(handler);
        this.addFocusListener(handler);
    }

    protected void init() {
        this.setModel(this.createDefaultModel());
        this.setEventHandler(this.createEventHandler());
    }

    public boolean isRolloverEnabled() {
        return (this.flags & ROLLOVER_ENABLED_FLAG) != 0;
    }

    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    public boolean isStyle(int style) {
        return (style & this.flags) == style;
    }

    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        if (this.hasFocus()) {
            graphics.setForegroundColor(ColorConstants.black);
            graphics.setBackgroundColor(ColorConstants.white);
            Rectangle area = this.getClientArea();
            if (this.isStyle(STYLE_BUTTON)) {
                graphics.drawFocus(area.x, area.y, area.width, area.height);
            } else {
                graphics.drawFocus(area.x, area.y, area.width - 1, area.height - 1);
            }
        }
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.isStyle(STYLE_BUTTON) && (this.getModel().isArmed() || this.getModel().isSelected())) {
            graphics.translate(1, 1);
            graphics.pushState();
            super.paintClientArea(graphics);
            graphics.popState();
            graphics.translate(-1, -1);
        } else {
            super.paintClientArea(graphics);
        }
    }

    public void removeActionListener(ActionListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.removeListener(clazz, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.draw2d.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.removeListener(clazz, listener);
    }

    protected void setContents(IFigure contents) {
        this.setLayoutManager(new StackLayout());
        if (this.getChildren().size() > 0) {
            this.remove((IFigure)this.getChildren().get(0));
        }
        this.add(contents);
    }

    public void setEnabled(boolean value) {
        if (this.isEnabled() == value) {
            return;
        }
        super.setEnabled(value);
        this.getModel().setEnabled(value);
        this.setChildrenEnabled(value);
    }

    public void setEventHandler(ClickableEventHandler h) {
        if (this.eventHandler != null) {
            this.unhookEventHandler(this.eventHandler);
        }
        this.eventHandler = h;
        if (this.eventHandler != null) {
            this.hookEventHandler(this.eventHandler);
        }
    }

    public void setFiringMethod(int type) {
        this.getModel().setFiringBehavior(type);
    }

    public void setModel(ButtonModel model) {
        if (this.model != null) {
            this.model.removeChangeListener(this.modelObserver);
            this.model.removeActionListener(this.modelObserver);
            this.modelObserver = null;
        }
        this.model = model;
        if (model != null) {
            this.modelObserver = this.createModelObserver();
            model.addActionListener(this.modelObserver);
            model.addChangeListener(this.modelObserver);
        }
    }

    public void setRolloverEnabled(boolean value) {
        if (this.isRolloverEnabled() == value) {
            return;
        }
        this.setFlag(ROLLOVER_ENABLED_FLAG, value);
        this.repaint();
    }

    public void setSelected(boolean value) {
        this.getModel().setSelected(value);
    }

    public void setStyle(int style) {
        if ((style & STYLE_BUTTON) != 0) {
            this.setFlag(STYLE_BUTTON_FLAG, true);
            if (!(this.getBorder() instanceof ButtonBorder)) {
                this.setBorder(new ButtonBorder());
            }
            this.setOpaque(true);
        } else {
            this.setFlag(STYLE_BUTTON_FLAG, false);
            this.setOpaque(false);
        }
        if ((style & STYLE_TOGGLE) != 0) {
            this.setFlag(STYLE_TOGGLE_FLAG, true);
            this.setModel(this.createDefaultModel());
        }
    }

    protected void unhookEventHandler(ClickableEventHandler handler) {
        if (handler == null) {
            return;
        }
        this.removeMouseListener(handler);
        this.removeMouseMotionListener(handler);
        this.removeChangeListener(handler);
    }

    static interface ModelObserver
    extends ActionListener,
    ChangeListener {
    }
}

