/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.DefaultRangeModel;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ViewportLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class Viewport
extends Figure
implements PropertyChangeListener {
    public static final String PROPERTY_VIEW_LOCATION = "viewLocation";
    private IFigure view;
    private boolean useTranslate = false;
    private boolean trackWidth = false;
    private boolean trackHeight = false;
    private boolean ignoreScroll = false;
    private RangeModel horiztonalRangeModel = null;
    private RangeModel verticalRangeModel = null;

    public Viewport() {
        this.setLayoutManager(new ViewportLayout());
        this.setHorizontalRangeModel(new DefaultRangeModel());
        this.setVerticalRangeModel(new DefaultRangeModel());
    }

    public Viewport(boolean setting) {
        this.setLayoutManager(new ViewportLayout());
        this.setHorizontalRangeModel(new DefaultRangeModel());
        this.setVerticalRangeModel(new DefaultRangeModel());
        this.useTranslate = setting;
    }

    public Rectangle getClientArea(Rectangle rect) {
        super.getClientArea(rect);
        if (this.useGraphicsTranslate()) {
            rect.translate(this.getViewLocation());
        }
        return rect;
    }

    public IFigure getContents() {
        return this.view;
    }

    public RangeModel getHorizontalRangeModel() {
        return this.horiztonalRangeModel;
    }

    public boolean getContentsTracksHeight() {
        return this.trackHeight;
    }

    public boolean getContentsTracksWidth() {
        return this.trackWidth;
    }

    public RangeModel getVerticalRangeModel() {
        return this.verticalRangeModel;
    }

    public Point getViewLocation() {
        return new Point(this.getHorizontalRangeModel().getValue(), this.getVerticalRangeModel().getValue());
    }

    private void localRevalidate() {
        this.invalidate();
        if (this.getLayoutManager() != null) {
            this.getLayoutManager().invalidate();
        }
        this.getUpdateManager().addInvalidFigure(this);
    }

    protected void paintClientArea(Graphics g) {
        if (this.useGraphicsTranslate()) {
            Point p = this.getViewLocation();
            try {
                g.translate(-p.x, -p.y);
                g.pushState();
                super.paintClientArea(g);
                g.popState();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                g.translate(p.x, p.y);
                throw throwable;
            }
            Object var3_5 = null;
            g.translate(p.x, p.y);
        } else {
            super.paintClientArea(g);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof RangeModel && "value".equals(event.getPropertyName())) {
            if (!this.ignoreScroll) {
                this.localRevalidate();
                if (this.useGraphicsTranslate()) {
                    this.repaint();
                    this.fireMoved();
                }
            }
            this.firePropertyChange(PROPERTY_VIEW_LOCATION, event.getOldValue(), event.getNewValue());
        }
    }

    protected void readjustScrollBars() {
        if (this.getContents() == null) {
            return;
        }
        this.getVerticalRangeModel().setAll(0, this.getClientArea().height, this.getContents().getBounds().height);
        this.getHorizontalRangeModel().setAll(0, this.getClientArea().width, this.getContents().getBounds().width);
    }

    public void setContents(IFigure figure) {
        if (this.view != null) {
            this.remove(this.view);
        }
        this.view = figure;
        this.add(figure);
    }

    public void setContentsTracksHeight(boolean track) {
        this.trackHeight = track;
    }

    public void setContentsTracksWidth(boolean track) {
        this.trackWidth = track;
    }

    public void setHorizontalLocation(int value) {
        this.setViewLocation(value, this.getVerticalRangeModel().getValue());
    }

    public void setHorizontalRangeModel(RangeModel rangeModel) {
        if (this.horiztonalRangeModel != null) {
            this.horiztonalRangeModel.removePropertyChangeListener(this);
        }
        this.horiztonalRangeModel = rangeModel;
        this.horiztonalRangeModel.addPropertyChangeListener(this);
    }

    public void setIgnoreScroll(boolean value) {
        this.ignoreScroll = value;
    }

    public void setVerticalLocation(int value) {
        this.setViewLocation(this.getHorizontalRangeModel().getValue(), value);
    }

    public void setVerticalRangeModel(RangeModel rangeModel) {
        if (this.verticalRangeModel != null) {
            this.verticalRangeModel.removePropertyChangeListener(this);
        }
        this.verticalRangeModel = rangeModel;
        this.verticalRangeModel.addPropertyChangeListener(this);
    }

    public void setViewLocation(int x, int y) {
        if (this.getHorizontalRangeModel().getValue() != x) {
            this.getHorizontalRangeModel().setValue(x);
        }
        if (this.getVerticalRangeModel().getValue() != y) {
            this.getVerticalRangeModel().setValue(y);
        }
    }

    public void setViewLocation(Point p) {
        this.setViewLocation(p.x, p.y);
    }

    public void translateFromParent(Translatable t) {
        if (this.useTranslate) {
            t.performTranslate(this.getHorizontalRangeModel().getValue(), this.getVerticalRangeModel().getValue());
        }
        super.translateFromParent(t);
    }

    public void translateToParent(Translatable t) {
        if (this.useTranslate) {
            t.performTranslate(-this.getHorizontalRangeModel().getValue(), -this.getVerticalRangeModel().getValue());
        }
        super.translateToParent(t);
    }

    public boolean useGraphicsTranslate() {
        return this.useTranslate;
    }

    public void validate() {
        super.validate();
        this.readjustScrollBars();
    }
}

