/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.io.Serializable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class Point
implements Cloneable,
Serializable,
Translatable {
    static final long serialVersionUID = 1L;
    public static final Point SINGLETON = new Point();
    public int x;
    public int y;

    public Point() {
    }

    public Point(Point copy) {
        this.x = copy.x;
        this.y = copy.y;
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(double x, double y) {
        this.x = (int)x;
        this.y = (int)y;
    }

    public boolean equals(Object o) {
        if (o instanceof Point) {
            Point p = (Point)o;
            return p.x == this.x && p.y == this.y;
        }
        return false;
    }

    public Point getCopy() {
        return new Point(this.x, this.y);
    }

    public Dimension getDifference(Point pt) {
        return new Dimension(this.x - pt.x, this.y - pt.y);
    }

    public double getDistance(Point pt) {
        return Math.sqrt(this.getDistance2(pt));
    }

    public int getDistance2(Point pt) {
        int i = pt.x - this.x;
        int j = pt.y - this.y;
        return i * i + j * j;
    }

    public int getDistanceOrthogonal(Point pt) {
        return Math.abs(this.y - pt.y) + Math.abs(this.x - pt.x);
    }

    public Point getNegated() {
        return this.getCopy().negate();
    }

    public int getPosition(Point p) {
        int dx = p.x - this.x;
        int dy = p.y - this.y;
        if (Math.abs(dx) > Math.abs(dy)) {
            if (dx < 0) {
                return 8;
            }
            return 16;
        }
        if (dy < 0) {
            return 1;
        }
        return 4;
    }

    public Point getScaled(double amount) {
        return this.getCopy().scale(amount);
    }

    public org.eclipse.swt.graphics.Point getSWTPoint() {
        return new org.eclipse.swt.graphics.Point(this.x, this.y);
    }

    public Point getTranslated(Dimension delta) {
        return this.getCopy().translate(delta);
    }

    public Point getTranslated(int x, int y) {
        return this.getCopy().translate(x, y);
    }

    public Point getTranslated(Point pt) {
        return this.getCopy().translate(pt);
    }

    public Point getTransposed() {
        return this.getCopy().transpose();
    }

    public static Point max(Point p1, Point p2) {
        return new Rectangle(p1, p2).getBottomRight().translate(-1, -1);
    }

    public static Point min(Point p1, Point p2) {
        return new Rectangle(p1, p2).getTopLeft();
    }

    public Point negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public void performScale(double factor) {
        this.scale(factor);
    }

    public void performTranslate(int dx, int dy) {
        this.translate(dx, dy);
    }

    public Point scale(double amount) {
        this.x = (int)Math.floor((double)this.x * amount);
        this.y = (int)Math.floor((double)this.y * amount);
        return this;
    }

    public Point scale(double xAmount, double yAmount) {
        this.x = (int)Math.floor((double)this.x * xAmount);
        this.y = (int)Math.floor((double)this.y * yAmount);
        return this;
    }

    public Point setLocation(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Point setLocation(Point pt) {
        this.x = pt.x;
        this.y = pt.y;
        return this;
    }

    public String toString() {
        return "Point(" + this.x + ", " + this.y + ")";
    }

    public Point translate(Point p) {
        return this.translate(p.x, p.y);
    }

    public Point translate(Dimension d) {
        return this.translate(d.width, d.height);
    }

    public Point translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public Point transpose() {
        int temp = this.x;
        this.x = this.y;
        this.y = temp;
        return this;
    }
}

