/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.internal.ImageInfo;
import org.eclipse.swt.graphics.Image;

public class ImageCache {
    private static List checkedOut = new ArrayList();
    private static List checkedIn = new ArrayList();
    private static int totalNumberOfImagesCreated = 0;
    private static int numberOfImagesDisposed = 0;

    public static boolean checkin(Image img) {
        if (img == null) {
            return false;
        }
        int i = 0;
        while (i < checkedOut.size()) {
            ImageInfo info = (ImageInfo)checkedOut.get(i);
            if (info.checkin(img)) {
                checkedOut.remove(info);
                checkedIn.add(0, info);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Image checkout(Dimension d, Object o) {
        d = d.getCopy();
        int powerOf2 = 128;
        while (powerOf2 < d.height) {
            powerOf2 *= 2;
        }
        d.height = powerOf2;
        powerOf2 = 128;
        while (powerOf2 < d.width) {
            powerOf2 *= 2;
        }
        d.width = powerOf2;
        Image result = null;
        int i = 0;
        while (i < checkedIn.size()) {
            ImageInfo info = (ImageInfo)checkedIn.get(i);
            if (result == null && (result = info.checkout(d, o)) != null) {
                checkedIn.remove(info);
                checkedOut.add(info);
                --i;
            } else if (info.getStatistic() == 0) {
                checkedIn.remove(info);
                info.dispose();
                ++numberOfImagesDisposed;
                --i;
            }
            ++i;
        }
        if (result != null) {
            return result;
        }
        try {
            ImageInfo newInfo = new ImageInfo(d);
            checkedOut.add(newInfo);
            ++totalNumberOfImagesCreated;
            return newInfo.checkout(d, o);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

