/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal;

import java.util.Date;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageInfo {
    public static final int BAD_STATISTIC = 0;
    public static final int GOOD_STATISTIC = 1;
    private static final double STAT_THRESHOLD = 0.46;
    private Image img;
    private boolean checkedIn = true;
    private int timesCheckedOut = 0;
    private double stat3;
    private long checkinTime = System.currentTimeMillis();
    private Dimension iSize;
    private Object source;

    public ImageInfo(Dimension d) {
        this(d.width, d.height);
    }

    public ImageInfo(int width, int height) {
        this.img = new Image((Device)Display.getDefault(), width, height);
        this.iSize = new Dimension(width, height);
        this.stat3 = (double)(this.iSize.width * this.iSize.height) * 15.0 / 1310720.0;
        this.stat3 = 15.0 - this.stat3;
        this.stat3 = this.stat3 < 0.0 ? 0.0 : this.stat3;
    }

    private double calculateStatistic() {
        double stat1 = this.timesCheckedOut * 3;
        stat1 = stat1 > 45.0 ? 45.0 : stat1;
        double stat2 = (double)this.timeSinceLastUse() / 6.0;
        stat2 = 40.0 - stat2;
        stat2 = stat2 < 0.0 ? 0.0 : stat2;
        return (stat1 + stat2 + this.stat3) / 100.0;
    }

    public boolean checkin(Image i) {
        if (i != this.img) {
            return false;
        }
        this.checkinTime = System.currentTimeMillis();
        this.checkedIn = true;
        this.source = null;
        return true;
    }

    public Image checkout(Dimension d, Object holder) {
        if (!this.checkedIn || !this.fits(d)) {
            return null;
        }
        ++this.timesCheckedOut;
        this.checkedIn = false;
        this.source = holder;
        return this.img;
    }

    public void dispose() {
        this.img.dispose();
    }

    public boolean fits(Dimension d) {
        if (this.iSize.equals(d)) {
            return true;
        }
        return this.iSize.contains(d) && this.iSize.getArea() < d.getArea() * 2;
    }

    public int getStatistic() {
        if (!this.checkedIn) {
            return 1;
        }
        return this.calculateStatistic() < 0.46 ? 0 : 1;
    }

    public boolean isCheckedIn() {
        return this.checkedIn;
    }

    public boolean merge(ImageInfo info) {
        if (this.isCheckedIn() && info.isCheckedIn() && info.iSize.equals(this.iSize) && info != this) {
            this.timesCheckedOut += info.timesCheckedOut;
            this.source = info.source;
            this.checkinTime = this.checkinTime < info.checkinTime ? info.checkinTime : this.checkinTime;
            info.dispose();
            return true;
        }
        return false;
    }

    public long timeSinceLastUse() {
        if (!this.checkedIn) {
            return 0L;
        }
        return (new Date().getTime() - this.checkinTime) / 1000L;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "\n\tImage Checked In: " + this.checkedIn + "\n\tImage Bounds: " + this.img.getBounds() + "\n\tNumber of times checked out: " + this.timesCheckedOut + "\n\tTime since last use: " + this.timeSinceLastUse() + " seconds\n\tStatistic: " + this.calculateStatistic() + "\n\tChecked out by: " + this.source;
    }
}

