/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.browser;

import com.lavans.util.BaseClass;
import com.lavans.util.Config;
import com.lavans.util.browser.Browser;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BrowserChecker
extends BaseClass {
    public static final String DESKTOP = "desktop";
    public static final String PHONE = "phone";
    public static final String PDA = "pda";
    public static final String DOCOMO_PDC = "docomo_pdc";
    public static final String DOCOMO_FOMA = "docomo_foma";
    public static final String EZWEB = "ezweb";
    public static final String EZWEB_WAP2 = "ezweb_wap2";
    public static final String VODAFONE = "vodafone";
    private static String CONFIG_SECTION = "browser";
    private static BrowserChecker instance = null;
    private Map browserTypeMap = null;

    protected BrowserChecker() {
        BaseClass.logger.entering();
        this.init();
        BaseClass.logger.exiting();
    }

    public static BrowserChecker getInstance() {
        BaseClass.logger.entering("BrowserChecker", "getInstance");
        if (instance == null) {
            instance = new BrowserChecker();
        }
        BaseClass.logger.exiting("BrowserChecker", "getInstance");
        return instance;
    }

    public void init() {
        this.browserTypeMap = new HashMap();
        Element conf = (Element)Config.getInstance().getNode(CONFIG_SECTION);
        boolean showModels = Boolean.valueOf(conf.getAttribute("showModels"));
        NodeList list = conf.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() != 3 && "include".equals(node.getNodeName())) {
                this.load(node.getChildNodes().item(0).getNodeValue(), showModels);
            }
            ++i;
        }
    }

    private void load(String config_file, boolean showModels) {
        BaseClass.logger.debug(config_file);
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(Thread.currentThread().getContextClassLoader().getResourceAsStream(config_file));
            Element root = doc.getDocumentElement();
            String type = root.getAttribute("type");
            Map browserMap = this.getBrowserMap(root.getTagName());
            NodeList list = root.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                    Browser browser = new Browser();
                    browser.setName(node.getNodeName());
                    browser.setType(type);
                    NodeList attrs = node.getChildNodes();
                    int j = 0;
                    while (j < attrs.getLength()) {
                        Node attr = attrs.item(j);
                        if (attr.getNodeType() != 3 && attr.getNodeType() != 8) {
                            String value = null;
                            try {
                                value = attr.getChildNodes().item(0).getNodeValue();
                            }
                            catch (Exception e) {
                                BaseClass.logger.err("attr_name:" + attr.getNodeName());
                                BaseClass.logger.err(e);
                            }
                            browser.setAttribute(attr.getNodeName(), value);
                        }
                        ++j;
                    }
                    if (showModels) {
                        BaseClass.logger.debug(browser.toString());
                    }
                    StringTokenizer token = new StringTokenizer(browser.getUserAgent(), " ");
                    String key = token.nextToken();
                    if (root.getTagName().equals(DOCOMO_FOMA) && !key.equals("Default")) {
                        key = token.nextToken();
                    } else if (root.getTagName().equals(DESKTOP)) {
                        key = browser.getName();
                    }
                    browserMap.put(key, browser);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Browser getBrowser(String userAgent) {
        Browser browser = null;
        Map browserMap = null;
        if (userAgent == null) {
            BaseClass.logger.debugTool("user_agent==null");
            browser = (Browser)this.getBrowserMap(DESKTOP).get("Default");
            userAgent = browser.getUserAgent();
        }
        BaseClass.logger.debugTool(userAgent);
        StringTokenizer token = new StringTokenizer(userAgent, " ");
        String key = token.nextToken();
        if (userAgent.indexOf("DoCoMo/1.0") > -1) {
            browserMap = this.getBrowserMap(DOCOMO_PDC);
        } else if (userAgent.indexOf("DoCoMo/2.0") > -1) {
            browserMap = this.getBrowserMap(DOCOMO_FOMA);
            key = token.nextToken();
        } else if (userAgent.indexOf("KDDI") > -1) {
            browserMap = this.getBrowserMap(EZWEB_WAP2);
        } else if (userAgent.indexOf("UP.Browser") > -1) {
            browserMap = this.getBrowserMap(EZWEB);
        } else if (userAgent.indexOf("J-PHONE") > -1 || userAgent.indexOf("Vodafone") > -1) {
            browserMap = this.getBrowserMap(VODAFONE);
            int index = key.lastIndexOf("/SN");
            if (index > 0) {
                key = key.substring(0, index);
            }
            BaseClass.logger.debug(key);
        } else {
            browserMap = this.getBrowserMap(DESKTOP);
            try {
                if (userAgent.indexOf("MSIE") > -1) {
                    token.nextToken();
                    token.nextToken();
                    String version = token.nextToken();
                    version = version.substring(0, version.length() - 1);
                    int ver = (int)Double.parseDouble(version);
                    key = "IE" + ver;
                } else if (userAgent.indexOf("Mozilla") > -1) {
                    StringTokenizer slashToken = new StringTokenizer(key, "/");
                    slashToken.nextToken();
                    int ver = (int)Double.parseDouble(slashToken.nextToken());
                    key = "Mozilla" + ver;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        browser = browserMap.containsKey(key) ? (Browser)browserMap.get(key) : (Browser)browserMap.get("Default");
        return browser;
    }

    private Map getBrowserMap(String type) {
        HashMap map = (HashMap)this.browserTypeMap.get(type);
        if (map == null) {
            map = new HashMap();
            this.browserTypeMap.put(type, map);
        }
        return map;
    }

    public Map getBrowserTypeMap() {
        return this.browserTypeMap;
    }
}

