/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.text;

import java.text.AttributedCharacterIterator;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class ThreadSafeSimpleDateFormat
extends SimpleDateFormat {
    private static Map localeInstanceMap = Collections.synchronizedMap(new HashMap());
    private String format = null;
    private boolean isLenient = true;
    private Locale locale = null;

    public ThreadSafeSimpleDateFormat(String format) {
        this.format = format;
        this.locale = Locale.getDefault();
    }

    public ThreadSafeSimpleDateFormat(String format, Locale locale) {
        this.format = format;
        locale = Locale.getDefault();
    }

    private SimpleDateFormat getSdf() {
        List poolList;
        Map formatMap = (Map)localeInstanceMap.get(this.locale);
        if (formatMap == null) {
            formatMap = Collections.synchronizedMap(new HashMap());
            localeInstanceMap.put(this.locale, formatMap);
        }
        if ((poolList = (List)formatMap.get(this.format)) == null) {
            poolList = Collections.synchronizedList(new LinkedList());
        }
        SimpleDateFormat sdf = null;
        List list = poolList;
        synchronized (list) {
            int i = 0;
            while (i < poolList.size()) {
                sdf = (SimpleDateFormat)poolList.get(i);
                if (sdf.isLenient() == this.isLenient) {
                    poolList.remove(sdf);
                    return sdf;
                }
                ++i;
            }
        }
        sdf = new SimpleDateFormat(this.format);
        sdf.setLenient(this.isLenient);
        return sdf;
    }

    private void releaseSdf(SimpleDateFormat sdf) {
        List<SimpleDateFormat> poolList;
        Map formatMap = (Map)localeInstanceMap.get(this.locale);
        if (formatMap == null) {
            formatMap = Collections.synchronizedMap(new HashMap());
            localeInstanceMap.put(this.locale, formatMap);
        }
        if ((poolList = (List<SimpleDateFormat>)formatMap.get(this.format)) == null) {
            poolList = Collections.synchronizedList(new ArrayList());
        }
        poolList.add(sdf);
    }

    public Object clone() {
        return new ThreadSafeSimpleDateFormat(this.format);
    }

    public boolean equals(Object arg0) {
        SimpleDateFormat sdf = this.getSdf();
        boolean result = sdf.equals(arg0);
        this.releaseSdf(sdf);
        return result;
    }

    public StringBuffer format(Date arg0, StringBuffer arg1, FieldPosition arg2) {
        SimpleDateFormat sdf = this.getSdf();
        StringBuffer result = sdf.format(arg0, arg1, arg2);
        this.releaseSdf(sdf);
        return result;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object arg0) {
        SimpleDateFormat sdf = this.getSdf();
        AttributedCharacterIterator result = sdf.formatToCharacterIterator(arg0);
        this.releaseSdf(sdf);
        return result;
    }

    public Date get2DigitYearStart() {
        SimpleDateFormat sdf = this.getSdf();
        Date result = sdf.get2DigitYearStart();
        this.releaseSdf(sdf);
        return result;
    }

    public Calendar getCalendar() {
        SimpleDateFormat sdf = this.getSdf();
        Calendar result = sdf.getCalendar();
        this.releaseSdf(sdf);
        return result;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        SimpleDateFormat sdf = this.getSdf();
        DateFormatSymbols result = sdf.getDateFormatSymbols();
        this.releaseSdf(sdf);
        return result;
    }

    public NumberFormat getNumberFormat() {
        SimpleDateFormat sdf = this.getSdf();
        NumberFormat result = sdf.getNumberFormat();
        this.releaseSdf(sdf);
        return result;
    }

    public TimeZone getTimeZone() {
        SimpleDateFormat sdf = this.getSdf();
        TimeZone result = sdf.getTimeZone();
        this.releaseSdf(sdf);
        return result;
    }

    public int hashCode() {
        SimpleDateFormat sdf = this.getSdf();
        int result = sdf.hashCode();
        this.releaseSdf(sdf);
        return result;
    }

    public Date parse(String arg0) throws ParseException {
        SimpleDateFormat sdf = this.getSdf();
        Date result = sdf.parse(arg0);
        this.releaseSdf(sdf);
        return result;
    }

    public Date parse(String arg0, ParsePosition arg1) {
        SimpleDateFormat sdf = this.getSdf();
        Date result = sdf.parse(arg0, arg1);
        this.releaseSdf(sdf);
        return result;
    }

    public Object parseObject(String arg0) throws ParseException {
        SimpleDateFormat sdf = this.getSdf();
        Object result = sdf.parseObject(arg0);
        this.releaseSdf(sdf);
        return result;
    }

    public Object parseObject(String arg0, ParsePosition arg1) {
        SimpleDateFormat sdf = this.getSdf();
        Object result = sdf.parseObject(arg0, arg1);
        this.releaseSdf(sdf);
        return result;
    }

    public String toLocalizedPattern() {
        SimpleDateFormat sdf = this.getSdf();
        String result = sdf.toLocalizedPattern();
        this.releaseSdf(sdf);
        return result;
    }

    public String toString() {
        SimpleDateFormat sdf = this.getSdf();
        String result = sdf.toString();
        this.releaseSdf(sdf);
        return "ThreadSafeSDF(" + this.format + ")[" + result + "]";
    }

    public void setLenient(boolean isLenient) {
        this.isLenient = isLenient;
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public void applyPattern(String format) {
        this.format = format;
        throw new UnsupportedOperationException();
    }

    public String toPattern() {
        return this.format;
    }

    public void applyLocalizedPattern(String arg0) {
        throw new UnsupportedOperationException();
    }

    public void set2DigitYearStart(Date arg0) {
        throw new UnsupportedOperationException();
    }

    public void setCalendar(Calendar arg0) {
        throw new UnsupportedOperationException();
    }

    public void setDateFormatSymbols(DateFormatSymbols arg0) {
        throw new UnsupportedOperationException();
    }

    public void setNumberFormat(NumberFormat arg0) {
        throw new UnsupportedOperationException();
    }

    public void setTimeZone(TimeZone arg0) {
        throw new UnsupportedOperationException();
    }
}

