#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[/][/*]SH_'     ;O=${0##*[/]};R=`dirname $0`;R=${R%/}/;R0=$R$O;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGsuffix"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d
:l;n;p;bl"<$R0>$Rm;$Rp"$Rm"';RB=$($R"s/${C}OP//p"<$R0|(F=mw;while read -r a b;do
B=${a%:};F=`$Rp"$F"|$R"s#$B:*##1;p"`${a%_};$Rp"C$B=\$(cat<<'E'$O$b${O}E$O)";done
$Rp"R1=$F"));Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;bl"<$R0';Cw="(R=LS;$Rw;$Rw>&3;R=HD
$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';Re=eval\ ;$Re"$RB";while getopts $R1\
 R;do case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac
done;[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit   #END GPL3+*/

/*SH_LS*/
/* Copyright (C) 2021 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc
title=*SH_bn* section=1 repnl=\040

@name txt2lit
@_brief conv text to C-lang literal form
@_syno
	*SH_bn* [-hHV] [-b] [-o ofname] infile
@tl;dr
		@(code)@
	~$ txt2lit mylua.lj		#>> output
	~$ cat mylua.lj | txt2lit -b	#>> array mode with '\0' end
	~$ echo '1"23\' | txt2lit -o out.txt	#>> "1\"23\\\n"
		@()
@_opt
	@(list_o)
	-hHV: usage, version
	-b: output binary array format instead of literal
	-o file: set output to `_file` (dfl@:stdout)
	@()
@_desc
	`*SH_bn*` outputs quoted strings for C-lang and byte size.
		@(code)--
	--mylua.lua
	print("hw")
	return 0
	
	~$ txt2lit mylua.lua > mylua.h
	~$ cat mylua.h	#>>>
	  "--mylua.lua\n"
	  "print(\"hw\")\n"
	  "return 0\n"
	  / *112* /
	
	// almost the same as:
	// sed -e 's/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g'
		@()--

	output code is used as:
	@(code)--
	#include <stdio.h>
	static const char* str =
		#include "out.txt"
		;
	// const char str[] = ... if use -b option, c99+
	int main(int ac, char** av){
	  puts("text is:");
	  puts(str);
	  return 0;
	}
	@()--
	'-b' opt outputs array syntax {1,2,3...,0} end with '\0'.
	the last '\0' is out of binary size count.
@EXIT_STATUS
	suc/err == 0/not0

@conforming_to	POSIX.1-2001+
@copyright
	Copyright (C) 2021 Momi-g --
@_ver 2021-11-26 v1.0.2
@_see `lbc(3)`
//SH_docE*/
/*SH_ED*/

/*SH_HD*/
#ifndef txt2lit_5c607fb65f2e
#define txt2lit_5c607fb65f2e

#include <stdio.h>
#include <string.h>
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

int *SH_bn*_main(int ac, char** av);
#endif /* txt2lit_5c607fb65f2e */
/*SH_ED*/

/*SH_SC*/
/* tool macros */
#ifndef ERRact
#include <stdio.h>
 #if (199901L <= __STDC_VERSION__ +0)	/* nealy 200112L, _POSIX_C_SOURCE	c99*/
	#define ERRactag	__func__, getpid()
 #else
	#define ERRactag	"func:c99+", 0
 #endif
 #include <sys/types.h>
 #include <unistd.h>
 #include <string.h>
 #include <errno.h>
 #define ERRact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr, \
	"ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, ERRactag \
	, "hit(" #xpr ")", msg, strerror(en_) ); act; }
 #define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1) )
#endif
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
/*tool end*/

#include <stdlib.h>
#include <string.h>

#include "*SH_bn*.h"
#include "optbox.h"

OPTBOX_SET( opts, "q"
 , ( usage,  "-h", "0"  ,bool)
 , ( usageH, "-H", "0"  ,bool)
 , ( version,"-V", "0"  ,bool)
 , ( binary	,"-b", "0"  ,bool)
 , ( ofile,  "-o", ""   ,str)
)
// opts: ptrname to static buffer
// "q": parsing mode, Quiet mode
// setting cols count is 4/5. col 5 is raw testcode (rtn0 >>> fail)

int f_usage(){
	const char* s=
/*SH_lit
HowTo (txt2lit - conv string to C-lang literal suitable form
opt: -hH(elp), -V(er), -o(utput fname), -b(yte)
---
eg) ~$ cat a.txt	#>> 12\3"4
    ~$ txt2lit a.txt	#>> "12\\3\"4\n"
    ~$ txt2lit -b a.txt	#>> {49(=='1'),50,92 ..., '\0'}
    ~$ cat a.txt | txt2lit	#>> same
    ~$ cat a.txt | txt2lit -o out.txt	#>> output to out.txt
 
 ..almost the same as:
      cat a.txt | sed -e 's/"/\\"/g;s/^/"/g;s/$/\\n"/g'
 
 the last '\0' of '-b' mode is out of byte conut.
/*SH_litE*/
	;
	fputs(s, stderr);
	exit(0);
}
int f_usageH(){
	const char* s=
/*SH_lit*/
	#include "*SH_bn*.1.txt"	/*SH_rf* 0 *SH_bn*.1.txt */
/*SH_litE*/
	;
	fputs(s, stderr);
	exit(0);
}

int f_version(){
	fputs("*SH_bn* *SH_ver*\n"
	"Copyright (C) 2021 Momi-g\n"
	"License GPLv3+: GNU GPL version 3 or later <https://gnu.org/licenses/gpl.html>\n"
	, stderr);
	exit(0);
}

static FILE* op = NULL;
static void bo(char c){
	unsigned int n = (unsigned char)c;
	char buf[4]={0};
	char* p=buf+3;
	while(1){
		p--;
		int v = n%10;
			if(v==9){  *p='9'; }
		else if(v==8){ *p='8'; }
		else if(v==7){ *p='7'; }
		else if(v==6){ *p='6'; }
		else if(v==5){ *p='5'; }
		else if(v==4){ *p='4'; }
		else if(v==3){ *p='3'; }
		else if(v==2){ *p='2'; }
		else if(v==1){ *p='1'; }
		else if(v==0){ *p='0'; }
		n /=10;
		if(n==0){break;}
	}
	if(strlen(p)==0){
		fprintf(stderr, "@%d@\n", c);
		;STOP(1, "fatal");
	}
	fputs(p, op);
}

#define PERLINE 20
int txt2lit_main(int argc, char** argv){
	int rc= optbox_init(opts, &argc, &argv);	//eat optargs, changes ac,av
	if(rc){ printf("badopt: -%c\n", rc);return rc;} //rc=='d' etc. optchar.
	if(opts->usage){ f_usage(); }
	if(opts->usageH){ f_usageH(); }
	if(opts->version){ f_version(); }
	op=stdout;
	if(opts->ofile[0]!='\0'){
		op = fopen(opts->ofile, "w");
		; STOP(op==NULL, opts->ofile);
	}
	
	FILE* fp=NULL;
	if(argc==1){ fp=stdin; }
	else{ fp = fopen(argv[1], "r");}
	; STOP(fp==NULL, argv[1]);
	int head=1;
	int ccnt=0;
	int wcnt=0; //line char count. width

	while(opts->binary==0){
		char c;
		rc = fread(&c, 1, 1, fp);
		if(rc==0){
			if(head==0){fputs("\"\n", op);}
			if(ccnt==0){ fputs("\"\"\n", op);}
			break;
		}
		if(head){fputc('"', op);head=0;}
		ccnt++;
		// sed -e 's/[\]/&&/g;s/"/\\"/g;s/^/"/g;s/$/\\n"/g'
		// \ >> \\, " >> \" \n >> "\n + ^"
			if(c=='\\'||c=='"'){fputc('\\', op);}
		else if(c=='\n'){fputs("\\n\"", op); head=1; }		// \n >> \\n" + \n
		fputc(c, op);
	}
	while(opts->binary){
		char c;
		rc = fread(&c, 1, 1, fp);
		if(rc==0){
			if(head==0){fputs(",0}\n", op);}
			else{ fputs("{0}\n", op);}
			break;
		}
		ccnt++;
		wcnt++;
		if(wcnt>PERLINE){wcnt=0;fputc('\n', op);}
		if(head){fputc('{', op);head=0;}
		else{fputc(',', op);}
		bo(c);
	}
	fprintf(op, "/*%d*/\n", ccnt);
	fclose(fp);
	return 0;
}

#ifdef TEST
	#include "*SH_bn*.h"	/*SH_co*  */
	#include "hcut.h"
	#include "msgp.h"
	#include "laptime.h"
	#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
	#define qu(...)		Qsub(__VA_ARGS__)
	#define Qsub(...)	#__VA_ARGS__
#endif

#ifdef TEST
HCUT_ADD(t_txt2lit) {
	dbg();
	puts("*SH_bn* works on terminal, no libtest");
//	txt2lit_main(argc, argv);
}
#endif

/*SH_SMP
#include "*SH_bn*.h"
#include <stdio.h>

int main(int argc, char** argv) {
	lbc_t* obj = lbc_new();
//	#include "mod.h"
//	#include "run.h"
//	lbc_reqbcM(obj, mod);
//	lbc_runbcM(obj, argc, argv, run);
	lbc_runstr(obj, argc, argv, "return 1,2,3" );
	lbc_rt res = lbc_tbval(obj, 0, 1);
	printf("%c / %d\n", res.tp, res.i);
	lbc_free(obj);
	return 0;
}
//~$ gcc src.c -static lib*SH_bn*.a -ldl -lm
//SH_SMPE*/

#ifdef TEST
HCUT_RUN("stderr", 1,
         t_txt2lit)
#endif

/*
 change log
 --
2021-11-26	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(arr): add end \0 for lit compat. v1.0.2
	* (brp): update build script

2021-11-18	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(arr): add ary api for avoid ISO C99 -Woverlength. v1.0.1

2021-11-18	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c(build): release. v1.0.0

*/

/*SH_ED*/

/*SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
/*SH_OP	h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
/*SH_OP	f sed -ne "/${C}DF/q;/;/d;/^[a-z].*)/p"<$R0 #*/
/*SH_OP t $e"$CW";ftt "$@";$p'cc -O0 -static -Wall -pedantic -g -pg -ggdb3 $Rm `fOI $Rs $tf` `fg $Rs $tf` `fL`'|fv	#*/
/*SH_OP T $e"$CW";ftt "$@";$p'cc -O3 $Rm `fOI $Rs $tf ` `fg $Rs $tf ` `fL`'|fv	#*/
/*SH_OP s $e"$CB";fgr0 "${C}SMP" "${C}SMPE"<$Rs|fbn>eg.c;$p'cc eg.c `fg eg.c` `fOI eg.c`'|fv #*/

/*SH_OP L $p"valgrind --leak-check=full --show-leak-kinds=all --track-origins=yes --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"|fv #*/
/*SH_OP M $p"fM ./a.out"|fv	 #*/
/*SH_OP P $p'valgrind --tool=callgrind --callgrind-out-file=log.out ./a.out;kcachegrind log.out'|fv	 #*/

/*SH_OP b $e"$CW";$p'cc -c $Rs -pedantic -O2 -Wall -g `fg $Rs` `fI $Rs`'|fv;$p"$bn.o"	#*/
/*SH_OP B $e"$Cb";$p"ar -r lib$bn.a $bn.o `fO $Rs`"|fv;$p"lib$bn.a"	#*/
/*SH_OP A $e"$CB";$p'fA lib$bn.a `fg $Rh $Rs|fu|grep '[.]a$'|fU`'|fv;$p"lib$bn.a" #*/
/*SH_OP S $e"$Cb";$p"cc -shared -fPIC -o lib$bn.so $bn.o `fOI $Rs` `fg $Rs`"|fv;$p"lib$bn.so" #*/
/*SH_OP W $e"$Cm$O$Cw">/dev/null;fborn;$p"$Rs $Rh $tf"	#*/

/*SH_OP z cat $R0 | sed -e "s@\*${C##*]}bn\*@$bn@g"|frf		#*/

/*SH_OP o $e"$CW";$p'fman $Rh 3'|fv		#*/

/*SH_DF
#-- noob
fman()( $p"fgr0 '${C}doc' '${C}docE'<$1|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 #fgr0 '${C}doc' '${C}docE'<$1|amn -Dzwsp=1 >$Rm
 #man -Tutf8 /dev/stdin<$Rm|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
 "|fv
)

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv|flit)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()(sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

# fO src.o from inc"src.abc" etc. kick self
fO()(set -- `fdp "$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.o/'|fU`
	buf="";for i;do test -f $i&&buf="$buf $i";done;$p"$buf"
)
fI()(fdp "$@"|sed -e 's/[^/]*$//g'|fu|sed -e '/./s/^/ -I/g'|fu|grep -v '^\-I$'|fU)
fL()(find -L `dirname $R0` -type d|sed -e 's/^/-L/g'|fU)
# inc""系.h,hpp,oをパス付きで羅列 OIはfdpが重複するので高速化でまとめる 複数file_ok
fOI()(
set -- `fdp "$@"`
s="-I./ "`$p"$@"|sed -e 's/[^/]*$//g'|fu|sed -e 's/^/ -I/g'|fu|grep -v '^\-I$'|fU`
set -- `$p"$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.o/'|fU`
buf="";for i;do test -f $i&&buf="$buf $i";done;
$p"$buf $s"
)

# 依存inc""を再帰的に取得./以下全て self系はkick
fdp()( l="$*"; paths="$@"; all=""; used=""
 while :;do
	all=`$p$all $paths|fU`	#差分を追加 repの始末 差分たちからaaa.hを取得 partial path
	buf=`(cat $paths|sed -ne 's@^[ \t]*#inc[^"]*.\([a-zA-Z0-9._]*\)".*@\1@p')|sort -u`
	ch=`$p$used $buf|tr -s ' ' '\n'|sort|uniq -u`	#使用済は外す
	used="$used $ch"	#リスト更新
	paths=`fsvy $ch|sort -u`	#ls検索 name系のみのはず
	buf=`$p"$all" "$paths"|fU`	#増えたらloop
	[ ${#all} = ${#buf} ]&&break
 done
# initを除く
 set -- $all
 for i;do a=${i##*[/]}; a=${a%%.*};[ "${l##*$a*}" = "$l" ]&&set -- "$@" $i;shift;done
 $p"$@"
)

# corecode:search + depthck + uniq
fsvy()(c="find -L ./ -false"
	for i; do c="$c -o -path '*'$i";done; l=`$e"$c"`
	for i; do $p"$l"|grep -F "$i"|awk '{sv=$0;print gsub("[/]","") " " sv}'|
	sort -k 1.1,1n -k 2.2,2|awk '{print $2;exit}'; done
)

# libをまとめる
fA()(n=0;dir=`dirname $0`/tmpdir;mkdir $dir;cd $dir;
 for i;do
 	n=$((n+1))
 	cp ../$i $i
 	ar -x $i
 	for ii in *.o;do mv "$ii" "p${n}_$ii";done
 	ar -r lib$bn.aa *.o
 	rm *.o
 done
 $p'mv lib$bn.aa ../lib$bn.a'|fv
 cd ..;rm -r $dir
)

#-- yacc
# /*SH_OP y $e"$CW";fy
# /*SH_OP Y $e"$Cy";fU $( ($p"lib$bn.a";fg $Rs $Rh)|$n|grep '[.]a$'|$U)
fy()(
cat<<'EEE'|fv
f0 "${C}YACC" "${C}YACCE"<$Rs>myyacc.y
f0 "${C}LEX" "${C}LEXE"<$Rs>mylex.l
lex mylex.l; yacc -p zz -dv myyacc.y
cat y.tab.c lex.yy.c > $Rs
gcc -c y.tab.c lex.yy.c -lfl `fA $Rs $Rh`
rm mylex.l myyacc.y lib$bn.a
ar r lib$bn.a `fo $Rs` y.tab.o lex.yy.o
$p"lib$bn.a"
EEE
)

#-- longcmd
frf()(
 # *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
 awk -v tg="${C##*]}rf" 'index($0,tg){
 s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
 m="[ -f \"%s\" ]&&(echo \"/*--copyfrom %s*\"/;cat \"%s\";echo \"/*--copyend %s*\"/)"
 mm="[ -f \"%s\" ]&&(_=\"%s\"/;cat \"%s\";_=\"%s\")"
 for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,v,v,v)) }
 next
 }
 {print}'
)

frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
flit()(sed -ne "/${C}lit/bl;p;d;:l;n;/${C}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;bl')

fte(){
 cat > $Rm-
 a="`sed -ne 's@^HCUT_ADD(\([^)]*\).*@\1, @p' $Rm-|tr -d '\n'`NULL"
 if [ $# != 0 ];then	a=""; for i;do a="$a $i,";done; a="$a NULL"; fi
 sed -ne "p;/_RUN/bl;d;:l;/[)]/{c\\$O $a)$O p;d};n;bl" $Rm-
 rm $Rm-
}
ftt()(fte "$@"<$tf>$Rm;mv $Rm $tf; cat $Rs $tf>$Rm)
fborn(){
 fgr0 "^#ifdef TEST" "^#endif"<$R0|fbn>$tf
 fgR "^#ifdef TEST_" "^#endif"<$R0 |fgr0 "^#ifdef TEST" "^#endif"|fbn|fte>tests.code
 fgR "^#ifdef TEST" "^#endif"<$Rs|fbn>$Rm;mv $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
}
fM()(
 valgrind -q --tool=massif --massif-out-file=./vmem.buf --stacks=yes --trace-children=yes $1>/dev/null
 ms_print ./vmem.buf|sed -ne '/[KMG]B/bl;d;:l;/snap/q;p;n;bl';rm ./vmem.buf)

/*SH_DE*/
