/* Copyright (C) 2021 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc
title=txt2lit section=1 repnl=\040

@name txt2lit
@_brief conv text to C-lang literal form
@_syno
	txt2lit [-hHV] [-b] [-o ofname] infile
@tl;dr
		@(code)@
	~$ txt2lit mylua.lj		#>> output
	~$ cat mylua.lj | txt2lit -b	#>> array mode with '\0' end
	~$ echo '1"23\' | txt2lit -o out.txt	#>> "1\"23\\\n"
		@()
@_opt
	@(list_o)
	-hHV: usage, version
	-b: output binary array format instead of literal
	-o file: set output to `_file` (dfl@:stdout)
	@()
@_desc
	`txt2lit` outputs quoted strings for C-lang and byte size.
		@(code)--
	--mylua.lua
	print("hw")
	return 0
	
	~$ txt2lit mylua.lua > mylua.h
	~$ cat mylua.h	#>>>
	  "--mylua.lua\n"
	  "print(\"hw\")\n"
	  "return 0\n"
	  / *112* /
	
	// almost the same as:
	// sed -e 's/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g'
		@()--

	output code is used as:
	@(code)--
	#include <stdio.h>
	static const char* str =
		#include "out.txt"
		;
	// const char str[] = ... if use -b option, c99+
	int main(int ac, char** av){
	  puts("text is:");
	  puts(str);
	  return 0;
	}
	@()--
	'-b' opt outputs array syntax {1,2,3...,0} end with '\0'.
	the last '\0' is out of binary size count.
@EXIT_STATUS
	suc/err == 0/not0

@conforming_to	POSIX.1-2001+
@copyright
	Copyright (C) 2021 Momi-g --
@_ver 2021-11-26 v1.0.2
@_see `lbc(3)`
//SH_docE*/
/* tool macros */
#ifndef ERRact
#include <stdio.h>
 #if (199901L <= __STDC_VERSION__ +0)	/* nealy 200112L, _POSIX_C_SOURCE	c99*/
	#define ERRactag	__func__, getpid()
 #else
	#define ERRactag	"func:c99+", 0
 #endif
 #include <sys/types.h>
 #include <unistd.h>
 #include <string.h>
 #include <errno.h>
 #define ERRact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr, \
	"ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, ERRactag \
	, "hit(" #xpr ")", msg, strerror(en_) ); act; }
 #define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1) )
#endif
#define loop(a)		for(int lpcnt=1;lpcnt<=a;lpcnt++)
/*tool end*/

#include <stdlib.h>
#include <string.h>

#include "txt2lit.h"
#include "optbox.h"

OPTBOX_SET( opts, "q"
 , ( usage,  "-h", "0"  ,bool)
 , ( usageH, "-H", "0"  ,bool)
 , ( version,"-V", "0"  ,bool)
 , ( binary	,"-b", "0"  ,bool)
 , ( ofile,  "-o", ""   ,str)
)
// opts: ptrname to static buffer
// "q": parsing mode, Quiet mode
// setting cols count is 4/5. col 5 is raw testcode (rtn0 >>> fail)

int f_usage(){
	const char* s=
"HowTo (txt2lit - conv string to C-lang literal suitable form\n"
"opt: -hH(elp), -V(er), -o(utput fname), -b(yte)\n"
"---\n"
"eg) ~$ cat a.txt	#>> 12\\3\"4\n"
"    ~$ txt2lit a.txt	#>> \"12\\\\3\\\"4\\n\"\n"
"    ~$ txt2lit -b a.txt	#>> {49(=='1'),50,92 ..., '\\0'}\n"
"    ~$ cat a.txt | txt2lit	#>> same\n"
"    ~$ cat a.txt | txt2lit -o out.txt	#>> output to out.txt\n"
" \n"
" ..almost the same as:\n"
"      cat a.txt | sed -e 's/\"/\\\\\"/g;s/^/\"/g;s/$/\\\\n\"/g'\n"
" \n"
" the last '\\0' of '-b' mode is out of byte conut.\n"
	;
	fputs(s, stderr);
	exit(0);
}
int f_usageH(){
	const char* s=
"TXT2LIT(1)                  General Commands Manual                 TXT2LIT(1)\n"
"\n"
"\n"
"\n"
"NAME\n"
"       txt2lit - conv text to C-lang literal form\n"
"\n"
"SYNOPSIS\n"
"       txt2lit [-hHV] [-b] [-o ofname] infile\n"
"\n"
"TL;DR\n"
"       ~$ txt2lit mylua.lj      #>> output\n"
"       ~$ cat mylua.lj | txt2lit -b  #>> array(binary) mode\n"
"       ~$ echo '1\"23\\' | txt2lit -o out.txt    #>> \"1\\\"23\\\\\\n\"\n"
"\n"
"\n"
"OPTIONS\n"
"       -hHV   usage, version\n"
"\n"
"       -b     output binary array format instead of literal\n"
"\n"
"       -o file\n"
"              set output to file (dfl:stdout)\n"
"\n"
"DESCRIPTION\n"
"       txt2lit outputs quoted strings for C-lang and byte size.\n"
"\n"
"            --mylua.lua\n"
"            print(\"hw\")\n"
"            return 0\n"
"\n"
"            ~$ txt2lit mylua.lua > mylua.h\n"
"            ~$ cat mylua.h #>>>\n"
"              \"--mylua.lua\\n\"\n"
"              \"print(\\\"hw\\\")\\n\"\n"
"              \"return 0\\n\"\n"
"              / *112* /\n"
"\n"
"            // almost the same as:\n"
"            // sed -e 's/[\\]/&&/g;s/\"/\\\\\"/g;s@.*@\"&\\\\n\"@g'\n"
"\n"
"       output code is used as:\n"
"\n"
"            #include <stdio.h>\n"
"            static const char* str =\n"
"                 #include \"out.txt\"\n"
"                 ;\n"
"            // const char str[] = ... if use -b option, c99+\n"
"            int main(int ac, char** av){\n"
"              puts(\"text is:\");\n"
"              puts(str);\n"
"              return 0;\n"
"            }\n"
"\n"
"\n"
"\n"
"EXIT_STATUS\n"
"       suc/err == 0/not0\n"
"\n"
"CONFORMING_TO\n"
"       POSIX.1-2001+\n"
"\n"
"COPYRIGHT\n"
"       Copyright (C) 2021 Momi-g\n"
"\n"
"\n"
"VERSION\n"
"       2021-11-23 v1.0.1\n"
"\n"
"SEE_ALSO\n"
"       lbc(3)\n"
"\n"
"\n"
"\n"
"                                                                    TXT2LIT(1)\n"
	;
	fputs(s, stderr);
	exit(0);
}

int f_version(){
	fputs("txt2lit v1.0.2\n"
	"Copyright (C) 2021 Momi-g\n"
	"License GPLv3+: GNU GPL version 3 or later <https://gnu.org/licenses/gpl.html>\n"
	, stderr);
	exit(0);
}

static FILE* op = NULL;
static void bo(char c){
	unsigned int n = (unsigned char)c;
	char buf[4]={0};
	char* p=buf+3;
	while(1){
		p--;
		int v = n%10;
			if(v==9){  *p='9'; }
		else if(v==8){ *p='8'; }
		else if(v==7){ *p='7'; }
		else if(v==6){ *p='6'; }
		else if(v==5){ *p='5'; }
		else if(v==4){ *p='4'; }
		else if(v==3){ *p='3'; }
		else if(v==2){ *p='2'; }
		else if(v==1){ *p='1'; }
		else if(v==0){ *p='0'; }
		n /=10;
		if(n==0){break;}
	}
	if(strlen(p)==0){
		fprintf(stderr, "@%d@\n", c);
		;STOP(1, "fatal");
	}
	fputs(p, op);
}

#define PERLINE 20
int txt2lit_main(int argc, char** argv){
	int rc= optbox_init(opts, &argc, &argv);	//eat optargs, changes ac,av
	if(rc){ printf("badopt: -%c\n", rc);return rc;} //rc=='d' etc. optchar.
	if(opts->usage){ f_usage(); }
	if(opts->usageH){ f_usageH(); }
	if(opts->version){ f_version(); }
	op=stdout;
	if(opts->ofile[0]!='\0'){
		op = fopen(opts->ofile, "w");
		; STOP(op==NULL, opts->ofile);
	}
	
	FILE* fp=NULL;
	if(argc==1){ fp=stdin; }
	else{ fp = fopen(argv[1], "r");}
	; STOP(fp==NULL, argv[1]);
	int head=1;
	int ccnt=0;
	int wcnt=0; //line char count. width

	while(opts->binary==0){
		char c;
		rc = fread(&c, 1, 1, fp);
		if(rc==0){
			if(head==0){fputs("\"\n", op);}
			if(ccnt==0){ fputs("\"\"\n", op);}
			break;
		}
		if(head){fputc('"', op);head=0;}
		ccnt++;
		// sed -e 's/[\]/&&/g;s/"/\\"/g;s/^/"/g;s/$/\\n"/g'
		// \ >> \\, " >> \" \n >> "\n + ^"
			if(c=='\\'||c=='"'){fputc('\\', op);}
		else if(c=='\n'){fputs("\\n\"", op); head=1; }		// \n >> \\n" + \n
		fputc(c, op);
	}
	while(opts->binary){
		char c;
		rc = fread(&c, 1, 1, fp);
		if(rc==0){
			if(head==0){fputs(",0}\n", op);}
			else{ fputs("{0}\n", op);}
			break;
		}
		ccnt++;
		wcnt++;
		if(wcnt>PERLINE){wcnt=0;fputc('\n', op);}
		if(head){fputc('{', op);head=0;}
		else{fputc(',', op);}
		bo(c);
	}
	fprintf(op, "/*%d*/\n", ccnt);
	fclose(fp);
	return 0;
}



/*SH_SMP
#include "txt2lit.h"
#include <stdio.h>

int main(int argc, char** argv) {
	lbc_t* obj = lbc_new();
//	#include "mod.h"
//	#include "run.h"
//	lbc_reqbcM(obj, mod);
//	lbc_runbcM(obj, argc, argv, run);
	lbc_runstr(obj, argc, argv, "return 1,2,3" );
	lbc_rt res = lbc_tbval(obj, 0, 1);
	printf("%c / %d\n", res.tp, res.i);
	lbc_free(obj);
	return 0;
}
//~$ gcc src.c -static libtxt2lit.a -ldl -lm
//SH_SMPE*/


/*
 change log
 --
2021-11-26	Momi-g	<dmy@dmy.dmy>

	* txt2lit.sh.c(arr): add end \0 for lit compat. v1.0.2
	* (brp): update build script

2021-11-18	Momi-g	<dmy@dmy.dmy>

	* txt2lit.sh.c(arr): add ary api for avoid ISO C99 -Woverlength. v1.0.1

2021-11-18	Momi-g	<dmy@dmy.dmy>

	* txt2lit.sh.c(build): release. v1.0.0

*/

