/****************************************************************************/
/* The developnent of this program is partly supported by IPA.              */
/* (Infomation-Technology Promotion Agency, Japan).                         */
/****************************************************************************/

/****************************************************************************/
/*  cloopprofiler.h                                                         */
/*  Copyright : Copyright (C) 2006 ALPHA SYSTEMS INC.                       */
/*  Authors : Daisuke Abe (abeda@alpha.co.jp)                               */
/*           ALPHA SYSTEMS INC. knoppix team(knoppix@alpha.co.jp)           */
/*                                                                          */
/*  This is free software; you can redistribute it and/or modify            */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This software is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this software; if not, write to the Free Software            */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  */
/*  USA.                                                                    */
/****************************************************************************/

/**
 * Comment for Doxygen
 * @file cloopprofiler.h
 * @author Daisuke Abe
 * @date 21/11/2005
 */

#include "cloopprofiler_msg.h"

///Macro Defines
//CopyRight
//#define VERSION "0.8"
#define COPYRIGHT "Copyright{c} 2006 Alpha Systems, INC. "

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

//Draw parameters
#define FRM_WIDTH 8
#define FRM_HEIGHT 12
#define BLK_WIDTH (FRM_WIDTH - 1)
#define BLK_HEIGHT (FRM_HEIGHT - 1)
#define BLK_PER_LINE 64
#define BLK_PER_LINE_BASE 8
#define MARGIN 7
#define MARGIN_2 37

#define RED 0xffff
#define GREEN 0xffff
#define BLUE 0xffff

//GTK Widget parameters
#define CONTEXT_NAME "Main"	//TODO:no use

#define NOTEPAGE_STATE 0	//TODO:no use
#define NOTEPAGE_BLOCKS 1	//TODO:no use
#define MAX_NOTEPAGE 2		//TODO:no use?

#define INFO_LENGTH 128
#define INFO_WIDTH 128

//Font parameters
#define FONT "Serif Regular 8"

//Other parameters
#define BUFLEN 8192
#define CLOOP_BSIZE 65536

#define FREQ_RATE 3
#define TIME_RATE 250

#define SECTOR_SIZE 1024
#define NAMELEN 512

/// Debug MACRO / usage: dbg(const char *format, ...);
#define dbg(...) \
  (printf("%s %u @%s:",__FILE__,__LINE__,__func__), \
   printf(" "__VA_ARGS__))

#define SEP " "

//const char* separator = " ";

///Enumelate parameters(Over 0:Normality Under 0:Abnormality)
///Block Color Status(>0)

enum
{
  R_TIME,
  R_FREQ,
  B_GRND,
  F_NOW,
  F_GRND,
  F_SEL,
  R_TIMEF,
  R_FREQT,
  R_TIME_R,
  R_FREQ_R,
  R_TIMEF_R,
  R_FREQT_R,
};

///number of Block Color Status
#define MAX_VIEW ( R_FREQT_R + 1 )

///GUI Event Status(>0)
enum
{
  EV_PLAY,
  EV_STOP,
  EV_FPRESS,
  EV_FRELEASE,
  EV_RPRESS,
  EV_RRELEASE,
  EV_SUMMARY,
  EV_SCALE,
  EV_SWITCH_TAB,
  EV_LIST,
  EV_DISP,
};

///Datalist Elements (>0)
enum
{
  INFO_READNO,
  INFO_BLOCKNO,
  INFO_REFTIME,
  INFO_RDFREQ,
  INFO_OFFSET,
  INFO_SIZE,
  INFO_TFRATE,
};
///number of Datalist Elements
#define INFO_CNT (INFO_TFRATE + 1)

///Menu Elements for display mode (>0)
enum
{
  TIME,
  FREQ,
  TIMEFREQ,
  FREQTIME,
};
///number of Menu Elements for display mode
#define DISP_MODE (FREQTIME + 1)

///Menu Elements for resource mode (>0)
enum
{
  READ_BLOCKS,
  CLOOP_HEADER,
};
///number of Menu Element for resource mode
#define RESOURCE_MODE (CLOOP_HEADER + 1)

enum
{
  OPEN_LOG,
  CLP_HEAD,
  IN_LOG,
  IN_LOG_CLP,
  OUT_LOG,
  OUT_LOG_CLP,
  IN_CLP,
  OUT_CLP,
  WIZ_BLKLST,
  WIZ_CLP,
  APPEND,
  APP_IN,
};

#define FSEL_MODE (APP_IN + 1)

enum
{
  BLKLST,
  OPTIMIZE,
  WIZARD,
};

#define DIALOG_TYPE (WIZARD + 1)

/// Data Structures
/// Font for Pango(gtk2.0)
typedef struct
{
  PangoFontDescription *font;
  PangoLayout *layout;
  int width;
  int height;
  int ascent;
  int descent;
} t_font_g2;

/// Text Data
typedef struct
{
  //Pango Structure
  t_font_g2 *font;
  GtkTextBuffer *text_buffer;
  GtkTextTagTable *tagtable;
  GtkAdjustment *adjust;

  GString *gstring;
  gchar *string;

  GtkWidget *widget;		//TODO:no use
} t_text;

/// Blocks per cell
typedef struct
{
  //SpinButton Widget(1-100/0-10)
  GtkWidget *widget;
  GtkWidget *label;
  GtkObject *adj;
  //GtkObject *adj_bc;
  //GtkObject *adj_sc;
  gint cnt;

} t_spin;


/// CList
typedef struct
{
  //CList Widget
  GtkWidget *widget;
} t_clist;


/// Draw Field
typedef struct
{
  //Draw_field Widget
  GtkWidget *widget;
  //Pixmap Buffer
  GdkPixmap *pixmap;

  //Graphic Context
  GdkGC *gc;
  GdkGC *b_gc;

  //BackGroundColor
  GdkColor bg_color;
  //Block Color
  GdkColor bk_color[MAX_VIEW];

  //Font Structure
  t_font_g2 *font;

  //Draw Parameter
  gint bnum_width;
  gint width;
  gint height;

  GtkWidget *scrl_win;
  gint blks_per_line;
  gint draw_per_line;
  gint summary_cnt;		//"block_mag"?

  //catch start point
  gint startx;
  gint starty;
  gint endx;
  gint endy;

  //Scroll Bar (TODO:no use)
  //GtkAdjustment *adjust;
} t_draw;


/// status bar
/// TODO:Use This Structure!
typedef struct
{
  GtkWidget *widget;
  gchar *msg;
  guint cid;
} t_state;

/// scale bar
typedef struct
{
  GtkWidget *widget;
  GtkAdjustment *adjust;
} t_scale;

//button
typedef struct
{
  GtkWidget *play;
  GtkWidget *stop;
  GtkWidget *rewind;
  GtkWidget *forward;
} t_button;

/// ComboBox
typedef struct
{
  GtkWidget *widget;
  GtkWidget *popdown_list;
  gchar *s;
  GList *list;
} t_combo;

///Dialog Widget Status
///rblkstat2list
typedef struct
{
  GtkWidget *input_entry;
  GtkWidget *input_button;
  GtkWidget *output_entry;
  GtkWidget *output_button;
} t_rblkstat2list;

///optimize
typedef struct
{
  GtkWidget *inputblklst_entry;
  GtkWidget *inputblklst_button;
  GtkWidget *inputclp_entry;
  GtkWidget *inputclp_button;
  GtkWidget *outputblklst_entry;
  GtkWidget *outputblklst_button;
  GtkWidget *outputclp_button;
  GtkWidget *outputclp_entry;

} t_clpoptimize;

///wizard
typedef struct
{
  GtkWidget *rblkstat_entry;
  GtkWidget *noopt_entry;
  GtkWidget *blklst_entry;
  GtkWidget *blklst_button;
  GtkWidget *append_button;
  GtkWidget *opt_entry;
  GtkWidget *opt_button;

} t_wizard;

typedef struct
{
  GtkWidget *hscale;
  GtkWidget *spin;
  GtkObject *adjustment;  
} t_burst;

typedef struct
{
  GtkWidget *bar;
  GtkWidget *label;
  GtkObject *adj;
} t_progress;

typedef struct
{
  gchar *inputblklst;
  gchar *inputclp;
  gchar *outputblklst;
  gchar *outputclp;
} t_optfile;

typedef struct
{
  GtkWidget **window;
  GtkWidget **next_button;
  GtkWidget **cancel_button;

  gint type;

  t_clpoptimize *opt_widget;
  t_rblkstat2list *blklst_widget;
  t_wizard *wiz_widget;

  t_progress progress;
  t_optfile file;
  t_burst spin;
  gint wid;
  
  GThread *oth;
  gint run;

} t_dialog;

typedef struct
{
  GtkWidget *window;
  GtkWidget *up_button;
  GtkWidget *down_button;
  GtkWidget *append_button;
  GtkWidget *remove_button;
  GtkWidget *ok_button;
  
  GtkWidget *list;
  gchar **filename;
  gint count;
  gint select_row;

  gboolean is_set;
} t_append;

 
/// application status
typedef struct
{
  GtkWidget *window;
  GtkWidget *dialog;

  t_draw blks;
  t_text time;
  t_text size;
  t_spin summary;
  t_combo mode;
  t_clist list;
  t_text state;
  t_button btns;
  t_scale scale;
  t_state sbar;			//TODO:use it!

  t_dialog dialog_state;
  t_append append;
#if 0
  t_rblkstat2list rblk2lst_dialog;
  t_clpoptimize optimize_dialog;
  t_wizard wizard_dialog;
#endif /* 0 */

  GtkWidget *popup;
  GList *plist;

  //Bad Define.
  GtkWidget *cloopfile_menu;
  GtkWidget *readahead_menu;
  GtkWidget *optwiz_menu;
  GtkWidget *wizard_menu;
  GtkWidget *reset_menu;
  GtkWidget *resourcemenu_item[2];
  GtkWidget *colormenu_item[4];

} t_app_status;


/// a cloop block Structrue
typedef struct
{
  unsigned int no;
  unsigned int size;
  unsigned long offset;
} t_cloop;

/// cloop header info
typedef struct
{
  gulong first_offset;
  gulong total_size;
  guint total_offsets;

} t_clpimg;

///a block structure
typedef struct
{
  gint read_no;
  gint blk_no;
  gint size;
  gdouble ref_time;		//readtime
  gdouble utc_time;		//accesstime(utc)
  gdouble draw_time;		//wrote number(memory)
  gdouble extract_time;         //extract block time
  gchar draw_freq;		//drawn number(draw field)

  gboolean progress;		//now drawing : TRUE
  t_cloop *cloop;		//cloop block
} t_block;

/// Play Status
typedef struct
{
  // -1:rewind 0:stop 1:play or forward this value-> frame of drawtime
  gint frame;
  gboolean is_play;		//
  gboolean is_pause;
  gboolean r_draw;
  gboolean is_next;
} t_play;

typedef struct
{
  gint cloop_device;
  gint total_blocks;
  gdouble last_jiffies;
  gint call_mkclo_req;
  gint request_length_sum;
  gint mkclo_req_len_max;
  gint bio_loop;
  gint call_load_buffer;
  gint call_read_from_file;
  gint read_time_max;
  gint read_time_min;
  gint read_time_sum;
  gint read_length_sum;
  gint extract_time_max;
  gint extract_time_min;
  gint extract_time_sum;
  gint extract_length_sum;
} t_read_blocks_log;

typedef struct
{
  gboolean is_opt;
  //gchar *is_opt;

  gint cloop_device;
  gdouble read_jiffies;
  gint total_blocks;

  gint total_size;
  gint total_size_as_kb;
  gint cloop_total_size;

  gdouble trance_rate;
  gdouble read_size_average;

  gdouble read_time_average;
  gdouble read_rate_average;
  gdouble total_time;
  gdouble total_read_time;
  gint total_freq;

  gint total_ublocks;
  gint total_ublock_size;
  gdouble start_time;
  gdouble ublock_size_average;

  gdouble last_read_block;

} t_result;

///Timer Status
typedef struct
{
  guint min;
  guint sec;
  guint msec;

  gulong t_count;
  gulong top_block_jiffies;

  gint timer_tag;

  gchar *t_string;
} t_timer;

/// popup
typedef struct
{
  GtkWidget *popup;
  //GList* pblist;
  t_block *pblock;
} t_popup;

typedef struct
{
  GtkWidget *dialog;
  GtkWidget *input;
  gchar *name;
} t_filedialog;

// TODO:arranges it.
/// Run Status
typedef struct
{
  gchar *filename;
  gchar *cloopname;
  gchar fsel;

  t_result result;
  t_clpimg cloop;
  
  gboolean is_cloop;

  GList *blk_list;
  GList *tmp_list;
  GList *load_list;

  gint b_loc;
  gint b_edge;

  gint *rate;
  gint *first_draw;
  t_play play;

  t_timer timer;

  gdouble p_timer;		// progress
  gdouble delay;
  gint d_tag;

  gchar type;
  gchar restype;		// read_blocks ? cloop header

  gint size;
  gint width;
  gint height;

  t_read_blocks_log rblog;

  t_popup popup_list;
  t_filedialog fdialog;

} t_run_status;

///All Status
typedef struct
{
  t_app_status *app;
  t_run_status *run;
} t_all_data;

/// Functions
/// Window
GtkWidget *create_window (gpointer all);
void window_destroy (GtkObject * object, gpointer tmp);

GtkWidget *dialog_blklst_0 (gpointer tmp);
GtkWidget *dialog_blklst_1 (gpointer tmp);
GtkWidget *dialog_blklst_2 (gpointer tmp);

GtkWidget *dialog_opt_0 (gpointer tmp);
GtkWidget *dialog_opt_1 (gpointer tmp);
GtkWidget *dialog_opt_2 (gpointer tmp);
GtkWidget *dialog_opt_3 (gpointer tmp);

GtkWidget *dialog_wiz_0 (gpointer tmp);
GtkWidget *dialog_wiz_1 (gpointer tmp);
GtkWidget *dialog_wiz_2 (gpointer tmp);
GtkWidget *dialog_wiz_3 (gpointer tmp);
//GtkWidget *dialog_wiz_4 (gpointer tmp);

GtkWidget *dialog_append (gpointer tmp);

/// Menu
void on_quit1_activate (GtkMenuItem * menuitem, gpointer tmp);
void on_info_activate (GtkMenuItem * menuitem, gpointer tmp);
void on_rtime_activate (GtkMenuItem * menuitem, gpointer tmp);
void on_rcount_activate (GtkMenuItem * menuitem, gpointer tmp);
void on_openlog_menu_activate (GtkMenuItem * menuitem, gpointer tmp);
void on_openclp_menu_activate (GtkMenuItem * menuitem, gpointer tmp);
void on_viewmenu_select (GtkMenuItem * menuitem, gpointer tmp);
void on_viewmenu_changed (GtkRadioMenuItem * rmitem, gpointer tmp);
void on_timemenu_activate (GtkRadioMenuItem * item, gpointer tmp);
void on_freqmenu_activate (GtkRadioMenuItem * item, gpointer tmp);
void on_timefreqmenu_activate (GtkRadioMenuItem * item, gpointer tmp);
void on_freqtimemenu_activate (GtkRadioMenuItem * item, gpointer tmp);
void on_rblog_menu_activate (GtkRadioMenuItem * item, gpointer tmp);
void on_clphead_menu_activate (GtkRadioMenuItem * item, gpointer tmp);
void on_mkrh_menu_activate (GtkMenuItem * menuitem, gpointer tmp);
void on_optwiz_menu_activate (GtkMenuItem * menuitem, gpointer tmp);
void on_wizard_menu_activate (GtkMenuItem * menuitem, gpointer tmp);
void on_reset_menu_activate (GtkMenuItem * menuitem, gpointer tmp);

/// DrawArea
gboolean on_drawarea_expose (GtkWidget * widget, GdkEventExpose * event,
			     gpointer tmp);
gboolean on_drawarea_configure (GtkWidget * widget, GdkEventExpose * event,
				gpointer tmp);
gint on_drawarea_hovering (GtkWidget * widget, GdkEventMotion * event,
			   gpointer tmp);
gint on_drawarea_press (GtkWidget * widget, GdkEventButton * event,
			gpointer tmp);
gint on_drawarea_enter (GtkWidget * widget, GdkEventCrossing * event,
			gpointer tmp);
//TODO:check use state
gint on_drawarea_proxy (GtkWidget * widget, GdkEventProximity * event,
			gpointer tmp);

/// Widget Event
void on_update_clicked (GtkButton * button, gpointer tmp);
gboolean timescale_change_value (GtkRange * range, GtkScrollType arg1,
				 gdouble arg2, gpointer tmp);
void timescale_move_slider (GtkRange * range, GtkScrollType scroll,
			    gpointer tmp);
gboolean timescale_pressed (GtkWidget * widget, GdkEventButton * event,
			    gpointer tmp);
gboolean timescale_released (GtkWidget * widget, GdkEventButton * event,
			     gpointer tmp);
void on_stop_clicked (GtkButton * button, gpointer tmp);
void on_play_clicked (GtkButton * button, gpointer tmp);
void on_rewind_pressed (GtkButton * button, gpointer tmp);
void on_rewind_released (GtkButton * button, gpointer tmp);
void on_forward_pressed (GtkButton * button, gpointer tmp);
void on_forward_released (GtkButton * button, gpointer tmp);
void on_summary_changed (GtkWidget * widget, gpointer tmp);
void on_disp_changed (GtkWidget * widget, gpointer tmp);
void on_select_block (GtkWidget * widget, gint row, gint column,
		      GdkEventButton * event, gpointer tmp);
void on_unselect_block (GtkWidget * widget, gint row, gint column,
			GdkEventButton * event, gpointer tmp);

/// Timer Event
void stop_timer (gpointer tmp);
void reset_timer (gpointer tmp);

/// CloopProfiler's Function Define
void draw_initalize (gint summary_cnt, gpointer tmp);
void draw_view (gpointer tmp, gint ev_type);
void draw_blocks (t_all_data * all);
void play_label_change (gpointer tmp);
void on_clist_clicked (GtkCList * clist, gint column, gpointer tmp);
gint clist_compare (GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2);
//void dialog_message (gchar * message);
void dialog_message (const char *format, ...);
void ext_filename (gpointer tmp);
void quit_anyway (gpointer tmp);
void dialog_quit (gchar * message, gpointer tmp);
//void reset_popup(gpointer popup,gpointer tmp);
void reset_popup (GtkWidget * widget, GdkEventButton * event, gpointer tmp);

void check_draw_area (gpointer tmp);
void draw_one_frame (t_draw * blks, t_block * block, gint type, glong offset,
		     gpointer tmp);
void draw_one_block (t_draw * blks, t_block * block, gint type, glong offset,
		     gpointer tmp);

void analyze_cloop (gpointer tmp);
void analyze_read_log (gpointer tmp);

void draw_update (t_draw * blks);
void draw_timer (gpointer tmp);
void start_playing (gpointer tmp);
void pause_playing (gpointer tmp);
void get_summary_cnt (t_spin * summary);
void get_disp_state (t_combo * combo);

void set_select_mode (GtkButton * button, gpointer tmp);
void get_filename (gpointer tmp);

void check_name_input_mkrh (GtkEditable * edit, gpointer tmp);
void check_name_input_opt (GtkEditable * edit, gpointer tmp);
void check_name_input_wiz (GtkEditable * edit, gpointer tmp);
void check_name_input (GtkEditable * edit, gpointer tmp);

///Test
void play_label_change (gpointer tmp);
void clearance_field (gpointer tmp);

///Optimizer.
//void *cloop_optimizer (gpointer tmp);
void progress_change(void* tmp);
