/****************************************************************************/
/* The developnent of this program is partly supported by IPA.              */
/* (Infomation-Technology Promotion Agency, Japan).                         */
/****************************************************************************/

/****************************************************************************/
/*  interface.c                                                             */
/*  Copyright : Copyright (C) 2006 ALPHA SYSTEMS INC.                       */
/*  Authors : Daisuke Abe (abeda@alpha.co.jp)                               */
/*           ALPHA SYSTEMS INC. knoppix team(knoppix@alpha.co.jp)           */
/*                                                                          */
/*  This is free software; you can redistribute it and/or modify            */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This software is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this software; if not, write to the Free Software            */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  */
/*  USA.                                                                    */
/****************************************************************************/

/**
 * Comment for Doxygen
 * @file interface.c 
 * @author Daisuke Abe
 * @date 28/11/2005
 */

///Macro Defines
#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <glib.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "cloopprofiler.h"
#include "support.h"
#include "callbacks.h"
#include "log2list.h"
#include "cloop_optimizer.h"

/// Macro by Glade
#define HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

/**
 *
 *
 */
void
progress_change(void* tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  GtkWidget *pbar = dialog->progress.bar;

  if(do_optimize<1)return;

  gdk_threads_enter();
  //gtk_progress_set_value(GTK_PROGRESS(pbar),opt_progress*100);
  gtk_progress_set_percentage(GTK_PROGRESS(pbar),opt_progress);
  thread_flush();
  gdk_threads_leave();
}
/**
 *
 *
 */
void
ext_filename (gpointer tmp)
{
  t_run_status *run = ((t_all_data *) tmp)->run;
  t_filedialog *fdialog = &run->fdialog;

  if (fdialog->name == NULL)
    {
      fdialog->name = malloc (sizeof (gchar) * 512);
      if (fdialog->name == NULL)
	{
	  fprintf (stderr, "memory error.\n");
	  abort();
	  //exit (1);
	}
    }
  memset (fdialog->name, '\0', sizeof (gchar) * 512);

  strcpy (fdialog->name,
	  gtk_editable_get_chars ((GtkEditable *) fdialog->input, 0, 512));
  dbg ("get strings:%s\n", fdialog->name);

  return;
}

/**
 * @brief dialog_message - make dialog message
 * @param[in] message for dialog
 */
void
dialog_message(const gchar *format, ...)
//dialog_message (gchar * message)
{
  GtkWidget *dialog, *label, *okbutton;
  GtkRequisition req;
  va_list arg;
  gchar *msg;

  va_start(arg,format);
  //msg = malloc(sizeof(vfprintf(stdout,format,arg)));
  msg = malloc(sizeof(gchar)*1024);
  if(msg == NULL)
    {
      fprintf(stderr,"%s",ERR_MEMORY);
      abort();
    }
  memset(msg,'\0',sizeof(msg));
  vsprintf(msg,format,arg);
  va_end(arg);

  dbg("%s\n",msg);
  dialog = gtk_dialog_new ();
  label = gtk_label_new (msg);
  okbutton = gtk_button_new_with_label (LABEL_OK);
  
  gtk_widget_size_request(label,&req);

  if(req.width > 200)
    gtk_widget_set_size_request (dialog, req.width+50, 150);
  else
    gtk_widget_set_size_request (dialog, 300, 150);

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area),
		     okbutton);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label);
  
  gtk_signal_connect_object (GTK_OBJECT (okbutton),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), dialog);
  
  gtk_widget_show_all (dialog);
}

/**
 * @brief dialog_quit - make quit dialog
 * @param[in] - message for dialog
 * @param[in] - pointer that contains all @parameters
 */
void
dialog_quit (gchar * message, gpointer tmp)
{
  GtkWidget *dialog, *label, *yesbutton, *nobutton;
  t_app_status *app = ((t_all_data*)tmp)->app;

  dialog = gtk_dialog_new ();
  label = gtk_label_new (message);
  yesbutton = gtk_button_new_with_label ("Yes");
  nobutton = gtk_button_new_with_label ("No");

  gtk_signal_connect(GTK_OBJECT (yesbutton),
		     "clicked",
		     GTK_SIGNAL_FUNC (gtk_main_quit), 
		     app->window);
  gtk_signal_connect_object (GTK_OBJECT (yesbutton),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), dialog);
  gtk_signal_connect_object (GTK_OBJECT (nobutton),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), dialog);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      yesbutton, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      nobutton, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label);

  gtk_widget_show_all (dialog);
}

/**
 *
 *
 */
GtkWidget*
dialog_blklst_0 (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;  
  t_rblkstat2list *widget = dialog->blklst_widget;

  if(dialog->type != 0) return NULL;

  //t_rblkstat2list *dialog = &app->rblk2lst_dialog;

  GtkWidget *blocklist_window;
  GtkWidget *vbox2;
  GtkWidget *table1;
  GtkWidget *output_label;
  GtkWidget *output_entry;
  GtkWidget *input_entry;
  GtkWidget *output_button;
  GtkWidget *info_label1;
  GtkWidget *input_label;
  GtkWidget *input_button;
  GtkWidget *title_label1;
  GtkWidget *hbox1;
  GtkWidget *label89;
  GtkWidget *cancel_button1;
  GtkWidget *alignment14;
  GtkWidget *hbox17;
  GtkWidget *image14;
  GtkWidget *label90;
  GtkWidget *label91;
  GtkWidget *next_button1;
  GtkWidget *alignment15;
  GtkWidget *hbox18;
  GtkWidget *image15;
  GtkWidget *label92;
  GtkWidget *label93;
  GtkWidget *hbox_sc;
  GtkWidget *label_burst;
  GtkWidget *label_kb;
  GtkWidget *hscale;
  GtkWidget *spin;
  GtkObject *adj;

  blocklist_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (blocklist_window, 400, 250);
  gtk_window_set_title (GTK_WINDOW (blocklist_window),
			_(TITLE_BLKLST));
  gtk_window_set_resizable (GTK_WINDOW (blocklist_window), FALSE);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (blocklist_window), vbox2);

  table1 = gtk_table_new (8, 2, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (vbox2), table1, TRUE, TRUE, 0);

  output_label = gtk_label_new (_("Output File (\"KNOPPIX.blklist\")"));
  gtk_widget_show (output_label);
  gtk_table_attach (GTK_TABLE (table1), output_label, 0, 2, 4, 5,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (output_label), 0, 0.5);

  output_entry = gtk_entry_new ();
  gtk_widget_show (output_entry);
  gtk_table_attach (GTK_TABLE (table1), output_entry, 0, 1, 5, 6,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  input_entry = gtk_entry_new ();
  gtk_widget_show (input_entry);
  gtk_table_attach (GTK_TABLE (table1), input_entry, 0, 1, 3, 4,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  output_button = gtk_button_new_with_mnemonic (_(LABEL_SELECT));
  gtk_widget_show (output_button);
  gtk_table_attach (GTK_TABLE (table1), output_button, 1, 2, 5, 6,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  info_label1 = gtk_label_new (_("Choose Input/Output File"));
  gtk_widget_show (info_label1);
  gtk_table_attach (GTK_TABLE (table1), info_label1, 0, 2, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (info_label1), 0, 0.5);

  input_label = gtk_label_new (_("Input File(\"read_blocks\")"));
  gtk_widget_show (input_label);
  gtk_table_attach (GTK_TABLE (table1), input_label, 0, 2, 2, 3,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (input_label), 0, 0.5);

  input_button = gtk_button_new_with_mnemonic (_(LABEL_SELECT));
  gtk_widget_show (input_button);
  gtk_table_attach (GTK_TABLE (table1), input_button, 1, 2, 3, 4,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  title_label1 = gtk_label_new (_(LABEL_BLKLST));
  gtk_widget_show (title_label1);
  gtk_table_attach (GTK_TABLE (table1), title_label1, 0, 2, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (title_label1), 0, 0.5);

  hbox_sc = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox_sc);
  gtk_table_attach (GTK_TABLE (table1), hbox_sc, 0, 2, 7, 8,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  label_burst =
    gtk_label_new (_("burst block (use on cloopreadahead at boot)"));
  gtk_widget_show (label_burst);
  gtk_table_attach (GTK_TABLE (table1), label_burst, 0, 2, 6, 7,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_burst), 0, 0.5);

  adj = gtk_adjustment_new (256, 0, 1024, 4, 10, 10);
  hscale = gtk_hscale_new (GTK_ADJUSTMENT (adj));
  gtk_scale_set_digits (GTK_SCALE (hscale), 0);
  gtk_widget_show (hscale);
  gtk_box_pack_start (GTK_BOX (hbox_sc), hscale, TRUE, TRUE, 0);

  spin = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
  gtk_widget_show (spin);
  gtk_box_pack_start (GTK_BOX (hbox_sc), spin, FALSE, FALSE, 0);

  label_kb = gtk_label_new (_("[KB]"));
  gtk_widget_show (label_kb);
  gtk_box_pack_start (GTK_BOX (hbox_sc), label_kb, FALSE, FALSE, 0);

  hbox1 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox1, TRUE, TRUE, 0);

  label89 = gtk_label_new ("");
  gtk_widget_show (label89);
  gtk_box_pack_start (GTK_BOX (hbox1), label89, FALSE, FALSE, 0);

  cancel_button1 = gtk_button_new ();
  gtk_widget_show (cancel_button1);
  gtk_box_pack_start (GTK_BOX (hbox1), cancel_button1, FALSE, TRUE, 0);
  gtk_widget_set_size_request (cancel_button1, 70, 15);

  alignment14 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment14);
  gtk_container_add (GTK_CONTAINER (cancel_button1), alignment14);

  hbox17 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox17);
  gtk_container_add (GTK_CONTAINER (alignment14), hbox17);

  image14 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image14);
  gtk_box_pack_start (GTK_BOX (hbox17), image14, FALSE, FALSE, 0);

  label90 = gtk_label_new_with_mnemonic (_(LABEL_CANCEL));
  gtk_widget_show (label90);
  gtk_box_pack_start (GTK_BOX (hbox17), label90, FALSE, FALSE, 0);

  label91 = gtk_label_new ("");
  gtk_widget_show (label91);
  gtk_box_pack_start (GTK_BOX (hbox1), label91, FALSE, FALSE, 0);

  next_button1 = gtk_button_new ();
  gtk_widget_show (next_button1);
  gtk_box_pack_start (GTK_BOX (hbox1), next_button1, TRUE, TRUE, 0);
  gtk_widget_set_size_request (next_button1, 57, 15);

  alignment15 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment15);
  gtk_container_add (GTK_CONTAINER (next_button1), alignment15);

  hbox18 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox18);
  gtk_container_add (GTK_CONTAINER (alignment15), hbox18);

  image15 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image15);
  gtk_box_pack_start (GTK_BOX (hbox18), image15, FALSE, FALSE, 0);

  label92 = gtk_label_new_with_mnemonic (_(LABEL_NEXT));
  gtk_widget_show (label92);
  gtk_box_pack_start (GTK_BOX (hbox18), label92, FALSE, FALSE, 0);

  label93 = gtk_label_new ("");
  gtk_widget_show (label93);
  gtk_box_pack_start (GTK_BOX (hbox1), label93, FALSE, FALSE, 0);

  dialog->next_button[dialog->wid] = next_button1;
  dialog->cancel_button[dialog->wid] = cancel_button1;
  widget->input_entry = input_entry;
  widget->input_button = input_button;
  widget->output_entry = output_entry;
  widget->output_button = output_button;

  dialog->spin.hscale = hscale;
  dialog->spin.spin = spin;
  dialog->spin.adjustment = adj;

  //gtk_window_get_position(GTK_WINDOW(app->window),&x,&y);
  //gtk_window_set_position(blocklist_window,x+50,y+50);
  gtk_window_set_position (GTK_WINDOW (blocklist_window), GTK_WIN_POS_CENTER);

  return blocklist_window;
}


/**
 *
 *
 */
GtkWidget *
dialog_blklst_1 (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  //t_rblkstat2list *widget = dialog->blklst_widget;
  if(dialog->type != BLKLST)return NULL;

  //t_rblkstat2list *dialog = &app->rblk2lst_dialog;

  GtkWidget *blocklist_window;
  GtkWidget *vbox3;
  GtkWidget *table6;
  GtkWidget *info_label2;
  GtkWidget *title_label2;
  GtkWidget *convert_progress_bar;
  GtkWidget *spacer_label;
  GtkWidget *hbox2;
  GtkWidget *label98;
  GtkWidget *cancel_button2;
  GtkWidget *alignment16;
  GtkWidget *hbox20;
  GtkWidget *image16;
  GtkWidget *label99;
  GtkWidget *label100;
  GtkWidget *next_button2;
  GtkWidget *alignment17;
  GtkWidget *hbox21;
  GtkWidget *image17;
  GtkWidget *label101;
  GtkWidget *label102;

  GtkObject *adj;

  blocklist_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (blocklist_window, 400, 250);
  gtk_window_set_title (GTK_WINDOW (blocklist_window),
			_(TITLE_BLKLST));
  gtk_window_set_resizable (GTK_WINDOW (blocklist_window), FALSE);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (blocklist_window), vbox3);

  table6 = gtk_table_new (4, 1, FALSE);
  gtk_widget_show (table6);
  gtk_box_pack_start (GTK_BOX (vbox3), table6, TRUE, TRUE, 0);

  info_label2 = gtk_label_new (_(MSG_BLKMAKE_1));
  gtk_widget_show (info_label2);
  gtk_table_attach (GTK_TABLE (table6), info_label2, 0, 1, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (info_label2), 0, 0.5);

  title_label2 = gtk_label_new (_(LABEL_BLKLST));
  gtk_widget_show (title_label2);
  gtk_table_attach (GTK_TABLE (table6), title_label2, 0, 1, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (title_label2), 0, 0.5);

  adj = gtk_adjustment_new (0, 0, 100, 1, 1, 1);

  convert_progress_bar = gtk_progress_bar_new ();
  gtk_progress_set_show_text (GTK_PROGRESS (convert_progress_bar), TRUE);
  gtk_progress_set_adjustment(GTK_PROGRESS (convert_progress_bar), GTK_ADJUSTMENT(adj));
  gtk_widget_show (convert_progress_bar);
  gtk_table_attach (GTK_TABLE (table6), convert_progress_bar, 0, 1, 2, 3,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  spacer_label = gtk_label_new (_("\n\n\n\n\n"));
  gtk_widget_show (spacer_label);
  gtk_table_attach (GTK_TABLE (table6), spacer_label, 0, 1, 3, 4,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (spacer_label), 0, 0.5);

  hbox2 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox2, TRUE, TRUE, 0);

  label98 = gtk_label_new ("");
  gtk_widget_show (label98);
  gtk_box_pack_start (GTK_BOX (hbox2), label98, FALSE, FALSE, 0);

  cancel_button2 = gtk_button_new ();
  gtk_widget_show (cancel_button2);
  gtk_box_pack_start (GTK_BOX (hbox2), cancel_button2, FALSE, TRUE, 0);
  gtk_widget_set_size_request (cancel_button2, 70, 15);

  alignment16 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment16);
  gtk_container_add (GTK_CONTAINER (cancel_button2), alignment16);

  hbox20 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox20);
  gtk_container_add (GTK_CONTAINER (alignment16), hbox20);

  image16 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image16);
  gtk_box_pack_start (GTK_BOX (hbox20), image16, FALSE, FALSE, 0);

  label99 = gtk_label_new_with_mnemonic (_(LABEL_CANCEL));
  gtk_widget_show (label99);
  gtk_box_pack_start (GTK_BOX (hbox20), label99, FALSE, FALSE, 0);

  label100 = gtk_label_new ("");
  gtk_widget_show (label100);
  gtk_box_pack_start (GTK_BOX (hbox2), label100, FALSE, FALSE, 0);

  next_button2 = gtk_button_new ();
  gtk_widget_show (next_button2);
  gtk_box_pack_start (GTK_BOX (hbox2), next_button2, TRUE, TRUE, 0);
  gtk_widget_set_size_request (next_button2, 57, 15);

  alignment17 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment17);
  gtk_container_add (GTK_CONTAINER (next_button2), alignment17);

  hbox21 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox21);
  gtk_container_add (GTK_CONTAINER (alignment17), hbox21);

  image17 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image17);
  gtk_box_pack_start (GTK_BOX (hbox21), image17, FALSE, FALSE, 0);

  label101 = gtk_label_new_with_mnemonic (_(LABEL_NEXT));
  gtk_widget_show (label101);
  gtk_box_pack_start (GTK_BOX (hbox21), label101, FALSE, FALSE, 0);

  label102 = gtk_label_new ("");
  gtk_widget_show (label102);
  gtk_box_pack_start (GTK_BOX (hbox2), label102, FALSE, FALSE, 0);

  dialog->next_button[dialog->wid] = next_button2;
  dialog->cancel_button[dialog->wid] = cancel_button2;
  dialog->progress.bar = convert_progress_bar;
  dialog->progress.label = info_label2;
  dialog->progress.adj = adj;

  //gtk_window_get_position(GTK_WINDOW(app->window),&x,&y);
  //gtk_window_set_position(blocklist_window,x+50,y+50);
  gtk_window_set_position (GTK_WINDOW (blocklist_window), GTK_WIN_POS_CENTER);

  return blocklist_window;

}

/**
 *
 *
 */
GtkWidget *
dialog_blklst_2 (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  //t_rblkstat2list *widget = dialog->blklst_widget;
  if(dialog->type != BLKLST)return NULL;

  GtkWidget *blocklist_window;
  GtkWidget *vbox4;
  GtkWidget *table7;
  GtkWidget *title_label3;
  GtkWidget *info_label3;
  GtkWidget *label113;
  GtkWidget *hbox3;
  GtkWidget *label108;
  GtkWidget *cancel_button3;
  GtkWidget *alignment18;
  GtkWidget *hbox23;
  GtkWidget *image18;
  GtkWidget *label109;
  GtkWidget *label110;
  GtkWidget *next_button3;
  GtkWidget *alignment19;
  GtkWidget *hbox24;
  GtkWidget *image19;
  GtkWidget *label114;
  GtkWidget *label112;

  blocklist_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (blocklist_window, 400, 250);
  gtk_window_set_title (GTK_WINDOW (blocklist_window),
			_(TITLE_BLKLST));

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (blocklist_window), vbox4);

  table7 = gtk_table_new (3, 1, FALSE);
  gtk_widget_show (table7);
  gtk_box_pack_start (GTK_BOX (vbox4), table7, TRUE, TRUE, 0);

  title_label3 = gtk_label_new (_(LABEL_BLKLST));
  gtk_widget_show (title_label3);
  gtk_table_attach (GTK_TABLE (table7), title_label3, 0, 1, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (title_label3), 0, 0.5);

  info_label3 = gtk_label_new (_(MSG_BLKLST_2));
  gtk_widget_show (info_label3);
  gtk_table_attach (GTK_TABLE (table7), info_label3, 0, 1, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (info_label3), 0, 0.5);

  label113 = gtk_label_new (_("\n\n\n\n\n"));
  gtk_widget_show (label113);
  gtk_table_attach (GTK_TABLE (table7), label113, 0, 1, 2, 3,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label113), 0, 0.5);

  hbox3 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox3, TRUE, TRUE, 0);

  label108 = gtk_label_new ("");
  gtk_widget_show (label108);
  gtk_box_pack_start (GTK_BOX (hbox3), label108, FALSE, FALSE, 0);

  cancel_button3 = gtk_button_new ();
  gtk_widget_show (cancel_button3);
  gtk_box_pack_start (GTK_BOX (hbox3), cancel_button3, FALSE, TRUE, 0);

  alignment18 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment18);
  gtk_container_add (GTK_CONTAINER (cancel_button3), alignment18);

  hbox23 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox23);
  gtk_container_add (GTK_CONTAINER (alignment18), hbox23);

  image18 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image18);
  gtk_box_pack_start (GTK_BOX (hbox23), image18, FALSE, FALSE, 0);

  label109 = gtk_label_new_with_mnemonic (_(LABEL_CANCEL));
  gtk_widget_show (label109);
  gtk_box_pack_start (GTK_BOX (hbox23), label109, FALSE, FALSE, 0);

  label110 = gtk_label_new ("");
  gtk_widget_show (label110);
  gtk_box_pack_start (GTK_BOX (hbox3), label110, FALSE, FALSE, 0);

  next_button3 = gtk_button_new ();
  gtk_widget_show (next_button3);
  gtk_box_pack_start (GTK_BOX (hbox3), next_button3, TRUE, TRUE, 0);

  alignment19 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment19);
  gtk_container_add (GTK_CONTAINER (next_button3), alignment19);

  hbox24 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox24);
  gtk_container_add (GTK_CONTAINER (alignment19), hbox24);

  image19 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image19);
  gtk_box_pack_start (GTK_BOX (hbox24), image19, FALSE, FALSE, 0);

  label114 = gtk_label_new_with_mnemonic (_(LABEL_OK));
  gtk_widget_show (label114);
  gtk_box_pack_start (GTK_BOX (hbox24), label114, FALSE, FALSE, 0);

  label112 = gtk_label_new ("");
  gtk_widget_show (label112);
  gtk_box_pack_start (GTK_BOX (hbox3), label112, FALSE, FALSE, 0);

  dialog->next_button[dialog->wid] = next_button3;
  dialog->cancel_button[dialog->wid] = cancel_button3;

  //gtk_window_get_position(GTK_WINDOW(app->window),&x,&y);
  //gtk_window_set_position(blocklist_window,x+50,y+50);
  gtk_window_set_position (GTK_WINDOW (blocklist_window), GTK_WIN_POS_CENTER);
  return blocklist_window;

}

/**
 *
 *
 */
GtkWidget*
dialog_opt_0 (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  //t_clpoptimize *widget = dialog->opt_widget;
  if(dialog->type != OPTIMIZE)return NULL;

  //t_clpoptimize *dialog = &app->optimize_dialog;

  GtkWidget *opt_window4;
  GtkWidget *vbox4;
  GtkWidget *table4;
  GtkWidget *title_label4;
  GtkWidget *info_label4;
  GtkWidget *hbox10;
  GtkWidget *label38;
  GtkWidget *cancel_button4;
  GtkWidget *alignment7;
  GtkWidget *hbox11;
  GtkWidget *image7;
  GtkWidget *label39;
  GtkWidget *label40;
  GtkWidget *next_button4;
  GtkWidget *alignment10;
  GtkWidget *hbox15;
  GtkWidget *image10;
  GtkWidget *label49;
  GtkWidget *label42;

  opt_window4 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (opt_window4, 400, 250);
  gtk_window_set_title (GTK_WINDOW (opt_window4), _(TITLE_OPTWZD));
  gtk_window_set_resizable (GTK_WINDOW (opt_window4), FALSE);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (opt_window4), vbox4);

  table4 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table4);
  gtk_box_pack_start (GTK_BOX (vbox4), table4, TRUE, TRUE, 0);

  title_label4 = gtk_label_new (_(LABEL_OPTWZD));
  gtk_widget_show (title_label4);
  gtk_table_attach (GTK_TABLE (table4), title_label4, 0, 2, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (title_label4), 0, 0.5);

  info_label4 = gtk_label_new (_("Cloop Optimize Wizard\n\n"));
  gtk_widget_show (info_label4);
  gtk_table_attach (GTK_TABLE (table4), info_label4, 0, 2, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (info_label4), 0, 0.5);

  hbox10 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox10);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox10, TRUE, TRUE, 0);

  label38 = gtk_label_new ("");
  gtk_widget_show (label38);
  gtk_box_pack_start (GTK_BOX (hbox10), label38, FALSE, FALSE, 0);

  cancel_button4 = gtk_button_new ();
  gtk_widget_show (cancel_button4);
  gtk_box_pack_start (GTK_BOX (hbox10), cancel_button4, FALSE, TRUE, 0);
  gtk_widget_set_size_request (cancel_button4, 70, 15);

  alignment7 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment7);
  gtk_container_add (GTK_CONTAINER (cancel_button4), alignment7);

  hbox11 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox11);
  gtk_container_add (GTK_CONTAINER (alignment7), hbox11);

  image7 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image7);
  gtk_box_pack_start (GTK_BOX (hbox11), image7, FALSE, FALSE, 0);

  label39 = gtk_label_new_with_mnemonic (_(LABEL_CANCEL));
  gtk_widget_show (label39);
  gtk_box_pack_start (GTK_BOX (hbox11), label39, FALSE, FALSE, 0);

  label40 = gtk_label_new ("");
  gtk_widget_show (label40);
  gtk_box_pack_start (GTK_BOX (hbox10), label40, FALSE, FALSE, 0);

  next_button4 = gtk_button_new ();
  gtk_widget_show (next_button4);
  gtk_box_pack_start (GTK_BOX (hbox10), next_button4, TRUE, TRUE, 0);
  gtk_widget_set_size_request (next_button4, 57, 15);

  alignment10 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment10);
  gtk_container_add (GTK_CONTAINER (next_button4), alignment10);

  hbox15 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox15);
  gtk_container_add (GTK_CONTAINER (alignment10), hbox15);

  image10 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image10);
  gtk_box_pack_start (GTK_BOX (hbox15), image10, FALSE, FALSE, 0);

  label49 = gtk_label_new_with_mnemonic (_(LABEL_NEXT));
  gtk_widget_show (label49);
  gtk_box_pack_start (GTK_BOX (hbox15), label49, FALSE, FALSE, 0);

  label42 = gtk_label_new ("");
  gtk_widget_show (label42);
  gtk_box_pack_start (GTK_BOX (hbox10), label42, FALSE, FALSE, 0);

  dialog->next_button[dialog->wid] = next_button4;
  dialog->cancel_button[dialog->wid] = cancel_button4;

  //gtk_window_get_position(GTK_WINDOW(app->window),&x,&y);
  //gtk_window_set_position(opt_window4,x+50,y+50);
  gtk_window_set_position (GTK_WINDOW (opt_window4), GTK_WIN_POS_CENTER);

  return opt_window4;
}

/**
 *
 *
 */
GtkWidget *
dialog_opt_1 (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  t_clpoptimize *widget = dialog->opt_widget;
  if(dialog->type != OPTIMIZE) return NULL;

  //t_clpoptimize *dialog = &app->optimize_dialog;
  //t_rblkstat2list *dialog = &app->rblk2lst_dialog;

  GtkWidget *opt_window1;
  GtkWidget *vbox1;
  GtkWidget *table1;
  GtkWidget *blklstinput_label;
  GtkWidget *blklistinput_entry;
  GtkWidget *clpinput_entry;
  GtkWidget *blklistinput_button;
  GtkWidget *info_label1;
  GtkWidget *clpinput_label;
  GtkWidget *clpinput_button;
  GtkWidget *title_label1;
  GtkWidget *clpoutput_button;
  GtkWidget *clpoutput_entry;
  GtkWidget *clpoutput_label;
#if 0
  GtkWidget *blklstoutput_button;
  GtkWidget *blklstoutput_entry;
  GtkWidget *blklstoutput_label;
#endif /* 0 */
  GtkWidget *hbox1;
  GtkWidget *label5;
  GtkWidget *cancel_button1;
  GtkWidget *alignment1;
  GtkWidget *hbox2;
  GtkWidget *image1;
  GtkWidget *label6;
  GtkWidget *label7;
  GtkWidget *next_button1;
  GtkWidget *alignment2;
  GtkWidget *hbox3;
  GtkWidget *image2;
  GtkWidget *label8;
  GtkWidget *label9;

  opt_window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (opt_window1, 400, 250);
  gtk_window_set_title (GTK_WINDOW (opt_window1), _(TITLE_OPTWZD));
  gtk_window_set_resizable (GTK_WINDOW (opt_window1), FALSE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (opt_window1), vbox1);

  table1 = gtk_table_new (10, 2, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (vbox1), table1, TRUE, TRUE, 0);

  blklstinput_label =
    gtk_label_new (_("Input Block List(\"KNOPPIX.blklst\")"));
  gtk_widget_show (blklstinput_label);
  gtk_table_attach (GTK_TABLE (table1), blklstinput_label, 0, 2, 4, 5,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (blklstinput_label), 0, 0.5);

  blklistinput_entry = gtk_entry_new ();
  gtk_widget_show (blklistinput_entry);
  gtk_table_attach (GTK_TABLE (table1), blklistinput_entry, 0, 1, 5, 6,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  clpinput_entry = gtk_entry_new ();
  gtk_widget_show (clpinput_entry);
  gtk_table_attach (GTK_TABLE (table1), clpinput_entry, 0, 1, 3, 4,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  blklistinput_button = gtk_button_new_with_mnemonic (_(LABEL_SELECT));
  gtk_widget_show (blklistinput_button);
  gtk_table_attach (GTK_TABLE (table1), blklistinput_button, 1, 2, 5, 6,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  info_label1 = gtk_label_new (_("Choose  Files"));
  gtk_widget_show (info_label1);
  gtk_table_attach (GTK_TABLE (table1), info_label1, 0, 2, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (info_label1), 0, 0.5);

  clpinput_label = gtk_label_new (_("Input Cloop(\"KNOPPIX\")"));
  gtk_widget_show (clpinput_label);
  gtk_table_attach (GTK_TABLE (table1), clpinput_label, 0, 2, 2, 3,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (clpinput_label), 0, 0.5);

  clpinput_button = gtk_button_new_with_mnemonic (_(LABEL_SELECT));
  gtk_widget_show (clpinput_button);
  gtk_table_attach (GTK_TABLE (table1), clpinput_button, 1, 2, 3, 4,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  title_label1 = gtk_label_new (_(LABEL_OPTWZD));
  gtk_widget_show (title_label1);
  gtk_table_attach (GTK_TABLE (table1), title_label1, 0, 2, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (title_label1), 0, 0.5);

  clpoutput_button = gtk_button_new_with_mnemonic (_(LABEL_SELECT));
  gtk_widget_show (clpoutput_button);
  gtk_table_attach (GTK_TABLE (table1), clpoutput_button, 1, 2, 7, 8,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  clpoutput_entry = gtk_entry_new ();
  gtk_widget_show (clpoutput_entry);
  gtk_table_attach (GTK_TABLE (table1), clpoutput_entry, 0, 1, 7, 8,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  clpoutput_label = gtk_label_new (_("Output Cloop(\"KNOPPIX.opt\")"));
  gtk_widget_show (clpoutput_label);
  gtk_table_attach (GTK_TABLE (table1), clpoutput_label, 0, 2, 6, 7,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (clpoutput_label), 0, 0.5);

#if 0
  blklstoutput_button = gtk_button_new_with_mnemonic (_(LABEL_SELECT));
  gtk_widget_show (blklstoutput_button);
  gtk_table_attach (GTK_TABLE (table1), blklstoutput_button, 1, 2, 9, 10,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  blklstoutput_entry = gtk_entry_new ();
  gtk_widget_show (blklstoutput_entry);
  gtk_table_attach (GTK_TABLE (table1), blklstoutput_entry, 0, 1, 9, 10,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  blklstoutput_label =
    gtk_label_new (_("Output Block List Path(\"KNOPPIX.blklst\")"));
  gtk_widget_show (blklstoutput_label);
  gtk_table_attach (GTK_TABLE (table1), blklstoutput_label, 0, 2, 8, 9,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (blklstoutput_label), 0, 0.5);
#endif /* 0 */

  hbox1 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  label5 = gtk_label_new ("");
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (hbox1), label5, FALSE, FALSE, 0);

  cancel_button1 = gtk_button_new ();
  gtk_widget_show (cancel_button1);
  gtk_box_pack_start (GTK_BOX (hbox1), cancel_button1, FALSE, TRUE, 0);
  gtk_widget_set_size_request (cancel_button1, 70, 15);

  alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (cancel_button1), alignment1);

  hbox2 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox2);
  gtk_container_add (GTK_CONTAINER (alignment1), hbox2);

  image1 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image1);
  gtk_box_pack_start (GTK_BOX (hbox2), image1, FALSE, FALSE, 0);

  label6 = gtk_label_new_with_mnemonic (_(LABEL_CANCEL));
  gtk_widget_show (label6);
  gtk_box_pack_start (GTK_BOX (hbox2), label6, FALSE, FALSE, 0);

  label7 = gtk_label_new ("");
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (hbox1), label7, FALSE, FALSE, 0);

  next_button1 = gtk_button_new ();
  gtk_widget_show (next_button1);
  gtk_box_pack_start (GTK_BOX (hbox1), next_button1, TRUE, TRUE, 0);
  gtk_widget_set_size_request (next_button1, 57, 15);

  alignment2 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment2);
  gtk_container_add (GTK_CONTAINER (next_button1), alignment2);

  hbox3 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox3);
  gtk_container_add (GTK_CONTAINER (alignment2), hbox3);

  image2 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image2);
  gtk_box_pack_start (GTK_BOX (hbox3), image2, FALSE, FALSE, 0);

  label8 = gtk_label_new_with_mnemonic (_(LABEL_NEXT));
  gtk_widget_show (label8);
  gtk_box_pack_start (GTK_BOX (hbox3), label8, FALSE, FALSE, 0);

  label9 = gtk_label_new ("");
  gtk_widget_show (label9);
  gtk_box_pack_start (GTK_BOX (hbox1), label9, FALSE, FALSE, 0);

  dialog->next_button[dialog->wid] = next_button1;
  dialog->cancel_button[dialog->wid] = cancel_button1;
  widget->inputblklst_entry = blklistinput_entry;
  widget->inputblklst_button = blklistinput_button;
  widget->inputclp_entry = clpinput_entry;
  widget->inputclp_button = clpinput_button;

  widget->outputclp_entry = clpoutput_entry;
  widget->outputclp_button = clpoutput_button;

  //gtk_window_get_position(GTK_WINDOW(app->window),&x,&y);
  //gtk_window_set_position(opt_window1,x+50,y+50);
  gtk_window_set_position (GTK_WINDOW (opt_window1), GTK_WIN_POS_CENTER);
  return opt_window1;
}

/**
 *
 *
 */
GtkWidget*
dialog_opt_2 (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  //t_clpoptimize *widget = dialog->opt_widget;
  if(dialog->type != OPTIMIZE)return NULL;

  GtkWidget *opt_window2;
  GtkWidget *vbox2;
  GtkWidget *table2;
  GtkWidget *title_label2;
  GtkWidget *info_label2;
  GtkWidget *opt_progressbar;
  GtkWidget *spacer;
  GtkWidget *hbox4;
  GtkWidget *label18;
  GtkWidget *cancel_button2;
  GtkWidget *alignment3;
  GtkWidget *hbox5;
  GtkWidget *image3;
  GtkWidget *label19;
  GtkWidget *label20;
  GtkWidget *next_button2;
  GtkWidget *alignment4;
  GtkWidget *hbox6;
  GtkWidget *image4;
  GtkWidget *label21;
  GtkWidget *label22;

  GtkObject *adj;

  opt_window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (opt_window2, 400, 250);
  gtk_window_set_title (GTK_WINDOW (opt_window2), _(TITLE_OPTWZD));
  gtk_window_set_resizable (GTK_WINDOW (opt_window2), FALSE);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (opt_window2), vbox2);

  table2 = gtk_table_new (4, 2, FALSE);
  gtk_widget_show (table2);
  gtk_box_pack_start (GTK_BOX (vbox2), table2, TRUE, TRUE, 0);

  title_label2 = gtk_label_new (_(LABEL_OPTWZD));
  gtk_widget_show (title_label2);
  gtk_table_attach (GTK_TABLE (table2), title_label2, 0, 2, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (title_label2), 0, 0.5);

  info_label2 = gtk_label_new (_(MSG_OPTMIZ_1));
  gtk_widget_show (info_label2);
  gtk_table_attach (GTK_TABLE (table2), info_label2, 0, 2, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (info_label2), 0, 0.5);

  adj = gtk_adjustment_new (0, 0, 100, 1, 1, 1);

  opt_progressbar = gtk_progress_bar_new ();
  gtk_progress_set_show_text (GTK_PROGRESS (opt_progressbar), TRUE);
  gtk_progress_set_adjustment (GTK_PROGRESS (opt_progressbar), GTK_ADJUSTMENT(adj));
  gtk_widget_show (opt_progressbar);
  gtk_table_attach (GTK_TABLE (table2), opt_progressbar, 0, 2, 2, 3,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  spacer = gtk_label_new (_("\n\n\n\n"));
  gtk_widget_show (spacer);
  gtk_table_attach (GTK_TABLE (table2), spacer, 0, 2, 3, 4,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (spacer), 0, 0.5);

  hbox4 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox4, TRUE, TRUE, 0);

  label18 = gtk_label_new ("");
  gtk_widget_show (label18);
  gtk_box_pack_start (GTK_BOX (hbox4), label18, FALSE, FALSE, 0);

  cancel_button2 = gtk_button_new ();
  gtk_widget_show (cancel_button2);
  gtk_box_pack_start (GTK_BOX (hbox4), cancel_button2, FALSE, TRUE, 0);
  gtk_widget_set_size_request (cancel_button2, 70, 15);

  alignment3 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment3);
  gtk_container_add (GTK_CONTAINER (cancel_button2), alignment3);

  hbox5 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox5);
  gtk_container_add (GTK_CONTAINER (alignment3), hbox5);

  image3 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image3);
  gtk_box_pack_start (GTK_BOX (hbox5), image3, FALSE, FALSE, 0);

  label19 = gtk_label_new_with_mnemonic (_(LABEL_CANCEL));
  gtk_widget_show (label19);
  gtk_box_pack_start (GTK_BOX (hbox5), label19, FALSE, FALSE, 0);

  label20 = gtk_label_new ("");
  gtk_widget_show (label20);
  gtk_box_pack_start (GTK_BOX (hbox4), label20, FALSE, FALSE, 0);

  next_button2 = gtk_button_new ();
  gtk_widget_show (next_button2);
  gtk_box_pack_start (GTK_BOX (hbox4), next_button2, TRUE, TRUE, 0);
  gtk_widget_set_size_request (next_button2, 57, 15);

  alignment4 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment4);
  gtk_container_add (GTK_CONTAINER (next_button2), alignment4);

  hbox6 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox6);
  gtk_container_add (GTK_CONTAINER (alignment4), hbox6);

  image4 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image4);
  gtk_box_pack_start (GTK_BOX (hbox6), image4, FALSE, FALSE, 0);

  label21 = gtk_label_new_with_mnemonic (_(LABEL_NEXT));
  gtk_widget_show (label21);
  gtk_box_pack_start (GTK_BOX (hbox6), label21, FALSE, FALSE, 0);

  label22 = gtk_label_new ("");
  gtk_widget_show (label22);
  gtk_box_pack_start (GTK_BOX (hbox4), label22, FALSE, FALSE, 0);

  dialog->next_button[dialog->wid] = next_button2;
  dialog->cancel_button[dialog->wid] = cancel_button2;
  dialog->progress.bar = opt_progressbar;
  dialog->progress.label = info_label2;
  dialog->progress.adj = adj;

  //gtk_window_get_position(GTK_WINDOW(app->window),&x,&y);
  //gtk_window_set_position(opt_window2,x+50,y+50);
  gtk_window_set_position (GTK_WINDOW (opt_window2), GTK_WIN_POS_CENTER);
  return opt_window2;
}

/**
 *
 *
 */
GtkWidget *
dialog_opt_3 (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  //t_clpoptimize *widget = dialog->opt_widget;
  if(dialog->type != OPTIMIZE)return NULL;

  GtkWidget *opt_window3;
  GtkWidget *vbox3;
  GtkWidget *table3;
  GtkWidget *title_label3;
  GtkWidget *info_label3;
  GtkWidget *hbox7;
  GtkWidget *label31;
  GtkWidget *cancel_button3;
  GtkWidget *alignment5;
  GtkWidget *hbox8;
  GtkWidget *image5;
  GtkWidget *label32;
  GtkWidget *label33;
  GtkWidget *next_button3;
  GtkWidget *alignment6;
  GtkWidget *hbox9;
  GtkWidget *image6;
  GtkWidget *label34;
  GtkWidget *label35;

  opt_window3 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (opt_window3, 400, 250);
  gtk_window_set_title (GTK_WINDOW (opt_window3), _(TITLE_OPTWZD));
  gtk_window_set_resizable (GTK_WINDOW (opt_window3), FALSE);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (opt_window3), vbox3);

  table3 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table3);
  gtk_box_pack_start (GTK_BOX (vbox3), table3, TRUE, TRUE, 0);

  title_label3 = gtk_label_new (_(TITLE_OPTWZD));
  gtk_widget_show (title_label3);
  gtk_table_attach (GTK_TABLE (table3), title_label3, 0, 2, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (title_label3), 0, 0.5);

  info_label3 = gtk_label_new (_(MSG_OPTWZD_2));
  gtk_widget_show (info_label3);
  gtk_table_attach (GTK_TABLE (table3), info_label3, 0, 2, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (info_label3), 0, 0.5);

  hbox7 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox7);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox7, TRUE, TRUE, 0);

  label31 = gtk_label_new ("");
  gtk_widget_show (label31);
  gtk_box_pack_start (GTK_BOX (hbox7), label31, FALSE, FALSE, 0);

  cancel_button3 = gtk_button_new ();
  gtk_widget_show (cancel_button3);
  gtk_box_pack_start (GTK_BOX (hbox7), cancel_button3, FALSE, TRUE, 0);
  gtk_widget_set_size_request (cancel_button3, 70, 15);

  alignment5 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment5);
  gtk_container_add (GTK_CONTAINER (cancel_button3), alignment5);

  hbox8 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox8);
  gtk_container_add (GTK_CONTAINER (alignment5), hbox8);

  image5 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image5);
  gtk_box_pack_start (GTK_BOX (hbox8), image5, FALSE, FALSE, 0);

  label32 = gtk_label_new_with_mnemonic (_(LABEL_CANCEL));
  gtk_widget_show (label32);
  gtk_box_pack_start (GTK_BOX (hbox8), label32, FALSE, FALSE, 0);

  label33 = gtk_label_new ("");
  gtk_widget_show (label33);
  gtk_box_pack_start (GTK_BOX (hbox7), label33, FALSE, FALSE, 0);

  next_button3 = gtk_button_new ();
  gtk_widget_show (next_button3);
  gtk_box_pack_start (GTK_BOX (hbox7), next_button3, TRUE, TRUE, 0);
  gtk_widget_set_size_request (next_button3, 57, 15);

  alignment6 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment6);
  gtk_container_add (GTK_CONTAINER (next_button3), alignment6);

  hbox9 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox9);
  gtk_container_add (GTK_CONTAINER (alignment6), hbox9);

  image6 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image6);
  gtk_box_pack_start (GTK_BOX (hbox9), image6, FALSE, FALSE, 0);

  label34 = gtk_label_new_with_mnemonic (_(LABEL_OK));
  gtk_widget_show (label34);
  gtk_box_pack_start (GTK_BOX (hbox9), label34, FALSE, FALSE, 0);

  label35 = gtk_label_new ("");
  gtk_widget_show (label35);
  gtk_box_pack_start (GTK_BOX (hbox7), label35, FALSE, FALSE, 0);

  dialog->next_button[dialog->wid] = next_button3;
  dialog->cancel_button[dialog->wid] = cancel_button3;

  //gtk_window_get_position(GTK_WINDOW(app->window),&x,&y);
  //gtk_window_set_position(opt_window3,x+50,y+50);
  gtk_window_set_position (GTK_WINDOW (opt_window3), GTK_WIN_POS_CENTER);
  return opt_window3;
}

#if 0
/**
 *
 *
 */
void
save_clist(GtkWidget *widget, gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_append *append = &app->append;
  GtkWidget *list = append->list;

  gint count = 0;
  gchar **textbuf = NULL;

  if(append->filename != NULL){
    
    free(append->filename);
  }
  append->filename = malloc(sizeof(gchar*));
  *(append->filename) = malloc(sizeof(gchar)*512);
  if(append->filename == NULL)
    {
      fprintf(stderr,ERR_MEMORY);
      abort();
    }
  memset(*(append->filename),'\0',sizeof(gchar)*512);
  
  textbuf = malloc(sizeof(gchar*));
  *(textbuf) = malloc(sizeof(gchar)*512);

  while(gtk_clist_get_text(GTK_CLIST(list),count,0,textbuf) > 0)
    {
      strcpy(*(append->filename+count),*textbuf);
      append->filename = realloc(append->filename,sizeof(gchar*)*(count+2));
      if(append->filename == NULL)
	{
	  fprintf(stderr,ERR_MEMORY);
	  abort();
	}
      count++;
      (*(append->filename+count)) = malloc(sizeof(gchar)*512);
      if(*(append->filename+count) == NULL)
	{
	  fprintf(stderr,ERR_MEMORY);
	  abort();
	}
      memset(*(append->filename+count),'\0',sizeof(gchar)*512);
    }
}

void
remove_from_list(GtkWidget *widget ,gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_append *append = &app->append;
  GtkWidget *list = append->list;

  gtk_clist_remove(GTK_CLIST(list),append->select_row);

}

void
move_up(GtkWidget *widget ,gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_append *append = &app->append;
  GtkWidget *list = append->list;
  
  gtk_clist_row_move(GTK_CLIST(list),append->select_row,append->select_row-1);
  append->select_row--;
}

void
move_down(GtkWidget *widget ,gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_append *append = &app->append;
  GtkWidget *list = append->list;

  gtk_clist_row_move(GTK_CLIST(list),append->select_row,append->select_row+1);
  append->select_row++;
}

void
get_row(GtkCList *list, gint row, gint column, GdkEventButton *event, gpointer tmp)
{
  t_append *append = (t_append*)tmp;
  append->select_row = row;
}

GtkWidget*
dialog_append(gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_append *append = &app->append;

  GtkWidget *append_window;
  GtkWidget *vbox2;
  GtkWidget *ab_label;
  GtkWidget *scrolledwindow1;
  GtkWidget *viewport1;
  GtkWidget *hbox4;
  GtkWidget *scrolledwindow2;
  GtkWidget *clist1;
  GtkWidget *label28;
  GtkWidget *vbox3;
  GtkWidget *down_button;
  GtkWidget *image13;
  GtkWidget *up_button;
  GtkWidget *image12;
  GtkWidget *hbox5;
  GtkWidget *append_button;
  GtkWidget *alignment11;
  GtkWidget *hbox22;
  GtkWidget *image8;
  GtkWidget *label32;
  GtkWidget *remove_button;
  GtkWidget *alignment10;
  GtkWidget *hbox21;
  GtkWidget *image7;
  GtkWidget *label31;
  GtkWidget *ok_button;
  GtkWidget *alignment12;
  GtkWidget *hbox23;
  GtkWidget *image9;
  GtkWidget *label33;

  gint count = 0;

  append_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (append_window, 700, 400);
  gtk_window_set_title (GTK_WINDOW (append_window), _("Append Application Block List"));
  gtk_window_set_resizable (GTK_WINDOW (append_window), FALSE);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (append_window), vbox2);

  ab_label = gtk_label_new (_("Input Application Blocklist"));
  gtk_widget_show (ab_label);
  gtk_box_pack_start (GTK_BOX (vbox2), ab_label, FALSE, FALSE, 3);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox2), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_NEVER);

  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), viewport1);
  gtk_viewport_set_shadow_type (GTK_VIEWPORT (viewport1), GTK_SHADOW_NONE);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox4);
  gtk_container_add (GTK_CONTAINER (viewport1), hbox4);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (hbox4), scrolledwindow2, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_placement (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_CORNER_TOP_RIGHT);

  clist1 = gtk_clist_new (1);
  gtk_widget_show (clist1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), clist1);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 80);
  gtk_clist_column_titles_hide (GTK_CLIST (clist1));
  gtk_clist_set_shadow_type (GTK_CLIST (clist1), GTK_SHADOW_NONE);
      
  label28 = gtk_label_new (_("label28"));
  gtk_widget_show (label28);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label28);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_box_pack_end (GTK_BOX (hbox4), vbox3, FALSE, FALSE, 0);

  down_button = gtk_button_new ();
  gtk_widget_show (down_button);
  gtk_box_pack_end (GTK_BOX (vbox3), down_button, TRUE, FALSE, 0);
  gtk_widget_set_size_request (down_button, 20, 60);

  image13 = gtk_image_new_from_stock ("gtk-go-down", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image13);
  gtk_container_add (GTK_CONTAINER (down_button), image13);

  up_button = gtk_button_new ();
  gtk_widget_show (up_button);
  gtk_box_pack_end (GTK_BOX (vbox3), up_button, TRUE, FALSE, 0);
  gtk_widget_set_size_request (up_button, 29, 60);

  image12 = gtk_image_new_from_stock ("gtk-go-up", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image12);
  gtk_container_add (GTK_CONTAINER (up_button), image12);

  hbox5 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox5, FALSE, FALSE, 0);

  append_button = gtk_button_new ();
  gtk_widget_show (append_button);
  gtk_box_pack_start (GTK_BOX (hbox5), append_button, FALSE, FALSE, 0);

  alignment11 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment11);
  gtk_container_add (GTK_CONTAINER (append_button), alignment11);

  hbox22 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox22);
  gtk_container_add (GTK_CONTAINER (alignment11), hbox22);

  image8 = gtk_image_new_from_stock ("gtk-new", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image8);
  gtk_box_pack_start (GTK_BOX (hbox22), image8, FALSE, FALSE, 0);

  label32 = gtk_label_new_with_mnemonic (_("Append"));
  gtk_widget_show (label32);
  gtk_box_pack_start (GTK_BOX (hbox22), label32, FALSE, FALSE, 0);

  remove_button = gtk_button_new ();
  gtk_widget_show (remove_button);
  gtk_box_pack_start (GTK_BOX (hbox5), remove_button, FALSE, FALSE, 0);

  alignment10 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment10);
  gtk_container_add (GTK_CONTAINER (remove_button), alignment10);

  hbox21 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox21);
  gtk_container_add (GTK_CONTAINER (alignment10), hbox21);

  image7 = gtk_image_new_from_stock ("gtk-clear", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image7);
  gtk_box_pack_start (GTK_BOX (hbox21), image7, FALSE, FALSE, 0);

  label31 = gtk_label_new_with_mnemonic (_("remove"));
  gtk_widget_show (label31);
  gtk_box_pack_start (GTK_BOX (hbox21), label31, FALSE, FALSE, 0);

  ok_button = gtk_button_new ();
  gtk_widget_show (ok_button);
  gtk_box_pack_start (GTK_BOX (hbox5), ok_button, FALSE, FALSE, 0);

  alignment12 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment12);
  gtk_container_add (GTK_CONTAINER (ok_button), alignment12);

  hbox23 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox23);
  gtk_container_add (GTK_CONTAINER (alignment12), hbox23);

  image9 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image9);
  gtk_box_pack_start (GTK_BOX (hbox23), image9, FALSE, FALSE, 0);

  label33 = gtk_label_new_with_mnemonic (_("   OK   "));
  gtk_widget_show (label33);
  gtk_box_pack_start (GTK_BOX (hbox23), label33, FALSE, FALSE, 0);
  
  if(append->filename != NULL)
    {
      dbg("replace saved filename.\n");
      dbg("strlen(append->filename) : %lu\n",sizeof((gchar**)append->filename));
      dbg("sizeof(append->filename) : %lu \n",strlen(*(append->filename)));
      dbg("sizeof(gchar*)           : %lu \n",sizeof(gchar));

      //for (count = 0;count < sizeof(append->filename)/(sizeof(gchar*));count++)
      count = 0;
      while(strlen(*(append->filename+count)) > 0)
	{
	  dbg("%s\n",*(append->filename+count));
	  //gtk_clist_set_text(GTK_CLIST(clist1),0,count,*(append->filename+count++));
	  gtk_clist_append(GTK_CLIST(clist1),(append->filename+count));
	  count++;
	}
#if 0
      for (count = 0;count < sizeof(append->filename)/sizeof(gchar*);count++)
	{
	  dbg("count : %d\n",count);
	  dbg("%s\n",*(append->filename+count));
	  gtk_clist_set_row_data(GTK_CLIST(clist1),count,*(append->filename+count));
	}
#endif /* 0 */

    }

  append->up_button = up_button;
  append->down_button = down_button;
  append->list = clist1;
  append->append_button = append_button;
  append->remove_button = remove_button;
  append->ok_button = ok_button;


  gtk_signal_connect (GTK_OBJECT (append_window),
		      "destroy", GTK_SIGNAL_FUNC (resensitive_dialog),
		      (gpointer) tmp);
  gtk_signal_connect (GTK_OBJECT (append->append_button),
		     "clicked",
		     GTK_SIGNAL_FUNC (set_select_mode), (gpointer) tmp);  
  gtk_signal_connect_object (GTK_OBJECT (append->append_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (get_filename), (gpointer) tmp);
  
  gtk_signal_connect (GTK_OBJECT (append->remove_button),
		      "clicked",
		      GTK_SIGNAL_FUNC (remove_from_list), (gpointer) tmp);
  gtk_signal_connect (GTK_OBJECT (append->up_button),
		      "clicked",
		      GTK_SIGNAL_FUNC (move_up), (gpointer) tmp);
  gtk_signal_connect (GTK_OBJECT (append->down_button),
		      "clicked",
			  GTK_SIGNAL_FUNC (move_down), (gpointer) tmp);
  
  gtk_signal_connect (GTK_OBJECT(append->list),
		      "select-row",
		      GTK_SIGNAL_FUNC(get_row), (gpointer)append);

  gtk_signal_connect (GTK_OBJECT (append->ok_button),
		      "clicked",
		      GTK_SIGNAL_FUNC (save_clist), (gpointer) tmp);
  gtk_signal_connect (GTK_OBJECT (append->ok_button),
		     "clicked",
		     GTK_SIGNAL_FUNC (set_select_mode), (gpointer) tmp);  
  gtk_signal_connect_object (GTK_OBJECT (append->ok_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			     append_window);

  gtk_window_set_position (GTK_WINDOW (append_window), GTK_WIN_POS_CENTER);

  return append_window;
}
#endif /* 0 */

/**
 *
 *
 */
GtkWidget *
dialog_wiz_0 (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  if(dialog->type != WIZARD) return NULL;

  GtkWidget *opt_window4;
  GtkWidget *vbox4;
  GtkWidget *table4;
  GtkWidget *title_label4;
  GtkWidget *info_label4;
  GtkWidget *hbox10;
  GtkWidget *label38;
  GtkWidget *cancel_button4;
  GtkWidget *alignment7;
  GtkWidget *hbox11;
  GtkWidget *image7;
  GtkWidget *label39;
  GtkWidget *label40;
  GtkWidget *next_button4;
  GtkWidget *alignment10;
  GtkWidget *hbox15;
  GtkWidget *image10;
  GtkWidget *label49;
  GtkWidget *label42;

  opt_window4 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (opt_window4, 400, 250);
  gtk_window_set_title (GTK_WINDOW (opt_window4), _("Acceleration Cloop"));
  gtk_window_set_resizable (GTK_WINDOW (opt_window4), FALSE);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (opt_window4), vbox4);

  table4 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table4);
  gtk_box_pack_start (GTK_BOX (vbox4), table4, TRUE, TRUE, 0);

  title_label4 = gtk_label_new (_(LABEL_OPTWZD));
  gtk_widget_show (title_label4);
  gtk_table_attach (GTK_TABLE (table4), title_label4, 0, 2, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (title_label4), 0, 0.5);

  info_label4 = gtk_label_new (_(MSG_OPTWZD_1));
  gtk_widget_show (info_label4);
  gtk_table_attach (GTK_TABLE (table4), info_label4, 0, 2, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (info_label4), 0, 0.5);

  hbox10 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox10);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox10, TRUE, TRUE, 0);

  label38 = gtk_label_new ("");
  gtk_widget_show (label38);
  gtk_box_pack_start (GTK_BOX (hbox10), label38, FALSE, FALSE, 0);

  cancel_button4 = gtk_button_new ();
  gtk_widget_show (cancel_button4);
  gtk_box_pack_start (GTK_BOX (hbox10), cancel_button4, FALSE, TRUE, 0);
  gtk_widget_set_size_request (cancel_button4, 70, 15);

  alignment7 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment7);
  gtk_container_add (GTK_CONTAINER (cancel_button4), alignment7);

  hbox11 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox11);
  gtk_container_add (GTK_CONTAINER (alignment7), hbox11);

  image7 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image7);
  gtk_box_pack_start (GTK_BOX (hbox11), image7, FALSE, FALSE, 0);

  label39 = gtk_label_new_with_mnemonic (_(LABEL_CANCEL));
  gtk_widget_show (label39);
  gtk_box_pack_start (GTK_BOX (hbox11), label39, FALSE, FALSE, 0);

  label40 = gtk_label_new ("");
  gtk_widget_show (label40);
  gtk_box_pack_start (GTK_BOX (hbox10), label40, FALSE, FALSE, 0);

  next_button4 = gtk_button_new ();
  gtk_widget_show (next_button4);
  gtk_box_pack_start (GTK_BOX (hbox10), next_button4, TRUE, TRUE, 0);
  gtk_widget_set_size_request (next_button4, 57, 15);

  alignment10 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment10);
  gtk_container_add (GTK_CONTAINER (next_button4), alignment10);

  hbox15 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox15);
  gtk_container_add (GTK_CONTAINER (alignment10), hbox15);

  image10 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image10);
  gtk_box_pack_start (GTK_BOX (hbox15), image10, FALSE, FALSE, 0);

  label49 = gtk_label_new_with_mnemonic (_(LABEL_NEXT));
  gtk_widget_show (label49);
  gtk_box_pack_start (GTK_BOX (hbox15), label49, FALSE, FALSE, 0);

  label42 = gtk_label_new ("");
  gtk_widget_show (label42);
  gtk_box_pack_start (GTK_BOX (hbox10), label42, FALSE, FALSE, 0);

  dialog->next_button[dialog->wid] = next_button4;
  dialog->cancel_button[dialog->wid] = cancel_button4;

  //gtk_window_get_position(GTK_WINDOW(app->window),&x,&y);
  //gtk_window_set_position(opt_window4,x+50,y+50);
  gtk_window_set_position (GTK_WINDOW (opt_window4), GTK_WIN_POS_CENTER);

  return opt_window4;
}

GtkWidget*
dialog_wiz_1 (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  t_wizard *widget = dialog->wiz_widget;
  if(dialog->type != WIZARD) return NULL;

  GtkWidget *wiz_window1;
  GtkWidget *table1;
  GtkWidget *frame1;
  GtkWidget *alignment1;
  GtkWidget *table2;
  GtkWidget *rblk_label;
  GtkWidget *noopt_label;
  GtkWidget *rblk_entry;
  GtkWidget *noopt_entry;
  GtkWidget *input_label;
  GtkWidget *title_label1;
  GtkWidget *blklst_label;
  GtkWidget *burst_label;
#if 0
  GtkWidget *app_label;
  GtkWidget *app_button;
#endif /* 0 */
  GtkWidget *cloop_label;
  GtkWidget *hbox1;
  GtkWidget *cancel_button1;
  GtkWidget *alignment14;
  GtkWidget *hbox25;
  GtkWidget *image10;
  GtkWidget *label42;
  GtkWidget *next_button1;
  GtkWidget *alignment15;
  GtkWidget *hbox26;
  GtkWidget *image11;
  GtkWidget *label43;
  GtkWidget *hbox2;
  GtkWidget *blklst_entry;
  GtkWidget *blklst_button;
  GtkWidget *hbox3;
  GtkWidget *opt_entry;
  GtkWidget *cloop_button;
  GtkWidget *burst_scale;
  GtkObject *burst_spin_adj;
  GtkWidget *burst_spin;

  wiz_window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (wiz_window1, 350, 380);
  gtk_window_set_title (GTK_WINDOW (wiz_window1), _("Acceleration Cloop"));
  gtk_window_set_resizable (GTK_WINDOW (wiz_window1), FALSE);

  table1 = gtk_table_new (11, 10, FALSE);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (wiz_window1), table1);

#if 0
  app_button = gtk_button_new_with_mnemonic (_("Append Application Block List"));
  gtk_widget_show (app_button);
  gtk_table_attach (GTK_TABLE (table1), app_button, 0, 10, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
#endif /* 0 */

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_table_attach (GTK_TABLE (table1), frame1, 0, 10, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_IN);

  alignment1 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (frame1), alignment1);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment1), 0, 0, 12, 0);

  table2 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (alignment1), table2);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 10);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 10);

  rblk_label = gtk_label_new (_("read_blocks : "));
  gtk_widget_show (rblk_label);
  gtk_table_attach (GTK_TABLE (table2), rblk_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (rblk_label), 0, 0.5);

  noopt_label = gtk_label_new (_("cloop image :"));
  gtk_widget_show (noopt_label);
  gtk_table_attach (GTK_TABLE (table2), noopt_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (noopt_label), 0, 0.5);

  rblk_entry = gtk_entry_new ();
  gtk_widget_show (rblk_entry);
  gtk_table_attach (GTK_TABLE (table2), rblk_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_editable_set_editable (GTK_EDITABLE (rblk_entry), FALSE);

  noopt_entry = gtk_entry_new ();
  gtk_widget_show (noopt_entry);
  gtk_table_attach (GTK_TABLE (table2), noopt_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_editable_set_editable (GTK_EDITABLE (noopt_entry), FALSE);

  input_label = gtk_label_new (_("<b>Input Files</b>"));
  gtk_widget_show (input_label);
  gtk_frame_set_label_widget (GTK_FRAME (frame1), input_label);
  gtk_label_set_use_markup (GTK_LABEL (input_label), TRUE);

  title_label1 = gtk_label_new (_("Cloop Optimize Wizard"));
  gtk_widget_show (title_label1);
  gtk_table_attach (GTK_TABLE (table1), title_label1, 0, 10, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);
  gtk_misc_set_alignment (GTK_MISC (title_label1), 0, 0.5);

  blklst_label = gtk_label_new (_("Block List :"));
  gtk_widget_show (blklst_label);
  gtk_table_attach (GTK_TABLE (table1), blklst_label, 0, 10, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);
  gtk_misc_set_alignment (GTK_MISC (blklst_label), 0, 0.5);

  burst_label = gtk_label_new (_("burst size(KB)"));
  gtk_widget_show (burst_label);
  gtk_table_attach (GTK_TABLE (table1), burst_label, 0, 10, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);
  gtk_misc_set_alignment (GTK_MISC (burst_label), 0, 0.5);

#if 0
  app_label = gtk_label_new (_("Application BlockList:"));
  gtk_widget_show (app_label);
  gtk_table_attach (GTK_TABLE (table1), app_label, 0, 10, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);
  gtk_misc_set_alignment (GTK_MISC (app_label), 0, 0.5);
#endif /* 0 */

  cloop_label = gtk_label_new (_("Optimized Cloop:"));
  gtk_widget_show (cloop_label);
  gtk_table_attach (GTK_TABLE (table1), cloop_label, 0, 10, 8, 9,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);
  gtk_misc_set_alignment (GTK_MISC (cloop_label), 0, 0.5);

  hbox1 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox1);
  gtk_table_attach (GTK_TABLE (table1), hbox1, 0, 10, 10, 11,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  cancel_button1 = gtk_button_new ();
  gtk_widget_show (cancel_button1);
  gtk_box_pack_start (GTK_BOX (hbox1), cancel_button1, FALSE, FALSE, 0);

  alignment14 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment14);
  gtk_container_add (GTK_CONTAINER (cancel_button1), alignment14);

  hbox25 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox25);
  gtk_container_add (GTK_CONTAINER (alignment14), hbox25);

  image10 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image10);
  gtk_box_pack_start (GTK_BOX (hbox25), image10, FALSE, FALSE, 0);

  label42 = gtk_label_new_with_mnemonic (_("cancel"));
  gtk_widget_show (label42);
  gtk_box_pack_start (GTK_BOX (hbox25), label42, FALSE, FALSE, 0);

  next_button1 = gtk_button_new ();
  gtk_widget_show (next_button1);
  gtk_box_pack_start (GTK_BOX (hbox1), next_button1, FALSE, FALSE, 0);
  gtk_widget_set_size_request (next_button1, 70, -1);

  alignment15 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment15);
  gtk_container_add (GTK_CONTAINER (next_button1), alignment15);

  hbox26 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox26);
  gtk_container_add (GTK_CONTAINER (alignment15), hbox26);

  image11 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image11);
  gtk_box_pack_start (GTK_BOX (hbox26), image11, FALSE, FALSE, 0);

  label43 = gtk_label_new_with_mnemonic (_("next"));
  gtk_widget_show (label43);
  gtk_box_pack_start (GTK_BOX (hbox26), label43, FALSE, FALSE, 0);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox2);
  gtk_table_attach (GTK_TABLE (table1), hbox2, 0, 10, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  blklst_entry = gtk_entry_new ();
  gtk_widget_show (blklst_entry);
  gtk_box_pack_start (GTK_BOX (hbox2), blklst_entry, TRUE, TRUE, 0);

  blklst_button = gtk_button_new_with_mnemonic (_("select"));
  gtk_widget_show (blklst_button);
  gtk_box_pack_start (GTK_BOX (hbox2), blklst_button, FALSE, FALSE, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox3);
  gtk_table_attach (GTK_TABLE (table1), hbox3, 0, 10, 9, 10,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  opt_entry = gtk_entry_new ();
  gtk_widget_show (opt_entry);
  gtk_box_pack_start (GTK_BOX (hbox3), opt_entry, TRUE, TRUE, 0);

  cloop_button = gtk_button_new_with_mnemonic (_("select"));
  gtk_widget_show (cloop_button);
  gtk_box_pack_start (GTK_BOX (hbox3), cloop_button, FALSE, FALSE, 0);

  burst_spin_adj = gtk_adjustment_new (256, 0, 1024, 4, 10, 10);
  burst_spin = gtk_spin_button_new (GTK_ADJUSTMENT (burst_spin_adj), 1, 0);
  gtk_widget_show (burst_spin);
  gtk_table_attach (GTK_TABLE (table1), burst_spin, 9, 10, 5, 6,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  burst_scale = gtk_hscale_new (GTK_ADJUSTMENT (burst_spin_adj));
  gtk_scale_set_digits (GTK_SCALE (burst_scale), 0);
  gtk_widget_show (burst_scale);
  gtk_table_attach (GTK_TABLE (table1), burst_scale, 0, 9, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  widget->rblkstat_entry = rblk_entry;
  widget->noopt_entry = noopt_entry;

  widget->blklst_entry = blklst_entry;
  widget->blklst_button = blklst_button;
  
  dialog->spin.hscale = burst_scale;
  dialog->spin.spin = burst_spin;
  dialog->spin.adjustment = burst_spin_adj;

#if 0
  widget->append_button = app_button;
#endif /* 0 */

  widget->opt_entry = opt_entry;
  widget->opt_button = cloop_button;

  dialog->next_button[dialog->wid] = next_button1;
  dialog->cancel_button[dialog->wid] = cancel_button1;

  gtk_window_set_position (GTK_WINDOW (wiz_window1), GTK_WIN_POS_CENTER);

  return wiz_window1;
}

GtkWidget*
dialog_wiz_2 (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  //t_wizard *widget = dialog->wiz_widget;
  if(dialog->type != WIZARD)return NULL;
  //t_wizard *dialog = &app->wizard_dialog;
  
  GtkWidget *wiz_window3;
  GtkWidget *table3;
  GtkWidget *next_button3;
  GtkWidget *alignment7;
  GtkWidget *hbox17;
  GtkWidget *image4;
  GtkWidget *label27;
  GtkWidget *progress_label;
  GtkWidget *progressbar1;
  GtkWidget *cancel_button3;
  GtkWidget *alignment6;
  GtkWidget *hbox16;
  GtkWidget *image3;
  GtkWidget *label26;
  GtkWidget *titel_label3;

  GtkObject *adj;

  wiz_window3 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (wiz_window3, 400, 300);
  gtk_window_set_title (GTK_WINDOW (wiz_window3), _("Acceleration Cloop"));
  gtk_window_set_resizable (GTK_WINDOW (wiz_window3), FALSE);

  table3 = gtk_table_new (4, 2, FALSE);
  gtk_widget_show (table3);
  gtk_container_add (GTK_CONTAINER (wiz_window3), table3);

  next_button3 = gtk_button_new ();
  gtk_widget_show (next_button3);
  gtk_table_attach (GTK_TABLE (table3), next_button3, 1, 2, 3, 4,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (next_button3, 70, -1);

  alignment7 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment7);
  gtk_container_add (GTK_CONTAINER (next_button3), alignment7);

  hbox17 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox17);
  gtk_container_add (GTK_CONTAINER (alignment7), hbox17);

  image4 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image4);
  gtk_box_pack_start (GTK_BOX (hbox17), image4, FALSE, FALSE, 0);

  label27 = gtk_label_new_with_mnemonic (_("next"));
  gtk_widget_show (label27);
  gtk_box_pack_start (GTK_BOX (hbox17), label27, FALSE, FALSE, 0);

  progress_label = gtk_label_new (_("Optimizing..."));
  gtk_widget_show (progress_label);
  gtk_table_attach (GTK_TABLE (table3), progress_label, 0, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 40);
  gtk_misc_set_alignment (GTK_MISC (progress_label), 0, 0.5);

  adj = gtk_adjustment_new (0, 0, 100, 1, 1, 1);

  progressbar1 = gtk_progress_bar_new ();
  gtk_progress_set_show_text (GTK_PROGRESS (progressbar1), TRUE);
  gtk_progress_set_adjustment (GTK_PROGRESS (progressbar1), GTK_ADJUSTMENT(adj));
			       
  gtk_widget_show (progressbar1);
  gtk_table_attach (GTK_TABLE (table3), progressbar1, 0, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 25);

  cancel_button3 = gtk_button_new ();
  gtk_widget_show (cancel_button3);
  gtk_table_attach (GTK_TABLE (table3), cancel_button3, 0, 1, 3, 4,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 65);

  alignment6 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment6);
  gtk_container_add (GTK_CONTAINER (cancel_button3), alignment6);

  hbox16 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox16);
  gtk_container_add (GTK_CONTAINER (alignment6), hbox16);

  image3 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image3);
  gtk_box_pack_start (GTK_BOX (hbox16), image3, FALSE, FALSE, 0);

  label26 = gtk_label_new_with_mnemonic (_("cancel"));
  gtk_widget_show (label26);
  gtk_box_pack_start (GTK_BOX (hbox16), label26, FALSE, FALSE, 0);

  titel_label3 = gtk_label_new (_("Cloop Optimize Wizard\n\n"));
  gtk_widget_show (titel_label3);
  gtk_table_attach (GTK_TABLE (table3), titel_label3, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 10);
  gtk_misc_set_alignment (GTK_MISC (titel_label3), 0, 0.5);

  dialog->next_button[dialog->wid] = next_button3;
  dialog->cancel_button[dialog->wid] = cancel_button3;
  dialog->progress.bar = progressbar1;
  dialog->progress.label = progress_label;
  dialog->progress.adj = adj;

  gtk_window_set_position (GTK_WINDOW (wiz_window3), GTK_WIN_POS_CENTER);

  return wiz_window3;
}

/**
 *
 *
 */
GtkWidget *
dialog_wiz_3 (gpointer tmp)
{
  t_app_status *app = ((t_all_data *) tmp)->app;
  t_dialog *dialog = &app->dialog_state;
  //t_wizard *widget = dialog->wiz_widget;
  if(dialog->type != WIZARD) return NULL;
   //t_wizard *dialog = &app->wizard_dialog;

  GtkWidget *opt_window3;
  GtkWidget *vbox3;
  GtkWidget *table3;
  GtkWidget *title_label3;
  GtkWidget *info_label3;
  GtkWidget *hbox7;
  GtkWidget *label31;
  GtkWidget *cancel_button3;
  GtkWidget *alignment5;
  GtkWidget *hbox8;
  GtkWidget *image5;
  GtkWidget *label32;
  GtkWidget *label33;
  GtkWidget *next_button3;
  GtkWidget *alignment6;
  GtkWidget *hbox9;
  GtkWidget *image6;
  GtkWidget *label34;
  GtkWidget *label35;

  opt_window3 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (opt_window3, 400, 250);
  gtk_window_set_title (GTK_WINDOW (opt_window3), _("Acceleration Cloop"));
  gtk_window_set_resizable (GTK_WINDOW (opt_window3), FALSE);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (opt_window3), vbox3);

  table3 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table3);
  gtk_box_pack_start (GTK_BOX (vbox3), table3, TRUE, TRUE, 0);

  title_label3 = gtk_label_new (_("Cloop Optimize Wizard\n\n"));
  gtk_widget_show (title_label3);
  gtk_table_attach (GTK_TABLE (table3), title_label3, 0, 2, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (title_label3), 0, 0.5);

  info_label3 = gtk_label_new (_(MSG_OPTWZD_2));
  gtk_widget_show (info_label3);
  gtk_table_attach (GTK_TABLE (table3), info_label3, 0, 2, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (info_label3), 0, 0.5);

  hbox7 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox7);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox7, TRUE, TRUE, 0);

  label31 = gtk_label_new ("");
  gtk_widget_show (label31);
  gtk_box_pack_start (GTK_BOX (hbox7), label31, FALSE, FALSE, 0);

  cancel_button3 = gtk_button_new ();
  gtk_widget_show (cancel_button3);
  gtk_box_pack_start (GTK_BOX (hbox7), cancel_button3, FALSE, TRUE, 0);
  gtk_widget_set_size_request (cancel_button3, 70, 15);

  alignment5 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment5);
  gtk_container_add (GTK_CONTAINER (cancel_button3), alignment5);

  hbox8 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox8);
  gtk_container_add (GTK_CONTAINER (alignment5), hbox8);

  image5 = gtk_image_new_from_stock ("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image5);
  gtk_box_pack_start (GTK_BOX (hbox8), image5, FALSE, FALSE, 0);

  label32 = gtk_label_new_with_mnemonic (_(LABEL_CANCEL));
  gtk_widget_show (label32);
  gtk_box_pack_start (GTK_BOX (hbox8), label32, FALSE, FALSE, 0);

  label33 = gtk_label_new ("");
  gtk_widget_show (label33);
  gtk_box_pack_start (GTK_BOX (hbox7), label33, FALSE, FALSE, 0);

  next_button3 = gtk_button_new ();
  gtk_widget_show (next_button3);
  gtk_box_pack_start (GTK_BOX (hbox7), next_button3, TRUE, TRUE, 0);
  gtk_widget_set_size_request (next_button3, 57, 15);

  alignment6 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment6);
  gtk_container_add (GTK_CONTAINER (next_button3), alignment6);

  hbox9 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox9);
  gtk_container_add (GTK_CONTAINER (alignment6), hbox9);

  image6 = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image6);
  gtk_box_pack_start (GTK_BOX (hbox9), image6, FALSE, FALSE, 0);

  label34 = gtk_label_new_with_mnemonic (_(LABEL_OK));
  gtk_widget_show (label34);
  gtk_box_pack_start (GTK_BOX (hbox9), label34, FALSE, FALSE, 0);

  label35 = gtk_label_new ("");
  gtk_widget_show (label35);
  gtk_box_pack_start (GTK_BOX (hbox7), label35, FALSE, FALSE, 0);

  dialog->next_button[dialog->wid] = next_button3;
  dialog->cancel_button[dialog->wid] = cancel_button3;

  //gtk_window_get_position(GTK_WINDOW(app->window),&x,&y);
  //gtk_window_set_position(opt_window3,x+50,y+50);
  gtk_window_set_position (GTK_WINDOW (opt_window3), GTK_WIN_POS_CENTER);
  return opt_window3;
}

/**
 * @brief create_window - create main window 
 * @param[in] pointer that contains all parameters
 * @param[out] Main Window Widget
 */
GtkWidget *
create_window (gpointer all)
{

  t_app_status *app = ((t_all_data *) all)->app;
  gint i;

  GtkWidget *window;
  GdkPixbuf *window_icon_pixbuf;
  GtkWidget *vboxm;
  GtkWidget *vpaned1;
  GtkWidget *vbox1;

  GtkWidget *separator;
  GtkWidget *separator_2;

  ///Menu Items
  GtkWidget *menubar;
  GtkWidget *file_menuitem;
  GtkWidget *file_menu;
  GtkWidget *openlog_menuitem;
  GtkWidget *openclp_menuitem;
  GtkWidget *quit_menuitem;
  GtkWidget *quit_image;

  GtkWidget *opt_menu;
  GtkWidget *opt_menuitem;
  GtkWidget *wizard_menuitem;
  GtkWidget *separator_3;
  GtkWidget *reset_menuitem;
  GtkWidget *separator_4;
  GtkWidget *mkrh_menuitem;
  GtkWidget *optwiz_menuitem;

#if 0
  GtkWidget *mkiso_menuitem;
  GtkWidget *cdwt_menuitem;
#endif /* 0 */

  GtkWidget *view_menu;
  GtkWidget *view_menuitem;
  GtkWidget *time_menu;
  GtkWidget *freq_menu;
  GtkWidget *timefreq_menu;
  GtkWidget *freqtime_menu;

  GtkWidget *resource_menu;
  GtkWidget *bcolor_menu;

  GtkWidget *resource_menuitem;
  GtkWidget *bcolor_menuitem;

  GtkWidget *rblog_menu;
  GtkWidget *clphead_menu;

  GtkWidget *help_menu;
  GtkWidget *help_menuitem;
  GtkWidget *info_menuitem;
  GtkWidget *about_image;

  GtkWidget *frame1;
  GtkWidget *drawarea_scrlwin;
  GtkWidget *viewport1;
  GtkWidget *drawingarea;
  GtkWidget *hscale1;
  GtkObject *adjustment;
  GtkWidget *hbox1;

  ///Contorl Buttons
  GtkWidget *rewind_button;
  GtkWidget *play_button;
  GtkWidget *stop_button;
  GtkWidget *forward_button;

  GtkWidget *frame2;
  GtkWidget *hbox7;
  GtkWidget *label1;
  GtkWidget *timer_label;
  GtkWidget *frame3;
  GtkWidget *hbox8;
  GtkWidget *label3;
  GtkWidget *size_label;
  GtkWidget *label5;
  GtkWidget *hbox2;
  GtkWidget *frame4;
  GtkWidget *hbox3;
  GtkWidget *summary_label;
  GtkObject *summary_spin_adj;
  //GtkObject *summary_spin_adj_bc;
  //GtkObject *summary_spin_adj_sc;
  GtkWidget *summary_spin;
  GtkWidget *summary_button;
  GtkWidget *frame5;
  GtkWidget *hbox4;
  GtkWidget *label7;
  GtkWidget *drawmode_box;
  GtkWidget *drawmode_button;
  GtkWidget *vbox2;
  GtkWidget *notebook1;

  GtkWidget *state_text;
  //GtkWidget *state_textbuffer;
  GObject *state_textbuffer;
  //GtkWidget *state_texttag; 
  GObject *state_texttag;

  GtkWidget *label9;
  GtkWidget *scrolledwindow3;
  GtkWidget *statearea_scrlwin;
  GtkWidget *state_list;
  GtkWidget *label10;
  GtkWidget *label11;
  GtkWidget *label12;
  GtkWidget *label13;
  GtkWidget *label14;
  GtkWidget *label15;
  GtkWidget *label16;
  GtkWidget *label17;

  GtkWidget *statusbar;

  GList *drawmode_list = NULL;
  GSList *timelist = NULL;
  GSList *resourcelist = NULL;

  static const gchar *vmenu[] = {
    "draw resource",
    "block color",
  };

  static const gchar *dres[] = {
    "read_blocks log",
    "cloop header",
  };

  static const gchar *bcolor[] = {
    "read time",
    "read count",
    "time/count",
    "count/time",
  };

  ///
  //
  add_pixmap_directory (PIXMAP_DIR);
  add_pixmap_directory ("../icons/"); 

  separator = gtk_menu_item_new ();

  ///Main Window
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), _("Cloop Reference Profiler"));

  window_icon_pixbuf = create_pixbuf ("cdrom_unmount.png");

  ///Window Icon
  if (window_icon_pixbuf)
    {
      gtk_window_set_icon (GTK_WINDOW (window), window_icon_pixbuf);
      gdk_pixbuf_unref (window_icon_pixbuf);
    }

  ///bar to change displayed size
  vboxm = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vboxm);
  gtk_container_add (GTK_CONTAINER (window), vboxm);

  ///MenuBar
  menubar = gtk_menu_bar_new ();
  gtk_widget_show (menubar);
  gtk_box_pack_start (GTK_BOX (vboxm), menubar, FALSE, FALSE, 0);

  //File Menu
  file_menuitem = gtk_menu_item_new_with_mnemonic (_("File(_F)"));
  gtk_widget_show (file_menuitem);
  gtk_container_add (GTK_CONTAINER (menubar), file_menuitem);

  file_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (file_menuitem), file_menu);

  openlog_menuitem = gtk_menu_item_new_with_label ("Open read_blocks");
  gtk_menu_shell_append (GTK_MENU_SHELL (file_menu), openlog_menuitem);
  gtk_widget_show (openlog_menuitem);

  openclp_menuitem = gtk_menu_item_new_with_label ("Open CLOOP");
  gtk_menu_shell_append (GTK_MENU_SHELL (file_menu), openclp_menuitem);
  gtk_widget_show (openclp_menuitem);

  gtk_widget_set_sensitive (openclp_menuitem, FALSE);


  separator_2 = gtk_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (file_menu), separator_2);
  gtk_widget_show (separator_2);

  quit_menuitem = gtk_image_menu_item_new_with_mnemonic (_("Quit(_Q)"));
  gtk_widget_show (quit_menuitem);
  gtk_container_add (GTK_CONTAINER (file_menu), quit_menuitem);

  quit_image = gtk_image_new_from_stock ("gtk-quit", GTK_ICON_SIZE_MENU);
  gtk_widget_show (quit_image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (quit_menuitem),
				 quit_image);

  //View Menu
  view_menuitem = gtk_menu_item_new_with_mnemonic (_("View(_V)"));
  gtk_widget_show (view_menuitem);
  gtk_container_add (GTK_CONTAINER (menubar), view_menuitem);

  view_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (view_menuitem), view_menu);

  /// -dresource Menu
  resource_menuitem = gtk_menu_item_new_with_label (vmenu[0]);
  gtk_container_add (GTK_CONTAINER (view_menu), resource_menuitem);
  gtk_widget_show (resource_menuitem);

  /// resource : read_blocks log
  resource_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (resource_menuitem),
			     resource_menu);
  rblog_menu = gtk_radio_menu_item_new_with_label (resourcelist, dres[0]);
  resourcelist =
    gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (rblog_menu));
  gtk_container_add (GTK_CONTAINER (resource_menu), rblog_menu);
  gtk_widget_show (rblog_menu);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (rblog_menu), TRUE);

  /// resource : cloop header
  clphead_menu = gtk_radio_menu_item_new_with_label (resourcelist, dres[1]);
  resourcelist =
    gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (clphead_menu));
  gtk_container_add (GTK_CONTAINER (resource_menu), clphead_menu);
  gtk_widget_show (clphead_menu);

  gtk_widget_set_sensitive (rblog_menu, FALSE);
  gtk_widget_set_sensitive (clphead_menu, FALSE);

  /// draw color Menu  
  bcolor_menuitem = gtk_menu_item_new_with_label (vmenu[1]);
  gtk_container_add (GTK_CONTAINER (view_menu), bcolor_menuitem);
  gtk_widget_show (bcolor_menuitem);

  bcolor_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (bcolor_menuitem), bcolor_menu);

  /// Color set from "draw time"
  time_menu = gtk_radio_menu_item_new_with_label (timelist, bcolor[0]);
  timelist = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (time_menu));
  gtk_container_add (GTK_CONTAINER (bcolor_menu), time_menu);
  gtk_widget_show (time_menu);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (time_menu), TRUE);

  /// Color set from "draw freq"
  freq_menu = gtk_radio_menu_item_new_with_label (timelist, bcolor[1]);
  timelist = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (freq_menu));
  gtk_container_add (GTK_CONTAINER (bcolor_menu), freq_menu);
  gtk_widget_show (freq_menu);

  /// Color set from "draw time / draw freq"
  timefreq_menu = gtk_radio_menu_item_new_with_label (timelist, bcolor[2]);
  timelist =
    gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (timefreq_menu));
  gtk_container_add (GTK_CONTAINER (bcolor_menu), timefreq_menu);
  gtk_widget_show (timefreq_menu);

  /// Color set from "draw freq / draw time"
  freqtime_menu = gtk_radio_menu_item_new_with_label (timelist, bcolor[3]);
  timelist =
    gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (freqtime_menu));
  gtk_container_add (GTK_CONTAINER (bcolor_menu), freqtime_menu);
  gtk_widget_show (freqtime_menu);

  //Opt Menu
  //opt_menuitem = gtk_menu_item_new_with_mnemonic (_("Optimize(_O)"));
  opt_menuitem = gtk_menu_item_new_with_mnemonic (_("Tools(_T)"));
  gtk_widget_show (opt_menuitem);
  gtk_container_add (GTK_CONTAINER (menubar), opt_menuitem);

  opt_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (opt_menuitem), opt_menu);

  wizard_menuitem = gtk_menu_item_new_with_label ("Accelerate Wizard");
  gtk_menu_shell_append (GTK_MENU_SHELL (opt_menu), wizard_menuitem);
  gtk_widget_set_sensitive(wizard_menuitem,FALSE);
  gtk_widget_show (wizard_menuitem);
  
  separator_3 = gtk_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (opt_menu), separator_3);
  gtk_widget_show (separator_3);

  reset_menuitem = gtk_menu_item_new_with_label ("reset \"/proc/read_blocks\"");
  gtk_menu_shell_append (GTK_MENU_SHELL (opt_menu), reset_menuitem);
  gtk_widget_set_sensitive(reset_menuitem,FALSE);
  gtk_widget_show (reset_menuitem);

  separator_4 = gtk_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (opt_menu), separator_4);
  gtk_widget_show (separator_4);

  mkrh_menuitem = gtk_menu_item_new_with_label ("Make readahead list");
  gtk_menu_shell_append (GTK_MENU_SHELL (opt_menu), mkrh_menuitem);
  gtk_widget_show (mkrh_menuitem);

  //gtk_widget_set_sensitive (mkrh_menuitem, FALSE);

  optwiz_menuitem = gtk_menu_item_new_with_label ("Optimize Cloop");
  gtk_menu_shell_append (GTK_MENU_SHELL (opt_menu), optwiz_menuitem);
  gtk_widget_show (optwiz_menuitem);

  //gtk_widget_set_sensitive (optwiz_menuitem, FALSE);
#if 0
  gtk_menu_shell_append (GTK_MENU_SHELL (opt_menu), separator);
  gtk_widget_show (separator);

  mkiso_menuitem = gtk_menu_item_new_with_label ("Make ISO Image");
  gtk_menu_shell_append (GTK_MENU_SHELL (opt_menu), mkiso_menuitem);
  gtk_widget_show (mkiso_menuitem);

  //gtk_widget_set_sensitive(mkiso_menuitem,FALSE);
  //app->optwiz_menu = mkiso_menuitem;
  cdwt_menuitem = gtk_menu_item_new_with_label ("Write CDImage");
  gtk_menu_shell_append (GTK_MENU_SHELL (opt_menu), cdwt_menuitem);
  gtk_widget_show (cdwt_menuitem);
#endif /* 0 */
  /// Menu to Help
  help_menuitem = gtk_menu_item_new_with_mnemonic (_("Help(_H)"));
  gtk_widget_show (help_menuitem);
  gtk_container_add (GTK_CONTAINER (menubar), help_menuitem);

  help_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (help_menuitem), help_menu);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (help_menuitem));

  ///Information Dialog
  info_menuitem = gtk_image_menu_item_new_with_mnemonic (_("Info(_I)"));
  gtk_menu_shell_append (GTK_MENU_SHELL (help_menu), info_menuitem);
  gtk_widget_show (info_menuitem);

  about_image = gtk_image_new_from_stock ("gtk-about", GTK_ICON_SIZE_MENU);
  gtk_widget_show (about_image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (info_menuitem),
				 about_image);

  vpaned1 = gtk_vpaned_new ();
  gtk_widget_show (vpaned1);
  gtk_box_pack_start (GTK_BOX (vboxm), vpaned1, TRUE, TRUE, 0);
  gtk_paned_set_position (GTK_PANED (vpaned1), 600);

  ///UI Field
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_paned_pack1 (GTK_PANED (vpaned1), vbox1, FALSE, TRUE);

  ///Frame that contains Draw Field
  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, TRUE, TRUE, 0);
  gtk_widget_set_size_request (frame1, -1, 200);
  gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_NONE);

  ///Draw Field Window
  drawarea_scrlwin = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (drawarea_scrlwin);
  gtk_container_add (GTK_CONTAINER (frame1), drawarea_scrlwin);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (drawarea_scrlwin),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport1);
  gtk_container_add (GTK_CONTAINER (drawarea_scrlwin), viewport1);

  drawingarea = gtk_drawing_area_new ();
  gtk_widget_show (drawingarea);
  gtk_container_add (GTK_CONTAINER (viewport1), drawingarea);

  adjustment = gtk_adjustment_new (0, 0, 0, 1, 0, 0);
  hscale1 = gtk_hscale_new (GTK_ADJUSTMENT (adjustment));
  gtk_widget_show (hscale1);
  gtk_box_pack_start (GTK_BOX (vbox1), hscale1, FALSE, FALSE, 0);
  gtk_scale_set_digits (GTK_SCALE (hscale1), 0);
  gtk_scale_set_draw_value (GTK_SCALE (hscale1), FALSE);
  gtk_widget_set_events (GTK_WIDGET (hscale1),
			 GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);

  ///Control Button Field
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 0);

  ///Rewind Button
  rewind_button = gtk_button_new_with_mnemonic (_("<<"));
  gtk_widget_show (rewind_button);
  gtk_box_pack_start (GTK_BOX (hbox1), rewind_button, FALSE, FALSE, 0);
  gtk_widget_set_size_request (rewind_button, 30, 24);

  ///Play Button
  play_button = gtk_button_new_with_mnemonic (_(">"));
  gtk_widget_show (play_button);
  gtk_box_pack_start (GTK_BOX (hbox1), play_button, FALSE, FALSE, 0);
  gtk_widget_set_size_request (play_button, 50, 40);

  ///Stop Button
  stop_button = gtk_button_new_with_mnemonic (_("\342\226\240"));
  gtk_widget_show (stop_button);
  gtk_box_pack_start (GTK_BOX (hbox1), stop_button, FALSE, FALSE, 0);
  gtk_widget_set_size_request (stop_button, 50, 40);

  ///Forward Button
  forward_button = gtk_button_new_with_mnemonic (_(">>"));
  gtk_widget_show (forward_button);
  gtk_box_pack_start (GTK_BOX (hbox1), forward_button, FALSE, FALSE, 0);
  gtk_widget_set_size_request (forward_button, 30, -1);

  ///Timer Field
  frame2 = gtk_frame_new (NULL);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (hbox1), frame2, TRUE, TRUE, 0);

  hbox7 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox7);
  gtk_container_add (GTK_CONTAINER (frame2), hbox7);

  label1 = gtk_label_new (_(" Time: "));
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox7), label1, FALSE, FALSE, 0);

  timer_label = gtk_label_new (_("00:00:00"));
  gtk_widget_show (timer_label);
  gtk_box_pack_start (GTK_BOX (hbox7), timer_label, TRUE, TRUE, 0);

  ///Drawsize Field
  frame3 = gtk_frame_new (NULL);
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (hbox1), frame3, TRUE, TRUE, 0);

  hbox8 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox8);
  gtk_container_add (GTK_CONTAINER (frame3), hbox8);

  label3 = gtk_label_new (_(" Total Read: "));
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (hbox8), label3, FALSE, FALSE, 0);

  size_label = gtk_label_new (_("0"));
  gtk_widget_show (size_label);
  gtk_box_pack_start (GTK_BOX (hbox8), size_label, TRUE, TRUE, 0);

  label5 = gtk_label_new (_("bytes"));
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (hbox8), label5, FALSE, FALSE, 0);

  ///Draw Scale Conter Field
  hbox2 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 0);

  frame4 = gtk_frame_new (NULL);
  gtk_widget_show (frame4);
  gtk_box_pack_start (GTK_BOX (hbox2), frame4, TRUE, TRUE, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox3);
  gtk_container_add (GTK_CONTAINER (frame4), hbox3);

  summary_label = gtk_label_new (_("Block/Cell      : "));
  gtk_widget_show (summary_label);
  gtk_box_pack_start (GTK_BOX (hbox3), summary_label, TRUE, FALSE, 0);

  summary_spin_adj = gtk_adjustment_new (4, 1, 100, 1, 1, 11);
  //summary_spin_adj_sc = gtk_adjustment_new(4, 0, 16, 1, 1, 11);
  //summary_spin_adj_sc = gtk_adjustment_new (4, 2, 16, 1, 1, 11);
  summary_spin =
    gtk_spin_button_new (GTK_ADJUSTMENT (summary_spin_adj), 1, 0);
  gtk_widget_show (summary_spin);
  gtk_box_pack_start (GTK_BOX (hbox3), summary_spin, TRUE, TRUE, 0);

  summary_button = gtk_button_new_with_mnemonic (_("Update"));
  gtk_widget_show (summary_button);
  gtk_box_pack_start (GTK_BOX (hbox3), summary_button, FALSE, FALSE, 0);

  ///Draw Color Change Field
  frame5 = gtk_frame_new (NULL);
  gtk_widget_show (frame5);
  gtk_box_pack_start (GTK_BOX (hbox2), frame5, TRUE, TRUE, 0);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox4);
  gtk_container_add (GTK_CONTAINER (frame5), hbox4);

  label7 = gtk_label_new (_("Draw Color:"));
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (hbox4), label7, TRUE, FALSE, 0);

  drawmode_box = gtk_combo_new ();
  gtk_box_pack_start (GTK_BOX (hbox4), drawmode_box, TRUE, TRUE, 0);
  gtk_widget_set_size_request (drawmode_box, 150, -1);

  drawmode_list = g_list_append (drawmode_list, "read time");
  drawmode_list = g_list_append (drawmode_list, "read count");
  drawmode_list = g_list_append (drawmode_list, "time/count");
  drawmode_list = g_list_append (drawmode_list, "count/time");
  gtk_combo_set_popdown_strings (GTK_COMBO (drawmode_box), drawmode_list);

  gtk_widget_show (drawmode_box);

  drawmode_button = gtk_button_new_with_mnemonic (_("Change"));
  gtk_widget_show (drawmode_button);
  gtk_box_pack_start (GTK_BOX (hbox4), drawmode_button, FALSE, FALSE, 0);

  ///Data Viewer on Bottom Field
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_paned_pack2 (GTK_PANED (vpaned1), vbox2, TRUE, TRUE);

  notebook1 = gtk_notebook_new ();
  gtk_widget_show (notebook1);
  gtk_box_pack_start (GTK_BOX (vbox2), notebook1, TRUE, TRUE, 0);
  gtk_widget_set_size_request (notebook1, -1, 1);

  scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow3);
  gtk_container_add (GTK_CONTAINER (notebook1), scrolledwindow3);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow3),
				       GTK_SHADOW_IN);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow3),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  ///TabScale Setting
  {
    PangoTabArray *tab = pango_tab_array_new (500, TRUE);

    state_text = gtk_text_view_new ();
    gtk_text_view_set_editable (GTK_TEXT_VIEW (state_text), FALSE);
    gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (state_text), FALSE);
    gtk_text_view_set_justification (GTK_TEXT_VIEW (state_text),
				     GTK_JUSTIFY_LEFT);
    gtk_text_view_set_tabs (GTK_TEXT_VIEW (state_text), tab);
    gtk_widget_show (state_text);
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
					   (scrolledwindow3), state_text);

    state_texttag = (GObject *) gtk_text_tag_table_new ();
    state_textbuffer =
      (GObject *) gtk_text_buffer_new (GTK_TEXT_TAG_TABLE (state_texttag));

  }

  label9 = gtk_label_new (_("Analytial of Log"));
  gtk_widget_show (label9);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK
							 (notebook1), 0),
			      label9);

  statearea_scrlwin = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (statearea_scrlwin);
  gtk_container_add (GTK_CONTAINER (notebook1), statearea_scrlwin);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW
				       (statearea_scrlwin), GTK_SHADOW_IN);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (statearea_scrlwin),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  ///List Field Setting
  state_list = gtk_clist_new (INFO_CNT);
  gtk_widget_show (state_list);
  gtk_container_add (GTK_CONTAINER (statearea_scrlwin), state_list);

  //justif
  for (i = 0; i < INFO_CNT; i++)
    {
      gtk_clist_set_column_width (GTK_CLIST (state_list), i, 65);
      gtk_clist_set_column_justification (GTK_CLIST (state_list), i,
					  GTK_JUSTIFY_RIGHT);
    }

  gtk_clist_set_sort_type (GTK_CLIST (state_list), GTK_SORT_ASCENDING);
  gtk_clist_set_selection_mode (GTK_CLIST (state_list),
				GTK_SELECTION_MULTIPLE);
  gtk_clist_column_titles_show (GTK_CLIST (state_list));
  gtk_clist_set_shadow_type (GTK_CLIST (state_list), GTK_SHADOW_NONE);

  label10 = gtk_label_new (_("Read No."));
  gtk_widget_show (label10);
  gtk_clist_set_column_widget (GTK_CLIST (state_list), 0, label10);

  label11 = gtk_label_new (_("Block No."));
  gtk_widget_show (label11);
  gtk_clist_set_column_widget (GTK_CLIST (state_list), 1, label11);

  label12 = gtk_label_new (_("Ref time(s)"));
  gtk_widget_show (label12);
  gtk_clist_set_column_widget (GTK_CLIST (state_list), 2, label12);

  label13 = gtk_label_new (_("Read freq"));
  gtk_widget_show (label13);
  gtk_clist_set_column_widget (GTK_CLIST (state_list), 3, label13);

  label17 = gtk_label_new (_("Offset"));
  gtk_widget_show (label17);
  gtk_clist_set_column_widget (GTK_CLIST (state_list), 4, label17);

  label14 = gtk_label_new (_("Size(bytes)"));
  gtk_widget_show (label14);
  gtk_clist_set_column_widget (GTK_CLIST (state_list), 5, label14);

  label15 = gtk_label_new (_("Transfer rate(KB/s)"));
  gtk_widget_show (label15);
  gtk_clist_set_column_widget (GTK_CLIST (state_list), 6, label15);

  label16 = gtk_label_new (_("Data of Blocks"));
  gtk_widget_show (label16);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK
							 (notebook1), 1),
			      label16);

  ///Status Bar
  statusbar = gtk_statusbar_new ();
  gtk_widget_show (statusbar);
  gtk_box_pack_start (GTK_BOX (vboxm), statusbar, FALSE, FALSE, 0);

  /* Widget Setting All Over. */
  /* Value Settings */

  app->blks.widget = drawingarea;
  app->blks.scrl_win = drawarea_scrlwin;

  app->time.widget = timer_label;
  app->time.adjust = NULL;

  app->size.widget = size_label;
  app->size.adjust = NULL;

  app->btns.play = play_button;
  app->btns.stop = stop_button;
  app->btns.rewind = rewind_button;
  app->btns.forward = forward_button;

  app->summary.widget = summary_spin;
  app->summary.label = summary_label;
  app->summary.adj = summary_spin_adj;
  //app->summary.adj_bc = summary_spin_adj_bc;
  //app->summary.adj_sc = summary_spin_adj_sc;

  app->mode.widget = drawmode_box;
  app->mode.list = drawmode_list;

  app->list.widget = state_list;

  app->state.widget = state_text;
  app->state.text_buffer = GTK_TEXT_BUFFER (state_textbuffer);
  app->state.tagtable = GTK_TEXT_TAG_TABLE (state_texttag);

  app->state.adjust = gtk_scrolled_window_get_vadjustment
    (GTK_SCROLLED_WINDOW (statearea_scrlwin));

  app->scale.widget = hscale1;
  app->scale.adjust = GTK_ADJUSTMENT (adjustment);

  app->sbar.widget = statusbar;
  app->sbar.cid =
    gtk_statusbar_get_context_id (GTK_STATUSBAR (app->sbar.widget),
				  CONTEXT_NAME);

  app->cloopfile_menu = openclp_menuitem;

  app->resourcemenu_item[0] = rblog_menu;
  app->resourcemenu_item[1] = clphead_menu;

  app->colormenu_item[0] = time_menu;
  app->colormenu_item[1] = freq_menu;
  app->colormenu_item[2] = timefreq_menu;
  app->colormenu_item[3] = freqtime_menu;

  app->wizard_menu = wizard_menuitem;
  app->reset_menu = reset_menuitem;
  app->readahead_menu = mkrh_menuitem;
  app->optwiz_menu = optwiz_menuitem;

  ///Signal Connect

  g_signal_connect ((gpointer) window, "destroy",
		    G_CALLBACK (window_destroy), all);
  g_signal_connect ((gpointer) drawingarea, "expose_event",
		    G_CALLBACK (on_drawarea_expose), all);
  g_signal_connect ((gpointer) drawingarea, "button_press_event",
		    G_CALLBACK (on_drawarea_press), all);
  g_signal_connect ((gpointer) drawingarea, "button_release_event",
		    G_CALLBACK (reset_popup), all);

  gtk_widget_set_events (drawingarea, GDK_EXPOSURE_MASK
			 | GDK_ENTER_NOTIFY_MASK
			 | GDK_LEAVE_NOTIFY_MASK
			 | GDK_BUTTON_PRESS_MASK
			 | GDK_BUTTON_RELEASE_MASK
			 | GDK_POINTER_MOTION_MASK
			 | GDK_PROXIMITY_IN_MASK
			 | GDK_POINTER_MOTION_HINT_MASK);

  g_signal_connect ((gpointer) hscale1, "change_value",
		    G_CALLBACK (timescale_change_value), all);
  g_signal_connect ((gpointer) hscale1, "button-press-event",
		    G_CALLBACK (timescale_pressed), all);
  g_signal_connect ((gpointer) hscale1, "button-release-event",
		    G_CALLBACK (timescale_released), all);
  g_signal_connect ((gpointer) stop_button, "released",
		    G_CALLBACK (on_stop_clicked), all);
  g_signal_connect ((gpointer) play_button, "released",
		    G_CALLBACK (on_play_clicked), all);
  g_signal_connect ((gpointer) rewind_button, "pressed",
		    G_CALLBACK (on_rewind_pressed), all);
  g_signal_connect ((gpointer) rewind_button, "released",
		    G_CALLBACK (on_rewind_released), all);
  g_signal_connect ((gpointer) forward_button, "pressed",
		    G_CALLBACK (on_forward_pressed), all);
  g_signal_connect ((gpointer) forward_button, "clicked",
		    G_CALLBACK (on_forward_released), all);
  g_signal_connect ((gpointer) summary_button, "clicked",
		    G_CALLBACK (on_summary_changed), all);
  gtk_combo_set_case_sensitive (GTK_COMBO (drawmode_box), TRUE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (drawmode_box), TRUE);
  gtk_combo_disable_activate (GTK_COMBO (drawmode_box));
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (drawmode_box)->entry), FALSE);

  g_signal_connect ((gpointer) drawmode_button, "clicked",
		    G_CALLBACK (on_disp_changed), all);
  g_signal_connect ((gpointer) state_list, "select_row",
		    G_CALLBACK (on_select_block), all);
  g_signal_connect ((gpointer) state_list, "unselect_row",
		    G_CALLBACK (on_unselect_block), all);

  // Menu
  g_signal_connect ((gpointer) quit_menuitem, "activate",
		    G_CALLBACK (on_quit1_activate), all);
  g_signal_connect ((gpointer) info_menuitem, "activate",
		    G_CALLBACK (on_info_activate), all);
  g_signal_connect ((gpointer) time_menu, "activate",
		    G_CALLBACK (on_timemenu_activate), all);
  g_signal_connect ((gpointer) freq_menu, "activate",
		    G_CALLBACK (on_freqmenu_activate), all);
  g_signal_connect ((gpointer) timefreq_menu, "activate",
		    G_CALLBACK (on_timefreqmenu_activate), all);
  g_signal_connect ((gpointer) freqtime_menu, "activate",
		    G_CALLBACK (on_freqtimemenu_activate), all);
  g_signal_connect ((gpointer) openlog_menuitem, "activate",
		    G_CALLBACK (on_openlog_menu_activate), all);
  g_signal_connect ((gpointer) openclp_menuitem, "activate",
		    G_CALLBACK (on_openclp_menu_activate), all);
  g_signal_connect ((gpointer) rblog_menu, "activate",
		    G_CALLBACK (on_rblog_menu_activate), all);
  g_signal_connect ((gpointer) clphead_menu, "activate",
		    G_CALLBACK (on_clphead_menu_activate), all);
  g_signal_connect ((gpointer) state_list, "click-column",
		    G_CALLBACK (on_clist_clicked), all);
  g_signal_connect ((gpointer) mkrh_menuitem, "activate",
		    G_CALLBACK (on_mkrh_menu_activate), all);
  g_signal_connect ((gpointer) optwiz_menuitem, "activate",
		    G_CALLBACK (on_optwiz_menu_activate), all);

  g_signal_connect ((gpointer) wizard_menuitem, "activate",
		    G_CALLBACK (on_wizard_menu_activate), all);
  g_signal_connect ((gpointer) reset_menuitem, "activate",
		    G_CALLBACK (on_reset_menu_activate), all);
#if 0
  g_signal_connect ((gpointer) mkiso_menuitem, "activate",
		    G_CALLBACK (on_mkiso_menu_activate), all);
  g_signal_connect ((gpointer) cdwt_menuitem, "activate",
		    G_CALLBACK (on_cdwt_menu_activate), all);
#endif /* 0 */

  /* Store pointers to all widgets, for use by lookup_widget(). */
  HOOKUP_OBJECT_NO_REF (window, window, "window");
  HOOKUP_OBJECT (window, vbox1, "vbox1");
  HOOKUP_OBJECT (window, menubar, "menubar");
  HOOKUP_OBJECT (window, file_menuitem, "file_menuitem");
  HOOKUP_OBJECT (window, file_menu, "file_menu");
  HOOKUP_OBJECT (window, quit_menuitem, "quit_menuitem ");
  HOOKUP_OBJECT (window, quit_image, "quit_image");
  HOOKUP_OBJECT (window, view_menuitem, "view_menuitem");
  HOOKUP_OBJECT (window, view_menu, "view_menu");
  HOOKUP_OBJECT (window, help_menuitem, "help_menuitem");
  HOOKUP_OBJECT (window, help_menu, "help_menu");
  HOOKUP_OBJECT (window, info_menuitem, "info_menuitem");
  HOOKUP_OBJECT (window, about_image, "about_image");
  HOOKUP_OBJECT (window, frame1, "frame1");
  HOOKUP_OBJECT (window, drawarea_scrlwin, "drawarea_scrlwin");
  HOOKUP_OBJECT (window, viewport1, "viewport1");
  HOOKUP_OBJECT (window, drawingarea, "drawingarea");
  HOOKUP_OBJECT (window, hscale1, "hscale1");
  HOOKUP_OBJECT (window, hbox1, "hbox1");
  HOOKUP_OBJECT (window, rewind_button, "rewind_button");
  HOOKUP_OBJECT (window, play_button, "play_button");
  HOOKUP_OBJECT (window, stop_button, "stop_button");
  HOOKUP_OBJECT (window, forward_button, "forward_button");
  HOOKUP_OBJECT (window, frame2, "frame2");
  HOOKUP_OBJECT (window, hbox7, "hbox7");
  HOOKUP_OBJECT (window, label1, "label1");
  HOOKUP_OBJECT (window, timer_label, "timer_label");
  HOOKUP_OBJECT (window, frame3, "frame3");
  HOOKUP_OBJECT (window, hbox8, "hbox8");
  HOOKUP_OBJECT (window, label3, "label3");
  HOOKUP_OBJECT (window, size_label, "size_label");
  HOOKUP_OBJECT (window, label5, "label5");
  HOOKUP_OBJECT (window, hbox2, "hbox2");
  HOOKUP_OBJECT (window, frame4, "frame4");
  HOOKUP_OBJECT (window, hbox3, "hbox3");
  HOOKUP_OBJECT (window, summary_label, "summary_label");
  HOOKUP_OBJECT (window, summary_spin, "summary_spin");
  HOOKUP_OBJECT (window, summary_button, "summary_button");
  HOOKUP_OBJECT (window, frame5, "frame5");
  HOOKUP_OBJECT (window, hbox4, "hbox4");
  HOOKUP_OBJECT (window, label7, "label7");
  HOOKUP_OBJECT (window, drawmode_box, "drawmode_box");
  HOOKUP_OBJECT (window, drawmode_button, "drawmode_button");
  HOOKUP_OBJECT (window, notebook1, "notebook1");
  HOOKUP_OBJECT (window, state_text, "state_text");
  HOOKUP_OBJECT (window, label9, "label9");
  HOOKUP_OBJECT (window, scrolledwindow3, "scrolledwindow3");
  HOOKUP_OBJECT (window, statearea_scrlwin, "statearea_scrlwin");
  HOOKUP_OBJECT (window, state_list, "state_list");
  HOOKUP_OBJECT (window, label10, "label10");
  HOOKUP_OBJECT (window, label11, "label11");
  HOOKUP_OBJECT (window, label12, "label12");
  HOOKUP_OBJECT (window, label13, "label13");
  HOOKUP_OBJECT (window, label14, "label14");
  HOOKUP_OBJECT (window, label15, "label15");
  HOOKUP_OBJECT (window, label16, "label16");
  HOOKUP_OBJECT (window, statusbar, "statusbar");

  ///Set Window Default Size
  gtk_window_set_default_size (GTK_WINDOW (window), 500, 800);

  gtk_widget_show (window);

  return window;
}
