#ifndef __LIBPASORI_H
#define __LIBPASORI_H

#include "libpasori_config.h"

/* DEFINE types */

#ifndef uint8
typedef unsigned char uint8;
#endif

#ifndef uint16
typedef unsigned short int uint16;
#endif

/* DEFINE pasori */



#ifdef __LIBPASORI_WITH_LIBUSB
#include <usb.h>
struct tag_pasori{
        struct usb_device* dev;
        usb_dev_handle *dh;
};
#endif
#ifdef __LIBPASORI_WITH_BSDUGEN

struct tag_pasori{ /* FIXME: merge global header */
       int fd_cntl;
       int fd_intr;
      volatile uint8 id[8];
       int mdate;
};

#endif


typedef struct tag_pasori pasori;
/*~DEFINE pasori */

/* DEFINE felica */

struct tag_felica{
	pasori* p;
	uint16 systemcode;
	uint8 IDm[8];
	uint8 PMm[8];
};
typedef struct tag_felica felica;

struct tag_felica_block{
	uint8 data[8];
};
typedef struct tag_felica_block felica_block;

/*~DEFINE felica */

#include "libpasori_com.h"


/* DEFINE constants */

#define POLLING_ANY 0xffff
#define POLLING_SUICA 0x0300
#define POLLING_EDY 0x00fe 

#define FELICA_CMD_POLLING 0
#define FELICA_ANS_POLLING 1

#define FELICA_CMD_REQUEST_RESPONSE 4
#define FELICA_ANS_REQUEST_RESPONSE 5

#define FELICA_CMD_READ_WITHOUT_ENCRYPTION 6
#define FELICA_ANS_READ_WITHOUT_ENCRYPTION 7

#define FELICA_CMD_WRITE_WITHOUT_ENCRYPTION 8
#define FELICA_ANS_WRITE_WITHOUT_ENCRYPTION 9

#define PASORI2_CMD_SELF_DIAGNOSIS 0x52
#define PASORI2_ANS_SELF_DIAGNOSIS 0x53

#define PASORI2_CMD_GET_FIRMWARE_VERSION 0x58
#define PASORI2_ANS_GET_FIRMWARE_VERSION 0x59

#define PASORI2_CMD_SEND_PACKET 0x5c
#define PASORI2_ANS_SEND_PACKET 0x5d

#define PASORI2_DIAG_COMMUNICATION_LINE_TEST 0x00
#define PASORI2_DIAG_EEPROM_TEST 0x01
#define PASORI2_DIAG_RAM_TEST 0x02
#define PASORI2_DIAG_CPU_FUNCTION_TEST 0x03
#define PASORI2_DIAG_CPU_FANCTION_TEST 0x03
#define PASORI2_DIAG_POLLING_TEST_TO_CARD 0x10

/*~DEFINE constants */

#endif
