﻿Imports System.Linq
Imports System.Windows
Imports System.Windows.Media
Imports System.Windows.Media.Imaging
Imports System.IO

Imports Microsoft.Kinect

''' <summary>
''' Interaction logic for MainWindow.xaml 
''' </summary>
''' <remarks></remarks>
Class MainWindow
#Region "メンバー変数"
    Private _Kinect As KinectSensor
    Private _ColorImageBitmap As WriteableBitmap
    Private _ColorImageBitmapRect As Int32Rect
    Private _ColorImageStride As Integer
    Private _ColorImagePixelData() As Byte
#End Region

#Region "コンストラクタ"
    Sub New()

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        AddHandler CompositionTarget.Rendering, AddressOf CompositionTarget_Rendering
    End Sub
#End Region

#Region "メソッド"
    ' Listing 2-11
    Private Sub DiscoverKinectSensor()
        If Me._Kinect IsNot Nothing AndAlso Me._Kinect.Status <> KinectStatus.Connected Then
            'センサーが接続状態でなくなったら、新しいセンサーを検出する必要がある
            Me._Kinect = Nothing
        End If

        If Me._Kinect Is Nothing Then
            '接続されている最初のセンサーを見つける
            Me._Kinect = KinectSensor.KinectSensors.FirstOrDefault(Function(x)
                                                                       Return x.Status = KinectStatus.Connected
                                                                   End Function)
            If Me._Kinect IsNot Nothing Then
                '検出したセンサーを初期化する
                Me._Kinect.ColorStream.Enable()
                Me._Kinect.Start()

                Dim colorStream As ColorImageStream = Me._Kinect.ColorStream
                Me._ColorImageBitmap = New WriteableBitmap(colorStream.FrameWidth,
                                                           colorStream.FrameHeight,
                                                           96,
                                                           96,
                                                           PixelFormats.Bgr32,
                                                           Nothing)
                Me._ColorImageBitmapRect = New Int32Rect(0,
                                                         0,
                                                         colorStream.FrameWidth,
                                                         colorStream.FrameHeight)
                Me._ColorImageStride = colorStream.FrameWidth * colorStream.FrameBytesPerPixel
                Me.ColorImageElement.Source = Me._ColorImageBitmap
                ReDim Me._ColorImagePixelData(colorStream.FramePixelDataLength - 1)
            End If
        End If
    End Sub

    ' Listing 2-12
    Private Sub PollColorImageStream()
        If Me._Kinect Is Nothing Then
            'TODO: Kinectの接続を促すメッセージを表示する
        Else
            Try
                Using frame As ColorImageFrame = Me._Kinect.ColorStream.OpenNextFrame(100)
                    If frame IsNot Nothing Then
                        frame.CopyPixelDataTo(Me._ColorImagePixelData)
                        Me._ColorImageBitmap.WritePixels(Me._ColorImageBitmapRect,
                                                         Me._ColorImagePixelData,
                                                         Me._ColorImageStride,
                                                         0)
                    End If
                End Using
            Catch ex As Exception
                'TODO: エラーメッセージをレポートする
            End Try
        End If
    End Sub

    Private Sub CompositionTarget_Rendering(sender As Object, e As EventArgs)
        DiscoverKinectSensor()
        PollColorImageStream()
    End Sub
#End Region
End Class
