﻿Imports System.Windows

Namespace Input
    Public Delegate Sub KinectCursorEventHandler(sender As Object, e As KinectCursorEventArgs)

    ''' <summary>
    ''' KinectInput is a contains custom events used in the Beginning.Kinect.Framework.
    ''' </summary> 
    Public Class KinectInput

#Region "KinectCursorEnter"

        ''' <summary>
        ''' Identifies the KinectCursorEnterEvent.
        ''' </summary>
        Public Shared ReadOnly KinectCursorEnterEvent As RoutedEvent = EventManager.RegisterRoutedEvent("KinectCursorEnter", RoutingStrategy.Bubble,
                                                                                                        GetType(KinectCursorEventHandler),
                                                                                                        GetType(KinectInput))
        ''' <summary>
        ''' Adds a specified event handler for the KinectCursorEnter event.
        ''' </summary>
        ''' <param name="o">The object that listens to the event.</param>
        ''' <param name="handler">The event handler to add.</param>
        Public Shared Sub AddKinectCursorEnterHandler(o As DependencyObject, handler As KinectCursorEventHandler)
            CType(o, UIElement).AddHandler(KinectCursorEnterEvent, handler)
        End Sub
        ''' <summary>
        ''' Remove the specified event handler for the KinectCursorEnter event.
        ''' </summary>
        ''' <param name="o">The object that listens to the event.</param>
        ''' <param name="handler">The event handler to add.</param>
        Public Shared Sub RemoveKinectCursorEnterHandler(o As DependencyObject, handler As KinectCursorEventHandler)
            CType(o, UIElement).RemoveHandler(KinectCursorEnterEvent, handler)
        End Sub

#End Region

#Region "KinectCursorLeave"

        ''' <summary>
        ''' Identifies the KinectCursorLeaveEvent.
        ''' </summary>
        Public Shared ReadOnly KinectCursorLeaveEvent As RoutedEvent = EventManager.RegisterRoutedEvent("KinectCursorLeave", RoutingStrategy.Bubble,
                                                                                                        GetType(KinectCursorEventHandler),
                                                                                                        GetType(KinectInput))
        ''' <summary>
        ''' Adds a specified event handler for the KinectCursorLeave event.
        ''' </summary>
        ''' <param name="o">The object that listens to the event.</param>
        ''' <param name="handler">The event handler to add.</param>
        Public Shared Sub AddKinectCursorLeaveHandler(o As DependencyObject, handler As KinectCursorEventHandler)
            CType(o, UIElement).AddHandler(KinectCursorEnterEvent, handler)
        End Sub
        ''' <summary>
        ''' Remove the specified event handler for the KinectCursorLeave event.
        ''' </summary>
        ''' <param name="o">The object that listens to the event.</param>
        ''' <param name="handler">The event handler to add.</param>
        Public Shared Sub RemoveKinectCursorLeaveHandler(o As DependencyObject, handler As KinectCursorEventHandler)
            CType(o, UIElement).RemoveHandler(KinectCursorEnterEvent, handler)
        End Sub
#End Region

#Region "KinectCursorActivated"

        ''' <summary>
        ''' Identifies the KinectCursorActivatedEvent.
        ''' </summary>
        Public Shared ReadOnly KinectCursorActivatedEvent As RoutedEvent = EventManager.RegisterRoutedEvent("KinectCursorActivated", RoutingStrategy.Bubble,
                                                                                                            GetType(RoutedEventHandler),
                                                                                                            GetType(KinectInput))
        ''' <summary>
        ''' Adds a specified event handler for the KinectCursorActivated event.
        ''' </summary>
        ''' <param name="o">The object that listens to the event.</param>
        ''' <param name="handler">The event handler to add.</param>
        Public Shared Sub AddKinectCursorActivatedHandler(o As DependencyObject, handler As RoutedEventHandler)
            CType(o, UIElement).AddHandler(KinectCursorActivatedEvent, handler)
        End Sub
        ''' <summary>
        ''' Remove the specified event handler for the KinectCursorActivated event.
        ''' </summary>
        ''' <param name="o">The object that listens to the event.</param>
        ''' <param name="handler">The event handler to add.</param>
        Public Shared Sub RemoveKinectCursorActivatedHandler(o As DependencyObject, handler As RoutedEventHandler)
            CType(o, UIElement).RemoveHandler(KinectCursorActivatedEvent, handler)
        End Sub
#End Region

#Region "KinectCursorDeactivated"
        ''' <summary>
        ''' Identifies the KinectCursorvctivatedEvent.
        ''' </summary>
        Public Shared ReadOnly KinectCursorDeactivatedEvent As RoutedEvent = EventManager.RegisterRoutedEvent("KinectCursorDeactivated", RoutingStrategy.Bubble,
                                                                                                               GetType(RoutedEventHandler),
                                                                                                               GetType(KinectInput))
        ''' <summary>
        ''' Adds a specified event handler for the KinectCursorDeactivated event.
        ''' </summary>
        ''' <param name="o">The object that listens to the event.</param>
        ''' <param name="handler">The event handler to add.</param>
        Public Shared Sub AddKinectCursorDeactivatedHandler(o As DependencyObject, handler As RoutedEventHandler)
            CType(o, UIElement).AddHandler(KinectCursorDeactivatedEvent, handler)
        End Sub
        ''' <summary>
        ''' Remove the specified event handler for the KinectCursorDeactivated event.
        ''' </summary>
        ''' <param name="o">The object that listens to the event.</param>
        ''' <param name="handler">The event handler to add.</param>
        Public Shared Sub RemoveKinectCursorDeactivatedHandler(o As DependencyObject, handler As RoutedEventHandler)
            CType(o, UIElement).RemoveHandler(KinectCursorDeactivatedEvent, handler)
        End Sub
#End Region

#Region "KinectCursorMove"

        ''' <summary>
        ''' Identifies the KinectCursorMoveEvent.
        ''' </summary>
        Public Shared ReadOnly KinectCursorMoveEvent As RoutedEvent = EventManager.RegisterRoutedEvent("KinectCursorMove", RoutingStrategy.Bubble,
                                                                                                       GetType(KinectCursorEventHandler),
                                                                                                       GetType(KinectInput))
        ''' <summary>
        ''' Adds a specified event handler for the KinectCursorMove event.
        ''' </summary>
        ''' <param name="o">The object that listens to the event.</param>
        ''' <param name="handler">The event handler to add.</param>
        Public Shared Sub AddKinectCursorMoveHandler(o As DependencyObject, handler As KinectCursorEventHandler)
            CType(o, UIElement).AddHandler(KinectCursorMoveEvent, handler)
        End Sub
        ''' <summary>
        ''' Remove the specified event handler for the KinectCursorMove event.
        ''' </summary>
        ''' <param name="o">The object that listens to the event.</param>
        ''' <param name="handler">The event handler to add.</param>
        Public Shared Sub RemoveKinectCursorMoveHandler(o As DependencyObject, handler As KinectCursorEventHandler)
            CType(o, UIElement).RemoveHandler(KinectCursorMoveEvent, handler)
        End Sub
#End Region

        Public Shared ReadOnly KinectCursorLockEvent As RoutedEvent = EventManager.RegisterRoutedEvent("KinectCursorLock", RoutingStrategy.Bubble,
                                                                                                       GetType(KinectCursorEventHandler),
                                                                                                       GetType(KinectInput))

        ''' <summary>
        ''' Adds the kinect cursor lock handler.
        ''' </summary>
        ''' <param name="o">The o.</param>
        ''' <param name="handler">The handler.</param>
        Public Shared Sub AddKinectCursorLockHandler(o As DependencyObject, handler As KinectCursorEventHandler)
            CType(o, UIElement).AddHandler(KinectCursorLockEvent, handler)
        End Sub

        Public Shared ReadOnly KinectCursorUnlockEvent As RoutedEvent = EventManager.RegisterRoutedEvent("KinectCursorUnlock", RoutingStrategy.Bubble,
                                                                                                         GetType(KinectCursorEventHandler),
                                                                                                         GetType(KinectInput))

        ''' <summary>
        ''' Adds the kinect cursor unlock handler.
        ''' </summary>
        ''' <param name="o">The o.</param>
        ''' <param name="handler">The handler.</param>
        Public Shared Sub AddKinectCursorUnlockHandler(o As DependencyObject, handler As KinectCursorEventHandler)
            CType(o, UIElement).AddHandler(KinectCursorUnlockEvent, handler)
        End Sub
    End Class
End Namespace
