﻿Imports System.Windows
Imports System.ComponentModel
Imports Microsoft.Kinect

Class MainWindow
    Implements INotifyPropertyChanged

    Public Sub New()
        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        Me.DataContext = Me
        AddHandler Me.Loaded, Sub()
                                  ListenForBeamChanges()
                              End Sub
    End Sub
    Private Function CreateAudioSource() As KinectAudioSource
        Dim source As KinectAudioSource = KinectSensor.KinectSensors(0).AudioSource
        source.NoiseSuppression = True
        source.AutomaticGainControlEnabled = True
        source.BeamAngleMode = BeamAngleMode.Adaptive
        Return source
    End Function

    Private Sub ListenForBeamChanges()
        KinectSensor.KinectSensors(0).Start()
        Dim audioSource As KinectAudioSource = CreateAudioSource()
        AddHandler audioSource.BeamAngleChanged, AddressOf audioSource_BeamAngleChanged
        audioSource.Start()
    End Sub

    Public Event PropertyChanged(sender As Object, e As System.ComponentModel.PropertyChangedEventArgs) Implements System.ComponentModel.INotifyPropertyChanged.PropertyChanged
    Private Sub NotifyPropertyChanged(ByVal propName As String)
        Dim handler As PropertyChangedEventHandler = PropertyChangedEvent
        If Nothing IsNot handler Then
            handler(Me, New PropertyChangedEventArgs(propName))
        End If
    End Sub

    Private _beamAngle As Double
    Public Property BeamAngle As Double
        Get
            Return _beamAngle
        End Get
        Set(value As Double)
            _beamAngle = value
            NotifyPropertyChanged("BeamAngle")
        End Set
    End Property

    Sub audioSource_BeamAngleChanged(sender As Object, e As BeamAngleChangedEventArgs)
        BeamAngle = -1 * e.Angle
    End Sub

End Class
