﻿Imports System.Windows
Imports Microsoft.Kinect
Imports ImageLibrarySamples.ImageManipulationExtensionMethods

Class MainWindow
    Private _kinectSensor As Microsoft.Kinect.KinectSensor

    Public Sub New()

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        AddHandler Me.Unloaded, Sub()
                                    _kinectSensor.ColorStream.Disable()
                                    _kinectSensor.DepthStream.Disable()
                                End Sub

        AddHandler Me.Loaded, Sub()
                                  _kinectSensor = KinectSensor.KinectSensors(0)
                                  _kinectSensor.ColorStream.Enable(ColorImageFormat.RgbResolution640x480Fps30)
                                  _kinectSensor.DepthStream.Enable(DepthImageFormat.Resolution320x240Fps30)
                                  AddHandler _kinectSensor.ColorFrameReady, AddressOf ColorFrameReady
                                  AddHandler _kinectSensor.DepthFrameReady, AddressOf DepthFrameReady

                                  _kinectSensor.Start()
                              End Sub
    End Sub

    Sub DepthFrameReady(sender As Object, e As DepthImageFrameReadyEventArgs)
        Me.depthImage.Source = e.OpenDepthImageFrame().ToBitmap().ToBitmapSource()
    End Sub

    Sub ColorFrameReady(sender As Object, e As ColorImageFrameReadyEventArgs)
        Me.rgbImage.Source = e.OpenColorImageFrame().ToBitmapSource()
    End Sub
End Class
