//=========================================================================
//	JNX[ camera.cpp ]
//	쐬ҁF
//	쐬F2017/04/27
//=========================================================================
//=========================================================================
//	CN[ht@C
//=========================================================================
#include	"main.h"
#include	"camera.h"
#include	"renderer.h"
#include	"manager.h"

//=========================================================================
//	萔`
//=========================================================================
//_ω
#define LOOKAT_RANGE ( 2.0f )
//]ω
#define ROTATE_RAD   ( 0.05f )
//ړω
#define MOVE_RANGE  ( 0.5f )

//=========================================================================
//	RXgN^
//=========================================================================
CCamera::CCamera()
{
	MembervariableIniter();

	SetRotRange( ROTATE_RAD );
}

//=========================================================================
//	fXgN^
//=========================================================================
CCamera::~CCamera()
{

}

//=========================================================================
// 
//=========================================================================
void	CCamera::Init( void )
{

	MembervariableIniter();

	SetAngle( ( 270 * D3DX_PI ) / 180 );
	SetLength( -10.0f );
	SetRotRange( 0.1f );

	SetPosAt( D3DXVECTOR3( 0.0f , 4.0f , 0.0f ) );	//(_)
	
	//ڂ̈ʒu
	SetPosEye( D3DXVECTOR3( 0.0f ,
							6.0f , 
							-25.0f ));
	
	SetVecUp ( D3DXVECTOR3( 0.0f , 1.0f , 0.0f ) );	//̌

	//p[XeBNeBus쐬	
	D3DXMatrixPerspectiveFovLH( &m_mtxProj ,
								D3DX_PI / 3.0f ,	//p
								(float)SCREEN_WIDTH / (SCREEN_HEIGHT),	//AXyNg
								0.1f,	// near ̒lOɂĂ͍sȂ@łOK
								5000.0f);//far

}

//=========================================================================
// I
//=========================================================================
void	CCamera::Uninit( void )
{
	
}

//=========================================================================
// XV
//=========================================================================
void	CCamera::Update( void )
{

	//J̉]
	m_PosAt.x = m_PosEye.x + ( sinf( GetAngle() )  * LOOKAT_RANGE ) ;
	//m_PosAt.y = 1.0f ; 
	m_PosAt.z = m_PosEye.z + ( cosf( GetAngle() ) * LOOKAT_RANGE );

	//_̉]
	m_PosAt.x = cosf( GetAngle() ) * ( GetLength() ) + GetPosEye().x;
	m_PosAt.z = sinf( GetAngle() ) * ( GetLength() ) + GetPosEye().z;

	//sړ𔽉f
	SetPosEye( D3DXVECTOR3( GetPosEye().x + GetSpeed().x ,
							GetPosEye().y + GetSpeed().y ,
							GetPosEye().z + GetSpeed().z));

	//_sړ
	SetPosAt( D3DXVECTOR3(	GetPosAt().x + GetSpeed().x ,
							GetPosAt().y + GetSpeed().y ,
							GetPosAt().z + GetSpeed().z));

	SetSpeed( D3DXVECTOR3( 0.0f , 0.0f , 0.0f ) );

}

//=========================================================================
//	J̏ԂfoCXɓo^
//=========================================================================
void	CCamera::Set( void )
{
	LPDIRECT3DDEVICE9	pDevice;
	pDevice = CRenderer::GetDevice();

	//p[XyNeBus̐ݒ
	pDevice->SetTransform( D3DTS_PROJECTION , &m_mtxProj );

	// r[s̍쐬
	D3DXMatrixLookAtLH( &m_mtxView , &m_PosEye , &m_PosAt , &m_VecUp );

	//foCXɃr[ϊsݒ
	pDevice->SetTransform( D3DTS_VIEW , &m_mtxView);
}

//=========================================================================
//	oϐ̏
//=========================================================================
void	CCamera::MembervariableIniter( void )
{
	D3DXMatrixIdentity( &m_mtxProj );	//vWFNVs̏
	D3DXMatrixIdentity(	&m_mtxView );	//Js̏
	SetAngle( 0.0f );			//Jpx
	SetRotRange( 0.0f ); 		//J]x
	SetLength( 1.0f );		//Ε
	SetSpeed( D3DXVECTOR3( 0.0f , 0.0f , 0.0f ) );		//ړx
	SetPosEye( D3DXVECTOR3( 0.0f , 0.0f , 0.0f ) );	//JW̏
	SetPosAt( D3DXVECTOR3( 0.0f , 0.0f , 1.0f ) );	//J_
	SetVecUp( D3DXVECTOR3( 0.0f , 1.0f , 0.0f ) );	//J
}

//=========================================================================
//	J̉]
//=========================================================================
void	CCamera::Rotate ( DIRECTION dir )
{
	if( dir == DIRECTION_RIGHT )
	{
		AddAngle( -GetRotRange() );
	}

	if( dir == DIRECTION_LEFT )
	{
		AddAngle( GetRotRange() );
	}


}

//=========================================================================
//	J̕sړ
//=========================================================================
void	CCamera::Move	( DIRECTION dir )
{
	switch ( dir )
	{
	case DIRECTION_BACK:

		m_Speed.x = cosf(m_fAngle) * (MOVE_RANGE);
		m_Speed.z = sinf(m_fAngle) * (MOVE_RANGE);
		break;

	case DIRECTION_RIGHT:

		m_Speed.x = cosf(m_fAngle + ( D3DX_PI / 2)) * (MOVE_RANGE);
		m_Speed.z = sinf(m_fAngle + ( D3DX_PI / 2)) * (MOVE_RANGE);
		break;

	case DIRECTION_ADVANCE: 
		m_Speed.x = cosf( m_fAngle - ( D3DX_PI )) * (MOVE_RANGE);
		m_Speed.z = sinf( m_fAngle - ( D3DX_PI )) * (MOVE_RANGE);
		break;

	case DIRECTION_LEFT:
		m_Speed.x = cosf(m_fAngle - (D3DX_PI / 2)) * (MOVE_RANGE);
		m_Speed.z = sinf(m_fAngle - (D3DX_PI / 2)) * (MOVE_RANGE);
		break;

	default:
		break;
	}
}