//=========================================================================
//	CSceneMeshNX [ sceneMesh.cpp ]
//	쐬F2017/05/02
//	쐬ҁF
//=========================================================================
//=========================================================================
//	CN[ht@C
//=========================================================================
#include	"sceneMesh3D.h"
#include	"manager.h"
#include	"renderer.h"
//=========================================================================
//	萔`
//=========================================================================
#define	TEXTURE_NAME ("data/TEXTURE/field000.jpg")

//=========================================================================
//	CXgN^
//=========================================================================
CSceneMesh3D::CSceneMesh3D( int sheetTate , int sheetYoko , D3DXVECTOR3 Size )
{

}

//=========================================================================
//	
//=========================================================================
void	CSceneMesh3D::Init( void )
{
	//foCX̎擾
	LPDIRECT3DDEVICE9	pDevice;
	pDevice = CRenderer::GetDevice();

	//hrɊ֐͂Ă̂ŁAFAILED}NɓΉɒȂȂ
	if( FAILED( D3DXCreateTextureFromFile( pDevice , TEXTURE_NAME , &m_pTexture ) ) )
	{	//FALED}N@s𔻒f
		UINT nID = MessageBox( NULL , "|St@C܂\n" , "ERROR[ sceneMesh3D.cpp ]" , MB_OK | MB_ICONEXCLAMATION );		
	}
	//FAILED}NŃG[`FbN

	//Sʒu
	SetPosition( D3DXVECTOR3( 0 , 0 , 0 ) );

	float fLengthYoko = GetSize().x;
	float fLengthTate = GetSize().y;
	unsigned int nFieldYoko = ( unsigned int )GetSheet().x;
	unsigned int nFieldTate = ( unsigned int )GetSheet().y;

	//Ίp̒
	SetLength( sqrtf( ( fLengthYoko * nFieldYoko ) * ( fLengthTate * nFieldTate) / 2 ));

	SetAngle( (atan2f( fLengthTate * nFieldTate , fLengthYoko * nFieldYoko ) ) );

	//tB[h̍
	SetStartPos( D3DXVECTOR3( -( GetLength() * cosf( GetAngle() )) , 0.0f , ( GetLength() * sinf( GetAngle() ) ) ) );

	SetNumVertex( ( nFieldTate + 1 ) * ( nFieldYoko + 1 ) );

	MakeVertex( pDevice );
}

//=========================================================================
//	I
//=========================================================================
void	CSceneMesh3D::Uninit( void )
{
	if(m_pVtxBuffer != NULL)
	{
		m_pVtxBuffer->Release();
		m_pVtxBuffer = NULL;
	}

	if(m_pTexture != NULL)
	{
		m_pTexture->Release();
		m_pTexture = NULL;
	}
}

//=========================================================================
//	XV
//=========================================================================
void	CSceneMesh3D::Update( void )
{/*ωȂ̂Ŗ*/}

//=========================================================================
//	`揈
//=========================================================================
void	CSceneMesh3D::Draw( void )
{
	//foCX̎擾
	LPDIRECT3DDEVICE9	pDevice;
	pDevice = CRenderer::GetDevice();

	D3DXMATRIX	mtxWorld;	//[h}gNX
	D3DXMatrixIdentity( &mtxWorld );

	//g̏
	D3DXMATRIX	mtxKakudai;	//gs
	D3DXMatrixScaling( &mtxKakudai , 1.0f , 1.0f , 1.0f );

	//]̏
	D3DXMATRIX	mtxKaiten;	//]s
	D3DXMatrixRotationYawPitchRoll( &mtxKaiten , 0.0f , 0.0f , 0.0f );	
	
	D3DXMATRIX	mtxHeikou;	//sړs
	D3DXMatrixTranslation( &mtxHeikou , GetPosition().x , GetPosition().y , GetPosition().z );

	//s̊|Z
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxKakudai );	
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxKaiten );	
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxHeikou );	

	//foCXɃ[hϊso^
	pDevice->SetTransform( D3DTS_WORLD , &mtxWorld );

	pDevice->SetStreamSource( 0 , m_pVtxBuffer , 0 , sizeof(VERTEX_3D) );

	pDevice->SetIndices( m_pIndexBuffer );

	pDevice->SetFVF( FVF_VERTEX_3D );

	pDevice->SetTexture( 0,  m_pTexture );

	//|S̕`
	pDevice->DrawIndexedPrimitive( 
		D3DPT_TRIANGLESTRIP ,
		 0 , //ŏ̒_CfbNX܂ł̃ItZbg
		 0 , //ŏ_CfbNX
		 GetNumIndex() ,	//_
		 0 , //X^[gCfbNX
		 GetPolygonNum() - 2 //v~eBu
	 );
}

//=========================================================================
//	_̕ҏW
//=========================================================================
HRESULT	CSceneMesh3D::MakeVertex( LPDIRECT3DDEVICE9 pDevice )
{
	unsigned int nFieldTate = ( unsigned int )GetSheet().z;
	unsigned int nFieldYoko = ( unsigned int )GetSheet().x;

	float	fLengthTate = GetSize().z;
	float	fLengthYoko = GetSize().x;

	//_obt@̐
	//FALED}Nł
	if( FAILED(pDevice->CreateVertexBuffer( sizeof(VERTEX_3D) * GetNumVertex() , //mۂobt@TCY(byte)
											D3DUSAGE_WRITEONLY , //̎gp@  Ƃ肠ꂾĂΑ@G`̂
											FVF_VERTEX_3D , //gp钸_tH[}bg ł͂Oőv
											D3DPOOL_MANAGED , //obt@̊Ǘ@@̂͂܂̂
											&m_pVtxBuffer , //|C^̊i[
											NULL ))) //Ȃ񂾂킩Ȃ)
	{										
		UINT nID = MessageBox( NULL , "_obt@ł܂\n" , "ERROR[ sceneMesh3D.cpp ]" , MB_OK | MB_ICONEXCLAMATION );		
		return E_FAIL;
	}

	//VERTEX_2D^̃|C^
	VERTEX_3D* pVtx = NULL;

	//obt@bNzAhX擾
	m_pVtxBuffer->Lock( 0 , 0 , (void**)&pVtx ,0 );	//̍ŏQɂOOw肷ƑS

	
	//_W̐ݒ				 X		   Y		Z
	//ĉ
	for( unsigned int numTate = 0 ; numTate <= nFieldTate ; numTate++ )
	{
		//̂
		for( unsigned int numYoko = 0 ; numYoko <= nFieldYoko ; numYoko++ )
		{
			pVtx[ numTate * ( nFieldYoko + 1 ) + numYoko ].pos = D3DXVECTOR3( GetStartPos().x + ( fLengthYoko * numYoko ) , 0.0f , GetStartPos().z - ( numTate * fLengthTate ) );
			pVtx[ numTate * ( nFieldYoko + 1 ) + numYoko ].tex = D3DXVECTOR2( (float)numYoko , (float)numTate );

			float	x = GetStartPos().x + ( fLengthYoko * numYoko);
			float	z = GetStartPos().z - ( numTate * fLengthTate);
			x = x;
		}
	}

	//@
	for( unsigned int i = 0 ; i < GetNumVertex() ; i++ )
	{
		pVtx[i].normal = D3DXVECTOR3(  0.0f , -1.0f , 0.0f );
		pVtx[i].color = D3DCOLOR_RGBA( 255, 255 , 255  , 255); 
	}


	m_pVtxBuffer->Unlock();

	//CfbNXobt@̍쐬
	if( pDevice->CreateIndexBuffer(
	sizeof( DWORD ) * GetNumIndex(),	//obt@(32ɂDWORDɂ)
	D3DUSAGE_WRITEONLY ,		//gp@tO
	D3DFMT_INDEX16 ,			//CfbNXtH[}bg
	D3DPOOL_MANAGED ,			//Ǘ@
	&m_pIndexBuffer ,		//CfbNXobt@[C^[tF[Xւ̃|C^̃AhX
	NULL ) )
	{
		UINT nID = MessageBox( NULL , "CfbNXobt@ł܂\n" , "G[" , MB_YESNO | MB_ICONEXCLAMATION );		
		return E_FAIL;
	}


	
	WORD* pIdx;
	m_pIndexBuffer->Lock( 0 , 0 , (void**)&pIdx , 0 );	//̈Ӗ̓o[ebNXobt@[̂ƂƓ

	int	index = 0;
	for( unsigned int nCntZ = 0 ; nCntZ < nFieldYoko ; nCntZ++ )
	{
		if( nCntZ != 0  )
		{
			pIdx[ index ] = (nFieldYoko + 1) * nCntZ+ (nFieldYoko + 1);
			index++;
		}
		pIdx[ index ] = (nFieldYoko+1)  * ( nCntZ + 1 );
		index++;
		pIdx[ index ] = (nFieldYoko+1) * nCntZ ;
		index++;
	
		for( unsigned int nCntX = 0 ; nCntX < nFieldYoko ; nCntX++ )
		{
			pIdx[ index ] = ( nFieldYoko + 1 ) * (nCntZ + 1) + (nCntX + 1);
			index++;
			pIdx[ index ] = ( nFieldYoko + 1 ) * nCntZ + (nCntX +1);
			index++;
		}
		if(nCntZ != (nFieldTate -1) )
		{
			pIdx[ index ] = nFieldYoko + ( nCntZ * (nFieldYoko+1) );
			index++;
 		}
	}

	m_pIndexBuffer->Unlock();
	

	return	S_OK;
}