// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// UssConnectionManager.h
// $Id: UssConnectionMonitor.h,v 1.21 2001/08/06 04:44:21 seagull Exp $
//


#if !defined(USS_H_ConnectionManager)
#define USS_H_ConnectionManager

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#include <algorithm>
#include <list>
#include <set>

#include "UssFileDescriptor.h"
#include "UssSocket.h"

class UssIOBuffer_Slide;
class UssIOBuffer_Queue;



class UssConnectionMonitor;




/**
   ̿٥Ȥȯ륯饹ݴ쥯饹
 */
class IUssConnectionEvent
{
public:
  /** ֥Ȥۤޤ
   */
  IUssConnectionEvent()
  {
    m_tvLast.tv_sec = 0;
    m_tvLast.tv_usec = 0;
    m_nTimeup = 0;
  }

  /** ̿˻Ѥ UssFileDescriptor ֥Ȥ᤹ޤ

     @return UssFileDescriptor ֥
   */
  virtual UssFileDescriptor* getFileDescriptor() const = 0;


  /**
     getFileDescriptor֤եǥץ򥯥ޤ
   */
  void close()
  {
    UssFileDescriptor* fd = getFileDescriptor();
    if (fd && fd->isOpened())
      fd->close();
  }

  /** ΥͥˤĤԤ碌ǧ˸ƤӽФޤ
      ޤUssFileDescriptorǤǤޤ

      @return Ԥ碌Ԥʤϡfalseᤷޤ
   */
  virtual bool onPrepareForWaiting();


  /** ɤ߹ǽ٥Ȥɬפ뤫

      @return
      ɤ߹ߥ٥Ȥʤˤfalseᤷޤ
  */
  virtual bool isNeedHandleToRead() const;


  /** 񤭹ǽ٥Ȥɬפ뤫
     
      @return
      񤭹ߥ٥Ȥʤˤfalseᤷޤ
  */
  virtual bool isNeedHandleToWrite() const;


  /** 㳰٥Ȥɬפ뤫

      @return
      㳰٥Ȥʤˤfalse ᤷޤ
   */
  virtual bool isNeedHandleToException() const;


  /**
     ɤ߹߲ǽ֤ˤʤäΥ٥Ȥªޤ
   */
  virtual void onReadSignal();

  /**
     񤭹߲ǽ֤ˤʤäΥ٥Ȥªޤ
   */
  virtual void onWriteSignal();

  /**
     㳰֤ˤʤäΥ٥Ȥªޤ
   */
  virtual void onExceptionSignal();




  /**
     ¦³äΥ٥Ȥªޤ
     @REMARK
     UssServerSocketConnectionEvent ³סȤϿ줿
     ϼưǸƤӽФޤǤʤϼǸƤӽФ
     Ƥ
   */
  virtual void onConnectSignal();


  /**
     Ǥ줿˸ƤӽФޤ
   */
  virtual void onDisconnectSignal();



  /**
     Ϣ³̵֤̿ˤäƼưŪ˲Ǥ֤ꤷޤ
     @param timeup   ưǤޤǤ̵̿֡ʥߥá
                     ꤹȡưǤϹԤޤ
   */
  void setAutoDisconnectTimer(unsigned long timeup)
  {
    m_nTimeup = timeup;
  }
  /**
     ưǤޤǤϢ³̵̿ƻ֤ᤷޤ

     @returm
     ꤵƤ뼫ưǻ֡
   */
  unsigned long getAutoDisconnectTimer() const
  {
    return m_nTimeup;
  }

  /**
     Ϣ³̵̿ƻԤ硢ǡΤȤ꤬ä
     ƤӽФƤ
   */
  void flushAutoDisconnectTimer()
  {
    ::gettimeofday(&m_tvLast, NULL);
  }

protected:
  unsigned long m_nTimeup;  // ưǤޤǤϢ³̵̿֡ʥߥá
  timeval m_tvLast;         // Ǹ̿Ԥä
};








/* ====================================================================== */

/**
   Ϥ˥ХåեѤ륳ͥ

   @param TF    ³ȤƻѤ UssFileDescriptor 
   @param TBI   ϥХåեȤƻѤ UssIOBuffer 
   @param TBO   ϥХåեȤƻѤ UssIOBuffer 
 */
template <class TF = UssFileDescriptor, class TBI = UssIOBuffer_Slide, class TBO = UssIOBuffer_Queue>
class TIUssBufferedConnectionEvent :
  public IUssConnectionEvent
{
public:
  /**
     ֥Ȥۤޤ
  */
  TIUssBufferedConnectionEvent()
  {
    m_IBuffer.setRedirectTo(&m_fd);
    m_OBuffer.setRedirectTo(&m_fd);

    m_bFlushTimerOnRead = true;
    m_bFlushTimerOnWrite = true;
  }

  /**
     ֥Ȥ˴ޤ
   */
  virtual ~TIUssBufferedConnectionEvent()
  {
  }


  /**
     ³٥Ȥ˷դƤեǥץᤷޤ
   */
  virtual TF* getFileDescriptor() const
  {
    return const_cast<TF*>(&m_fd);
  }

  /**
     ϥХåեΥݥ󥿤ᤷޤ

     @return
     ϥХåեǤ UssIOBuffer ֥ȤؤΥݥ
   */
  TBI* getIBuffer() const
  {
    return const_cast<TBI*>(&m_IBuffer);
  }


  /**
     ϥХåեΥݥ󥿤ᤷޤ

     @return
     ϥХåեǤ UssIOBuffer ֥ȤؤΥݥ
  */
  TBO* getOBuffer() const
  {
    return const_cast<TBO*>(&m_OBuffer);
  }


  /**
     Ϣ³̵֤̿ˤäƼưŪ˲Ǥ֤ꤷޤ

     @param timeup   ưǤޤǤ̵̿֡ʥߥá
                     ꤹȡưǤϹԤޤ
     @param onread ɤ߹߻˥ꥻåȤˤ true
     @param onwrite 񤭹߻˥ꥻåȤˤ true
   */
  void setAutoDisconnectTimer(unsigned long timeup, bool onread=true, bool onwrite=true)
  {
    IUssConnectionEvent::setAutoDisconnectTimer(timeup);
    m_bFlushTimerOnRead = onread;
    m_bFlushTimerOnWrite = onwrite;
  }
  


protected:
  bool isNeedHandleToRead() const
  {
    return getFileDescriptor()->isOpened() && ! m_IBuffer.isFull();
  }

  bool isNeedHandleToWrite() const
  {
    return getFileDescriptor()->isOpened() && ! m_OBuffer.isEmpty();
  }


  void onReadSignal()
  {
    if (m_IBuffer.fetch() == 0)
      onDisconnectSignal();
    else if (m_bFlushTimerOnRead)
      flushAutoDisconnectTimer();
  }

  void onWriteSignal()
  {
    if (m_OBuffer.flush() > 0 && m_bFlushTimerOnWrite)
      flushAutoDisconnectTimer();
  }


protected:
  TBI m_IBuffer;
  TBO m_OBuffer;
  TF m_fd;

  bool m_bFlushTimerOnWrite;
  bool m_bFlushTimerOnRead;
};



class EUssBadConnectionPool : public EUssException
{
public:
  virtual char const* getErrorMessage(char* buf, int len)
  {
    strncpy(buf, "file handle of registerd connection is not socket.", len);
    return buf;
  }
};








/**
   еǽ󶡤 ConnectionEvent

   饤Ȥ³Ե³ä makePool 
   Ͽ³ס򥻥åѤ˳Ƥޤ
 */
class UssServerSocketConnectionEvent
{
public:
  friend class UssConnectionMonitor;

  /**
     ֥Ȥۤޤ
     åȤϸƽ¦Ū˥ץ󤹤ɬפޤ
   */
  UssServerSocketConnectionEvent()
  {
  }


  /**
     ֥ȤۤꤷݡȤǥ饤Ȥ
     ³ԤĤ褦˽ޤ

     @param port Ԥ碌Ԥݡֹ
   */
  UssServerSocketConnectionEvent(int port)
  {
    m_Socket.open(port);
  }

  /**
     ꤷݡȤǥ饤Ȥ³ԤĤ褦˽ޤ

     @param port Ԥ碌Ԥݡֹ
   */
  int open(int port)
  {
    return m_Socket.open(port);
  }

  /**
     ֥Ȥθ򤷤ޤ
     ФץλˤϼưŪ˥졢ϿƤ
     ³סϺޤ
   */
  virtual ~UssServerSocketConnectionEvent();


  /**
     Ф UssSocket ֥Ȥޤ

     ܺ٥ץꤷꡢŪʥץԤ˻Ѥޤ

     @return
     ФȤƻѤƤ UssSocket ֥
   */
  UssServerSocket* getSocket() const
  {
    return const_cast<UssServerSocket*>(&m_Socket);
  }


  /**
     ³סϿޤ

     ƥץ졼ȥ᥽åɤʤΤǡ饤ȤȤƻѤ
     UssConnectionEvent 饹ʲΤ褦˻ꤷƸƽ
     ޤ

     foo.makePool<MyClient>(5);

     UssConnectionEvent 饹ϡ
     void init(UssServerSocketConnectionEvent* server)
     
     void onConnectSignal()

     ΣĤΥ᥽åɤƤɬפޤ
     init ᥽åɤϡ ֥Ȥ뤿ˡϿ
     ƤӽФޤ

     onConnectSignal ϡ饤Ȥ³դľ
     ƤӽФޤ

     @param n 륻å󥪥֥Ȥο
   */
  template <typename T>
  void makePool(int n)
  {
    while (n--)
      {
        T* p = new T;
        p->init(this);
        m_listClients.push_back(p);
        m_CreatedClients.insert(p);
      }
  }


  template <typename T>
  void addSession(T* p)
  {
    m_listClients.push_back(p);
  }


  /**
     ³סõޤ
   */
  void clearPool();


  /**
     ꤵ줿å󥪥֥Ȥޤ
     ʤ˻Ȥ뤫

     @param p оݤΥå󥪥֥
   */
  void removeSession(IUssConnectionEvent* p);

  /**
     Ф򥯥ޤ
   */
  void close();


  /**
     ƤΥ饤Ȥ򥯥ޤ
   */
  void closeAllClients();


protected:
  /**
     饤Ȥ³ƤΤǡ³ס뤫 IUssConnectionEvent
     Ф³դޤޤ
   */
  virtual void onConnectSignal();

protected:
  /** Ԥ碌˻Ѥ륵Хåȥ֥ */
  UssServerSocket m_Socket;
  /** ³ס */
  list<IUssConnectionEvent*> m_listClients;
  set<IUssConnectionEvent*> m_CreatedClients;
};







/**
   ʣ³֥ȤӥХ֥Ȥơ
   ̿٥ȤδƻԤ饹
 */
class UssConnectionMonitor
{
public:
  /**
     ֥Ȥۤޤ
  */
  UssConnectionMonitor()
  {
    m_Timeout.tv_sec = 0;
    m_Timeout.tv_usec = 0;
  }

  /**
     ֥Ȥ˴ޤ
  */
  virtual ~UssConnectionMonitor()
  {
  }


  //
  // °᥽åɷ
  //


  /**
     Ԥ碌ॢͤꤷޤ
     äͤꤹȥॢȤʤǱʵפԤͤˤʤޤ
     ¾Υ٥ȡʥ)ǤʤʤΤǡŬʥߥ󥰤
     alarm ʤ signal ȯƤ

     @param sec  
     @param usec ߥ
  */
  void setTimeout(long sec, long usec)
  {
    m_Timeout.tv_sec = sec;
    m_Timeout.tv_usec = usec;
  }

  /**
     @param tv  ॢȻ
  */
  void setTimeout(timeval const& tv)
  {
    m_Timeout = tv;
  }


  /**
     ߤԤ碌ॢͤޤ

     @parma tv ߤԤ碌ॢͤǼ٤Ρ
     timeval ¤ΤؤΥݥ󥿡
  */
  void getTimeout(timeval* tv)
  {
    *tv = m_Timeout;
  }


  //
  // ͥ
  //

  /**
     ͥ󥪥֥ȤϿޤ

     @param conn Ͽ륳ͥ󥪥֥
   */
  void addConnection(IUssConnectionEvent* conn)
  {
    m_listConnections.push_back(conn);
  }

  /**
     ͥ󥪥֥ȤϿޤ

     @param conn Ͽ륳ͥ󥪥֥
   */
  void removeConnection(IUssConnectionEvent* conn)
  {
    m_listConnections.remove(conn);
  }


  /**
     ƤΥͥ󥪥֥ȤϿޤ
   */
  void removeAllConnections()
  {
    for (list<IUssConnectionEvent*>::iterator i = m_listConnections.begin();
         i != m_listConnections.end(); i++)
      delete *i;
    m_listConnections.clear();
  }


  /**
     Х֥ȤϿޤ

     @param server Ͽ륵Х֥
   */
  void addServer(UssServerSocketConnectionEvent* server)
  {
    m_listServers.push_back(server);
  }

  /**
     Х֥ȤϿޤ

     @param server Ͽ륵Х֥
   */
  void removeServer(UssServerSocketConnectionEvent* server)
  {
    m_listServers.remove(server);
  }

  /**
     ƤΥХ֥ȤϿޤ
   */
  void removeAllServers()
  {
    m_listServers.clear();
  }


  /**
     ϿƤƤΥͥ󤪤ӥХ֥ȤˤĤƥ٥
     ԤԤޤ

     ʲΤ줫ξ֤ˤʤޤɤޤ
     \begin{enumerate}
     \item 줫Υͥ˥٥Ȥȯ
     \item 줫ΥФ³ä
     \item ॢȤã
     \item 餫Υʥ뤬ȯ
     \end{enumerate}

     @param autodispatch
       ͥ󥪥֥ȤФƥ٥Ȥȯ
       оݤΥ֥Ȥ˥٥ȤΤޤ
       (Ф³äˤϼưŪ³Ω)
       false ꤵƤϡμưԤޤ

     @return
       餫Υ顼ȯ EUssOSError 㳰ޤ
          0: ॢȤ
         ; 餫Υ٥Ȥȯ
         : ʥˤäƳޤ줿
   */
  int WaitForEvent(bool autodispatch = true);


 
  /**
     оݤΥͥ󥪥֥(ޤϥ)ɤ߽Ф
     ǽ֤Ǥ뤫ޤ

     @param p оݤΥͥ󥪥֥
     @return ɤ߽ФǽǤ true ᤷޤ
       
   */
 template <typename T>
  bool isReadable(T p)
  {
    return isReadable(p.getFileDescriptor());
  }
  bool isReadable(UssFileDescriptor* p)
  {
    return FD_ISSET(p->getFD(), &m_readfds);
  }


  /**
     оݤΥͥ󥪥֥(ޤϥ)˽񤭹
     ǽ֤Ǥ뤫ޤ

     @param p оݤΥͥ󥪥֥
     @return 񤭹߲ǽǤ true ᤷޤ
       
   */
  template <typename T>
  bool isWritable(T p)
  {
    return isWritable(p.getFileDescriptor());
  }
  bool isWritable(UssFileDescriptor* p)
  {
    return FD_ISSET(p->getFD(), &m_writefds);
  }


  /**
     оݤΥͥ󥪥֥(ޤϥ)
     㳰֤Ǥ뤫ޤ

     @param p оݤΥͥ󥪥֥
     @return 㳰֤Ǥ true ᤷޤ
       
   */
  template <typename T>
  bool isExepted(T p)
  {
    return isExpected(p.getFileDescriptor());
  }
  bool isExpected(UssFileDescriptor* p)
  {
    return FD_ISSET(p->getFD(), &m_exceptfds);
  }


  /**
     ƤΥå/Ф򥯥ޤ
   */
  void closeAll();

protected:
  /**
     list<IUssConnectionEvent> Ƥ³ˤĤơ
     Ԥ碌Ԥޤ
  */
  void setupFDs(list<IUssConnectionEvent*>& lst);


  /**
     list<IUssConnectionEvent> Ƥ³դơ
     ٥Ȥǥѥåޤ
  */
  void dispatchEvent(list<IUssConnectionEvent*>& lst);

protected:
  struct timeval m_Timeout;
  fd_set m_readfds;
  fd_set m_writefds;
  fd_set m_exceptfds;

  list<UssServerSocketConnectionEvent*> m_listServers;
  list<IUssConnectionEvent*> m_listConnections;
};

#endif

//EOF

