// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// UssException.cpp
// $Id: UssException.cpp,v 1.7 2001/08/02 05:00:26 seagull Exp $
//
#include <time.h>

#include "UssCommon.h"
#include "UssException.h"


EUssException::EUssException(void* obj)
{
  m_pObj = obj;

  // save raised time value
  ::gettimeofday(&m_RaisedTime, NULL);
}


EUssException::~EUssException()
{
}


char const*
EUssException::what()
{
  return "<Uss Unknoen exception>";
}


int
EUssException::report(FILE* fp)
{
  char* p = ::ctime(&getRaisedTime().tv_sec);
  char* p1 = strdup(p);
  char* p2 = NULL;
  if (! p1)
    p1 = p;
  else
  {
    p2 = p1;
    for (p = p1; *p && *p != '\n'; p++)
      ;
    *p = '\0';
  }

  int n =  fprintf(stderr, "%s : Exception raised. %s \n",
                   p1, getErrorMessage());
  if (p2)
    free(p2);

  return n;
}
