// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// $Id: UssIOBuffer.h,v 1.27 2001/09/08 07:47:16 seagull Exp $
//

#if !defined(USS_H_IOBuffer)
#define USS_H_IOBuffer


#include <stdint.h>
#include <limits.h>
#include "UssException.h"
#include "UssIO.h"


class UssIOBufferBase;

/**
   IOХåե˴ؤ㳰δܥ饹
 */
class EUssIOBuffer : public EUssException
{
public:
  EUssIOBuffer(UssIOBufferBase* obj)
    : EUssException(static_cast<void*>(obj))
  {
  }
};


/**
   ХåեСե뤤ϥե
   򼨤㳰
 */
class EUssIOBufferOverflow : public EUssIOBuffer
{
public:
  EUssIOBufferOverflow(UssIOBufferBase* obj)
    : EUssIOBuffer(obj)
  {
  }

  virtual char const* what()
  {
    return "Buffer over/under flow";
  }
};




/**
   Хåե쥯ȤƤʤ򼨤㳰

   Хåե¾IO֥Ȥ˥쥯ȤƤʤˡ
   fetch/flush ʤɡ쥯ȤƤɬפ᥽å
   ƤӽФȯ㳰
 */
class EUssIOBufferNotRedirected : public EUssIOBuffer
{
public:
  EUssIOBufferNotRedirected(UssIOBufferBase* obj)
    : EUssIOBuffer(obj)
  {
  }

  virtual char const* what()
  {
    return "Buffer not redirected";
  }
};






/**
   IOХåե˥ǡ񤭹ޤ줿Υ٥Ȥꥹ˥󥰤륯饹

   UssIOBuffer֥Ȥ setEventListener ǥꥹʤϿ
   ȡ٥ȯonWrite᥽åɤХåޤ
 */
class IUssIOBufferEventListener
{
public:
  virtual void onWrite(UssIOBufferBase* buffer, int len) = 0;
};




template <class T>
class UssIOBufferCallbackEvent : public IUssIOBufferEventListener
{
protected:
  UssIOBufferCallbackEvent(T* obj, void (T::*proc)(UssIOBufferBase* buffer, int len))
  {
    setProc(obj, proc);
  }

  void onWrite(UssIOBufferBase* buffer, int len)
  {
    (m_obj->*m_proc)(buffer, len);
  }


  void setProc(T* obj, void (T::*proc)(UssIOBufferBase* buffer, int len))
  {
    m_obj = obj;
    m_proc = proc;
  }

  T* m_obj;
  void (T::*m_proc)(UssIOBufferBase* buffer, int len);
};







/**
   Ƥ IOBuffer եߥδ쥯饹

   IOBuffer ȤƤδŪʵǽΥ󥿡ե󶡤ޤ
 */
class UssIOBufferBase : public IUssIO
{
public:
  UssIOBufferBase()
  {
    m_pRedirectedIO = NULL;
  }
  virtual ~UssIOBufferBase()
  {
  }



  /**
     Хåե֥Ȥޤ

     @param bufflen ХåեĹ
   */
  virtual void init(int bufflen)
  {
  }


  /**
     ХåեƤõޤ
   */
  virtual void reset()
  {
  }


  /**
		 ݤƤХåեΥ᤹
	*/
  virtual size_t getBufferSize() const = 0;

  virtual size_t getFreeSize() const = 0;  // Хåեζ᤹
  virtual size_t getUsedSize() const = 0;  // ХåեλѺѤߥ᤹

  virtual bool isEmpty() const = 0;  // Хåե
  virtual bool isFull() const = 0;   // Хåեդ

  virtual int write(void const* buf, int len);
  virtual int write_impl(void const* buf, int len);



  /**
     Хåե¾ IO ֥Ȥ³
     @PARAM io  ³ IO ֥ȡ
                NULL ꤹȡ³롣
   */
  void setRedirectTo(IUssIO* io) { m_pRedirectedIO = io; }
  /**
     ³Ƥ IO ֥Ȥ᤹
   */
  IUssIO* getRedirectTo() const { return m_pRedirectedIO; }


  /**
     ³Ƥ IO ֥ȤإХåեƤ񤭽Ф
     @REMARK
       оݤIOդʬ񤭽ФʤΤǡ˥Хåե
       Ȥƽ񤭽ФȤϸ¤ޤ

       ޤХåեΥ르ꥺˤäƤ⡢Ⱦüʥ
       񤭽Фʤޤ flush() 
       Фǡʾ write ׵᤬ФϤޤ
   */
  virtual int flush() = 0;

  /**
     ³Ƥ IO ֥ȤХåեƤɤ߹ࡣ
     @REMARK
       르ꥺˤäƤϥХåեΥäƤȾüʥ
       ɤ߹ʤޤ fetch() ƽ
       ǡʾ read ׵᤬ФϤޤ
   */
  virtual int fetch() = 0;

  virtual bool lookAhead(int offset, uint8_t* p) = 0;

  template <typename T>
  bool lookAhead(int offset, T* p)
  {
    for (int i = 0; i < sizeof(T); i++)
        if (! lookAhead(offset + i,
                        reinterpret_cast<uint8_t*>(p) + i) )
          return false;
    return true;
  }


  /**
     Хåե˥ǡä褿ΥեåؿϿ
   */
  IUssIOBufferEventListener* getEventListener() const
  {
    return m_pEventListener;
  }
  void setEventListener(IUssIOBufferEventListener* listener)
  {
    m_pEventListener = listener;
  }

protected:
  void testRedirected()
  {
    if (m_pRedirectedIO == NULL)
      throw new EUssIOBufferNotRedirected(this);
  }


protected:
  IUssIO* m_pRedirectedIO;
  IUssIOBufferEventListener* m_pEventListener;
};









/**
   Ϣ³֤Ѥ IOBuffer δ쥯饹
 */
class UssIOBuffer_Raw : public UssIOBufferBase
{
public:
  UssIOBuffer_Raw();
  virtual ~UssIOBuffer_Raw();

  virtual void init(int bufflen);

  virtual size_t getBufferSize() const
	{
		return m_pBufferTail - m_pBuffer;
	}

  uint8_t* getBufferPtr() const { return m_pBuffer; }

protected:
  uint8_t* m_pBuffer;
  uint8_t* m_pBufferTail;
};











/**
   ѥåȥå -- Хʸʬ򤷤ƥ٥ȤѴ륯饹
   δ쥯饹
 */
class UssPacketCracker : public IUssIOBufferEventListener
{
public:
  virtual void onWrite(UssIOBufferBase* buffer, int len) = 0;
  virtual void onPacket(void* packet, int len) = 0;

protected:
  void dispatchOnPacket(UssIOBufferBase* buffer, int len);
};




/**
   Ĺʸ򰷤ѥåȥå
 */
class UssPacketCracker_Fixed : public UssPacketCracker
{
public:
  /**
     ֥Ȥۤޤ

     @param len   ʸΥХȿ
   */
  UssPacketCracker_Fixed(size_t len=1)
  {
    setLength(len);
  }

  /**
     ʸΥХȿꤷޤ

     @param len   ʸΥХȿ
   */
  void setLength(size_t len) { m_nLength = len; }

  /**
     ʸΥХȿޤ

     @return
     ʸΥХȿ
   */
  size_t getLength() const { return m_nLength; }

  virtual void onWrite(UssIOBufferBase* buffer, int len);

protected:
  size_t m_nLength;
};







/**
   ڤʸǶڤ줿ʸ򰷤ѥåȥå

   ڤʸΤ onPacket ˤϤޤ
 */
class UssPacketCracker_Delimited : public UssPacketCracker
{
public:
  /**
     ֥Ȥۤޤ

     @param delm  ڤʸάϲ(NL)
   */
  UssPacketCracker_Delimited(int delm='\n')
  {
    setDelimiter(delm);
  }


  /**
     ڤʸꤷޤ

     @param delm ڤʸ
   */
  void setDelimiter(int delm) { m_cDelimiter = delm; }


  /**
     ڤʸޤ

     @return
     ꤵƤڤʸ
  */
  int getDelimiter() const { return m_cDelimiter; }

  virtual void onWrite(UssIOBufferBase* buffer, int len);

protected:
  int m_cDelimiter;
};







/**
   ʸĹʸ˵ҤƤ륿פʸ򰷤ѥåȥå
 */
class UssPacketCracker_Ref : public UssPacketCracker
{
public:
  /**
     ֥Ȥۤޤ

     @param size    ĹեɤΥǣХȤޤǤݾڤޤ
     @param offset  ʸƬĹեɤޤǤΥեå
     @param extra   Ĺեɤ˵Ͽ줿Ͱʳ˴ޤޤʸǡΥ
     @param endian  ʸȥ륨ǥξtrueꤷޤ
   */
  UssPacketCracker_Ref(uint size, uint offset, uint extra = 0, bool endian = false )
  {
    setEndian(endian);
    setSize(size);
    setOffset(offset);
    setExtra(extra);
  }

  /**
     ֥Ȥۤޤ

     Ƽܤ̤ξ֤ǤΤǡꤹɬפޤ
  */
  UssPacketCracker_Ref()
  {
  }



  /**
     ޤȤꤷޤ
  */
  void setConfig(uint size, uint offset, uint extra = 0, bool endian = false )
  {
    setEndian(endian);
    setSize(size);
    setOffset(offset);
    setExtra(extra);
  }

  /**
     ʸΥǥꤷޤ
     @param endian  ʸȥ륨ǥξtrueꤷޤ
  */
  void setEndian(bool b) { m_bLittleEndian = b; }

  /**
     ʸΥǥޤ
     @return ʸȥ륨ǥξtrueꤷޤ
  */
  bool getEndian() const { return m_bLittleEndian; }

  /**
     ʸΥǥޤ
     @return ʸȥ륨ǥξtrueꤷޤ
  */
  bool isLittleEndian() const { return getEndian(); }

  /**
     ʸΥǥޤ
     @retrun  ʸӥåǥξtrueꤷޤ
  */
  bool isBigEndian() const { return ! isLittleEndian(); }

  /**
     ĹեɤΥХȿꤷޤ
     @param size   
  */
  void setSize(uint size) { m_nSize = size; }

  /**
     ĹեɤΥХȿꤷޤ
     @return size 
  */
  uint getSize() const { return m_nSize; }
  
  /**
     ĹեɤΥեåȤꤷޤ
     @param offset եå
  */
  void setOffset(uint offset) { m_nOffset = offset; }

  /**
     ĹեɤΥեåȤޤ
     @return եå
  */
  uint getOffset() const { return m_nOffset; }

  /**
     ĹեɰʳɬפʥХȿꤷޤ
     @param extra Хȿ
  */
  void setExtra(uint extra) { m_nExtra = extra; }

  /**
     ĹեɰʳɬפʥХȿޤ
     @return extra Хȿ
  */
  uint getExtra() const { return m_nExtra; }

  virtual void onWrite(UssIOBufferBase* buffer, int len);

protected:
  bool m_bLittleEndian;
  uint m_nSize;
  uint m_nOffset;
  uint m_nExtra;
};






/**
   ѥåȥåФonPacket٥Ȥ¾Υ֥ȤΥ᥽åɤ
   Хå٤ proxy 饹Ǥ

   @param T ХåΥ饹
   @param BASE ˤʤѥåȥå饹
 */
template <class T, class BASE>
class UssCallbackPacketCracker : public BASE
{
public:
  /**
     ֥Ȥۤޤ

     @param obj ХåΥ֥
     @param proc ХåΥ᥽å
   */
  UssCallbackPacketCracker(T* obj, void (T::*proc)(void* packet, int len))
  {
    setProc(obj, proc);
  }


  /**
     Хåꤷޤ

     @param obj ХåΥ֥
     @param proc ХåΥ᥽å
   */
  void setProc(T* obj, void (T::*proc)(void* packet, int len))
  {
    m_obj = obj;
    m_proc = proc;
  }

protected:
  /**
     ѥåȤȤФ줿ΤǥХåԤޤ

     @param packet rawǡ
   */
  void onPacket(void* packet, int len)
  {
    (m_obj->*m_proc)(packet, len);
  }
protected:
  T* m_obj;
  void (T::*m_proc)(void* packet, int len);
};







#include "UssIOBuffer_Slide.h"
#include "UssIOBuffer_Ring.h"
#include "UssIOBuffer_Queue.h"
#include "UssIOBuffer_Direct.h"
#include "UssIOBuffer_Null.h"

#endif

//EOF

